//------------------------------------------------------------------------
// Program Name: File1555.c
// Operational file utility for Micro-x Accessor System Version 1.5.5 GXV.
// Use to produce and test operational file ACMX155.DAT.
//------------------------------------------------------------------------
//
// ********************************************************************
// [ FOR MICRO-X ACCESSOR SYSTEM Ver. 1.5.5 GXV. ]
// ********************************************************************
//
// ***********************************************
// [ Appendix: Terms Conditions and Aggreements ]
// ***********************************************
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// Author       : JOHN F. CLARK JR.
// I can be contacted by mail at......
// Address      : 11-15 Port Richmond Av. Staten Island, NY 10302
//
//                       NO WARRANTY
// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
// OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
// PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
// OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
// TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
// PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
// REPAIR OR CORRECTION.
//
// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
// INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
// OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
// TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
// YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
// PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGES.
//                    END OF TERMS AND CONDITIONS
//***************************************************************************
//
//
//
#include <stdlib.h>
#include <stdio.h>
#include <allegro.h>
#include <string.h>
#include <strings.h>
#include <fcntl.h>

int main(void)
{
   int handle;
   unsigned int result;
   int a, y, x;
   int t;
   int press_key = 0;
   char Itm_1s[] = "####################################L";
   char Itm_2s[] = "####################################P";
   char *ar_ptr[56];
   char c = '';
   char *buf = (char *)alloca(4800);
   PACKFILE *pack_file_ptr;

   // Initialise the Allegro stuff
   allegro_init();
   install_keyboard(); 
   install_timer();

   // Set up the graphics mode and basic object colors
   set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
   set_palette(desktop_palette);
   text_mode(-1);
   clear_to_color(screen, makecol(128, 128, 128));

   textout(screen, font, "Program File1555 for data base file utility ...", 2, 2, makecol(255, 255, 255));
   textout(screen, font, "Press the Enter key to begin ...", 2, 20, makecol(255, 255, 255));
   while((press_key & 0xFF) != 13)
   {
     press_key = readkey();
   }
   press_key = 0;

//......................................................   
// file opening operation ..(#1)..
//------------------------------------------------------
   if (!buf)
   {
     clear_to_color(screen, makecol(128, 128, 128));
     textout(screen, font, "Memory Access Error !!  ...", 100, 240, makecol(255, 0, 0));
     goto PRGEXIT;
   }
   
   pack_file_ptr = NULL;
   
   pack_file_ptr = pack_fopen("ACMX155.DAT", F_WRITE_PACKED);
   if ( !pack_file_ptr)
   {
     clear_to_color(screen, makecol(128, 128, 128));
     textout(screen, font, "Error !! opening ACMX155.DAT ...", 100, 240, makecol(255, 0, 0));
     goto PRGEXIT;
   }
//-------------------------------------------------------    
   t = 0;
   a = 0;
   x = 0;
   while (x != 28)
   {
    *(ar_ptr + t) = strcpy(buf + a, Itm_1s);
    t += 1;
    x += 1;
    a = a + 38;
   }

    a = 1064;
    t = 28;
    x = 28;
   
    while(x != 56)
    {
     *(ar_ptr + t) = strcpy(buf + a, Itm_2s);
     x += 1;
     t += 1;
     a = a + 128;
    }
//.........
     t = 0;
     x = 0;
     while (x != 4800)
     {
      if ((*(buf + t ) != '\0') && (*(buf + t) != '\n'))
      {
       *(buf + t) -= c;
      }
      t += 1;
      x += 1;
     }

// ..............................................................
// file write operation ..
//---------------------------------------------------------------
     if (!pack_fwrite(buf, 4800, pack_file_ptr))
     {
      clear_to_color(screen, makecol(128, 128, 128));
      textout(screen, font, "Error !! writting ACMX155.DAT to disk ...", 100, 140, makecol(255, 255, 0));
      pack_fclose(pack_file_ptr);
      goto PRGEXIT;
     }
     pack_fclose(pack_file_ptr);

// ........................................................................
// ------------------------------------------------------------------------
    clear_to_color(screen, makecol(128, 128, 128));
    textout(screen, font, "File data ... has been loaded into variables ...", 2, 2, makecol(255, 255, 255));
    textout(screen, font, "File data ... has been written to file ...", 2, 22, makecol(255, 255, 255));
    textout(screen, font, "Press the Enter key to see read from file, and a listing ...", 2, 42, makecol(255, 255, 0));
    while((press_key & 0xFF) != 13)
    {
      press_key = readkey();
    }
    press_key = 0;
//......................................................   
// file opening operation ..(#2)..
//------------------------------------------------------
   pack_file_ptr = NULL;
   
   pack_file_ptr = pack_fopen("ACMX155.DAT", F_READ_PACKED);
   if ( !pack_file_ptr)
   {
     clear_to_color(screen, makecol(128, 128, 128));
     textout(screen, font, "Error !! opening ACMX155.DAT ...", 100, 240, makecol(255, 0, 0));
     goto PRGEXIT;
   }
// ..............................................................
// file read operation ..(#2)..
//---------------------------------------------------------------
     if (pack_fread(buf, 4800, pack_file_ptr))
     {
      clear_to_color(screen, makecol(128, 128, 128));
      textout(screen, font, "ACMX155.DAT has been read from file ... press Enter to see listings ...", 2, 240, makecol(255, 255, 0));
      while((press_key & 0xFF) != 13)
      {
        press_key = readkey();
      }
      press_key = 0;
     }
     else
     {
      pack_fclose(pack_file_ptr);
      clear_to_color(screen, makecol(128, 128, 128));
      textout(screen, font, "Error !! writting ACMX155.DAT to disk ...", 100, 240, makecol(255, 0, 0));
      goto PRGEXIT;
     }
     pack_fclose(pack_file_ptr);

// ........................................................................
// ------------------------------------------------------------------------
   clear_to_color(screen, makecol(128, 128, 128));
   textout(screen, font, "Window name data listings ...", 2, 2, makecol(0, 255, 255));
   textout(screen, font, "Path data listings ...", 320, 2, makecol(0, 255, 255));
   t = 0;
   x = 0;
   while (x != 4800)
   {
      if ((*(buf + t) != '\0') && (*(buf + t) != '\n'))
      {
         *(buf + t) += c;
      }
      t += 1;
      x += 1;
   }
 //..........
   y = 0;
   t = 0;
   x = 16;
   a = 16;
   while(y != 56)
   {
        if(y <= 27)
        {
         textprintf(screen, font, 2, x, 15, "%s", ar_ptr[t]);
         x += 14;
        }
        else
        {
         textprintf(screen, font, 320, a, 15, "%s", ar_ptr[t]);
         a += 14;
        }
        y += 1;
        t += 1;
   }
 
 PRGEXIT:
   textout(screen, font, "Press  [ ESCAPE ]  to end program ...", 100, 460, makecol(200, 200, 0));
   while((press_key & 0xFF) != 27)
   {
     press_key = readkey();
   }
   press_key = 0;
   allegro_exit();
   return(0);
}
