/*    EPZip - the simple free distribution preparing tool
**    Copyright (C) 1997  Esa Peuha

**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.

**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.

**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include "epzip.h"

unsigned int *table;

void initialize_crc(void)
{
  unsigned int c, n;
  unsigned char i;

  table = malloc(0x100 * sizeof(unsigned int));
  if(table == NULL)
    {
      fprintf(stderr, "epzip: can't allocate memory for CRC table\n");
      exit(1);
    }

  for(n = 0; n < 0x100; n++)
    {
      c = n;
      for(i = 0; i < 8; i++)
	c = c & 1 ? 0xedb88320L ^ c >> 1 : c >> 1;
      table[n] = c;
    }
}
unsigned int get_crc(char *buffer, unsigned int length)
{
  unsigned int c = 0xffffffffL;
  if(buffer == NULL || length == 0)
    return 0L;
  while(length--)
    c = table[(c ^ *buffer++) & 0xff] ^ c >> 8;
  return c ^ 0xffffffffL;
}
void terminate_crc(void)
{
  free(table);
}
