/*    EPZip - the simple free distribution preparing tool
**    Copyright (C) 1997  Esa Peuha

**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.

**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.

**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include "epzip.h"

FILE *writefile, *readfile;
static unsigned char writestore, readstore;
static unsigned char writeused, readunused;

void bwrite_begin(FILE *outfile)
{
  writefile = outfile;
  writeused = writestore = 0;
}

void bwrite(unsigned int value, unsigned char bits)
{
  if(bits == 0 || bits > 32)
    return;
  value &= (1 << bits) - 1;
  while(bits--)
    {
      writestore |= value & 1 ? 1 << writeused : 0;
      value >>= 1;
      if(++writeused == 8)
	{
	  fputc(writestore, writefile);
	  writeused = writestore = 0;
	}
    }
}

void bwrite_end(void)
{
  if(writeused)
    bwrite(0, 8 - writeused);
  writefile = NULL;
}

void bread_begin(FILE *infile)
{
  readfile = infile;
  readstore = 0;
  readunused = 0;
}

unsigned int bread(unsigned char bits)
{
  unsigned int tempvalue = 0;
  unsigned char tempbits = 0;

  if(bits == 0 || bits > 32)
    return 0;
  while(tempbits < bits)
    {
      if(readunused == 0)
	{
	  readstore = fgetc(readfile);
	  readunused = 8;
	}
      tempvalue |= 1 << (8 - readunused) & readstore ? 1 << tempbits : 0;
      readunused--;
      tempbits++;
    }
  return tempvalue & ((1 << bits) - 1);
}

void bread_end(void)
{
  readfile = NULL;
}
