// SourceBuildDialog.cpp : implementation file
//

#include "stdafx.h"
#include "DFE32.h"
#include "SourceBuildDialog.h"
#include "cdialectpage.h"
#include "optimizepage.h"
#include "otherpage.h"
#include "overallpage.h"
#include "warningpage.h"
#include "advancedsheet.h"
#include "extern.h"
#include "messageview.h"
#include "postmessage.h"
#include "fork.h"
#include "mainfrm.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSourceBuildDialog dialog


CSourceBuildDialog::CSourceBuildDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSourceBuildDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSourceBuildDialog)
	m_Exename = _T("");
	m_Aout = -1;
	//}}AFX_DATA_INIT
}


void CSourceBuildDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSourceBuildDialog)
	DDX_Text(pDX, IDC_EDIT_EXENAME, m_Exename);
	DDX_Radio(pDX, IDC_RADIO_AOUT, m_Aout);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSourceBuildDialog, CDialog)
	//{{AFX_MSG_MAP(CSourceBuildDialog)
	ON_BN_CLICKED(IDC_RADIO_AOUT, OnRadioAout)
	ON_BN_CLICKED(IDCANCEL2, OnCancel2)
	ON_BN_CLICKED(IDC_RADIO_EXENAME, OnRadioExename)
	ON_BN_CLICKED(IDC_ADD_BUTTON, OnAddButton)
	ON_BN_CLICKED(IDC_REMOVE_BUTTON, OnRemoveButton)
	ON_BN_CLICKED(IDC_ADVANCED_BUTTON, OnAdvancedButton)
	ON_BN_CLICKED(IDC_COMPILE_BUTTON, OnCompileButton)
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSourceBuildDialog message handlers

BOOL CSourceBuildDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

	CListBox *list = (CListBox *)GetDlgItem(IDC_LIST);
	CString str('x', (3 - extension.GetLength()));
	m_Exename = filename + str;
	m_Exename.SetAt(m_Exename.GetLength() - 3, 'e');
	m_Exename.SetAt(m_Exename.GetLength() - 2, 'x');
	m_Exename.SetAt(m_Exename.GetLength() - 1, 'e');
	if (m_Aout == 0)
		GetDlgItem(IDC_EDIT_EXENAME)->EnableWindow(FALSE);
	for (int i = 0; i < numlibs; i++)
		list->AddString(libs[i]);
	UpdateData(FALSE);	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSourceBuildDialog::OnRadioAout() 
{
	GetDlgItem(IDC_EDIT_EXENAME)->EnableWindow(FALSE);
}

void CSourceBuildDialog::OnCancel2() 
{
	OnCancel();
}

void CSourceBuildDialog::OnRadioExename() 
{
	GetDlgItem(IDC_EDIT_EXENAME)->EnableWindow(TRUE);
}

void CSourceBuildDialog::OnAddButton() 
{
	CString ext;
	CString str;
	CFileDialog filedialog(TRUE, NULL, NULL, OFN_HIDEREADONLY | 
		OFN_OVERWRITEPROMPT, 
		"Object and Library Files (*.a), (*.so), (*.o)| *.a;*.so;*.o||");
	CListBox *list = (CListBox*)GetDlgItem(IDC_LIST);
	if (filedialog.DoModal() == IDOK)
	{
		ext = filedialog.GetFileExt();
		str = filedialog.GetFileName();
		if (!ext.CompareNoCase("o"))
			list->AddString(filedialog.GetPathName());
		else if (!ext.CompareNoCase("a"))
		{
			str = str.Left(str.GetLength()-2);
			str = str.Right(str.GetLength()-3);
			list->AddString(str);
		}
		else
		{
			str = str.Left(str.GetLength()-3);
			str = str.Right(str.GetLength()-3);
			list->AddString(str);
		}
		numlibs++;
	}
}

void CSourceBuildDialog::OnRemoveButton() 
{
	CListBox *list = (CListBox*)GetDlgItem(IDC_LIST);
	if (list->GetCurSel() != LB_ERR)
	{
		list->DeleteString(list->GetCurSel());
		numlibs--;
	}
}

void CSourceBuildDialog::OnAdvancedButton() 
{
	CAdvancedSheet sheet("Advanced Options");
	sheet.cdialectpage.m_Ansi = m_Ansi;
	sheet.cdialectpage.m_NoAsm = m_NoAsm;
	sheet.cdialectpage.m_Traditional = m_Traditional;
	sheet.optimizepage.m_Optimize = m_Optimize;
	sheet.otherpage.m_Other = m_Other;
	sheet.overallpage.m_E = m_E;
	sheet.overallpage.m_S = m_S;
	sheet.overallpage.m_GenDebug = m_GenDebug;
	sheet.overallpage.m_Language = m_Language;
	sheet.warningpage.m_Warning = m_Warning;
	if (sheet.DoModal() == IDOK)
	{
		m_Ansi = sheet.cdialectpage.m_Ansi;
		m_NoAsm = sheet.cdialectpage.m_NoAsm;
		m_Traditional = sheet.cdialectpage.m_Traditional;
		m_Optimize = sheet.optimizepage.m_Optimize;
		m_Other = sheet.otherpage.m_Other;
		m_E = sheet.overallpage.m_E;
		m_S = sheet.overallpage.m_S;
		m_GenDebug = sheet.overallpage.m_GenDebug;
		m_Language = sheet.overallpage.m_Language;
		m_Warning = sheet.warningpage.m_Warning;
	}
}

void CSourceBuildDialog::OnCompileButton() 
{
	UpdateData(TRUE);
	CString str;
	CString liststr;
	CString output, temp;
	HANDLE in, out, err, thread;
	DWORD number;
	char buffer[5000];
	memset(buffer,'\0', 4500);
	int i;
	CListBox *list = (CListBox *)GetDlgItem(IDC_LIST);
	CMainFrame *frame;
	frame = (CMainFrame *)AfxGetMainWnd();
	frame->lastrun = m_Exename;
	str = gccpath;
	str += " ";
	str += filename;
	str += " ";
	if (m_Aout == 1)
	{
		str += "-o ";
		str += m_Exename;
		str += " ";
	}
	if (m_GenDebug == TRUE)
		str += "-g ";
	if (m_Ansi == TRUE)
		str += "-ansi ";
	if (m_NoAsm == TRUE)
		str += "-fno-asm ";
	if (m_Traditional == TRUE)
		str += "-traditional ";
	switch (m_Optimize)
	{
	case 1:
		str += "-O1 ";
		break;
	case 2:
		str += "-O2 ";
		break;
	case 3:
		str += "-O3 ";
		break;
	default:
		break;
	}
	if (!m_Other.IsEmpty())
	{
		str += m_Other;
		str += " ";
	}
	if (m_S == TRUE)
		str += "-S ";
	if (m_E == TRUE)
		str += "-E ";
	switch (m_Language)
	{
	case 1:
		str += "-x c ";
		break;
	case 2:
		str += "-x objective-c ";
		break;
	case 3:
		str += "-x c++ ";
		break;
	case 4:
		str += "-x c-header ";
		break;
	case 5:
		str += "-x cpp-output ";
		break;
	case 6:
		str += "-x c++-cpp-output ";
		break;
	case 7:
		str += "-x assembler ";
		break;
	case 8:
		str += "-x assembler-with-cpp ";
		break;
	default:
		break;
	}
	switch (m_Warning)
	{
	case 1:
		str += "-w ";
		break;
	case 2:
		str += "-Wall ";
		break;
	case 3:
		str += "-W ";
		break;
	case 4:
		str += "-Werror ";
		break;
	default:
		break;
	}
	if (list->GetCount() != 0)
	{
		for (i = 0; i < list->GetCount(); i++)
		{
			list->GetText(i, liststr);
			if (liststr.GetLength() > 2)
			{
				if (liststr.GetAt(liststr.GetLength() - 2) == '.')
				{
					list->GetText(i, liststr);
					str += liststr;
					str += " ";
				}
			}
		}
		for (i = 0; i < list->GetCount(); i++)
		{
			list->GetText(i, liststr);
			if (liststr.GetLength() <= 2)
			{
				str += "-l";
				str += liststr;
				str += " ";
			}
			else if (liststr.GetAt(liststr.GetLength() - 2) != '.')
			{
				str += "-l";
				str += liststr;
				str += " ";
			}
		}
	}
	if (clear)
		GlobalMessageView->Reset();
	output = "Compiling ";
	output += filename;
	output += " with command line of:";
	PostOutput(output, FALSE);
	output = str;
	PostOutput(output, TRUE);
	thread = ForkChildProcess(str.GetBuffer(500), &in, &out, &err, TRUE);
	WaitForSingleObject(thread, INFINITE);
	PeekNamedPipe(err,NULL,NULL,NULL,&number,NULL);
	if (number == 0)
	{
		output = "No warnings or errors recieved from gcc";
		PostOutput(output, TRUE);
	}
	else
	{
		output = "Errors:";
		PostOutput(output, TRUE);
		ReadFile(err, buffer, 4000, &number, NULL);
		temp = buffer;
		while (1)
		{
			if (temp.Find('\n') != -1)
			{
				output = temp.Left(temp.Find('\n') - 1);
				temp = temp.Right(temp.GetLength() - (temp.Find('\n') + 1));
				PostOutput(output, FALSE);
				if (temp.Find('\n') == -1)
				{
					PostOutput(temp, FALSE);
					break;
				}
			}
			else
			{
				PostOutput(temp, FALSE);
				break;
			}
		}
	}
	for (i = 0; i < numlibs; i++)
		list->GetText(i, libs[i]);
	OnOK();
}

void CSourceBuildDialog::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	
	CButton *button = (CButton *)GetDlgItem(IDC_COMPILE_BUTTON);
	button->SetFocus();	
}
