// DFE95View.cpp : implementation of the CDFE95View class
//

#include "stdafx.h"
#include "DFE95.h"
#include "compiledialog.h"
#include "DFE95Doc.h"
#include "DFE95View.h"
#include "extern.h"
#include "debugdialog.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDFE95View

IMPLEMENT_DYNCREATE(CDFE95View, CEditView)

BEGIN_MESSAGE_MAP(CDFE95View, CEditView)
	//{{AFX_MSG_MAP(CDFE95View)
	ON_COMMAND(ID_BUILD_COMPILE, OnBuildCompile)
	ON_COMMAND(ID_BUILD_DEBUG, OnBuildDebug)
	ON_WM_CHAR()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CEditView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDFE95View construction/destruction

CDFE95View::CDFE95View()
{
	// TODO: add construction code here

}

CDFE95View::~CDFE95View()
{
}

BOOL CDFE95View::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	BOOL bPreCreated = CEditView::PreCreateWindow(cs);
	cs.style &= ~(ES_AUTOHSCROLL|WS_HSCROLL);	// Enable word-wrapping

	return bPreCreated;
}

/////////////////////////////////////////////////////////////////////////////
// CDFE95View drawing

void CDFE95View::OnDraw(CDC* pDC)
{
	CDFE95Doc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CDFE95View printing

BOOL CDFE95View::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default CEditView preparation
	return CEditView::OnPreparePrinting(pInfo);
}

void CDFE95View::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// Default CEditView begin printing.
	CEditView::OnBeginPrinting(pDC, pInfo);
}

void CDFE95View::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// Default CEditView end printing
	CEditView::OnEndPrinting(pDC, pInfo);
}

/////////////////////////////////////////////////////////////////////////////
// CDFE95View diagnostics

#ifdef _DEBUG
void CDFE95View::AssertValid() const
{
	CEditView::AssertValid();
}

void CDFE95View::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}

CDFE95Doc* CDFE95View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDFE95Doc)));
	return (CDFE95Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDFE95View message handlers

void CDFE95View::CompileMake(void)
{
	ShellExecute(NULL,"open","make",filename.GetBuffer(256),".",SW_NORMAL);
}

void CDFE95View::OnBuildCompile() 
{
	// TODO: Add your command handler code here
	int i;
	int extenlength = 0;
	CCompileDialog dialog;
	filename = GetDocument()->GetPathName();
	if (!filename.IsEmpty())
	{
		if (GetDocument()->IsModified())
		{
			if (AfxMessageBox("Document is not saved...continue anyway?",
				MB_YESNO) == IDNO)
				return;
		}
		for(i=0; i < filename.GetLength(); i++)
		{
			if (filename.GetAt(i) == '.')
				extenlength = filename.GetLength() - (i + 1);
		}
		extension = filename.Right(extenlength);
		if (extension.IsEmpty() || (extension.CompareNoCase("mak") == 0))
			CompileMake();
		else
			dialog.DoModal();
	}
	else
		AfxMessageBox("Sorry, there is no source or makefile to build\n");
}

void CDFE95View::OnBuildDebug() 
{
	// TODO: Add your command handler code here
	CDebugDialog debugdialog;
	debugdialog.DoModal();
}

void CDFE95View::OnInitialUpdate() 
{
	CEditView::OnInitialUpdate();

	// TODO: Add your specialized code here and/or call the base class
	CFont font;
	font.CreateStockObject(ANSI_FIXED_FONT);
	SetFont(&font);
	SetTabStops(16);
}

void CDFE95View::SetTabsCurr(int nooftabs)
{
CEdit &edit = GetEditCtrl();
int start, end;
int tabsinline, subtabs;
int currline = edit.LineFromChar();
tabsinline = GetTabsIn(currline);
if (nooftabs < 0)
	return;
if (tabsinline == nooftabs)
	return;
if (nooftabs > tabsinline)
{
	edit.GetSel(start, end);
	edit.SetSel(edit.LineIndex(currline),
		edit.LineIndex(currline));
	CString str('\t',nooftabs - tabsinline);
	edit.ReplaceSel(str.GetBuffer(256));
	edit.SetSel(start+(nooftabs-tabsinline), end + (nooftabs-tabsinline));
}
else
{
	edit.GetSel(start, end);
	subtabs = tabsinline - nooftabs;
	edit.SetSel(edit.LineIndex(currline), 
		edit.LineIndex(currline) + subtabs);
	edit.ReplaceSel("");
	edit.SetSel(start - subtabs, end - subtabs);
}	
}


int CDFE95View::GetTabsIn(int lineno)
{
CEdit &edit = GetEditCtrl();
CString text;
int start, end;
int sel;
int numtabs = 0;
edit.GetSel(start, end);
sel = edit.LineIndex(lineno);
while (1)
{
edit.SetSel(sel + numtabs, sel + numtabs + 1);
GetSelectedText(text);
if (!text.Compare("\t"))
	numtabs++;
else
	break;
}
edit.SetSel(start, end);
return numtabs;
}

void CDFE95View::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	// } = 125
	// \n = 13
	// ; = 59
	// { = 123
	// # = 35
	CEditView::OnChar(nChar, nRepCnt, nFlags);
	int start, end;
	int currline;
	CString lastchar;
	CString firstchar;
	CEdit &edit = GetEditCtrl();
	currline = edit.LineFromChar();
	if (13 == nChar)
	{
		edit.GetSel(start, end);
		edit.SetSel(start - 3, start - 2);
		GetSelectedText(lastchar);
		edit.SetSel(edit.LineIndex(currline - 1),
			edit.LineIndex(currline - 1) + 1);
		GetSelectedText(firstchar);
		edit.SetSel(start, end);
		if (!lastchar.Compare(";") || !lastchar.Compare("}") ||
			!lastchar.Compare(" ") || !lastchar.Compare("\t") ||
			!lastchar.Compare("\n") ||  !lastchar.Compare("") ||
			!firstchar.Compare("#"))
			SetTabsCurr(GetTabsIn(currline - 1));
		else
			SetTabsCurr(GetTabsIn(currline - 1) + 1);
	}
	if (125 == nChar || 123 == nChar)
		SetTabsCurr(GetTabsIn(currline) - 1);
}
