/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Src/Graphics/Window.CC
   Author    : Eric NICOLAS
   Overview  : TWindow Object = Overlapped windows management
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include <grx.h>
#include <time.h>

short RegTWindow;
char *IdentTWindow = "TWindow";

// ----- TWindow

// Constructors

TWindow::TWindow() : TZone()
{ Init();
}

TWindow::TWindow(int X, int Y, int L, int H) : TZone(X,Y,L,H)
{ Init();
}

TWindow::TWindow(TRect& R) : TZone(R)
{ Init();
}

TWindow::~TWindow(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TWindow::Init(void)
{ Register=RegTWindow;
  Ident=IdentTWindow;
  SetOptions(opSelectable | opCSHiX | opCSHiY);
  ColorGroup=0;
  Clipping=new TScreenZone();
  MinimalSize=TPoint(50,70);
}

void TWindow::Done(void)
{ TZone::Done();
  delete Clipping;
}

// Events

boolean TWindow::MouseLDown(TPoint& , int )
{ if (GetStatus(sfMouseIn))
  { if (!GetStatus(sfSelected)) ComeToForeground();
    return TRUE;
  }
  return FALSE;
}

void TWindow::HandleEvent(TEvent *Event)
{ boolean PurgeEvent=FALSE;
  if (Event->What == evMouseLDown)
    PurgeEvent=MouseLDown(Event->Where,Event->Buttons);
  DealEvent(Event);
  if (PurgeEvent) ClearEvent(Event);
             else DispatchEvent(Event);
}

// Graphics

int TWindow::GetColor(int C)
{ return SysColorGroup[ColorGroup][C];
}

void TWindow::SetColorGroup(char _ColorGroup)
{ ColorGroup=_ColorGroup;
  TZone::SetColorGroup(_ColorGroup);
}

void TWindow::DoDraw(TRect& Clip)
{ DrawBegin();
  TScreenZone *SZ=Clipping->Son();
  TRect        W;
  while(SZ!=NULL)
  { W=(SZ->Where-Where.P1())-Clip;
    if (!W.Empty())
    { // Clip all the drawings to W
      GrSetClipBox(W.X1()+Corner.X(),W.Y1()+Corner.Y(),W.X2()+Corner.X(),W.Y2()+Corner.Y());
      // Draw
      TZone::DoDraw(W);
    }
    SZ=SZ->Next();
  }
  DrawEnd();
}

// Objects streams

void TWindow::Read(TDisk *file)
{ TZone::Read(file);
  file->Read(&ColorGroup,sizeof(char));
}

void TWindow::Write(TDisk *file)
{ TZone::Write(file);
  file->Write(&ColorGroup,sizeof(char));
}

// Clipping

void TWindow::ComeToForeground(void)
{ // Change Linked list order
  // :: Remove from the list without doing anything else
  TZone::UnLink();
  // :: Replace in the top of the list
  Desktop->Insert(this);
}

void TWindow::ResetClip(void)
{ delete Clipping;
  Clipping=new TScreenZone();
}

void TWindow::CalculateClip(void)
{ TZone       *Z;
  TScreenZone *SZ, *SZn;
  TRect        RZ;
  ResetClip();
  // Gnre le rectangle de dpart qui couvre toute la zone
  Clipping->Insert(new TScreenZone(Where));
  // Clip ce rectangle avec toutes les zones qui couvrent
  Z=Next();
  while(Z!=NULL)
  { // Coupe tous les rectangles selon le masquage par Z
    SZ=Clipping->Son();
    while(SZ!=NULL)
    { SZn=SZ->Next();
      // On Clippe ici SZ->Where par Z->Where
      RZ=Z->Where;
      RZ.X1()+=2;
      RZ.Y1()+=2;
      RZ.X2()-=2;
      RZ.Y2()-=2;
      Clipping->Clip(SZ,RZ);
      //
      SZ=SZn;
    }
    // Regroupe les Zones de Clip qui peuvent tre regroupes
    Clipping->RegroupZones();
    // Zone suivante
    Z=Z->Next();
  }
}

// Liste chainee

void TWindow::UnLink(void)
{ // D-slectionne cette fentre
  UnSelect();
  // Enleve la fenetre du bureau
  TZone::UnLink();
  // Mise a jour de l'affichage
  Desktop->UpdateClipZone();
  Desktop->Invalidate(Where);
  // Slectionne la nouvelle fenetre de 1er plan
  TWindow *W=(TWindow*)Desktop->Son();
  if (W!=NULL) W=W->Last();
  if (W!=NULL)
  { W->Select();
    W->Invalidate();
  }
}
