/**
 ** TEST.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/


#include "test.h"
#include <string.h>

#ifdef __TURBOC__
extern long clock(void);
#endif

#ifdef __GNUC__
extern long rawclock(void);
#define clock() rawclock()
#endif

void print_stats(int clockdiff,int numwrites)
{
	char buff[200];
	double tdiff = (double)clockdiff / 18.2;
	double pixels = (double)GrSizeX() * (double)GrSizeY();
	double bytes = (double)GrPlaneSize(GrSizeX(),GrSizeY());

	sprintf(buff,
	   "  %d screen writes in %.2f seconds\n",
	   numwrites,
	   tdiff
	);
	strcat(exit_message,buff);
	sprintf(buff,
	   "  speed = %.2f Mpixels/second\n",
	   (pixels * numwrites) / tdiff / 1.0e+06
	);
	strcat(exit_message,buff);
	switch(GrAdapterType()) {
	  case GR_HERC:
	  case GR_EGA:
	  case GR_VGA:
	    sprintf(buff,
		"  video RAM write speed = %.2f Mbytes/second\n",
		(bytes * numwrites) / tdiff / 1.0e+06
	    );
	    break;
	  default:
	    strcpy(buff,"  accelerated video\n");
	    break;
	}
	strcat(exit_message,buff);
}

TESTFUNC(test1)
{
	long start;
	int  ii,results[16],res2[16];
	GrContext *xxx;

	sprintf(exit_message,
	    "GRAPHICS MODE:\n  width  = %d\n  height = %d\n  colors = %d\n",
	    GrSizeX(),
	    GrSizeY(),
	    GrNumColors()
	);
	while(kbhit()) getkey();
	ii = 0;
	start = clock();
	while(!kbhit() && (ii < 50)) GrClearContext(++ii & 15);
	strcat(exit_message,"\nVIDEO SPEED TEST:\n");
	print_stats((int)(clock() - start),ii);
	while(kbhit()) getkey();

	if((GrNumColors() == 256) && (GrAdapterType() == GR_VGA)) {
	    extern GrContext _GrContext;
	    GrPlot(0,0,0);
	    _GrContext.gc_onscreen = 0;
	    ii = 0;
	    start = clock();
	    while(!kbhit() && (ii < 50)) GrClearContext(++ii & 15);
	    strcat(exit_message,"\n256 COLOR SPEED NOT USING PLANE MODE:\n");
	    print_stats((int)(clock() - start),ii);
	    GrSetContext(NULL);
	    while(kbhit()) getkey();
	}

	GrClearScreen(GrBlack());
	drawing(0,0,GrSizeX(),GrSizeY(),GrWhite(),GrBlack());
	getkey();

	GrClearScreen(GrBlack());
	xxx = GrCreateContext(100,100,NULL,NULL);
	for(ii = 0; ii < 16; ii++) {
	    GrPlot(100+5*ii,100,ii);
	    results[ii] = GrPixel(100+5*ii,100);
	    GrBitBlt(xxx,3+ii,1,NULL,100+5*ii,100,100+5*ii,100,GrWRITE);
	    GrSetContext(xxx);
	    res2[ii] = GrPixel(3+ii,1);
	    GrSetContext(NULL);
	}

	strcat(exit_message,"\nREAD/WRITE TEST:\n");
	for(ii = 0; ii < 16; ii++) {
	    char buff[100];
	    sprintf(buff,"  written pixel: 0x%02x, read back 0x%02x (0x%02x)\n",
		ii,
		results[ii],
		res2[ii]
	    );
	    strcat(exit_message,buff);
	}
	getkey();
}

