/**
 ** TEXTSIZE.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/
#include <stdio.h>
#include <stdlib.h>

#include "grx.h"
#include "libgrx.h"
#include "grxfont.h"

GrFont *_GrDefaultFont = NULL;

GrFont *_GrGetDefaultFont(void)
{
	_GrDefaultFont = GrLoadBIOSFont("@:pc8x14.fnt");
	if(_GrDefaultFont == NULL) {
	    GrSetMode(GR_default_text);
	    fputs("Cannot find default font: \"@:pc8x14.fnt\"\n",stderr);
	    exit(1);
	}
	return(_GrDefaultFont);
}

int _GrGetTextSize(char *txt,int len,int *w,int *h,GrTextOption *opt)
{
	GrFont *font = CHECK_FONT(opt->txo_font);
	int ww,hh,chr;

	if((font == NULL) || (opt->txo_xmag <= 0) || (opt->txo_ymag <= 0)) {
	    *w = 0;
	    *h = 0;
	    return(FALSE);
	}
	if(font->fnt_isfixed) {
	    ww = font->fnt_width  * opt->txo_xmag * len;
	    hh = font->fnt_height * opt->txo_ymag;
	}
	else {
	    for(ww = 0; --len >= 0; ) {
		switch(opt->txo_chrtype) {
		  case GR_WORD_TEXT:
		    chr = *((unsigned short *)txt)++;
		    break;
		  case GR_ATTR_TEXT:
		    chr = *((short *)txt)++ & 0xff;
		    break;
		  default:
		    chr = *((unsigned char *)txt)++;
		    break;
		}
		if(chr > font->fnt_maxchar) continue;
		if((chr -= font->fnt_minchar) < 0) continue;
		ww += PFP(font)->pf_width[chr];
	    }
	    ww *= opt->txo_xmag;
	    hh = font->fnt_height * opt->txo_ymag;
	}
	switch(opt->txo_direct) {
	  case GR_TEXT_DOWN:
	    *w = (-hh);
	    *h = ww;
	    break;
	  case GR_TEXT_LEFT:
	    *w = (-ww);
	    *h = (-hh);
	    break;
	  case GR_TEXT_UP:
	    *w = hh;
	    *h = (-ww);
	    break;
	  default:
	    *w = ww;
	    *h = hh;
	}
	return(TRUE);
}

int GrStringWidth(char *text,int length,GrTextOption *opt)
{
	int ww,hh;

	_GrGetTextSize(text,length,&ww,&hh,opt);
	return(IABS(ww));
}

int GrStringHeight(char *text,int length,GrTextOption *opt)
{
	int ww,hh;

	_GrGetTextSize(text,length,&ww,&hh,opt);
	return(IABS(hh));
}

int GrCharWidth(int chr,GrTextOption *opt)
{
	char buff[1];

	buff[0] = chr;
	return(GrStringWidth(buff,1,opt));
}

int GrCharHeight(int chr,GrTextOption *opt)
{
	char buff[1];

	buff[0] = chr;
	return(GrStringHeight(buff,1,opt));
}

static int fontsize(GrTextOption *opt,int which)
{
	GrFont *font = CHECK_FONT(opt->txo_font);
	int w,h;

	if(font == NULL) return(0);
	w = opt->txo_xmag * font->fnt_width;
	h = opt->txo_ymag * font->fnt_height;
	switch(opt->txo_direct) {
	  case GR_TEXT_DOWN:
	  case GR_TEXT_UP:
	    return(which ? w : h);
	  default:
	    return(which ? h : w);
	}
}

int GrFontWidth(GrTextOption *opt)
{
	return(fontsize(opt,0));
}

int GrFontHeight(GrTextOption *opt)
{
	return(fontsize(opt,1));
}

