/**
 ** SCANCNVX.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "clipping.h"
#include "scale.h"

void _GrScanConvexPoly(int n,int pt[][2],
    int is_XOR_color,
    _GrPixelDrawProc pixelproc,
    _GrLineDrawProc  borderproc,
    _GrScanLineProc  scanfillproc,
    void *fillarg)
{
	int  *lp1,*lp2,*rp1,*rp2,*last;
	int  lxx,ldx,ldy,lslope,lerror;
	int  rxx,rdx,rdy,rslope,rerror;
	int  ymin,ymax,ynext;
	MOUSE_FLAG;

	if((n > 1) && (pt[0][0] == pt[n-1][0]) && (pt[0][1] == pt[n-1][1])) n--;
	if(n <= 2) {
	    if(n <= 0) return;
	    ldx = pt[0][0];
	    ldy = pt[0][1];
	    if(n == 1) {
		MOUSE_BLOCK(CURC,ldx,ldy,ldx,ldy);
		(*pixelproc)(ldx,ldy,fillarg);
	    }
	    else {
		rdx = pt[1][0];
		rdy = pt[1][0];
		MOUSE_BLOCK(CURC,ldx,ldy,rdx,rdy);
		(*borderproc)(ldx,ldy,rdx,rdy,fillarg);
	    }
	    MOUSE_UNBLOCK();
	    return;
	}
	lxx = ymin = 32000;
	rxx = ymax = (-32000);
	for(last = pt[0]; --n >= 0; last += 2) {
	    if(lxx  > last[0]) lxx  = last[0];
	    if(rxx  < last[0]) rxx  = last[0];
	    if(ymin > last[1]) ymin = (lp2 = rp2 = last)[1];
	    if(ymax < last[1]) ymax = last[1];
	}
	if(ymin == ymax) {
	    CLIPHLINE(CURC,lxx,rxx,ymin);
	    MOUSE_BLOCK(CURC,lxx,ymin,rxx,ymin);
	    (*scanfillproc)(lxx,rxx,ymin,fillarg);
	    MOUSE_UNBLOCK();
	    return;
	}
	CLIPSORTEDBOX(CURC,lxx,ymin,rxx,ymax);
	MOUSE_BLOCK(CURC,lxx,ymin,rxx,ymax);
	last -= 2;
	for( ; ; ) {
	    lp1 = lp2;
	    if((lp2 -= 2) < pt[0]) lp2 = last;
	    if((lp1[1] != lp2[1]) && (lp2[1] >= _GrLoY)) {
		lxx = lp1[0];
		ldy = lp2[1] - lp1[1];
		if(lp1[1] < _GrLoY) {
		    SCALE(ldx,(lxx - lp2[0]),(lp2[1] - _GrLoY),ldy);
		    lxx = lp2[0] + ldx;
		    ldy = lp2[1] - _GrLoY;
		}
		break;
	    }
	}
	for( ; ; ) {
	    rp1 = rp2;
	    if((rp2 += 2) > last) rp2 = pt[0];
	    if((rp1[1] != rp2[1]) && (rp2[1] >= _GrLoY)) {
		rxx = rp1[0];
		rdy = rp2[1] - rp1[1];
		if(rp1[1] < _GrLoY) {
		    SCALE(rdx,(rxx - rp2[0]),(rp2[1] - _GrLoY),rdy);
		    rxx = rp2[0] + rdx;
		    rdy = rp2[1] - _GrLoY;
		}
		break;
	    }
	}
	for( ; ; ) {
	    if(ldy > 0) {
		lslope = (ldx = lp2[0] - lxx) / ldy;
		if(lslope && !is_XOR_color) (*borderproc)(lp1[0],lp1[1],lp2[0],lp2[1],fillarg);
		if((ldx %= ldy) < 0) { lslope--; ldx += ldy; }
		lerror = (ldy >> 1);
		ldy = (-ldy);
	    }
	    if(rdy > 0) {
		rslope = (rdx = rp2[0] - rxx) / rdy;
		if(rslope && !is_XOR_color) (*borderproc)(rp1[0],rp1[1],rp2[0],rp2[1],fillarg);
		if((rdx %= rdy) < 0) { rslope--; rdx += rdy; }
		rerror = (rdy >> 1);
		rdy = (-rdy);
	    }
	    ynext = lp2[1];
	    if(ynext >= rp2[1]) ynext = rp2[1];
	    if(ynext >= ymax)	ynext = ymax + 1;
	    while(ymin < ynext) {
		(*scanfillproc)(lxx,rxx,ymin,fillarg);
		if((lerror -= ldx) < 0) lxx++,lerror -= ldy;
		if((rerror -= rdx) < 0) rxx++,rerror -= rdy;
		lxx += lslope;
		rxx += rslope;
		ymin++;
	    }
	    if(ymin >= ymax) break;
	    while(ynext == lp2[1]) {
		lp1 = lp2;
		if((lp2 -= 2) < pt[0]) lp2 = last;
		lxx = lp1[0];
		ldy = lp2[1] - lp1[1];
	    }
	    while(ynext == rp2[1]) {
		rp1 = rp2;
		if((rp2 += 2) > last) rp2 = pt[0];
		rxx = rp1[0];
		rdy = rp2[1] - rp1[1];
	    }
	}
	MOUSE_UNBLOCK();
}

