//  Copyright (c) 1995 ADVANCED MICRO DEVICES, INC. All Rights Reserved.
//  This software is unpblished and contains the trade secrets and
//  confidential proprietary information of AMD. Unless otherwise provided
//  in the Software Agreement associated herewith, it is licensed in confidence
//  "AS IS" and is not to be reproduced in whole or part by any means except
//  for backup. Use, duplication, or disclosure by the Government is subject
//  to the restrictions in paragraph (b) (3) (B) of the Rights in Technical
//  Data and Computer Software clause in DFAR 52.227-7013 (a) (Oct 1988).
//  Software owned by Advanced Micro Devices, Inc., 901 Thompson Place,
//  Sunnyvale, CA 94088.

//////////////////////// Miscellaneous Functions //////////////////////////

char inline charFromLong   (long  l){return char(l&0x000000FFL);}
int  inline shortFromLong  (long  l){return  int(l&0x0000FFFFL);}
int  inline shortFromLongHi(long  l){return  int((l&0xFFFF0000L)>>16);}
long inline shortToLong    (short s){return long(s);}
long inline shortToLongHi  (short s){return long(s)<<16;}

////////////////////////////// Prototypes /////////////////////////////////

void messageBox(
  char* msg,
  char* lbl="Press a key when ready",
  int   r1=10,
  int   c1=15,
  int   r2=17,
  int   c2=65);

/////////////////////  Root Object for UI Elements ////////////////////////
// User interface objects that can be inserted into the display.

typedef enum {TPels, TChars} TScrnUnit;

const long    lBlack=0;
const long    lBlue=1;
const long    lGreen=2;
const long    lCyan=3;
const long    lRed=4;
const long    lMagenta=5;
const long    lBrown=6;
const long    lWhite=7;
const long    lGray=8;
const long    lLtBlue=9;
const long    lLtGreen=10;
const long    lLtCyan=11;
const long    lLtRed=12;
const long    lLtMagenta=13;
const long    lYellow=14;
const long    lBrtWhite=15;

const int     iEsc      =0x1B;
const int     iTab      =0x09;
const int     iBackSpace=0x08;
const int     iDel      =0x53;
const int     iBackTab  =0xA5;
const int     iClose    =0x6B;
const int     iHelp     =0x3B;
const int     iRight    =0x4D;
const int     iLeft     =0x4B;
const int     iDown     =0x50;
const int     iAltDown  =0xA0;
const int     iUp       =0x48;
const int     iAltTab   =0xA5;
const int     iEnter    =0x0D;
const int     iF10      =0x44;

const int     iJanSum   =0xD9;
const int     iFebSum   =0xCD;
const int     iMarSum   =0xE0;
const int     iAprSum   =0xE3;
const int     iMaySum   =0xE7;
const int     iJunSum   =0xED;
const int     iJulSum   =0xEB;
const int     iAugSum   =0xDD;
const int     iSepSum   =0xE8;
const int     iOctSum   =0xE6;
const int     iNovSum   =0xF3;
const int     iDecSum   =0xCC;

const int     iJan      = 0;
const int     iFeb      = 1;
const int     iMar      = 2;
const int     iApr      = 3;
const int     iMay      = 4;
const int     iJun      = 5;
const int     iJul      = 6;
const int     iAug      = 7;
const int     iSep      = 8;
const int     iOct      = 9;
const int     iNov      =10;
const int     iDec      =11;

#define MAJVER    "v1."
#define MINVER    "10"

#define JANUARY   "JAN"
#define FEBRUARY  "FEB"
#define MARCH     "MAR"
#define APRIL     "APR"
#define MAY       "MAY"
#define JUNE      "JUN"
#define JULY      "JUL"
#define AUGUST    "AUG"
#define SEPTEMBER "SEP"
#define OCTOBER   "OCT"
#define NOVEMBER  "NOV"
#define DECEMBER  "DEC"
#define NOMONTH   0xFFFF

class TDisplayObj
{
 public:
  TDisplayObj(int,int,int,int,TDisplayObj*,const char*);
 ~TDisplayObj();
  char*                 getDataByName(const char*,char*,int);
  void*                 getObjPtrByName(const char*);
  int                   getOrgC(void){return iOrgC;}
  int                   getOrgR(void){return iOrgR;}
  int                   getWidth(void){return iWidth;}
  long                  getBkColor(void){return lBkColor;}
  long                  getFgColor(void){return lFgColor;}
  TDisplayObj*          getPtParent(void){return ptParent;}
  TDisplayObj*          getDispObjFirst(void){return ptDispObjFirst;}
  virtual long          message(long,long);             // Comm between objs.
  virtual TDisplayObj*  findFirstSelectable(TDisplayObj*);
  virtual TDisplayObj*  findNextSelectable(TDisplayObj*);
  virtual TDisplayObj&  operator+(TDisplayObj&); // Add to disp obj lst.
  virtual void          paint(void);                    // Disp obj on scrn.
  void                  setParent(TDisplayObj* p){ptParent=p;}
  void                  setFgBkColors(long f,long b){lFgColor=f;lBkColor=b;}
 protected:
  int           iOrgR;                  // Row of origin.
  int           iOrgC;                  // Column of origin.
  int           iWidth;                 // Width in columns.
  int           iHeight;                // Height in rows.
  int           iDataLen;               // Length of stuff in pcData.
  int           iDataMax;               // Size of pcData buffer.
  long          lBkColor;               // Background color.
  long          lFgColor;               // Foreground color.
  TBool         bDelayedInitCmplt;      // Post construction init done when T.
  TBool         bSelectable;            // True if object can be selected.
  TBool         bSelected;              // True when object is selected.
  TDisplayObj*  ptDispObjNext;          // Fwd link for parent's ptDispObjFirst.
  TDisplayObj*  ptDispObjFirst;         // Head of list of owned display objs.
  TDisplayObj*  ptDispObjLast;          // Tail of same.
  TDisplayObj*  ptParent;               // Owner. Gets msgs that object doesn't know.
  char*         pcData;                 // Data buffer of whatever type.
  char*         pcName;                 // Used to uniquely identify fields.
  static TDisplayObj* ptInputFocus;     // Obj to rx messages.
 private:
  void TDisplayObjInit(TDisplayObj*);
};

class TTextWindow : public TDisplayObj
{
 public:
  TTextWindow(int,int,int,int,TBrdr tBrdr=noBrdr,char* pcTitle=NULL);

  long message(long,long);
  void paint(void);
  void putText(char*);
 protected:
  char*   pcTitle;
 private:
  char  cULC;
  char  cURC;
  char  cLLC;
  char  cLRC;
  char  cLeft;
  char  cRight;
  char  cTop;
  char  cBottom;
  TBrdr tBrdr;
  int   iCurrRow;
  int   iCurrCol;
};

struct TLBEnt
{
  char* pcItemName;
  long  lItemData;
};
class TListBox : public TTextWindow
{
 public:
  TListBox(int,int,int,int,TLBEnt*);
 ~TListBox();
  long message(long,long);
  void paint(void);
  void select(int,int);
  const TLBEnt* getSelectedItem(void)
                {return (const TLBEnt*)&ptItemList[iSelected];}
  const TLBEnt* getItemList(void){return (const TLBEnt*)ptItemList;}
 protected:
  TLBEnt* ptItemList;
  int     iSelected;
  int     iItemListLen;
};

class TTextLbl : public TDisplayObj
{
 public:
  TTextLbl(char*,int,int);
 ~TTextLbl();
  virtual void paint(void);
 protected:
};

const int iDefTextFldLen=32;
const int iTextCursNormal=0x0607;
const int iTextCursNone=0x2000;
 
class TTextFld : public TDisplayObj
{
 public:
  TTextFld(const char*,char*,int,int,int,int);
 ~TTextFld();
  long message(long,long);
  void delOneChar(void);
  void paint(void);
  void setText(char*);
 protected:
  int     iCursPos;
};
 
class TListItem : public TTextLbl
{
 public:
  TListItem(char*,int,int);
 ~TListItem();
  void paint(void);                     // Need our own paint fnc.
 private:
  long  lBkColor;                       // Background when selected.
  long  lFgColor;                       // Foreground when selected.
};

class TComboBox : public TTextFld
{
 public:
  TComboBox(const char*,int,int,int,int,TLBEnt*);
 ~
 TComboBox();
  long  message(long,long);
  void  paint(void);
  const TLBEnt* getItemList(void){return ptListBox->getItemList();}
  const TLBEnt* getSelectedItem(void){return ptListBox->getSelectedItem();}
 protected:
  TListBox*   ptListBox;
};

const int iWndBrdrComp=2;            // Wndw border needs 1 char each side.

class TApplication : public TDisplayObj
{
 public:
  TApplication();
 ~TApplication();
  void paint(void);
  void messageLoop(void);
 private: 
  int       iScrnSzX;
  int       iScrnSzY;
  int       iCurrX;
  int       iCurrY;
  int       iOldCurs;

  TScrnUnit tUnits;
};
const unsigned short MAXATRS    = 16;       // Arbitrary.

class TDosInstl
{
  public:
    TDosInstl();
   ~TDosInstl();
    TBool setNextAtrVal(char*,char*,TType);
    TBool DoInstall(void);
    TDvr  getSelectedDriver(void){return tSelectedDriver;}
    TDvr  setSelectedDriver(TDvr tVal);
    TDvr  setSelectedDriver(char*,const char**);
    TDvr  setSelectedDriver(long);
  private:
    char    acSrcPath[DOSPATHBFRLEN];
    char    acDstPath[DOSPATHBFRLEN];
    char    acSerNum[CHRBFRLEN];
    char    acInstDate[CHRBFRLEN];
    char    acConnType[CHRBFRLEN];
    TAtrVal atAtrsToMod[MAXATRS];
    TDvr    tSelectedDriver;
    int     iAtrValIndex;
};

