/************************************************************************
 *     MultiSound Input Volume Demo Code
 *
 *     This program demonstrates the adjustment of the record in
 *     volume.  Running this with a source on the record input, you
 *     can adjust the volume using the '+' and '-' keys.  The 'q'
 *     key will stop the program.
 *
 *     Copyright 1992  Turtle Beach Systems Inc., All rights reserved.
 *
 *
 * **********************************************************************/

#include <stdio.h>
#include <conio.h>
#include "msnd_dsp.h"
#include "pcontrol.h"


BYTE bTerminator = 0;

main()
{
    bMem        = HPMEM_D000;
    bIrq        = HPIRQ_10;
    //bIrq            = HPIRQ_10;
    //nIRQValue       = 10;
    bIrq            = HPIRQ_9;
    nIRQValue       = 9;
    pMEM.dw.h       = 0xD000;
    pMEM.dw.l       = 0x0000;
    wBASEIO         = 0x290;          // DSP base address to program.

                                        // non plug and play jumpers as follows:
    wCFGIO          =0x250;           //     -------------------
                                      //     | /-------------\ |    address x250
                                      //     | |   o     o   | |
                                      //     | \-------------/ |
                                      //     |                 |
                                      //     |     o     o     |
                                      //     |                 |
                                      //     -------------------



    InitializeSMA();


    if (!UploadDspCode())
    {
        printf("Failed to upload and initialize DSP\n");
        exit(0);
    }


	SetupMsndIRQ();

	SetInVolume( 0x15 , GANG );

	while( !bTerminator ) {
		if( kbhit() ) {
			switch ( getch() ) {
				case '+':
					SetInVolume( ++SMA->bInPotPosLeft , GANG );
					printf("Input Volume = 0x%X\n", SMA->bInPotPosLeft );
					break;

				case '-':
					SetInVolume( --SMA->bInPotPosLeft , GANG );
					printf("Input Volume = 0x%X\n", SMA->bInPotPosLeft );
					break;

				case 'Q':
				case 'q':
					printf("Terminating\n");
					bTerminator = 1;
					break;

			}
		}
  }

  ResetMsndIRQ();
  return(0);
}

