/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.ImageData;

public class InvertMask
extends CoreEffect {
    private int pad;
    private int xoff;
    private int yoff;

    public InvertMask() {
        this(10);
    }

    public InvertMask(Effect effect) {
        this(10, effect);
    }

    public InvertMask(int n) {
        this(n, DefaultInput);
    }

    public InvertMask(int n, Effect effect) {
        super(effect);
        this.setPad(n);
        this.updatePeerKey("InvertMask");
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect effect) {
        this.setInput(0, effect);
    }

    public int getPad() {
        return this.pad;
    }

    public void setPad(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Pad value must be non-negative");
        }
        int n2 = this.pad;
        this.pad = n;
        this.firePropertyChange("pad", n2, n);
    }

    public int getOffsetX() {
        return this.xoff;
    }

    public void setOffsetX(int n) {
        int n2 = this.xoff;
        this.xoff = n;
        this.firePropertyChange("offsetX", n2, n);
    }

    public int getOffsetY() {
        return this.yoff;
    }

    public void setOffsetY(int n) {
        float f = this.yoff;
        this.yoff = n;
        this.firePropertyChange("offsetY", Float.valueOf(f), n);
    }

    @Override
    public BaseBounds getBounds(BaseTransform baseTransform, Effect effect) {
        BaseBounds baseBounds = super.getBounds(BaseTransform.IDENTITY_TRANSFORM, effect);
        BaseBounds baseBounds2 = new RectBounds(baseBounds.getMinX(), baseBounds.getMinY(), baseBounds.getMaxX(), baseBounds.getMaxY());
        baseBounds2.grow(this.pad, this.pad);
        if (!baseTransform.isIdentity()) {
            baseBounds2 = InvertMask.transformBounds(baseTransform, baseBounds2);
        }
        return baseBounds2;
    }

    @Override
    public Rectangle getResultBounds(BaseTransform baseTransform, Rectangle rectangle, ImageData ... imageDataArray) {
        Rectangle rectangle2 = super.getResultBounds(baseTransform, rectangle, imageDataArray);
        Rectangle rectangle3 = new Rectangle(rectangle2);
        rectangle3.grow(this.pad, this.pad);
        return rectangle3;
    }

    @Override
    protected Rectangle getInputClip(int n, BaseTransform baseTransform, Rectangle rectangle) {
        if (rectangle != null && this.pad != 0) {
            rectangle = new Rectangle(rectangle);
            rectangle.grow(this.pad, this.pad);
        }
        return rectangle;
    }
}

