/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMINVMECommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class NVMEInsertSSDCommand
extends SuperBladeCommand {
    byte aoc;
    byte slot;
    byte group;

    @Override
    public boolean preValidate() {
        this.aoc = 0;
        this.slot = 0;
        this.group = 0;
        if (this.parameters == null || this.parameters.length < 3) {
            MOut.G(this).println("Usage: nvme insert <aoc> <group> <slot>");
            this.statusCode = 147;
            return false;
        }
        try {
            this.aoc = Byte.parseByte(this.parameters[0], 10);
        }
        catch (NumberFormatException e) {
            MOut.G(this).println(e.getMessage());
            this.statusCode = 147;
            return false;
        }
        try {
            this.group = Byte.parseByte(this.parameters[1], 10);
        }
        catch (NumberFormatException e) {
            MOut.G(this).println(e.getMessage());
            this.statusCode = 147;
            return false;
        }
        try {
            this.slot = Byte.parseByte(this.parameters[2], 10);
        }
        catch (NumberFormatException e) {
            MOut.G(this).println(e.getMessage());
            this.statusCode = 147;
            return false;
        }
        if (this.slot / 12 != this.group) {
            MOut.G(this).println("Slot-Group mismatch");
            this.statusCode = 147;
            return false;
        }
        this.slot = (byte)(this.slot % 12);
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMINVMECommand ipmiNVMECommand = new IPMINVMECommand(null);
        ipmiNVMECommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (!ipmiNVMECommand.isEjected(this.aoc, this.slot, this.group)) {
            MOut.G(this).println("This device has been inserted already");
            return;
        }
        ArrayList<IPMINVMECommand.NVMEAOCInfo> nvmeAOCInfos = ipmiNVMECommand.getAll();
        if (nvmeAOCInfos == null) {
            this.statusCode = 153;
            MOut.G(this).println("No NVME info");
            return;
        }
        ipmiNVMECommand.setLocate(this.aoc, this.slot, (byte)2, this.group);
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

