/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;
import java.util.HashMap;

public class IPMISensorCommand
extends SuperBladeCommand {
    public static final int READING_SAFE = 0;
    public static final int READING_UNSAFE = 1;
    public static final int READING_UNKNOWN = 2;
    StringBuffer formatedString;
    String formatTemplate = "  %-6s | %-24s | %12s | %9s | %10s |\n";
    String formatTemplateValueOnly = "  %-6s | %-24s | %-27s |\n";
    String formatTemplateThreshold = "  %-6s | %6s | %8s | %-24s | %12s | %8s | %8s | %9s | %9s |\n";
    String formatTemplateNonThreshold = "  %-6s | %6s | %8s | %-24s | %27s |\n";
    HashMap ipToSDRs = new HashMap();
    boolean showThreshold;

    public IPMISensorCommand() {
        if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
            this.formatTemplateThreshold = "  %-6s | %6s | %8s | %8s | %-24s | %12s | %8s | %8s | %9s | %9s |\n";
        }
    }

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            this.showThreshold = false;
            return true;
        }
        if (this.parameters[0].equals("--full")) {
            this.showThreshold = true;
            return true;
        }
        MOut.G(this).println("Parameter error!");
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        ArrayList sdrList = null;
        boolean hasSensorData = false;
        MOut.G(this).println("Getting SDR records ...");
        if (this.ipToSDRs.get(this.config.getIp()) == null) {
            SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
            if (sdrInfo == null) {
                MOut.G(this).println("Get SDR Repository error");
                this.statusCode = 149;
                return;
            }
            try {
                sdrList = ipmiSDRCommand.getSDRsEx(sdrInfo.getRecordCount());
            }
            catch (Exception e) {
                MOut.G(this).println("Get SDR failed:" + e.getMessage());
                this.statusCode = 149;
                return;
            }
            this.ipToSDRs.put(this.config.getIp(), sdrList);
        } else {
            sdrList = (ArrayList)this.ipToSDRs.get(this.config.getIp());
        }
        this.formatedString = new StringBuffer();
        if (this.showThreshold) {
            if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
                this.formatedString.append(String.format(this.formatTemplateThreshold, "Status", "ID", "Num(Hex)", "Duty", "Sensor", "Reading", " Low NR ", " Low CT ", " High CT ", " High NR "));
                this.formatedString.append(String.format(this.formatTemplateThreshold, "------", "--", "--------", "----", "---------", "-------", "--------", "--------", "---------", "---------"));
            } else {
                this.formatedString.append(String.format(this.formatTemplateThreshold, "Status", "ID", "Num(Hex)", "Sensor", "Reading", " Low NR ", " Low CT ", " High CT ", " High NR "));
                this.formatedString.append(String.format(this.formatTemplateThreshold, "------", "--", "--------", "---------", "-------", "--------", "--------", "---------", "---------"));
            }
        } else {
            this.formatedString.append(String.format(this.formatTemplate, "Status", "(#)Sensor", "Reading", "Low Limit", "High Limit"));
            this.formatedString.append(String.format(this.formatTemplate, "------", "---------", "-------", "---------", "----------"));
        }
        boolean isMicroNode = IPMIMessagingCommand.isMicroBladeNodeGUID(new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface()).getSystemGUID());
        MOut.G(this).println("Getting sensors ...");
        block36: for (SDRRecord item : sdrList) {
            if (item.getEventReadingTypeCode() == 3 || item.getEventReadingTypeCode() == 6 || item.getEventReadingTypeCode() == 9 || item.getEventReadingTypeCode() == 111) {
                int status = 2;
                byte discreteReading = ipmiSDRCommand.getDiscreteOffset(item.getSensorNumber());
                int offset = -1;
                for (int i = 0; i < 8; ++i) {
                    if ((discreteReading >> i & 1) != 1) continue;
                    offset = (byte)i;
                }
                String value = offset == -1 ? "N/A" : GlobalDefine.getDiscreteSensorReading(item.getEventReadingTypeCode(), item.getSensorType(), (byte)offset);
                if (item.getEventReadingTypeCode() != 111) {
                    if (offset == 0) {
                        switch (item.getEventReadingTypeCode()) {
                            case 3: 
                            case 6: {
                                status = 0;
                            }
                        }
                    } else if (offset == 1) {
                        switch (item.getEventReadingTypeCode()) {
                            case 3: 
                            case 9: {
                                status = 0;
                                break;
                            }
                            case 6: {
                                status = 1;
                            }
                        }
                    } else if (offset == 5) {
                        switch (item.getEventReadingTypeCode()) {
                            case 9: {
                                status = 1;
                            }
                        }
                    }
                } else if (item.getSensorType() == 5) {
                    if (offset == -1) {
                        value = "OK";
                        status = 0;
                    } else {
                        status = 1;
                    }
                } else if (item.getSensorType() == 7) {
                    if (offset == 7) {
                        status = 0;
                    } else if (offset != -1) {
                        status = 1;
                    }
                } else if (item.getSensorType() == 8) {
                    status = offset == 0 ? 0 : 1;
                } else if (item.getSensorType() == 12) {
                    if (offset == 6) {
                        status = 0;
                    } else if (offset != -1) {
                        status = 1;
                    }
                } else if (item.getSensorType() == 13) {
                    if (offset == 0 || offset == 4) {
                        status = 0;
                    } else if (offset != -1) {
                        status = 1;
                    }
                }
                if (value == "N/A") {
                    status = 2;
                }
                if (this.showThreshold) {
                    this.addRawValueOnly(status, item, value);
                    continue;
                }
                this.addRawValueOnly(status, item.getSensorName(), value);
                continue;
            }
            if (item.getSensorType() == 1 || item.getSensorType() == 2 || item.getSensorType() == 4 || item.getSensorType() == 9 || item.getSensorType() == 11 || item.getSensorType() == -64 || item.getSensorType() == -62) {
                int value = 0;
                value = ipmiSDRCommand.getSensorReading(item.getSensorNumber());
                String reading = "";
                String hi = "";
                String low = "";
                String lnr = "";
                String lct = "";
                String hct = "";
                String hnr = "";
                switch (item.getSensorType()) {
                    case 1: {
                        reading = value == -1 ? "N/A" : this.showCandF((int)item.calSensorReading(value));
                        hi = this.showCandF((int)item.getHiLimit());
                        low = this.showCandF((int)item.getLowLimit());
                        lnr = this.showCandF((int)item.getLowNR());
                        lct = this.showCandF((int)item.getLowCT());
                        hct = this.showCandF((int)item.getHighCT());
                        hnr = this.showCandF((int)item.getHighNR());
                        break;
                    }
                    case 2: {
                        reading = value == -1 || value == 0 ? "N/A" : item.doubleToString(item.calSensorReading(value & 0xFF)) + " V";
                        hi = item.doubleToString(item.getHiLimit()) + " V";
                        low = item.doubleToString(item.getLowLimit()) + " V";
                        lnr = item.doubleToString(item.getLowNR()) + " V";
                        lct = item.doubleToString(item.getLowCT()) + " V";
                        hct = item.doubleToString(item.getHighCT()) + " V";
                        hnr = item.doubleToString(item.getHighNR()) + " V";
                        if (!isMicroNode || !item.getSensorName().contains("VBAT")) break;
                        hi = "N/A";
                        hct = "N/A";
                        hnr = "N/A";
                        break;
                    }
                    case 4: {
                        reading = value == -1 || value == 0 ? "N/A" : "" + (int)item.calSensorReading(value & 0xFF) + " RPM";
                        hi = "" + (int)item.getHiLimit() + " RPM";
                        low = "" + (int)item.getLowLimit() + " RPM";
                        lnr = "" + (int)item.getLowNR() + " RPM";
                        lct = "" + (int)item.getLowCT() + " RPM";
                        hct = "" + (int)item.getHighCT() + " RPM";
                        hnr = "" + (int)item.getHighNR() + " RPM";
                        break;
                    }
                    case -62: 
                    case 9: 
                    case 11: {
                        reading = value == -1 ? "N/A" : (int)item.calSensorReading(value & 0xFF) + " " + item.getUnit();
                        hi = item.getHiLimit() == 0.0 ? "N/A" : "" + item.getHiLimit();
                        low = item.getLowLimit() == 0.0 ? "N/A" : "" + item.getLowLimit();
                        lnr = item.getLowNR() == 0.0 ? "N/A" : "" + item.getLowNR();
                        lct = item.getLowCT() == 0.0 ? "N/A" : "" + item.getLowCT();
                        hct = item.getHighCT() == 0.0 ? "N/A" : "" + item.getHighCT();
                        hnr = item.getHighNR() == 0.0 ? "N/A" : "" + item.getHighCT();
                        break;
                    }
                    case -64: {
                        byte[] values = ipmiSDRCommand.getFullSensorValue(item.getSensorNumber());
                        reading = "N/A";
                        if (values == null) continue block36;
                        if (values != null) {
                            value = values[2];
                            if ((values[1] & 0x20) > 0) {
                                value = 7;
                            }
                            switch (value) {
                                case 0: {
                                    reading = "Low";
                                    break;
                                }
                                case 1: {
                                    reading = "Medium";
                                    break;
                                }
                                case 2: {
                                    reading = "High";
                                    break;
                                }
                                case 4: {
                                    reading = "Overheat";
                                    break;
                                }
                                default: {
                                    reading = "N/A";
                                }
                            }
                        }
                        hi = item.getHiLimit() == 0.0 ? "N/A" : "" + item.getHiLimit();
                        low = item.getLowLimit() == 0.0 ? "N/A" : "" + item.getLowLimit();
                        lnr = item.getLowNR() == 0.0 ? "N/A" : "" + item.getLowNR();
                        lct = item.getLowCT() == 0.0 ? "N/A" : "" + item.getLowCT();
                        hct = item.getHighCT() == 0.0 ? "N/A" : "" + item.getHighCT();
                        hnr = item.getHighNR() == 0.0 ? "N/A" : "" + item.getHighCT();
                    }
                }
                boolean failNa = false;
                if (reading.equalsIgnoreCase("N/A")) {
                    byte[] guid = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface()).getSystemGUID();
                    boolean isAten = false;
                    if (IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isATENAspeedGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid) || IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isAST2400GUID(guid) || IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid)) {
                        isAten = true;
                    }
                    boolean ispowerOn = new IPMIChassisCommand(this.ipmiCMMOEMCommand.getIPMIInterface()).isPowerOn();
                    if (isAten && ispowerOn && item.isIsValueAvailable() && (item.getHiLimit() != 0.0 || item.getLowLimit() != 0.0)) {
                        failNa = true;
                    }
                }
                if (this.showThreshold) {
                    if (failNa) {
                        this.addRaw(1, item, "0", lnr, lct, hct, hnr);
                    } else {
                        this.addRaw(this.checkSensorValue((byte)value, item), item, reading, lnr, lct, hct, hnr);
                    }
                } else if (failNa) {
                    this.addRaw(1, this.getSensornameAndNumber(item), "0", low, hi);
                } else {
                    this.addRaw(this.checkSensorValue((byte)value, item), this.getSensornameAndNumber(item), reading, low, hi);
                }
                hasSensorData = true;
                continue;
            }
            if (item.getSensorType() == 5 || item.getSensorType() == 8 || item.getSensorType() == 21 || item.getSensorType() == 7) {
                byte[] value = ipmiSDRCommand.getFullSensorValue(item.getSensorNumber());
                if (value != null) {
                    byte[] guid;
                    int status = 0;
                    status = value[2] == 0 ? 0 : 1;
                    if (item.getSensorType() == 8 && value[2] == 1) {
                        status = 0;
                    }
                    if (item.getSensorType() == 8 && (guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp())) != null && IPMIMessagingCommand.isOSAGUID(guid)) {
                        status = value[2] == 2 ? 0 : (value[2] == 0 ? 1 : 2);
                    }
                    if (this.showThreshold) {
                        this.addRaw(status, item, ByteUtility.bytesToHex(value), "N/A", "N/A", "N/A", "N/A");
                    } else {
                        this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.bytesToHex(value), "N/A", "N/A");
                    }
                } else if (this.showThreshold) {
                    this.addRaw(2, item, "N/A", "N/A", "N/A", "N/A", "N/A");
                } else {
                    this.addRaw(2, this.getSensornameAndNumber(item), "N/A", "N/A", "N/A");
                }
                hasSensorData = true;
                continue;
            }
            if (item.getSensorType() == -16 || item.getSensorType() == -15 || item.getSensorType() == -14 || item.getSensorType() == -13) {
                byte value = 0;
                value = ipmiSDRCommand.getSensorReading(item.getSensorNumber());
                int status = 0;
                switch (item.getSensorType()) {
                    case -16: {
                        if (value == 0) {
                            status = 0;
                            if (this.showThreshold) {
                                this.addRaw(status, item, "OK", "N/A", "N/A", "N/A", "N/A");
                                break;
                            }
                            this.addRaw(status, this.getSensornameAndNumber(item), "OK", "N/A", "N/A");
                            break;
                        }
                        if (value == 1) {
                            status = 1;
                            if (this.showThreshold) {
                                this.addRaw(status, item, "Error", "N/A", "N/A", "N/A", "N/A");
                                break;
                            }
                            this.addRaw(status, this.getSensornameAndNumber(item), "Error", "N/A", "N/A");
                            break;
                        }
                        status = 2;
                        if (this.showThreshold) {
                            this.addRaw(status, item, ByteUtility.byteToHex(value), "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.byteToHex(value), "N/A", "N/A");
                        break;
                    }
                    case -15: {
                        if (value == 0) {
                            status = 2;
                            if (this.showThreshold) {
                                this.addRaw(status, item, "Not Presence", "N/A", "N/A", "N/A", "N/A");
                                break;
                            }
                            this.addRaw(status, this.getSensornameAndNumber(item), "Not Presence", "N/A", "N/A");
                            break;
                        }
                        if (value == 1) {
                            status = 0;
                            if (this.showThreshold) {
                                this.addRaw(status, item, "Presence", "N/A", "N/A", "N/A", "N/A");
                                break;
                            }
                            this.addRaw(status, this.getSensornameAndNumber(item), "Presence", "N/A", "N/A");
                            break;
                        }
                        status = 2;
                        if (this.showThreshold) {
                            this.addRaw(status, item, ByteUtility.byteToHex(value), "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.byteToHex(value), "N/A", "N/A");
                        break;
                    }
                    case -14: {
                        if (value == 0) {
                            status = 0;
                            if (this.showThreshold) {
                                this.addRaw(status, item, "OK", "N/A", "N/A", "N/A", "N/A");
                                break;
                            }
                            this.addRaw(status, this.getSensornameAndNumber(item), "OK", "N/A", "N/A");
                            break;
                        }
                        if (value == 1) {
                            status = 1;
                            if (this.showThreshold) {
                                this.addRaw(status, item, "Over Temp", "N/A", "N/A", "N/A", "N/A");
                                break;
                            }
                            this.addRaw(status, this.getSensornameAndNumber(item), "Over Temp", "N/A", "N/A");
                            break;
                        }
                        status = 2;
                        if (this.showThreshold) {
                            this.addRaw(status, item, ByteUtility.byteToHex(value), "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.byteToHex(value), "N/A", "N/A");
                        break;
                    }
                    case -13: {
                        if (value == 0) {
                            status = 0;
                            if (this.showThreshold) {
                                this.addRaw(status, item, "OK", "N/A", "N/A", "N/A", "N/A");
                                break;
                            }
                            this.addRaw(status, this.getSensornameAndNumber(item), "OK", "N/A", "N/A");
                            break;
                        }
                        if (value == 1) {
                            status = 2;
                            if (this.showThreshold) {
                                this.addRaw(status, item, "Warp around", "N/A", "N/A", "N/A", "N/A");
                                break;
                            }
                            this.addRaw(status, this.getSensornameAndNumber(item), "Warp around", "N/A", "N/A");
                            break;
                        }
                        status = 2;
                        if (this.showThreshold) {
                            this.addRaw(status, item, ByteUtility.byteToHex(value), "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.byteToHex(value), "N/A", "N/A");
                        break;
                    }
                    default: {
                        if (this.showThreshold) {
                            this.addRaw(status, item, ByteUtility.byteToHex(value), "N/A", "N/A", "N/A", "N/A");
                            break;
                        }
                        this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.byteToHex(value), "N/A", "N/A");
                    }
                }
                hasSensorData = true;
                continue;
            }
            if (item.getSensorType() == 13) {
                byte[] value = ipmiSDRCommand.getFullSensorValue(item.getSensorNumber());
                int status = 1;
                String reading = "";
                if (value == null || value.length < 4) {
                    status = 2;
                    reading = "No reading";
                } else if ((byte)(value[2] & 1) == 1) {
                    reading = "Drive Presence";
                    status = 0;
                } else if ((byte)(value[2] & 2) == 2) {
                    reading = "Drive Fault";
                } else if ((byte)(value[2] & 4) == 4) {
                    reading = "Predictive Failure";
                } else if ((byte)(value[2] & 8) == 8) {
                    reading = "Hot Spare";
                } else if ((byte)(value[2] & 0x10) == 16) {
                    reading = "Consistency Check/Parity Check in progress";
                    status = 0;
                } else if ((byte)(value[2] & 0x20) == 32) {
                    reading = "In Critical Array";
                } else if ((byte)(value[2] & 0x40) == 64) {
                    reading = "In Failed Array";
                } else if ((byte)(value[2] & 0x80) == -128) {
                    reading = "Rebuild/Remap in progress";
                } else if ((byte)(value[3] & 1) == 1) {
                    reading = "Rebuild/Remap Aborted (was not completed normally)";
                } else if (value[2] == 0 && value[3] == 0) {
                    reading = "Not Present";
                    status = 2;
                } else {
                    reading = "Unknown";
                }
                if (this.showThreshold) {
                    this.addRaw(status, item.getSensorName(), reading);
                    continue;
                }
                this.addRawValueOnly(status, this.getSensornameAndNumber(item), reading);
                continue;
            }
            if (item.getSensorType() != 35) continue;
            byte value = 0;
            value = ipmiSDRCommand.getSensorReading(item.getSensorNumber());
            String reading = "";
            switch (value) {
                case 1: {
                    reading = "Tr. to Idle";
                    break;
                }
                case 2: {
                    reading = "Tr. to Active";
                    break;
                }
                case 4: {
                    reading = "Tr. to Busy";
                    break;
                }
                default: {
                    reading = "N/A";
                }
            }
            if (this.showThreshold) {
                this.addRaw(2, item, reading, "N/A", "N/A", "N/A", "N/A");
                continue;
            }
            this.addRaw(2, this.getSensornameAndNumber(item), reading, "N/A", "N/A");
        }
        if (GlobalDefine.THERMAL_TEAM_SCRIPT && this.showThreshold) {
            byte[] PWMdata = ipmiSDRCommand.getPWMDutyCycle();
            for (int i = 0; i < PWMdata.length; ++i) {
                this.formatedString.append(String.format(this.formatTemplateThreshold, "", "", "", PWMdata[i], "PWM " + (i + 1), "", "N/A", "N/A", "N/A", "N/A"));
            }
        }
        if (!hasSensorData) {
            MOut.G(this).println("no sensor data");
        } else {
            MOut.G(this).println(this.formatedString.toString());
        }
        this.statusCode = 0;
    }

    private String getSensornameAndNumber(SDRRecord item) {
        String sensorNameAndNumber = "(" + item.getRecordID() + ") " + item.getSensorName();
        return sensorNameAndNumber;
    }

    public int checkSensorValue(byte reading, SDRRecord item) {
        if (item.getSensorType() == -64) {
            if (reading == 0 || reading == 1 || reading == 2) {
                return 0;
            }
            if (reading == 4) {
                return 1;
            }
            return 2;
        }
        if (reading == 0) {
            return 2;
        }
        if (reading == -1) {
            return 2;
        }
        double value = item.calSensorReading(reading & 0xFF);
        double hi = item.getHiLimit();
        double low = item.getLowLimit();
        if (hi == 0.0 && low == 0.0) {
            return 0;
        }
        if (value < hi && value > low) {
            return 0;
        }
        return 1;
    }

    protected void addRaw(int checkedResult, String name, String value) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        this.formatedString.append(String.format(this.formatTemplateNonThreshold, result, "", "", name, value));
    }

    protected void addRaw(int checkedResult, String name, String value, String low, String high) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        this.formatedString.append(String.format(this.formatTemplate, result, name, value, low, high));
    }

    protected void addRaw(int checkedResult, String name, String aa, String value, String lnr, String lct, String hct, String hnr) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        this.formatedString.append(String.format(this.formatTemplateThreshold, result, name, value, lnr, lct, hct, hnr));
    }

    protected void addRaw(int checkedResult, SDRRecord item, String value, String lnr, String lct, String hct, String hnr) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
            byte[] duty = null;
            if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
                try {
                    IPMISDRCommand sdrCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
                    duty = sdrCommand.getDutyCycle(item.getSensorNumber());
                }
                catch (Exception e) {
                    duty = null;
                }
            }
            this.formatedString.append(String.format(this.formatTemplateThreshold, result, item.getRecordID(), ByteUtility.byteToHex(item.getSensorNumber()), duty == null ? "N/A" : Byte.valueOf(duty[1]), item.getSensorName(), value, lnr, lct, hct, hnr));
        } else {
            this.formatedString.append(String.format(this.formatTemplateThreshold, result, item.getRecordID(), ByteUtility.byteToHex(item.getSensorNumber()), item.getSensorName(), value, lnr, lct, hct, hnr));
        }
    }

    protected void addRawValueOnly(int checkedResult, String name, String value) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        this.formatedString.append(String.format(this.formatTemplateValueOnly, result, name, value));
    }

    protected void addRawValueOnly(int checkedResult, SDRRecord item, String value) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        this.formatedString.append(String.format(this.formatTemplateNonThreshold, result, item.getRecordID(), ByteUtility.byteToHex(item.getSensorNumber()), item.getSensorName(), value));
    }

    protected String showCandF(int c) {
        long f = Math.round(1.8 * (double)c + 32.0);
        if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
            return "" + c;
        }
        return c + "C/" + f + "F";
    }

    protected int getDiscreteStatus(byte readingType, int offset) {
        int checkResult = 0;
        if (offset == 0) {
            switch (readingType) {
                case 3: {
                    checkResult = 0;
                    break;
                }
                case 6: {
                    checkResult = 0;
                }
            }
        } else if (offset == 1) {
            switch (readingType) {
                case 3: {
                    checkResult = 0;
                    break;
                }
                case 6: {
                    checkResult = 1;
                    break;
                }
                case 9: {
                    checkResult = 0;
                }
            }
        } else if (offset == 5) {
            switch (readingType) {
                case 9: {
                    checkResult = 1;
                }
            }
        }
        return checkResult;
    }

    private void faridaWorkAround() {
    }
}

