/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.HDDStatus;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIHDDOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class HDDDiskCommand
extends SuperBladeCommand {
    int index;

    @Override
    public boolean preValidate() {
        this.index = -1;
        if (this.parameters != null) {
            try {
                this.index = Integer.parseInt(this.parameters[0]);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println("Invalid Index");
                return false;
            }
        } else {
            MOut.G(this).println("Index required");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
        ipmiHDDOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            IPMIHDDOEMCommand.HDDMap map = ipmiHDDOEMCommand.getHDDMap();
            if (map == null) {
                MOut.G(this).println("This device does not support HDD interface");
                this.statusCode = 153;
                return;
            }
            if (!map.isExist(this.index)) {
                MOut.G(this).println("This HDD is not present");
                return;
            }
            HDDStatus status = ipmiHDDOEMCommand.getHDDInfoStructure((byte)this.index);
            MOut.G(this).print(status.toString());
        }
        catch (IPMIException ex) {
            MOut.G(this).println("This device does not support HDD interface");
            this.statusCode = 153;
        }
        this.statusCode = 0;
    }
}

