/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.MicroBladeInfoManager;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

public class GenerateMicroBladeBIOSUpdateScriptCommand
extends Command {
    @Override
    public void execute() throws Exception {
        String usage = "Usage: genMicroBladeBIOSUpdateScript <BIOSFilename> <scriptFilename>";
        if (this.parameters == null || this.parameters.length != 2) {
            MOut.G(this).println(usage);
            return;
        }
        MicroBladeInfoManager manager = MicroBladeInfoManager.getInstance();
        String userName = this.config.getUserName();
        String password = this.config.getPassword();
        manager.setIp(this.config.getIp());
        manager.setUsername(userName);
        manager.setPassword(password);
        manager.getData();
        BladeRemoteInfo[] bladeRemoteInfos = manager.bladeRemoteInfos;
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(this.parameters[1]), true));
        bufferedWriter.write("# blade 1...n");
        bufferedWriter.newLine();
        for (int i = 0; i < bladeRemoteInfos.length; ++i) {
            BladeRemoteInfo bladeRemoteInfo = bladeRemoteInfos[i];
            for (int j = 0; j < bladeRemoteInfo.nodeCount; ++j) {
                bufferedWriter.write("task run " + bladeRemoteInfo.getNodeRemoteInfo(j).getBMCPIP() + " " + userName + " " + password + " bios update " + this.parameters[0]);
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.close();
        this.statusCode = 0;
    }
}

