/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.jdkevents;

import com.oracle.jrockit.jfr.EventToken;
import com.oracle.jrockit.jfr.Producer;
import com.sun.xml.internal.ws.org.objectweb.asm.ClassWriter;
import com.sun.xml.internal.ws.org.objectweb.asm.MethodVisitor;
import com.sun.xml.internal.ws.org.objectweb.asm.Type;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import jdk.internal.jfr.events.FileReadEvent;
import jdk.internal.jfr.events.FileWriteEvent;
import jdk.internal.jfr.events.SocketReadEvent;
import jdk.internal.jfr.events.SocketWriteEvent;
import oracle.jrockit.jfr.JFR;
import sun.misc.IoTrace;

public final class IoTracer {
    private static EventToken socketReadToken;
    private static EventToken socketWriteToken;
    private static EventToken fileReadToken;
    private static EventToken fileWriteToken;
    private static ThreadLocal<SocketReadEvent> socketReadEvent;
    private static ThreadLocal<SocketWriteEvent> socketWriteEvent;
    private static ThreadLocal<FileReadEvent> fileReadEvent;
    private static ThreadLocal<FileWriteEvent> fileWriteEvent;
    private static volatile boolean inited;

    public static void enable(JFR jFR, Producer producer) throws Exception {
        socketReadToken = producer.addEvent(SocketReadEvent.class);
        socketWriteToken = producer.addEvent(SocketWriteEvent.class);
        fileReadToken = producer.addEvent(FileReadEvent.class);
        fileWriteToken = producer.addEvent(FileWriteEvent.class);
        socketReadEvent = new ThreadLocal<SocketReadEvent>(){

            @Override
            public SocketReadEvent initialValue() {
                return new SocketReadEvent(socketReadToken);
            }
        };
        socketWriteEvent = new ThreadLocal<SocketWriteEvent>(){

            @Override
            public SocketWriteEvent initialValue() {
                return new SocketWriteEvent(socketWriteToken);
            }
        };
        fileReadEvent = new ThreadLocal<FileReadEvent>(){

            @Override
            public FileReadEvent initialValue() {
                return new FileReadEvent(fileReadToken);
            }
        };
        fileWriteEvent = new ThreadLocal<FileWriteEvent>(){

            @Override
            public FileWriteEvent initialValue() {
                return new FileWriteEvent(fileWriteToken);
            }
        };
        inited = true;
    }

    public static byte[] generateClass() {
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(50, 49, "sun/misc/IoTrace", null, "java/lang/Object", null);
        for (Method method : IoTrace.class.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers())) continue;
            MethodVisitor methodVisitor = classWriter.visitMethod(9, method.getName(), Type.getMethodDescriptor((Method)method), null, null);
            methodVisitor.visitCode();
            Type[] typeArray = Type.getArgumentTypes((Method)method);
            Type type = Type.getReturnType((Method)method);
            int n = 0;
            for (Type type2 : typeArray) {
                int n2;
                switch (type2.getSort()) {
                    case 5: {
                        n2 = 21;
                        break;
                    }
                    case 7: {
                        n2 = 22;
                        break;
                    }
                    case 10: {
                        n2 = 25;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unhandled argument type when generating code: " + type2);
                    }
                }
                methodVisitor.visitVarInsn(n2, n++);
            }
            methodVisitor.visitMethodInsn(184, "oracle/jrockit/jfr/jdkevents/IoTracer", method.getName(), Type.getMethodDescriptor((Method)method));
            if (type.getSort() == 0) {
                methodVisitor.visitInsn(177);
            } else if (type.getSort() == 10) {
                methodVisitor.visitInsn(176);
            } else {
                throw new IllegalArgumentException("Unhandled return type when generating code: " + type);
            }
            methodVisitor.visitMaxs(n + 1, n + 1);
            methodVisitor.visitEnd();
        }
        MethodVisitor methodVisitor = classWriter.visitMethod(2, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    public static Object socketReadBegin() {
        if (!inited || !socketReadToken.isEnabled()) {
            return null;
        }
        SocketReadEvent socketReadEvent = IoTracer.socketReadEvent.get();
        socketReadEvent.reset();
        socketReadEvent.begin();
        return socketReadEvent;
    }

    public static void socketReadEnd(Object object, InetAddress inetAddress, int n, int n2, long l) {
        if (object == null) {
            return;
        }
        SocketReadEvent socketReadEvent = (SocketReadEvent)object;
        socketReadEvent.end();
        if (socketReadEvent.shouldWrite()) {
            String string = inetAddress.toString();
            int n3 = string.lastIndexOf(47);
            socketReadEvent.host = string.substring(0, n3);
            socketReadEvent.address = string.substring(n3 + 1);
            socketReadEvent.port = n;
            socketReadEvent.bytesRead = l;
            socketReadEvent.timeout = n2;
            socketReadEvent.commit();
            socketReadEvent.reset();
            socketReadEvent.host = null;
        }
    }

    public static Object socketWriteBegin() {
        if (!inited || !socketWriteToken.isEnabled()) {
            return null;
        }
        SocketWriteEvent socketWriteEvent = IoTracer.socketWriteEvent.get();
        socketWriteEvent.reset();
        socketWriteEvent.begin();
        return socketWriteEvent;
    }

    public static void socketWriteEnd(Object object, InetAddress inetAddress, int n, long l) {
        if (object == null) {
            return;
        }
        SocketWriteEvent socketWriteEvent = (SocketWriteEvent)object;
        socketWriteEvent.end();
        if (socketWriteEvent.shouldWrite()) {
            String string = inetAddress.toString();
            int n2 = string.lastIndexOf(47);
            socketWriteEvent.host = string.substring(0, n2);
            socketWriteEvent.address = string.substring(n2 + 1);
            socketWriteEvent.port = n;
            socketWriteEvent.bytesWritten = l;
            socketWriteEvent.commit();
            socketWriteEvent.reset();
            socketWriteEvent.host = null;
        }
    }

    public static Object fileReadBegin(String string) {
        if (!inited || !fileReadToken.isEnabled()) {
            return null;
        }
        FileReadEvent fileReadEvent = IoTracer.fileReadEvent.get();
        fileReadEvent.reset();
        fileReadEvent.path = string;
        fileReadEvent.begin();
        return fileReadEvent;
    }

    public static void fileReadEnd(Object object, long l) {
        if (object == null) {
            return;
        }
        FileReadEvent fileReadEvent = (FileReadEvent)object;
        fileReadEvent.end();
        fileReadEvent.bytesRead = l;
        fileReadEvent.commit();
        fileReadEvent.reset();
        fileReadEvent.path = null;
    }

    public static Object fileWriteBegin(String string) {
        if (string == null) {
            return null;
        }
        if (!inited || !fileWriteToken.isEnabled()) {
            return null;
        }
        FileWriteEvent fileWriteEvent = IoTracer.fileWriteEvent.get();
        fileWriteEvent.reset();
        fileWriteEvent.path = string;
        fileWriteEvent.begin();
        return fileWriteEvent;
    }

    public static void fileWriteEnd(Object object, long l) {
        if (object == null) {
            return;
        }
        FileWriteEvent fileWriteEvent = (FileWriteEvent)object;
        fileWriteEvent.end();
        fileWriteEvent.bytesWritten = l;
        fileWriteEvent.commit();
        fileWriteEvent.reset();
        fileWriteEvent.path = null;
    }

    static {
        inited = false;
    }
}

