/*   V2DOSFIX.C	V1.0	12/23/97
 *
 *   Many V2x00 regularly play one or more Rendition-Ready MSDOS titles.
 *   Unforunately, most of these MSDOS games (Nascar2, Tomb Raider, etc.)
 *   were written before the V2x00 came into existance and have not been
 *   updated since.  While they can still be run in all their
 *   Rendition-accelerated glory, doing so requires use of Win95's DOS-box,
 *   an undesirable arrangement for some.
 *
 *   v2dosfix is a generic patch for Verite-accelerated DOS games.  When
 *   invoked with a user-specified filename, the program searches the binary
 *   for the first occurence
 *   of the Verite's PCI identification string: PCI_deviceID (0x0001) and
 *   PCI_vendorID (0x1163)  Upon locating these two elements, s2dosfix
 *   replaces the file's deviceID with the V2x00's deviceID -> 0x2000
 *
 *   The file is then written back to the disk.  If all goes well, this
 *   program will have changed the correct bytes.  Due to the very loose
 *   pattern-finding parameters, multiple occurences of the device/vendor
 *   pattern will confuse v2dosfix.  v2dosfix will report to the user
 *   warning condit ons that may have caused the patch-process to fail.
 *
 *   The absence of a failure report is not a 100% assurance:  running
 *   the patched game-executable is the
 *   algorithm will be confused
 *
 *
 *   program searches
 *
 */


#include<string.h>
#include<stdio.h>
#include<stdlib.h>
#include<stddef.h>


#define _ERROR -1
#define TRUE	1
#define FALSE	0
#define BUF_SIZE 1024
     /* s2dosfix reads BUF_SIZE# of bytes per disk-access. */
#define BACK_DISTANCE 30
     /* #byte positions to backtrack when searching for deviceID. */

/* the following two extern declarations link the command-line */

extern int _argc;
extern char **_argv;

/*
union word
{
     unsigned int w;
     struct
     {
          unsigned char b0;
          unsigned char b1;
     } b;
};
*/

/* union dword is a convenient data structure used by the search-loop */

union dword
{
     unsigned long int dw;    /* dword.dw is (unsigned long int) */

     struct
     {
          unsigned short int w0;
          unsigned short int w1;
     } w;          /* dword.w.w0, dword.w.w1 are (unsigned short int) */

     struct
     {
          unsigned char b0;
          unsigned char b1;
          unsigned char b2;
          unsigned char b3;
     } b;          /* dword.b.b0 ... dword.b.b3 are (unsigned char)	*/

};

/* below are the search strings that s2dosfix looks for! */

const union dword device= { 0x00000001 };     /* The V1000's deviceID	*/
const union dword vendor= { 0x00001163 };    /* Verite's assigned vendorID */


void
help_message( void )
{
     printf("\n\nUsage : V2DOSFIX.EXE [source file]");
     printf("\n\n\t[source file] -- MSDOS game-binary (EXE) to patch " );
     printf("\n\n\t*** MAKE A BACKUP OF THE EXE BEFORE PROCEEDING!!! ***\n");
     printf("\n\n\t\tV2DOSFIX.EXE patches MSDOS Rendition-Ready (Speedy3D)");
     printf("\n\t\texe's so the Rendition V2x00 chips can run them natively");
     printf("\n\t\tunder MSDOS, without the overhead of Win95's MS-DOS box.");
     printf("\n\t\tOn the command-line, type the name of the game's EXE.");
     printf("\n\n\t(refer to V2DOSFIX.TXT for a list of compatible games.)");
     return;
}


/* compare compares dword with the first 4 bytes of char data[]
 *
 * returns :   1    if all 4 bytes of {key} and data[] match
 *             0    otherwise (no match)
 */
int
compare( const union dword key, const unsigned char data[] )
{
     if ( key.b.b0 == data[ 0 ] &&
         key.b.b1 == data[ 1 ] &&
         key.b.b2 == data[ 2 ] &&
         key.b.b3 == data[ 3 ] )
         return TRUE;	/* strings match! */
     else
         return FALSE;	/* strings don't match! */
}


int
is_period( const char string[] )
{
     int i=0;
     int is_period = FALSE;

     while ( string[ i ] != NULL && i < 1000 )
          if ( string[ i++ ] == '.' )
             is_period=TRUE;

     return is_period;
}

void
patch_file( FILE *file, const union dword new_id )
{
     unsigned char buffer1[ BUF_SIZE + 100 ];
     long int i, j, marker0 = -1,marker1=-1 ,status1, status2, slen, count1=0;
     int endoffile = FALSE;
     int state = 0;

     count1 = 0;

     do	{
          fseek( file, count1, SEEK_SET );
          status1 = fread( buffer1, sizeof( char ), BUF_SIZE + 4, file );

          if ( status1 > 4 )
             slen = status1 - 4;
          else
          {
               slen = 0;
               printf("\nerror at %ld, slen = 0 ", count1 );
          }

          /* the switch( ) statement is the algorithm's state-machine */
          switch ( state )
          {
             case 0 : /* search for vendor_id */

                for ( i = 0; i < slen; ++i )
                   if ( compare( vendor, &buffer1[ i ]  ) == TRUE )
                      {
                         printf("\nFound vendorID at offset +%ld.",count1+i);
                         marker0 = count1 + i;
                         state = 1;
                      }
             break;

               case 1: /* search for pci_id */
                  fseek( file, marker0 - BACK_DISTANCE, SEEK_SET );

                  if ( fread( buffer1, sizeof( char ), BACK_DISTANCE + 4,
                     file )  != BACK_DISTANCE + 4 )
                     {
                         fprintf( stderr, "\nFATAL ERROR!  fread() failed!");
                         fclose( file );
                         exit( EXIT_FAILURE );
                     }

                    for ( j = 0; j < BACK_DISTANCE ; ++j)
		              if ( compare( device, &buffer1[ j ]  ) == TRUE )
                        {
                           marker1 = marker0- BACK_DISTANCE + j ;
                           printf("\n\tFound deviceID at offset +%ld.",marker1);
                           state = 2;
                        }

                  if ( state != 2 )
                  {
                    printf("  false alarm (no matching deviceID found)");
                    state = 0;      /* return to vendor-search mode */
                  }
                  break;

               case 2:  /* replace PCI_ID with "new_id" */
                  /* go to marker's location */
                  printf("  Going to location +%ld", marker1 );
                  if ( fseek( file, marker1, SEEK_SET ) != 0 )
                  {
                     fprintf( stderr,
                        "\nFATAL ERROR!  Could not seek that location!");
                     fclose ( file );
                     exit( EXIT_FAILURE );
                  }
                  status2 = fwrite( &new_id.dw, sizeof( new_id.dw ),1,file );
                  if ( status2 != 1 )
                  {
                     fprintf( stderr,
                        "\nFATAL ERROR!  Could not write to file!");
                     fclose( file );
                     exit( EXIT_FAILURE );
                  }
                  state = 3;
                  count1 = marker1; /* move past current location*/
                  break;

               case 3:  /* continue scanning for the vendor-string just
                        in case, if there are multiple occurences, we
                        should assume we modified the WRONG occurence! */
                  for ( i = 0; i < slen; ++i )
                      if ( compare( vendor, &buffer1[ i ]  ) == TRUE )
                      {
                        printf("\nFound another occurence of vendorID at offset +%ld.",
				        count1 +i );
                        printf("\n***** PATCH ATTEMPT PROBABLY FAILED (*sigh) ***** ");
                            state = 4;
                      }
                  break;

               default:
                  ;
               }


          /* in the rare event that < 4 bytes are read, bypass counter */
          if ( status1 > 4 )
             count1 += status1 - 4;

          /* if (#bytes_read != #bytes_requested), assume we hit EOF cond */
          if ( status1 != BUF_SIZE + 4)
          {
               endoffile = TRUE;
               printf("\nEnd of file detected at offset +%ld.", count1+4 );
          }
     }    while( !endoffile );

     /* check how far the patch state-machine got */

     switch ( state )
     {
          case 0 :
               printf("\nPatch failed..algorithm ended in vendor-seek state",
                    vendor.dw );
               break;
          case 1 :
               printf("\nPatch failed...algorithm found vendor, but not ");
               printf("deviceID (0x%08lX)", device.dw );
               break;
          case 2 :
               printf("\nPatch failed...could not rewrite input file");
               break;
          case 3 :
               printf("\nReplacement deviceID (0x%08lX) successfully written.",
                    new_id.dw );
               break;
          default:
               printf("\n*** UNKNOWN ERROR ***");
               printf("\n(algorithm ended in undefined state.)");
     }
}


void
main( void )
{
     char inname[ 50 ];  /* input filename */

     union dword new_id = { 0x00002000 }; /* default replacement deviceID */

     FILE *file; /* MSDOS file pointer */

     printf("\nV2DOSFIX.EXE msdos-verite patcher V1.0 (12/23/97)");

     if ( _argc > 1 )
     {
          strcpy( inname, _argv[ 1 ] );
          /* if there is a 2nd command-line parameter, -> replace deviceID */
          if ( _argc > 2 )
             sscanf( _argv[ 2 ], " %x", &new_id.w.w1 );
     }
     else
     {
          /* no command-line parameters, display help-message, then exit */
          help_message();
          exit( EXIT_SUCCESS );
     }

     file = fopen( inname, "rb+" );

     if ( file == NULL )	{
          fprintf( stderr, "\nFATAL ERROR!  Could not open %s!", inname );
          if ( is_period( inname ) == FALSE )
               fprintf( stderr,"\n(did you enter the COMPLETE (%s.EXE) name?",
                        inname );
          exit( EXIT_FAILURE );
     }

     patch_file( file, new_id );

     fclose( file );
}