                PAGE    80,132
                NAME    WEMS4
                SMART

include         wems.inc
include         wems.mac
include         mac_ibm.inc

;************************************************************************
;*          EMM/EMS ࠩ   ७                 *
;*              4.0 /  1.3  15/4/1991                   *
;************************************************************************

;--  EMS  ------------------------------------------------------:
;                                                                       :
; EMS_R0 : 76543210                                                     :
;          ||||++++-       1552      :
;          |||+----- (=1)  DC1 ࠧ襭                       :
;          ||+------ (=1)  DC2 ࠧ襭                       :
;          |+------- (=1)  DC3 ࠧ襭                       :
;          +--------  1 -  EMS ࠧ襭                           :
;                     0 -  饭, ࠧ襭   DC1 - DC3 :
;-----------------------------------------------------------------------:

code            SEGMENT
                ASSUME  CS:code

                ORG     0000H

                ;   
Emmdrv          DW      -1,-1           ;  ᫥饬 ࠩ
                DW      8000H
                DW      OFFSET strategy
                DW      OFFSET interrupt
Ems_ID          DB      'EMMXXXX0'

ptrsav          LABEL   DWORD
parofs          DW      0
parseg          DW      0

Page_Frame_Seg  DW      ?
total_pages     DW      PAGE_MAX        ;ᥣ ᪨ ࠭...
un_alloc_pages  DW      PAGE_MAX        ;ᥣ ᢮ ࠭...
handle_count    DW      0               ;ᥣ  ਯ஢ EMM...
jump_addr       DW      0               ; 室  㭪 EMM
emm_flag        DB      0               ; ⠫஢ ࠩ EMM

;
;       । ᬥ饭    ࠩ
;
iodat           STRUC
        cmdlen  DB      ?       ; ⮣ 
        unit    DB      ?       ; ன⢠
        cmd     DB      ?       ; 
        status  DW      ?       ;
                DB      8 DUP (?)
        media   DB      ?       ;ਯ ⥫
        trans   DD      ?       ;  ࠩ
        count   DW      ?       ; ப CONFIG.SYS
        start   DW      ?
iodat           ENDS

iodat2          STRUC
                DB      13 DUP (?)
                DB      ?
        brkoff  DW      ?       ;  ࠩ (OFFSET)
        brkseg  DW      ?       ;  ࠩ (SEGMENT)
iodat2          ENDS

; ࠡ稪 ⥣  - ⥬.
;
;                EVEN
strategy        PROC    FAR
                mov     cs:Parofs,bx
                mov     cs:Parseg,es
                ret
strategy        ENDP

; ࠡ稪   樠 ࠩ
;
;                EVEN
interrupt       PROC    FAR
                push    ax bx ds
                lds     bx,cs:Ptrsav    ; 㪠⥫   
                mov     al,[bx].cmd     ;   (1 => 16)
                cmp     al,10h          ;஢ ⨬ 
                ja      cmd_err         ;⨬  
                or      al,al           ; 樠樨 ?
                jnz     exit            ;஢ 䫠 EMS
                jmp     emminit         ;樠஢ ࠩ
cmd_err:
                mov     ax,8103h        ;⢨⥫쭠 
                jmp     exit1
exit:
                mov     ah,00000001B    ;⠭  襭
exit1:
                lds     bx,cs:Ptrsav    ;⠭ 㪠⥫   
                mov     [bx].status,ax  ;࠭    
                pop     ds bx ax
                ret
interrupt       ENDP

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

;--------------------------------------------------------------------
;        楤 뢠 int67 ࠩ EMM
;--------------------------------------------------------------------
int67           PROC    FAR
                sub     sp,EMMWORK
                sti
                push    ds es bp di si dx cx bx
                mov     bp,sp
                cld
                push    cs
                pop     ds

                ASSUME  DS:code

                cmp     ah,40H                  ;஫  㭪樨
                jb      err84                   ;(40H - 5EH)?
                cmp     ah,5EH
                jnb     err84
                push    bx
                mov     Jump_Addr,ax
                xchg    ah,al
                xor     ah,ah
                sub     ax,40H
                shl     ax,1
                mov     bx,offset Func_Table
                add     bx,ax
                mov     ax,[bx]
                xchg    ax,Jump_Addr
                pop     bx
                jmp     Jump_Addr               ;JMP  㭪樨
noerr:                                          ;窠 ଠ쭮 
                xor     ah,ah
err_ret:                                        ;窠   訡
                pop     bx cx dx si di bp es ds
                add     sp,EMMWORK
                iret
int67           ENDP

;--------------------------------------------------------------------
;       ⠡ ᮢ 㭪権 ࠩ EMM
;               (40H - 5DH)
;--------------------------------------------------------------------
func_table      LABEL   WORD
                DW      OFFSET func1            ;㭪 1
                DW      OFFSET func2            ;㭪 2
                DW      OFFSET func3            ;㭪 3
                DW      OFFSET func4            ;㭪 4
                DW      OFFSET func5            ;㭪 5
                DW      OFFSET func6            ;㭪 6
                DW      OFFSET func7            ;㭪 7
                DW      OFFSET func8            ;㭪 8
                DW      OFFSET func9            ;㭪 9
                DW      OFFSET func10           ;㭪 10
                DW      OFFSET func11           ;㭪 11
                DW      OFFSET func12           ;㭪 12
                DW      OFFSET func13           ;㭪 13
                DW      OFFSET func14           ;㭪 14
                DW      OFFSET func15           ;㭪 15
                DW      OFFSET func16           ;㭪 16
                DW      OFFSET func17           ;㭪 17
                DW      OFFSET func18           ;㭪 18
                DW      OFFSET func19           ;㭪 19
                DW      OFFSET func20           ;㭪 20
                DW      OFFSET func21           ;㭪 21
                DW      OFFSET func22           ;㭪 22
                DW      OFFSET func23           ;㭪 23
                DW      OFFSET func24           ;㭪 24
                DW      OFFSET func25           ;㭪 25
                DW      OFFSET func26           ;㭪 26
                DW      OFFSET func27           ;㭪 27
                DW      OFFSET func28           ;㭪 28
                DW      OFFSET func29           ;㭪 29
                DW      OFFSET func30           ;㭪 30

;--------------------------------------------------------------------
;                訡
;--------------------------------------------------------------------

;७ 訡 ࠩ EMM.
err80:
                MOV     AH,80H
                JMP     err_ret

;訡   EMS.
err81:
                MOV     AH,81H
                JMP     err_ret

; ਯ EMM.
err83:
                MOV     AH,83H
                JMP     err_ret

;襭 । 㭪.
err84:
                MOV     AH,84H
                JMP     err_ret

; 㯭 ਯ஢.
err85:
                MOV     AH,85H
                JMP     err_ret

;訡  ࠭  ⠭ 饣 ⥪.
err86:
                MOV     AH,86H
                JMP     err_ret

; ॢ蠥   EMS.
err87:
                MOV     AH,87H
                JMP     err_ret

; ॢ蠥 ᫮ ᢮ ࠭.
err88:
                MOV     AH,88H
                JMP     err_ret

;⪠  ਯ  㫥 ᫮ ࠭.
err89:
                MOV     AH,89H
                JMP     err_ret

;ਯ   ⠪ ᫠ ࠭.
err8a:
                MOV     AH,8AH
                JMP     err_ret

;୮ ஢,। ⮫쪮 䨧᪨ ࠭.
err8b:
                MOV     AH,8BH
                JMP     err_ret

;९  ࠭ 饣 ⥪.
err8c:
                MOV     AH,8CH
                JMP     err_ret

; ࠭ ⥪ ⮫쪮 ࠧ  ⥫.
err8d:
                MOV     AH,8DH
                JMP     err_ret

; ⠭ ⥪  ।⥫쭮 ࠭.
err8e:
                MOV     AH,8EH
                JMP     err_ret

; । ࠬ 㭪樨.
err8f:
                MOV     AH,8FH
                JMP     err_ret

; । ⨯ ਡ.
err90:
                MOV     AH,90H
                JMP     err_ret

;䨣 ⥬  ন ६頥.
err91:
                MOV     AH,91H
                JMP     err_ret

;-筨  -ਥ  EMS ४뢠.
err92:
                MOV     AH,92H
                JMP     err_ret

; ਥ  㪠 ਯ ᫨誮 .
err93:
                MOV     AH,93H
                JMP     err_ret

; 㪠  ४뢠  EMS.
err94:
                MOV     AH,94H
                JMP     err_ret

;誮 讥 ᬥ饭  筮 뫪.
err95:
                MOV     AH,95H
                JMP     err_ret

;  ॢ蠥 1.
err96:
                MOV     AH,96H
                JMP     err_ret

;-筨  -ਥ EMS      ਯ 
;४뢠.
err97:
                MOV     AH,97H
                JMP     err_ret

; ⨯  筨  ਥ.
err98:
                MOV     AH,98H
                JMP     err_ret

; ন ⠭ ॣ ୠ⨢ ஢.
err9a:
                MOV     AH,9AH
                JMP     err_ret

; ୠ⨢ ॣ ஢/ ।.
err9b:
                MOV     AH,9BH
                JMP     err_ret

; ⠭ ୠ⨢ ॣ஢ ஢/  ন.
err9c:
                MOV     AH,9CH
                JMP     err_ret

; ୠ⨢ ॣ ஢/ ७  .
err9d:
                MOV     AH,9DH
                JMP     err_ret

;Dedicated DMA channels are not supported.
err9e:
                MOV     AH,9EH
                JMP     err_ret

;    ন.
err9f:
                MOV     AH,9FH
                JMP     err_ret

; ਯ஢,ᮮ⢥ 㪠 .
erra0:
                MOV     AH,0A0H
                JMP     err_ret

;ਯ  㪠  㦥 .
erra1:
                MOV     AH,0A1H
                JMP     err_ret

; + ᬥ饭 筨  1.
erra2:
                MOV     AH,0A2H
                JMP     err_ret

;ন 㪠   ᯮ祭  ୮.
erra3:
                MOV     AH,0A3H
                JMP     err_ret

;   㭪樨 饭.
erra4:
                MOV     AH,0A4H
                JMP     err_ret

;------ 㭪  40h ------------------------------------------------
;  
; 室
;       AH      : 
;--------------------------------------------------------------------
func1:
                CMP     emm_flag,1              ;EMM ⠭ ?
                JNZ     f11                     ;
                JMP     noerr                   ;室
f11:
                JMP     err80                   ;室  訡

;------ 㭪  41h ------------------------------------------------
;    EMS
; 室
;       AH      : 
;       BX      : ᥣ  
;--------------------------------------------------------------------
func2:
                MOV     BX,page_frame_seg
f21:
                MOV     [BP].bx_save,BX
                JMP     noerr                   ;室

;------ 㭪  42h ------------------------------------------------
;  稪 ᢮ ࠭
; 室
;       AH      : 
;       BX      : ᢮ ࠭...
;       DX      : ᥣ ࠭...
;--------------------------------------------------------------------
func3:
                MOV     DX,total_pages
                MOV     BX,un_alloc_pages
                MOV     [BP].dx_save,DX         ; ᫮ ࠭
                JMP     f21

;------ 㭪  43h ------------------------------------------------
; ஢ ࠭
; 室
;       BX      : ॡ㥬 ᫮ ࠭
; 室
;       AH      : 
;       DX      : ਯ EMM
;--------------------------------------------------------------------
func4:
                OR      BX,BX
                JZ      f49                     ;襭 0 ࠭
f41:
                CMP     total_pages,BX
                JB      f42                     ;襭 ,祬  ᥣ
                CMP     un_alloc_pages,BX
                JB      f43                     ;襭 ,祬  ᢮
                XOR     DX,DX
                XOR     SI,SI
                MOV     CX,HANDLE_CNT
f45:
                CMP     [SI].handle_flag,0      ;᢮ ਯ ?
                JZ      f44
                INC     DX
                ADD     SI,FLAG_SIZE            ;ਡ  䫠 ~~
                LOOP    f45
                JMP     err85                   ;室  訡
f44:
                MOV     [SI].handle_flag,1      ;⠭ 祭 ~⨢~
                INC     handle_count            ;㢥 稪 ਯ஢
                SUB     un_alloc_pages,BX       ;㬥 稪 ᢮ ࠭
                MOV     [SI].alloc_page_count,BX; ⢮ ॡ ࠭
                MOV     [SI].back_address,0     ;㫨  ࠭ ⥪
                MOV     DI,page_ptr
                MOV     [SI].page_address,DI    ; ᯨ᪠ ஢ . ࠭
                PUSH    CS
                POP     ES
                MOV     SI,OFFSET log_page      ; ᪨ ࠭
                XOR     AX,AX
                MOV     CX,BX
                JCXZ    f48                     ;CX = 0?
f47:
                CMP     WORD PTR [SI],NOT_USE   ;᢮ ࠭ ?
                JZ      f46
f4a:
                ADD     SI,LOG_SIZE
                INC     AX
                JMP     f47
f46:
                MOV     [SI],DX
                STOSW                           ;  ਯ
                LOOP    f4a
f48:
                MOV     [BP].dx_save,DX         ; ਯ
                MOV     [BP].bx_save,BX         ; ᫮ ஢ ࠭
                MOV     page_ptr,DI
                JMP     noerr                   ;室
f49:
                JMP     err89                   ;室  訡
f42:
                JMP     err87                   ;室  訡
f43:
                JMP     err88                   ;室  訡

;------ 㭪  44h ------------------------------------------------
; ஢ ࠭
; 室
;       AL      :  䨧᪮ ࠭
;       BX      :  ᪮ ࠭ (᫨ BX=FFFFH,᪫ ࠭)
;       DX      : ਯ
; 室
;       AH      : 
;--------------------------------------------------------------------
func5:
                CMP     AL,PHYS_PAGES
                JNB     f51                     ;  䨧. ࠭
                MOV     DI,OFFSET map_table     ;  䨧. ࠭
                XCHG    AL,CL
                MOV     AX,SIZE phys_page_struct
                MUL     CL
                ADD     DI,AX
                CMP     DX,HANDLE_CNT           ;஢ઠ ਯ
                JNB     f5a
                MOV     SI,DX
                SHL     SI,1
                CMP     [SI].handle_flag,0      ;ਯ ⨢ ?
                JZ      f5a
                CMP     BX,UNMAP                ;᪫ ࠭ ?
                JZ      f57
                CMP     BX,[SI].alloc_page_count; .࠭ ࠢ ?
                JNB     f53
                SHL     BX,1
                ADD     BX,[SI].page_address
                MOV     AX,[BX]
                CMP     DX,[DI]                 ;  ਯ ?
                JNZ     f54
                CMP     AL,[DI].log_page_data   ;  ࠭ ?
                JZ      f56
f54:
                mov     bx,[di].Phys_Seg_Addr
                call    ems_out
f58:
                MOV     [DI],DX                 ;  ਯ
                MOV     [DI].log_page_data,AL   ;  .࠭
f56:
                JMP     noerr                   ;室
f57:
                XOR     AL,AL                   ;᪫ ࠭
                CMP     WORD PTR [DI],UNMAP
                JNZ     f55
                CMP     AL,[DI].log_page_data
                JZ      f56
f55:
                mov     al,DISABLE
                mov     bx,[di].Phys_Seg_Addr   ;᪫...
                call    ems_out
                MOV     DX,UNMAP
                JMP     f58
f51:
                JMP     err8b                   ;室  訡
f53:
                JMP     err8a                   ;室  訡
f59:
                JMP     err81                   ;室  訡
f5a:
                JMP     err83                   ;室  訡

;------ 㭪  45h ------------------------------------------------
; ஢ ࠭
; 室
;       DX      : ਯ
; 室
;       AH      : 
;--------------------------------------------------------------------
f61:
                JMP     err83                   ;室  訡
f63:
                JMP     err86                   ;室  訡
func6:
                PUSH    CS
                POP     ES
                CMP     DX,HANDLE_CNT           ;஢ઠ ਯ
                JNB     f61
                MOV     BX,DX
                SHL     BX,1
                CMP     [BX].handle_flag,0      ;ਯ ⨢ ?
                JZ      f61
                CMP     [BX].back_address,0     ;ᯮ짮 ࠭ ⥪?
                JNZ     f63
                MOV     CX,[BX].alloc_page_count
                JCXZ    f6c                     ;page = 0 ?
                MOV     DI,[BX].page_address    ;஢ .࠭...
                PUSH    BX
f65:
                MOV     BX,[DI]
                SHL     BX,1
                MOV     [BX].log_page,NOT_USE
                INC     un_alloc_pages          ;᫥ ࠭...
                INC     DI
                INC     DI
                LOOP    f65
                POP     BX
                MOV     SI,DI                   ;⪠  ஢  ࠭...
                MOV     DI,[BX].page_address
                MOV     CX,page_ptr
                SUB     CX,SI
                SHR     CX,1
                JCXZ    f62
                REPZ    MOVSW
f62:
                MOV     CX,[BX].alloc_page_count
                JCXZ    f68
                MOV     AX,UNALLOC
                REPZ    STOSW
f68:
                XOR     DI,DI                   ; ᮢ ࠭
                MOV     SI,[BX].page_address    ;  ࠭
                MOV     AX,[BX].alloc_page_count; ᫮ ࠭
                SHL     AX,1
                MOV     CX,handle_count
f66:
                CMP     [DI].handle_flag,0      ; ⨢ ਯ?
                JZ      f6b
                CMP     [DI].page_address,SI    ; ࠭ > SI ?
                JNG     f64
                SUB     [DI].page_address,AX    ; ࠭ - AX
f64:
                LOOP    f6b
                SUB     page_ptr,AX             ;㬥 㪠⥫ ࠭
                MOV     CX,PHYS_PAGES           ;஢ 䨧.࠭...
                XOR     AL,AL
                MOV     SI,OFFSET map_table
f6a:
                CMP     [SI],DX                 ;  ਯ?
                JNZ     f67
                CALL    reset_phys_page         ; 䨧.࠭
                JNB     f67
                JMP     err81                   ;室  訡
f6b:
                ADD     DI,FLAG_SIZE
                JMP     f66
f67:
                INC     AL
                ADD     SI,SIZE phys_page_struct
                LOOP    f6a
f6c:
                MOV     [BX].handle_flag,0      ; 䫠 ᯮ짮
                MOV     [BX].alloc_page_count,0 ; 稪 ࠭
                MOV     [BX].page_address,0     ; 㪠⥫ ᯨ᪠ ࠭
                MOV     [BX].back_address,0     ; 㪠⥫ ࠭ ⥪
                MOV     DI,OFFSET handle_name   ;  ਯ
                MOV     AX,DX
                MOV     CL,3
                SHL     AX,CL
                ADD     DI,AX
                XOR     AL,AL
                MOV     CX,HANDLE_NAME_SIZE
                REPZ    STOSB
                CMP     DX,0                    ;⥬ ਯ?
                JZ      f6d
                DEC     handle_count            ;㬥 稪 ਯ஢
                JMP     noerr                   ;室
f6d:
                MOV     [BX].handle_flag,1
                JMP     noerr                   ;室

;------ 㭪  46h ------------------------------------------------
;   EMS
; 室
;       AH      : 
;       AL      :  ᨨ
;--------------------------------------------------------------------
func7:
                MOV     AL,EMSVER
                JMP     noerr

;------ 㭪  47h ------------------------------------------------
; ࠭ 騩 ⥪
; 室
;       DX      : ਯ
; 室
;       AH      : 
;--------------------------------------------------------------------
func8:
                PUSH    CS
                POP     ES
                CMP     DX,HANDLE_CNT           ;஢ઠ ਯ
                JNB     f81
                MOV     SI,DX
                SHL     SI,1
                CMP     [SI].handle_flag,1      ;ਯ ⨢ ?
                JNZ     f81
                CMP     [SI].back_address,0     ;୮ ࠭ ?
                JNZ     f82
                MOV     AL,backup_count
                CMP     AL,BACK_MAX
                JB      f83
                JMP     err8c                   ;室  訡
f83:
                MOV     DI,back_ptr             ;஢  ஢ -> [DI]
                MOV     [SI].back_address,DI
                MOV     SI,OFFSET map_table
                MOV     CX,CONTEXT_SIZE
                REPZ    MOVSB
                INC     backup_count
                MOV     back_ptr,DI
                JMP     noerr                   ;室
f81:
                JMP     err83                   ;室  訡
f82:
                JMP     err8d                   ;室  訡

;------ 㭪  48h ------------------------------------------------
; ⠭ 騩 ⥪
; 室
 Oϙ	   pO  	pOϞpp@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ppF@pϐψO  	    pp B@pχϜppχϘppϜϙ    	   pϐψFppϐ Ϝpτ     BX,1
                CMP     [BX].handle_flag,1      ;ਯ ⨢ ?
                JNZ     f91
                CMP     [BX].back_address,0     ;୮ ⠭ ?
                JZ      f92
                MOV     DI,OFFSET map_table     ; 䨧.࠭...
                MOV     CX,PHYS_PAGES
f93:
                push    bx
                mov     bx,[di].Phys_Seg_Addr
                mov     al,DISABLE
                call    ems_out
                pop     bx
                ADD     DI,SIZE phys_page_struct
                LOOP    f93
                MOV     CX,CONTEXT_SIZE         ;६  ஢...
                MOV     SI,[BX].back_address
                MOV     DI,OFFSET map_table
                PUSH    DI
                REPZ    MOVSB
                POP     DI
                CALL    set_pages_map           ;ࠧ 䨧.࠭...
                JB      f97
                DEC     backup_count            ;㬥 稪 ࠭
                MOV     DI,[BX].back_address    ;  ஢  ࠭...
                MOV     SI,CONTEXT_SIZE
                ADD     SI,DI
                MOV     CX,back_ptr
                SUB     CX,SI
                JCXZ    f96
                REPZ    MOVSB
f96:
                MOV     CX,CONTEXT_SIZE
                MOV     AL,0FFH
                REPZ    STOSB
                MOV     SI,[BX].back_address    ; ᮢ ࠭...
                MOV     [BX].back_address,0
                XOR     DI,DI
                MOV     AX,CONTEXT_SIZE
                MOV     CX,HANDLE_CNT
f95:
                CMP     [DI].handle_flag,0
                JZ      f94
                CMP     [DI].back_address,SI
                JB      f94
                SUB     [DI].back_address,AX
f94:
                ADD     DI,FLAG_SIZE
                LOOP    f95
                SUB     back_ptr,AX             ;㬥 㪠⥫ ࠭
                JMP     noerr                   ;室
f92:
                JMP     err8e                   ;室  訡
f97:
                JMP     err81                   ;室  訡

;------ 㭪  10 -------------------------------------------------
; Get page mapping register I/O port array
; 室
;       ES:DI   : buffer address point
; 室
;       AH      : 
;       AL      : board count
;--------------------------------------------------------------------
func10:
;                MOV     SI,OFFSET port_addr
;                MOV     CX,PHYS_PAGES
;                REPZ    MOVSW
;                MOV     AL,1
;                JMP     noerr
                jmp     err84

;------ 㭪  11 -------------------------------------------------
; Get logical-to-physical page translation array
; 室
;       DX      : EMM handle
;       ES:DI   : buffer address point
; 室
;       AH      :  code
;       BX      : number of pages allocated EMM handle.
;--------------------------------------------------------------------
func11:
;                CMP     DX,HANDLE_CNT           ;check handle data
;                JNB     f112
;                MOV     SI,DX
;                SHL     SI,1
;                CMP     [SI].handle_flag,1
;                JNZ     f112
;                MOV     CX,[SI].alloc_page_count
;                JCXZ    f112
;                MOV     BX,[SI].page_address
;f111:
;                MOV     AX,[BX]
;                XCHG    AH,AL
;                STOSW
;                INC     BX
;                INC     BX
;                LOOP    f111
;                MOV     BX,[SI].alloc_page_count
;                MOV     [BP].bx_save,BX
;                JMP     noerr                   ;室
;f112:
;                JMP     err83                   ;室  訡
                jmp     err84

;------ 㭪  4Bh ------------------------------------------------
;  ᫮ ⨢ ਯ஢
; 室
;       AH      : 
;       BX      : ᫮ ⨢ ਯ஢
;--------------------------------------------------------------------
func12:
                MOV     BX,handle_count
f121:
                MOV     [BP].bx_save,BX
                JMP     noerr                   ;室

;------ 㭪  4Ch ------------------------------------------------
;  ᫮ ᪨ ࠭ ਯ
; 室
;       DX      : ਯ EMM
; 室
;       AH      : 
;       BX      : ᫮ ᪨ ࠭
;--------------------------------------------------------------------
func13:
                CMP     DX,HANDLE_CNT           ;஢ઠ ਯ
                JNB     f131
                MOV     SI,DX
                SHL     SI,1
                CMP     [SI].handle_flag,1      ;஢ઠ ਯ
                JNZ     f131
                MOV     BX,[SI].alloc_page_count
                JMP     f121                    ;室
f131:
                JMP     err83                   ;室  訡

;------ 㭪  4Dh ------------------------------------------------
;  ଠ   ਯ
; 室
;       ES:DI   : 㪠⥫  
; 室
;       AH      : 
;       BX      : ᫮ ⨢ ਯ஢
;--------------------------------------------------------------------
func14:
                XOR     SI,SI
                MOV     CX,HANDLE_CNT
                XOR     BX,BX
                XOR     DX,DX
f142:
                CMP     [SI].handle_flag,0
                JZ      f141
                MOV     AX,DX
                STOSW
                MOV     AX,[SI].alloc_page_count
                STOSW
                INC     BX
f141:
                INC     DX
                ADD     SI,FLAG_SIZE
                LOOP    f142
                JMP     f121

;------ 㭪  4Eh ------------------------------------------------
;  / ⠭   ࠭
; 室
;       AL      :  㭪樨
;       ES:DI   : 㪠⥫    ॣ஢
; 室
;       AH      : 
;--------------------------------------------------------------------
func15:
                CMP     AL,0
                JZ      get_page_map
                CMP     AL,1
                JZ      set_page_map
                CMP     AL,2
                JZ      get_set_page_map
                CMP     AL,3
                JZ      get_size_page_map
                JMP     err84                   ;室  訡

;--------------------------------------------------------------------
;   ࠭
; 室
;       ES:DI   : 㪠⥫  
; 室
;       AH      : 
;--------------------------------------------------------------------
get_page_map:
                MOV     SI,OFFSET map_table
                MOV     CX,CONTEXT_SIZE
                REPZ    MOVSB
                JMP     noerr                   ;室

;--------------------------------------------------------------------
; ⠭  ࠭
; 室
;       DS:SI   : 㪠⥫  
; 室
;       AH      : 
;--------------------------------------------------------------------
set_page_map:
                MOV     AX,[BP].ds_save
                MOV     DS,AX
                MOV     CX,CONTEXT_SIZE
                MOV     AX,SS
                MOV     ES,AX
                LEA     DI,[BP].f15_map_data    ;᪮஢   ⥪ ?
                REPZ    MOVSB
set_page_map3:
                LEA     DI,[BP].f15_map_data
                CALL    check_map_data          ;஢  (ES:DI)
                JNB     set_page_map2
                JMP     erra3                   ;室  訡
set_page_map2:
                MOV     AX,ES
                MOV     DS,AX
                MOV     SI,DI
                PUSH    CS
                POP     ES
                MOV     DI,OFFSET map_table
                MOV     CX,CONTEXT_SIZE
                REPZ    MOVSB
                CALL    set_pages_map           ;஢ 䨧. ࠭
                JB      set_page_map1
                JMP     noerr                   ;室
set_page_map1:
                JMP     err81                   ;室  訡

;--------------------------------------------------------------------
;   ⠭  
; 室
;       DS:SI   :   ⠭
;       ES:DI   : 頥 
; 室
;       AH      : 
;--------------------------------------------------------------------
get_set_page_map:
                PUSH    DI
                PUSH    DS
                PUSH    ES
                MOV     AX,[BP].ds_save
                MOV     DS,AX
                MOV     CX,CONTEXT_SIZE
                MOV     AX,SS
                MOV     ES,AX
                LEA     DI,[BP].f15_map_data
                REPZ    MOVSB
                POP     ES
                POP     DS
                POP     DI
                MOV     SI,OFFSET map_table     ; ⥪騩 ⥪
                MOV     CX,CONTEXT_SIZE
                REPZ    MOVSB
                MOV     AX,SS
                MOV     ES,AX
                JMP     set_page_map3

;--------------------------------------------------------------------
;  ࠧ 
; 室
;       AH      : 
;       AL      : ࠧ 
;--------------------------------------------------------------------
get_size_page_map:
                MOV     AL,CONTEXT_SIZE         ;map data size set.
                JMP     noerr

;------ 㭪  4Fh ------------------------------------------------
;  / ⠭   ࠭
;--------------------------------------------------------------------
func16:
                CMP     AL,0
                JZ      get_partial_map
                CMP     AL,1
                JZ      set_partial_map
                CMP     AL,2
                JZ      get_size_partial_map
                JMP     err84                   ;室  訡

;--------------------------------------------------------------------
;  ࠧ ᨢ 筮 ஢
; 室
;       BX      : ᫮ 䨧. ࠭
; 室
;       AH      : 
;       AL      : ࠧ ᨢ
;--------------------------------------------------------------------
get_size_partial_map:
                OR      BX,BX                   ;BX = 0?
                JZ      get_size_partial_map1
                CMP     BX,PHYS_PAGES           ;BX > ᫠ 䨧. ࠭?
                JG      get_size_partial_map2
                MOV     AX,SIZE phys_page_struct
                MUL     BL                      ; ࠧ
                ADD     AX,2
                JMP     noerr                   ;室
get_size_partial_map1:
                JMP     err8f                   ;室  訡
get_size_partial_map2:
                JMP     err8b                   ;室  訡

;--------------------------------------------------------------------
;    
; 室
;       DS:SI   : 筠  
;       ES:DI   : ᨢ - ਥ
; 室
;       AH      : 
;--------------------------------------------------------------------
get_partial_map:
                MOV     AX,[BP].ds_save
                MOV     DS,AX
                LODSW
                CMP     AX,PHYS_PAGES
                JG      get_partial_map1
                MOV     CX,AX
                JCXZ    get_partial_map5        ;᫮ ࠭ = 0?
                STOSW
get_partial_map4:
                LODSW
                PUSH    CX
                MOV     BX,OFFSET map_table
                MOV     CX,PHYS_PAGES
get_partial_map3:
                CMP     AX,CS:[BX].phys_seg_addr
                JZ      get_partial_map2
                ADD     BX,SIZE phys_page_struct
                LOOP    get_partial_map3
                POP     CX
                JMP     err8b                   ;室  訡
get_partial_map2:
                PUSH    SI                      ;६  ஢
                PUSH    DS
                PUSH    CS
                POP     DS
                MOV     SI,BX
                MOV     CX,SIZE phys_page_struct
                REPZ    MOVSB
                POP     DS
                POP     SI
                POP     CX
                LOOP    get_partial_map4
get_partial_map5:
                JMP     noerr                   ;室
get_partial_map1:
                JMP     erra4                   ;室  訡

;--------------------------------------------------------------------
; ⠭   
; 室
;       DS:SI   : ᨢ ஢
; 室
;       AH      : 
;--------------------------------------------------------------------
set_partial_map:
                MOV     AX,[BP].ds_save
                MOV     DS,AX
                LODSW
                MOV     [BP].f16_map_len,AX     ;࠭   ஢
                MOV     CX,SIZE phys_page_struct
                MUL     CL
                MOV     CX,AX
                JCXZ    set_partial_map1
                MOV     AX,SS                   ;࠭  ஢
                MOV     ES,AX
                LEA     DI,[BP].f16_map_data
                REPZ    MOVSB
                LEA     SI,[BP].f16_map_data    ;⠭  ஢
                MOV     AX,ES
                MOV     DS,AX
                MOV     AX,CS
                MOV     ES,AX
                MOV     CX,[BP].f16_map_len     ;   ஢
set_partial_map4:
                MOV     AX,[SI].phys_seg_addr
                CALL    change_seg_page         ; ᥣ ->  䨧. ࠭
                JB      set_partial_map3
                MOV     DI,OFFSET map_table
                PUSH    CX
                MOV     CX,SIZE phys_page_struct
                MUL     CL
                ADD     DI,AX
                REPZ    MOVSB
                POP     CX
                LOOP    set_partial_map4
                CALL    set_pages_map           ;஢ 䨧. ࠭
                JB      set_partial_map2
set_partial_map1:
                JMP     noerr                   ;室
set_partial_map2:
                JMP     err81                   ;室  訡
set_partial_map3:
                JMP     err8b                   ;室  訡

;------ 㭪  50h ------------------------------------------------
; ஢ / ஢ ᪮쪮 ࠭
;--------------------------------------------------------------------
func17:
                CMP     AL,0
                JZ      log_phys_map
                CMP     AL,1
                JZ      log_phys_map
                JMP     err84                   ;室  訡

;--------------------------------------------------------------------
; Logical page/physical page/segment method
; 室
;       AL      : ᥫ 䨧. ࠭/ᥣ
;       DX      : ਯ
;       CX      :   
;       DS:SI   : 㪠⥫ ᨢ ஢
; 室
;       AH      : 
;--------------------------------------------------------------------
log_phys_map:
                MOV     [BP].f17_ax_save,AX
                MOV     AX,[BP].ds_save
                MOV     DS,AX
                CALL    check_handle            ;஢ઠ ਯ
                JNB     log_phys_map2
                JMP     err83                   ;室  訡
log_phys_map2:
                CMP     CX,PHYS_PAGES
                JNA     log_phys_map1
                JMP     err8b                   ;室  訡
log_phys_map1:
                JCXZ    log_phys_map9
                MOV     [BP].f17_map_len,CX     ;࠭   
                MOV     AX,SS
                MOV     ES,AX
                LEA     DI,[BP].f17_map_data    ;࠭  
                SHL     CX,1
                REPZ    MOVSW
                MOV     AX,SS
                MOV     DS,AX
                LEA     SI,[BP].f17_map_data    ;⠭ 㪠⥫  
                MOV     CX,[BP].f17_map_len     ;  
log_phys_map7:
                MOV     BX,[SI].log_page_number1;  . ࠭
                CMP     BX,UNMAP                ;஢?
                JZ      log_phys_map6
                CALL    check_log_page          ;஢ઠ  . ࠭
                JNB     log_phys_map3
                JMP     err8a                   ;室  訡
log_phys_map3:
                MOV     BX,AX                   ;⠭ . ࠭
log_phys_map6:
                MOV     AX,[BP].f17_ax_save
                CMP     AL,0                    ;㭪 0?
                JNZ     log_phys_map8
                MOV     AX,[SI].phys_page_number1;  䨧. ࠭
                CMP     AX,PHYS_PAGES           ;஢ઠ  䨧. ࠭
                JB      log_phys_map4
                JMP     err8b                   ;室  訡
log_phys_map8:
                MOV     AX,[SI].mappable_seg_addr; ᥣ 
                CALL    change_seg_page         ; ᥣ ->  䨧. ࠭
                JNB     log_phys_map4
                JMP     err8b                   ;室  訡
log_phys_map4:
                CMP     BX,UNMAP                ;஢?
                JZ      log_phys_mapa
                CALL    set_phys_page           ;⠭ 䨧. ࠭
                JNB     log_phys_map5
                JMP     err81                   ;室  訡
log_phys_mapa:
                CALL    reset_phys_page         ; 䨧7 ࠭
                JNB     log_phys_map5
                JMP     err81                   ;室  訡
log_phys_map5:
                ADD     SI,SIZE log_to_phys_map_struct;
                LOOP    log_phys_map7
log_phys_map9:
                JMP     noerr                   ;室

;------ 㭪  51h -----------------------------------------------------
;  ࠧ 
; 室
;       DX      : ਯ
;       BX      :  ࠧ  . ࠭
; 室
;       AH      : 
;       BX      : ࠧ  ᫥ 믮 㭪樨
;-------------------------------------------------------------------------
func18:
                PUSH    CS
                POP     ES
                CMP     DX,HANDLE_CNT           ;஢ઠ ਯ
                JNB     f181
                MOV     SI,DX
                SHL     SI,1
                CMP     [SI].handle_flag,0
                JNZ     f181
                XOR     BX,BX
                MOV     [BP].bx_save,BX
                JMP     err83                   ;室  訡
f182:
                JMP     err87                   ;室  訡
f18a:
                JMP     noerr                   ;室
f181:
                CMP     total_pages,BX          ; ,祬  ᥣ?
                JB      f182                    ;
                MOV     AX,[SI].alloc_page_count; ⥪騩 ࠧ 
                OR      BX,BX                   ;襭 0 ࠭?
                JNZ     f184
                MOV     CX,AX
                JCXZ    f18a                    ;CX = 0 case?
                MOV     DI,[SI].page_address    ;BX = 0 case...
                PUSH    BX
f185:
                MOV     BX,[DI]
                SHL     BX,1
                MOV     [BX].log_page,NOT_USE   ;஢ . ࠭
                INC     un_alloc_pages          ;᫮ ᢮ ࠭ +1
                INC     DI
                INC     DI
                LOOP    f185
                POP     BX
                JMP     f18l
f184:
                CMP     AX,BX
                JNZ     f18c
                JMP     noerr                   ;襭   ࠧ
f18c:
                JNB     f183                    ;BX < allocated count?
                JMP     f186
f183:
                MOV     CX,AX                   ;BX < allocated pages case...
                SUB     CX,BX
                MOV     DI,[SI].page_address    ;BX = 0 case...
                MOV     AX,BX
                SHL     AX,1
                ADD     DI,AX
                PUSH    BX
f18b:
                MOV     BX,[DI]
                SHL     BX,1
                MOV     [BX].log_page,NOT_USE   ;஢ . ࠭
                INC     un_alloc_pages          ;᫮ ᢮ ࠭ +1
                INC     DI
                INC     DI
                LOOP    f18b
                POP     BX
f18l:
                MOV     CX,page_ptr             ;⪠  ஢  ࠭
                MOV     AX,BX
                SHL     AX,1
                ADD     AX,[SI].page_address
                SUB     CX,AX
                PUSH    SI
                MOV     DI,[SI].page_address
                MOV     AX,BX
                SHL     AX,1
                ADD     DI,AX
                MOV     AX,[SI].alloc_page_count
                MOV     SI,[SI].page_address
                SHL     AX,1
                ADD     SI,AX
                SHR     CX,1
                JCXZ    f18e
                REPZ    MOVSW
f18e:
                MOV     CX,page_ptr
                SUB     CX,DI
                SHR     CX,1
                JCXZ    f18f
                MOV     AX,UNALLOC
                REPZ    STOSW
f18f:
                POP     SI
                MOV     AX,[SI].alloc_page_count
                MOV     [SI].alloc_page_count,BX;⠭ ਯ
                XOR     DI,DI                   ; 㣨 ਯ஢
                SUB     AX,BX
                SHL     AX,1
                MOV     BX,[SI].page_address
                MOV     CX,handle_count
f18j:
                CMP     [DI].handle_flag,0      ;⨢ ਯ?
                JZ      f18k
                CMP     [DI].page_address,BX    ;page_address > BX ?
                JNG     f18m
                SUB     [DI].page_address,AX    ;page_address - AX
f18m:
                LOOP    f18k
                SUB     page_ptr,AX             ;page_ptr - AX
                CMP     [SI].alloc_page_count,0 ;allocate page count = 0 ?
                JNZ     f18o
                MOV     [SI].page_address,0     ;clear page buffer pointer
f18o:
                JMP     noerr                   ;室.
f18k:
                ADD     DI,FLAG_SIZE
                JMP     f18j
f186:
                MOV     CX,BX                   ;BX > allocated pages case...
                SUB     CX,AX
                CMP     un_alloc_pages,CX       ;request unallocate size over ?
                JNB     f187                    ;no
                MOV     AX,[SI].alloc_page_count
                MOV     [BP].bx_save,AX
                JMP     err88                   ;室  訡
f187:
                PUSH    SI                      ;move page buffer...
                MOV     DI,page_ptr
                CMP     [SI].page_address,0     ;not poniter address?
                JNZ     f18p
                MOV     [SI].page_address,DI    ;set page pointer
                JMP     f18q
f18p:
                DEC     DI
                MOV     AX,CX
                SHL     AX,1
                ADD     DI,AX
                MOV     AX,[SI].alloc_page_count
                SHL     AX,1
                ADD     AX,[SI].page_address
                PUSH    CX
                MOV     CX,page_ptr
                SUB     CX,AX
                MOV     SI,page_ptr
                DEC     SI
                STD
                JCXZ    f18g
                REPZ    MOVSB
f18g:
                POP     CX
f18q:
                SHL     CX,1
                ADD     page_ptr,CX             ;pointer add
                POP     SI
                CLD
                MOV     DI,[SI].page_address    ;allocate add pages...
                MOV     AX,[SI].alloc_page_count
                MOV     CX,BX
                SUB     CX,AX
                SHL     AX,1
                ADD     DI,AX
                PUSH    SI
                MOV     SI,OFFSET log_page
                XOR     AX,AX
f188:
                CMP     WORD PTR [SI],UNMAP     ;logical page end?
                JZ      f18d
                CMP     WORD PTR [SI],NOT_USE   ;unallocated page ?
                JNZ     f189
                MOV     WORD PTR [SI],DX
                STOSW
                DEC     un_alloc_pages          ;unallocated page - 1
                LOOP    f189
                POP     SI
                MOV     AX,[SI].alloc_page_count
                MOV     [SI].alloc_page_count,BX;set EMM handle used page count
                XOR     DI,DI                   ;change other handle page add-
                XCHG    AX,BX                   ;ress....
                SUB     AX,BX
                SHL     AX,1
                MOV     BX,[SI].page_address
                MOV     CX,handle_count
f18h:
                CMP     [DI].handle_flag,0
                JZ      f18i
                CMP     [DI].page_address,BX
                JNG     f18n
                ADD     [DI].page_address,AX
f18n:
                LOOP    f18i
                JMP     noerr                   ;室
f18i:
                ADD     DI,FLAG_SIZE
                JMP     f18h
f189:
                ADD     SI,LOG_SIZE
                INC     AX
                JMP     f188
f18d:
                POP     SI
                JMP     err80                   ;室  訡

;------ 㭪  52h ------------------------------------------------
; /⠭ ਡ ਯ
;--------------------------------------------------------------------
func19:
                cmp     al,0
                je      f1900
                cmp     al,1
                je      f1900
                cmp     al,2
                je      f1901
                jmp     err84                   ;室  訡
f1900:
                jmp     err91
f1901:
                mov     al,0
                jmp     noerr

;------ 㭪  53h ------------------------------------------------
; /⠭  ਯ
;--------------------------------------------------------------------
func20:
                CMP     AL,0
                JZ      get_handle_name
                CMP     AL,1
                JZ      set_handle_name
                JMP     err84                   ;室  訡

;--------------------------------------------------------------------
;   ਯ
; 室
;       DX      : ਯ
;       ES:DI   : 㪠⥫ ᨢ 
; 室
;       AH      : 
;--------------------------------------------------------------------
get_handle_name:
                CALL    check_handle            ;஢ઠ ਯ
                JNB     get_handle_name1
                JMP     err83                   ;室  訡
get_handle_name1:
                MOV     SI,OFFSET handle_name
                MOV     AX,DX
                MOV     CL,3
                SHL     AX,CL
                ADD     SI,AX
                MOV     DI,[BP].di_save
                MOV     CX,HANDLE_NAME_SIZE
                REPZ    MOVSB
                JMP     noerr                   ;室

;--------------------------------------------------------------------
; ⠭  ਯ
; 室
;       DX      : ਯ
;       DS:SI   : 㪠⥫ ᨢ 
; 室
;       AH      : 
;--------------------------------------------------------------------
set_handle_name:
                CALL    check_handle            ;஢ઠ ਯ
                JNB     set_handle_name1
                JMP     err83                   ;室  訡
set_handle_name1:
                PUSH    CS
                POP     ES
                MOV     AX,[BP].ds_save
                MOV     DS,AX
                MOV     BX,DX
                MOV     CX,HANDLE_CNT           ;஢ઠ ...
                MOV     DI,OFFSET handle_name
                XOR     DX,DX
set_handle_name2:
                CALL    check_handle            ;஢ઠ ਯ
                JB      set_handle_name3
                PUSH    CX                      ;ࠢ ...
                PUSH    SI
                PUSH    DI
                MOV     CX,HANDLE_NAME_SIZE
                REPZ    CMPSB
                POP     DI
                POP     SI
                POP     CX
                JZ      set_handle_name4        ; ⠪   ?
set_handle_name3:
                ADD     DI,HANDLE_NAME_SIZE
                INC     DX
                LOOP    set_handle_name2
                MOV     DI,OFFSET handle_name   ;⠭ ...
                MOV     AX,BX
                MOV     CL,3
                SHL     AX,CL
                ADD     DI,AX
                MOV     CX,HANDLE_NAME_SIZE
                REPZ    MOVSB
                JMP     noerr                   ;室
set_handle_name4:
                JMP     erra1                   ;室  訡

;------ 㭪  54h ------------------------------------------------
;  ⠫ ਯ஢
;--------------------------------------------------------------------
func21:
                CMP     AL,0
                JZ      get_handle_dir
                CMP     AL,1
                JZ      search_for_name
                CMP     AL,2
                JZ      get_total_handle
                JMP     err84                   ;室  訡

;--------------------------------------------------------------------
;  ⠫ ਯ஢
; 室
;       ES:DI   : 㪠⥫ ᨢ
; 室
;       AH      : 
;       AL      : ᫮ ⮢  ⠫
;--------------------------------------------------------------------
get_handle_dir:
                MOV     CX,HANDLE_CNT
                MOV     SI,OFFSET handle_name
                XOR     DX,DX
                XOR     BL,BL
get_handle_dir1:
                CALL    check_handle            ;஢ઠ ਯ
                JB      get_handle_dir2
                MOV     AX,DX                   ;⠭ ਯ
                STOSW
                PUSH    CX                      ;⠭ ...
                PUSH    SI
                MOV     CX,HANDLE_NAME_SIZE
                REPZ    MOVSB
                POP     SI
                POP     CX
                INC     BL                      ;稪 ਯ஢ +1
get_handle_dir2:
                ADD     SI,HANDLE_NAME_SIZE
                INC     DX
                LOOP    get_handle_dir1
                MOV     AL,BL
                JMP     noerr                   ;室

;--------------------------------------------------------------------
;    ਯ஢
; 室
;       DS:SI   : 㪠⥫ ᨢ ᪮ 
; 室
;       AH      : 
;       DX      : ਯ
;--------------------------------------------------------------------
search_for_name:
                PUSH    CS
                POP     ES
                MOV     CX,HANDLE_CNT
                MOV     DI,OFFSET handle_name
                MOV     AX,[BP].ds_save
                MOV     DS,AX
                XOR     DX,DX
search_for_name1:
                PUSH    CX
                PUSH    SI
                PUSH    DI
                MOV     CX,HANDLE_NAME_SIZE
                REPZ    CMPSB
                POP     DI
                POP     SI
                POP     CX
                JZ      search_for_name2
                ADD     DI,HANDLE_NAME_SIZE
                INC     DX
                LOOP    search_for_name1
                JMP     erra0                   ;室  訡
search_for_name2:
                MOV     CX,HANDLE_NAME_SIZE
                XOR     AL,AL
                REPZ    SCASB
                JNZ     search_for_name3
                JMP     erra1                   ;室  訡
search_for_name3:
                PUSH    CS
                POP     DS
                MOV     [BP].dx_save,DX
                JMP     noerr                   ;室

;--------------------------------------------------------------------
;  ᫮ ਯ஢
; 室
;       AH      : 
;       BX      : ᫮ ਯ஢
;--------------------------------------------------------------------
get_total_handle:
                MOV     BX,HANDLE_CNT
                MOV     [BP].bx_save,BX
                JMP     noerr                   ;室

;------ 㭪  55h ------------------------------------------------
; ୠ⨢ ஢  JUMP
; 室
;       AL      : ᥫ  䨧.࠭/ᥣ
;       DX      : ਯ
;       DS:SI   : 㪠⥫   ~map_and_jump~ 
; 室
;       AH      : 
;--------------------------------------------------------------------
func22:
                CMP     AL,0
                JZ      f220
                CMP     AL,1
                JZ      f220
                JMP     err8f                   ;室  訡
f220:
                MOV     [BP].f22_ax_save,AX
                CALL    check_handle            ;஢ઠ ਯ
                JNB     f221
                JMP     err83                   ;室  訡
f221:
                MOV     AX,[BP].ds_save         ;஢ ࠬ஢...
                MOV     DS,AX
                LES     BX,[SI].target_address1
                MOV     AX,ES
                MOV     [BP].f22_target_off,BX  ;ᬥ饭
                MOV     [BP].f22_target_seg,AX  ;ᥣ
                MOV     CL,[SI].log_phys_map_len;   
                XOR     CH,CH
                MOV     [BP].f22_map_len,CX     ;
                JCXZ    f22a
                LES     BX,[SI].log_phys_map_ptr; 㪠⥫...
                LEA     DI,[BP].f22_map_data    ;஢ ...
                SHL     CX,1
f228:
                MOV     AX,ES:[BX]
                MOV     SS:[DI],AX
                INC     DI
                INC     DI
                INC     BX
                INC     BX
                LOOP    f228
f22a:
                MOV     AX,SS
                MOV     DS,AX
                MOV     CX,[BP].f22_map_len     ;
                JCXZ    f222
                LEA     DI,[BP].f22_map_data    ; 㪠⥫  
f223:
                MOV     BX,[DI].log_page_number1;  .࠭
                CMP     BX,UNMAP                ;஢?
                JZ      f22b
                CALL    check_log_page          ;஢  .࠭
                JNB     f224
                JMP     err8a                   ;室  訡
f224:
                MOV     BX,AX                   ;⠭ .࠭
f22b:
                MOV     AX,[BP].f22_ax_save     ; ᥫ 㭪樨
                CMP     AL,0
                JNZ     f229
                MOV     AX,[DI].phys_page_number1;  䨧.࠭
                CMP     AX,PHYS_PAGES
                JB      f225
                JMP     err8b                   ;室  訡
f229:
                MOV     AX,[DI].mappable_seg_addr; ᥣ 
                CALL    change_seg_page         ;   䨧.࠭
                JNB     f225
                JMP     err8b                   ;室  訡
f225:
                CMP     BX,UNMAP                ;஢?
                JZ      f227
                CALL    set_phys_page           ;⠭ 䨧.࠭
                JNB     f226
                JMP     err81                   ;室  訡
f227:
                CALL    reset_phys_page         ; 䨧.࠭
                JNB     f226
                JMP     err81                   ;室  訡
f226:
                ADD     DI,SIZE log_to_phys_map_struct
                LOOP    f223
f222:
                MOV     AX,[BP].f22_target_seg  ; 
                MOV     [BP].ret_segment,AX     ;⠭ FAR:JUMP ᥣ
                MOV     AX,[BP].f22_target_off  ; 
                MOV     [BP].ret_offset,AX      ;⠭ FAR:JUMP ᬥ饭
                JMP     noerr                   ;室

;------ 㭪  56h ------------------------------------------------
; ୠ⨢ ஢  CALL
;--------------------------------------------------------------------
func23:
                CMP     AL,0
                JZ      f2300
                CMP     AL,1
                JZ      f2300
                CMP     AL,2
                JZ      get_page_map_stack
                JMP     err84                   ;室  訡

;--------------------------------------------------------------------
;  ࠧ  ⥪
; 室
;       AH      : 
;       BX      : ࠧ  ⥪
;--------------------------------------------------------------------
get_page_map_stack:
                MOV     BX,RET_SP
                MOV     [BP].bx_save,BX
                JMP     noerr                   ;室

;--------------------------------------------------------------------
; ୠ⨢ ஢  CALL
; 室
;       AL      : ᥫ  䨧.࠭/ᥣ
;       DX      : ਯ
;       DS:SI   : 㪠⥫  ~map_and_call~ 
; 室
;       AH      : 
;       AL      : ᫮ ⮢ handle_dir ᨢ
;--------------------------------------------------------------------
f2300:
                MOV     [BP].f23_ax_save,AX
                CALL    check_handle            ;஢ઠ ਯ
                JNB     f2301
                JMP     err83                   ;室  訡
f2301:
                MOV     AX,[BP].ds_save
                MOV     DS,AX
                LES     BX,[SI].target_address2 ; FAR:CALL 
                MOV     [BP].f23_target_off,BX  ;⠭ ᬥ饭
                MOV     AX,ES
                MOV     [BP].f23_target_seg,AX  ;⠭ ᥣ
                MOV     CL,[SI].new_page_map_len;  
                XOR     CH,CH
                MOV     [BP].f23_new_map_len,CX
                LES     BX,[SI].new_page_map_ptr;  㪠⥫
                JCXZ    f2303
                LEA     DI,[BP].f23_new_map_data
                SHL     CX,1
f2302:
                MOV     AX,ES:[BX]
                MOV     SS:[DI],AX
                INC     DI
                INC     DI
                INC     BX
                INC     BX
                LOOP    f2302
f2303:
                MOV     CL,[SI].old_page_map_len;  
                XOR     CH,CH
                MOV     [BP].f23_old_map_len,CX
                LES     BX,[SI].old_page_map_ptr;  㪠⥫
                JCXZ    f2305
                LEA     DI,[BP].f23_old_map_data
                SHL     CX,1
f2304:
                MOV     AX,ES:[BX]
                MOV     SS:[DI],AX
                INC     DI
                INC     DI
                INC     BX
                INC     BX
                LOOP    f2304
f2305:
                MOV     CX,[BP].f23_new_map_len ;  .
                JCXZ    f2307                   ;ࠧ  = 0?
                MOV     AX,SS
                MOV     DS,AX
                LEA     SI,[BP].f23_new_map_data;  㪠⥫
f2306:
                MOV     BX,[SI].log_page_number2;  .࠭
                CMP     BX,UNMAP                ;஢?
                JZ      f2313
                CALL    check_log_page
                JNB     f2309
                JMP     err8a                   ;室  訡
f2309:
                MOV     BX,AX
f2313:
                MOV     AX,[BP].f23_ax_save
                CMP     AL,0                    ;㭪 0?
                JZ      f2310
                MOV     AX,[SI].mappable_seg_addr
                CALL    change_seg_page         ; ᥣ ->  䨧.࠭
                JNB     f2311
                JMP     err8b                   ;室  訡
f2310:
                MOV     AX,[SI].phys_page_number1;  䨧.࠭
                CMP     AX,PHYS_PAGES
                JB      f2311
                JMP     err8b                   ;室  訡
f2311:
                CMP     BX,UNMAP                ;஢?
                JZ      f2312
                CALL    set_phys_page           ;⠭ 䨧.࠭
                JNB     f2308                   ;室  訡 ?
                JMP     err81                   ;室  訡
f2312:
                CALL    reset_phys_page         ; 䨧.࠭
                JNB     f2308
                JMP     err81                   ;室  訡
f2308:
                ADD     SI,SIZE log_to_seg_map_struct
                LOOP    f2306
f2307:
                MOV     BX,OFFSET f2350         ; FAR:CALL  
                MOV     [BP].f23_retoff,BX      ; ᬥ饭
                MOV     AX,CS
                MOV     [BP].f23_retseg,AX      ; ᥣ
                MOV     AX,[BP].ret_flag
                MOV     [BP].f23_flag,AX        ;⠭ 䫠
                MOV     AH,0
                POP     BX
                POP     CX
                POP     DX
                POP     SI
                POP     DI
                POP     BP
                POP     ES
                POP     DS
                IRET                            ;FAR:CALL
;
; far call 窠 
;
f2350:
                PUSHF                           ;push flags.
                POP     AX                      ;pop flags.
                CLI
                SUB     SP,F23_RETSP
                PUSH    DS                      ;PUSH registers...
                PUSH    ES
                PUSH    BP
                PUSH    DI
                PUSH    SI
                PUSH    DX
                PUSH    CX
                PUSH    BX
                MOV     BP,SP
                MOV     [BP].ret_flag,AX        ;⠭ 䫠 
                MOV     CX,[BP].f23_old_map_len ;  
                JCXZ    f2351                   ;ࠧ  = 0?
                MOV     AX,SS
                MOV     DS,AX
                LEA     SI,[BP].f23_old_map_data;  㪠⥫
f2352:
                MOV     BX,[SI].log_page_number2;  .࠭
                CMP     BX,UNMAP                ;஢?
                JZ      f2359
                CALL    check_log_page
                JNB     f2358
                STI
                JMP     err8a                   ;室  訡
f2358:
                MOV     BX,AX
f2359:
                MOV     AX,[BP].f23_ax_save
                CMP     AL,0
                JZ      f2354
                MOV     AX,[SI].mappable_seg_addr
                CALL    change_seg_page         ; ᥣ ->  䨧.࠭
                JNB     f2355
                STI
                JMP     err8b                   ;室  訡
f2354:
                MOV     AX,[SI].phys_page_number1;  䨧.࠭
                CMP     AX,PHYS_PAGES
                JB      f2355
                STI
                JMP     err8b                   ;室  訡
f2355:
                CMP     BX,UNMAP                ;஢?
                JZ      f2357
                CALL    set_phys_page           ;⠭ 䨧.࠭
                JNB     f2353
                STI
                JMP     err81                   ;室  訡
f2357:
                CALL    reset_phys_page         ; 䨧.࠭
                JNB     f2353
                STI
                JMP     err81                   ;室  訡
f2353:
                ADD     SI,SIZE log_to_seg_map_struct
                LOOP    f2352
f2351:
                STI
                JMP     noerr                   ;室

;------ 㭪  57h ------------------------------------------------
; ६/  
; 室
;       AL      : 롮 ० (00 = ६,01 = )
;       DS:SI   : 㪠⥫   ~move_info~
; 室
;       AH      : 
;--------------------------------------------------------------------
func24:
                cmp     al,0
                je      f2400
                cmp     al,1
                je      f2400
                jmp     err84                   ;室  訡

;    MoveInfo  ᪮஢ , 騥 䨪樨
f2400:
                mov     [bp].f24_al_save,al
                mov     ax,[bp].ds_save
                mov     ds,ax
                mov     ax,[si].source_offset   ;ࠬ 筨...
                mov     [bp].source_off,ax
                cmp     [si].source_type,0
                je      f2401
                mov     ax,[si].source_seg_page ;筨 = EMS
                mov     [bp].source_page,ax
                mov     ax,cs:Page_Frame_Seg
                mov     [bp].source_seg,ax
                jmp     short f2402
f2401:
                mov     ax,[si].source_seg_page ;筨 = RAM
                mov     [bp].source_seg,ax
f2402:
                mov     ax,[si].dest_offset     ;ࠬ ਥ...
                mov     [bp].dest_off,ax
                cmp     [si].dest_type,0
                je      f2403
                mov     ax,[si].dest_seg_page   ;ਥ = EMS
                mov     [bp].dest_page,ax
                mov     ax,cs:Page_Frame_Seg
                add     ax,400H
                mov     [bp].dest_seg,ax
                jmp     short f2404
f2403:
                mov     ax,[si].dest_seg_page   ;ਥ = RAM
                mov     [bp].dest_seg,ax
f2404:
                les     di,[si].region_lenght   ;᪮஢  뫪
                mov     [bp].region_low,di
                mov     ax,es
                mov     [bp].region_high,ax
                cmp     ax,10h                  ;஢ઠ  뫪
                jb      f2405
                je      f2406
f2407:
                jmp     err96                   ;室  訡
f2406:
                mov     ax,es
                or      ax,ax
                jnz     f2407

;஢ઠ  筨
f2405:
                cmp     [si].source_type,0
                jne     f2408                   ;筨 = RAM
                FarPtrAddress [bp].source_seg,[bp].source_off
                cmp     dx,10h                  ;஢ઠ  筨...
                jb      f2409
f2411:
                jmp     errA2                   ;室  訡
f2409:
                mov     [bp].source_ea_high,dx  ;࠭ ᮫ 
                mov     [bp].source_ea_low,ax
                Add32   [bp].region_high,[bp].region_low
                Sub32   0,1                     ;  뫪
                cmp     dx,10h                  ;஢ઠ 
                jb      f2410
                or      ax,ax
                jnz     f2411
                jmp     short f2410
f2408:
                mov     dx,[si].source_handle1  ;筨 = EMS
                call    check_handle            ;஢ઠ ਯ
                jnb     f2412
                jmp     err83                   ;室  訡
f2412:
                mov     bx,[bp].source_page
                call    check_log_page          ;஢ઠ .࠭
                jnb     f2413
                jmp     err8A                   ;室  訡
f2413:
                mov     di,dx
                mov     ax,[bp].source_off
                cmp     ax,4000h
                jb      f2414
                jmp     err95                   ;室  訡
f2414:
                mov     dx,[bp].region_high
                Add32   0,[bp].region_low
                Sub32   0,1
                Shl32 2
                add     bx,dx
                mov     dx,di
                call    check_log_page          ;஢ઠ .࠭
                jnb     f2410
                jmp     err93                   ;室  訡

;஢ઠ  ਥ
f2410:
                cmp     [si].dest_type,0
                jne     f2415                   ;ਥ = RAM
                FarPtrAddress [bp].dest_seg,[bp].dest_off
                cmp     dx,10h                  ;஢ઠ  ਥ..
                jb      f2416
f2418:
                jmp     errA2                   ;室  訡
f2416:
                mov     [bp].dest_ea_high,dx    ;࠭ ᮫ 
                mov     [bp].dest_ea_low,ax
                Add32   [bp].region_high,[bp].region_low
                Sub32   0,1                     ;  뫪
                cmp     dx,10h                  ;஢ઠ 
                jb      f2417
                or      ax,ax
                jnz     f2418
                jmp     short f2417
f2415:
                mov     dx,[si].dest_handle1    ;ਥ = EMS
                call    check_handle            ;஢ઠ ਯ
                jnb     f2419
                jmp     err83                   ;室  訡
f2419:
                mov     bx,[bp].dest_page
                call    check_log_page          ;஢ઠ .࠭
                jnb     f2420
                jmp     err8A                   ;室  訡
f2420:
                mov     di,dx
                mov     ax,[bp].dest_off
                cmp     ax,4000h
                jb      f2421
                jmp     err95                   ;室  訡
f2421:
                mov     dx,[bp].region_high
                Add32   0,[bp].region_low
                Sub32   0,1
                Shl32 2
                add     bx,dx
                mov     dx,di
                call    check_log_page          ;஢ઠ .࠭
                jnb     f2417
                jmp     err93                   ;室  訡

;। ࠢ 뫪  ४뢠 ⥩
f2417:
                mov     [bp].direct_move,0
                mov     al,[si].source_type
                cmp     al,[si].dest_type       ; ⨯ 筨  ਥ?
                je      f2422
                jmp     f2423
f2422:
                cmp     al,1
                je      f2424
                Load32  [bp].source_ea_high,[bp].source_ea_low
                mov     bx,[bp].dest_ea_low     ;筨 = ਥ = RAM
                mov     cx,[bp].dest_ea_high
                jmp     short f2430
f2424:
                mov     ax,[si].source_handle1  ;筨 = ਥ = EMS
                cmp     ax,[si].dest_handle1
                jne     f2423
                mov     dx,[bp].dest_page
                xor     ax,ax
                Shr32 2
                Add32   0,[bp].dest_off
                mov     bx,ax
                mov     cx,dx
                mov     dx,[bp].source_page
                xor     ax,ax
                Shr32 2
                Add32   0,[bp].source_off
f2430:
                cmp     dx,cx                   ;DX:AX = 筨, CX:BX = ਥ
                jne     f2425
                cmp     ax,bx
f2425:
                jae     f2426
                xchg    bx,ax
                xchg    cx,dx
                cmp     [bp].f24_al_save,1
                je      f2426
                or      [bp].direct_move,1      ;ᬥ ࠢ
f2426:
                sub     ax,bx
                sbb     dx,cx
                cmp     dx,[bp].region_high
                jne     f2427
                cmp     ax,[bp].region_low
f2427:
                jae     f2423
                cmp     [bp].f24_al_save,1
                jne     f2428                   ;஢ઠ ४  ० 
                jmp     err97                   ;室  訡
f2428:
                or      [bp].direct_move,2      ;४⨥  ० 뫪
f2423:
                mov     [bp].zero32_low,0
                mov     [bp].zero32_high,0
                test    [bp].direct_move,1
                jnz     f2429
                cld
                jmp     f2435

;᫥ ᮢ  ⭮ ࠢ 뫪
f2429:
                std
                cmp     [si].dest_type,1        ;⨯ ਥ = EMS ?
                je      f2432
                                                ;ᮢ⨬ ...
                Load32  [bp].dest_ea_high,[bp].dest_ea_low
                Add32   [bp].region_high,[bp].region_low
                Sub32   0,1
                mov     bx,ax
                and     bx,000Fh
                mov     [bp].dest_off,bx
                Shr32 4
                mov     [bp].dest_seg,ax
                jmp     short f2433
f2432:                                          ; EMS...
                Load32  [bp].region_high,[bp].region_low
                Add32   0,[bp].dest_off
                Sub32   0,1
                mov     bx,ax
                and     bx,3FFFh
                mov     [bp].dest_off,bx
                Shl32 2
                mov     bx,[bp].dest_page
                add     bx,dx
                mov     [bp].dest_page,bx
                mov     dx,[si].dest_handle1
                call    check_log_page
                mov     bx,ax
                mov     al,1
                call    set_phys_page
f2433:
                cmp     [si].source_type,1      ;⨯ 筨 = EMS ?
                je      f2434
                                                ;ᮢ⨬ ...
                Load32  [bp].source_ea_high,[bp].source_ea_low
                Add32   [bp].region_high,[bp].region_low
                Sub32   0,1
                mov     bx,ax
                and     bx,000Fh
                mov     [bp].source_off,bx
                Shr32 4
                mov     [bp].source_seg,ax
                jmp     short f2435
f2434:                                          ; EMS...
                Load32  [bp].region_high ,[bp].region_low
                Add32   0,[bp].source_off
                Sub32   0,1
                mov     bx,ax
                and     bx,3FFFh
                mov     [bp].source_off,bx
                Shl32 2
                mov     bx,[bp].source_page
                add     bx,dx
                mov     [bp].source_page,bx
                mov     dx,[si].source_handle1
                call    check_log_page
                mov     bx,ax
                mov     al,0
                call    set_phys_page

;࠭  䨧᪨ ࠭, ᫨  뫪/  EMS
f2435:
                mov     al,[si].source_type     ;஢ 室 ࠭
                or      al,[si].dest_type       ;饣 ⥪
                jz      f2436
                mov     cx,SIZE phys_page_struct*2
                mov     si,offset map_table
                mov     di,offset f24_data
f2437:
                mov     al,cs:[si]              ;࠭ 騩 ⥪
                mov     cs:[di],al
                inc     si
                inc     di
                loop    f2437
                or      [bp].direct_move,4

;஢ઠ  襭 樨
f2436:
                cmp     [bp].region_low,0
                jne     f2438
                cmp     [bp].region_high,0
                jne     f2438

                test    [bp].direct_move,4      ;⠭   ?
                jz      f2439
                mov     cx,SIZE phys_page_struct*2
                mov     si,offset f24_data
                mov     di,offset map_table
f2440:
                mov     al,cs:[si]              ;᫠  ஢
                mov     cs:[di],al
                inc     si
                inc     di
                loop    f2440
                call    set_pages_map
f2439:
                test    [bp].direct_move,2      ; 㭪樨 F24 !!!
                jnz     f2441
                jmp     noerr
f2441:
                jmp     err92
f2438:
                mov     ax,[bp].ds_save         ;⠭ 㪠⥫ 
                mov     ds,ax                   ; moveInfo
                mov     si,[bp].si_save

;᪮४஢ 筨  祭 ᨬ쭮  뫪
                cmp     [si].source_type,1
                je      f2442
                                                ; ᮢ⨬ ...
                FarPtrAddress [bp].source_seg,[bp].source_off
                test    [bp].direct_move,1
                jnz     f2443
                add     ax,[bp].zero32_low      ;אַ ࠢ 뫪...
                adc     dx,[bp].zero32_high
                mov     bx,ax
                and     bx,000Fh
                mov     [bp].source_off,bx
                SHR32 4
                mov     [bp].source_seg,ax
                jmp     f2444
f2443:
                sub     ax,[bp].zero32_low     ;⭮ ࠢ 뫪...
                sbb     dx,[bp].zero32_high
                mov     bx,ax
                or      bx,0FFF0h
                mov     [bp].source_off,bx
                sub     ax,bx
                sbb     dx,0
                SHR32 4
                mov     [bp].source_seg,ax
                jmp     f2444
f2442:
                mov     ax,[bp].source_off      ; EMS...
                test    [bp].direct_move,1
                jnz     f2445
                add     ax,[bp].zero32_low      ;אַ ࠢ 뫪...;אַ ࠢ 뫪...
                cmp     ax,4000h
                jb      f2446
                inc     [bp].source_page
                mov     [bp].source_off,0
                jmp     short f2446
f2445:
                sub     ax,[bp].zero32_low     ;⭮ ࠢ 뫪...
                jnc     f2446
                dec     [bp].source_page
                mov     [bp].source_off,3FFFh
f2446:
                mov     dx,[si].source_handle1
                mov     bx,[bp].source_page
                call    check_log_page
                mov     bx,ax
                mov     al,0
                call    set_phys_page

;᪮४஢ ਥ  祭 ᨬ쭮  뫪
f2444:
                test    [si].dest_type,1
                jnz     f2447
                                               ; ᮢ⨬ ...
                FarPtrAddress [bp].dest_seg,[bp].dest_off
                test    [bp].direct_move,1
                jnz     f2448
                add     ax,[bp].zero32_low     ;אַ ࠢ 뫪...
                adc     dx,[bp].zero32_high
                mov     bx,ax
                and     bx,000Fh
                mov     [bp].dest_off,bx
                SHR32 4
                mov     [bp].dest_seg,ax
                jmp     f2449
f2448:
                sub     ax,[bp].zero32_low     ;⭮ ࠢ 뫪...
                sbb     dx,[bp].zero32_high
                mov     bx,ax
                or      bx,0FFF0h
                mov     [bp].dest_off,bx
                sub     ax,bx
                sbb     dx,0
                SHR32 4
                mov     [bp].dest_seg,ax
                jmp     f2449
f2447:
                mov     ax,[bp].dest_off        ; EMS...
                test    [bp].direct_move,1
                jnz     f2450
                add     ax,[bp].zero32_low      ;אַ ࠢ 뫪...;אַ ࠢ 뫪...
                cmp     ax,4000h
                jb      f2451
                inc     [bp].dest_page
                mov     [bp].dest_off,0
                jmp     short f2451
f2450:
                sub     ax,[bp].zero32_low     ;⭮ ࠢ 뫪...
                jnc     f2451
                dec     [bp].dest_page
                mov     [bp].dest_off,3FFFh
f2451:
                mov     dx,[si].dest_handle1
                mov     bx,[bp].dest_page
                call    check_log_page
                mov     bx,ax
                mov     al,1
                call    set_phys_page
f2449:
                mov     bl,[si].dest_type      ;MAXLEN (dest)...
                mov     ax,[bp].dest_off
                call    maxlen
                mov     bx,ax
                push    bx
                mov     bl,[si].source_type    ;MAXLEN (source)...
                mov     ax,[bp].source_off
                call    maxlen
                pop     bx
                mov     cx,ax
                Load32  [bp].region_high,[bp].region_low
                cmp     cx,bx                  ;롮 쭮 祭
                jb      f2452
                mov     cx,bx
f2452:
                cmp     dx,0
                jne     f2453
                cmp     cx,ax
                jb      f2453
                mov     cx,ax

;樠஢ 㪠⥫  稪,  뫪/
f2453:
                mov     [bp].zero32_low,cx
                mov     ax,[bp].source_seg
                mov     ds,ax
                mov     ax,[bp].dest_seg
                mov     es,ax
                mov     si,[bp].source_off
                mov     di,[bp].dest_off

                cmp     [bp].f24_al_save,1
                je      f2454
                rep     movsb                   ;뫪...
f2455:
                Load32  [bp].region_high,[bp].region_low
                Sub32   [bp].zero32_high,[bp].zero32_low
                mov     [bp].region_low,ax
                mov     [bp].region_high,dx
                jmp     f2436
f2454:
                EXBYTE                          ;...
                loop    f2454
                jmp     f2455

;------ 㭪  58h ------------------------------------------------
;  ᨢ 㥬 䨧᪨ ᮢ
;--------------------------------------------------------------------
func25:
                CMP     AL,0
                JZ      get_map_phys_addr
                CMP     AL,1
                JZ      get_map_phys_ent
                JMP     err84                   ;室  訡

;--------------------------------------------------------------------
;  ᨢ 㥬 䨧᪨ ᮢ
; 室
;       ES:DI   : 㥬 䨧.࠭
; 室
;       AH      : 
;       CX      : ᫮ ⮢ 㥬 䨧.࠭
;--------------------------------------------------------------------
get_map_phys_addr:
                MOV     AX,[BP].es_save
                MOV     ES,AX
                MOV     CX,PHYS_PAGES
                MOV     SI,OFFSET map_table
                XOR     DX,DX
get_map_phys_addr1:
                MOV     AX,[SI].phys_seg_addr
                STOSW
                MOV     AX,DX
                STOSW
                INC     DX
                ADD     SI,SIZE phys_page_struct
                LOOP    get_map_phys_addr1
get_map_phys_addr2:
                MOV     CX,PHYS_PAGES
                MOV     [BP].cx_save,CX
                JMP     noerr                   ;室

;--------------------------------------------------------------------
;  ⢮ ᮢ
; 室
;       AH      : 
;       CX      : ᫮ ⮢ 㥬 䨧.࠭
;--------------------------------------------------------------------
get_map_phys_ent:
                JMP     get_map_phys_addr2

;------ 㭪  59h ------------------------------------------------
;  䨣 EMS
;--------------------------------------------------------------------
func26:
                CMP     AL,0
                JZ      get_hardware_config
                CMP     AL,1
                JZ      get_unalloc_raw_page
                JMP     err84                   ;室  訡

;--------------------------------------------------------------------
;  䨣 EMS
; 室
;       ES:DI   : 䨣 EMS
; 室
;       AH      : 
;--------------------------------------------------------------------
get_hardware_config:
                CMP     OSE_flag,0              ;OS/E 䫠 ࠧ襭?
                JZ      get_hardware_config1
                JMP     erra4                   ;室  訡
get_hardware_config1:
                MOV     AX,[BP].es_save
                MOV     ES,AX
                MOV     AX,RAW_PAGES
                STOSW
                MOV     AX,ALTER_REGS
                STOSW
                MOV     AX,CONTEXT_SIZE
                STOSW
                MOV     AX,DMA_REGS
                STOSW
                MOV     AX,DMA_CHANNEL
                STOSW
                JMP     noerr                   ;室

;--------------------------------------------------------------------
;  ᫮ ᢮ ப ࠭
; 室
;       AH      : 
;       BX      : ᫮ ᢮ ࠭
;       DX      : ᥣ ࠭
;--------------------------------------------------------------------
get_unalloc_raw_page:
                JMP     func3                   ;㭪  3

;------ 㭪  5Ah ------------------------------------------------
; ஢ ப ࠭
; 室
;       BX      : ᫮ ࠭
; 室
;       AH      : 
;       DX      : ப ਯ
;--------------------------------------------------------------------
func27:
                JMP     f41                     ;㭪  4

;------ 㭪  5Bh ------------------------------------------------
; ⠭ ୠ⨢ 騩 ॣ
;--------------------------------------------------------------------
func28:
                CMP     OSE_flag,0              ;OS/E 䫠 ࠧ襭?
                JZ      f280
                JMP     erra4                   ;室  訡
f280:
                CMP     AL,0
                JNZ     f281
                JMP     get_alter_map_reg
f281:
                CMP     AL,1
                JNZ     f282
                JMP     set_alter_map_reg
f282:
                CMP     AL,2
                JNZ     f283
                JMP     get_alter_map_size
f283:
                CMP     AL,3
                JNZ     f284
                JMP     alloc_alter_map_reg
f284:
                CMP     AL,4
                JNZ     f285
                JMP     dealloc_alter_map_reg
f285:
                CMP     AL,5
                JNZ     f286
                JMP     alloc_DMA_reg
f286:
                CMP     AL,6
                JNZ     f287
                JMP     enable_DMA_alter_reg
f287:
                CMP     AL,7
                JNZ     f288
                JMP     disable_DMA_alter_reg
f288:
                CMP     AL,8
                JNZ     f289
                JMP     dealloc_DMA_reg
f289:
                JMP     err84                   ;室  訡

;--------------------------------------------------------------------
;  ୠ⨢ 騩 ॣ
; 室
;       AH      : 
;       BL      : ⥪騩  ⨢ ୠ⨢ 饣 ॣ
;       ES:DI   : ࠧ  饣 ⥪
;--------------------------------------------------------------------
get_alter_map_reg:
                MOV     DI,CS:alter_map_off
                MOV     AX,CS:alter_map_seg
                MOV     ES,AX
                OR      AX,DI
                JNZ     get_alter_map_reg1
                JMP     get_alter_map_reg2
get_alter_map_reg1:
                MOV     SI,OFFSET map_table
                PUSH    CS
                POP     DS
                MOV     CX,CONTEXT_SIZE
                REPZ    MOVSB
get_alter_map_reg2:
                MOV     DI,CS:alter_map_off
                MOV     AX,CS:alter_map_seg
                MOV     [BP].di_save,DI
                MOV     [BP].es_save,AX
                MOV     BX,[BP].bx_save
                MOV     BL,0
                MOV     [BP].bx_save,BX
                JMP     noerr                   ;室

;--------------------------------------------------------------------
; ⠭ ୠ⨢ 騩 ॣ
; 室
;       BL      : new alternate map register set number
;       ES:DI   : pointer to a map register context restore area
; 室
;       AH      : 
;--------------------------------------------------------------------
set_alter_map_reg:
                CLI
                CMP     BL,0
                JZ      set_alter_map_reg1
                STI
                JMP     err9c                   ;室  訡
set_alter_map_reg1:
                MOV     CS:alter_map_off,DI
                MOV     AX,ES
                MOV     CS:alter_map_seg,AX
                OR      AX,DI
                JNZ     set_alter_map_reg2
                STI
                JMP     noerr                   ;室
set_alter_map_reg2:
                MOV     AX,ES
                MOV     DS,AX
                MOV     SI,DI
                MOV     CX,CONTEXT_SIZE
                MOV     AX,SS
                MOV     ES,AX
                LEA     DI,[BP].f28_map_data
                REPZ    MOVSB
                LEA     DI,[BP].f28_map_data
                CALL    check_map_data
                JNB     set_alter_map_reg3
                STI
                JMP     erra3                   ;室  訡
set_alter_map_reg3:
                MOV     SI,DI
                MOV     AX,ES
                MOV     DS,AX
                MOV     CX,CONTEXT_SIZE
                MOV     DI,OFFSET map_table
                PUSH    CS
                POP     ES
                PUSH    DI
                REPZ    MOVSB
                POP     DI
                MOV     CX,PHYS_PAGES
set_alter_map_reg5:
                mov     bx,cs:[di].Phys_Seg_Addr ;஢ 䨧.࠭
                mov     al,cs:[di].Log_Page_Data
                call    ems_out
                JNB     set_alter_map_reg4
                STI
                JMP     err81                   ;室  訡
set_alter_map_reg4:
                ADD     DI,SIZE phys_page_struct
                LOOP    set_alter_map_reg5
                STI
                JMP     noerr

;--------------------------------------------------------------------
;  ࠧ ୠ⨢ 饣 ⥪
; 室
;       AH      : 
;       DX      : ࠧ
;--------------------------------------------------------------------
get_alter_map_size:
                MOV     DX,CONTEXT_SIZE
                MOV     [BP].dx_save,DX
                JMP     noerr                   ;室

;--------------------------------------------------------------------
; ஢ ୠ⨢ 騩 ॣ
; 室
;       AH      : 
;       BL      :  ॣ
;--------------------------------------------------------------------
alloc_alter_map_reg:
                MOV     BL,0
                MOV     [BP].bx_save,BX
                JMP     noerr                   ;室

;--------------------------------------------------------------------
; ஢ ୠ⨢ 騩 ॣ
; 室
;       BL      :  ॣ
; 室
;       AH      : 
;--------------------------------------------------------------------
dealloc_alter_map_reg:
                CMP     BL,0
                JZ      dealloc_alter_map_reg1
                JMP     err9c                   ;室  訡
dealloc_alter_map_reg1:
                JMP     noerr                   ;室

;--------------------------------------------------------------------
; ஢ ॣ 
; 室
;       AH      : 
;       BL      :  ॣ
;--------------------------------------------------------------------
alloc_DMA_reg:
                MOV     BL,0
                MOV     [BP].bx_save,BX
                JMP     noerr                   ;室

;--------------------------------------------------------------------
;   ?!?!
; 室
;       BL      :  ॣ 
;       DL      :   
; 室
;       AH      : 
;--------------------------------------------------------------------
enable_DMA_alter_reg:
                CMP     BL,0
                JZ      enable_DMA_alter_reg1
                JMP     err9c                   ;室  訡
enable_DMA_alter_reg1:
                JMP     noerr                   ;室

;--------------------------------------------------------------------
;  
; 室
;       BL      :  ॣ
; 室
;       AH      : 
;--------------------------------------------------------------------
disable_DMA_alter_reg:
                CMP     BL,0
                JZ      disable_DMA_alter_reg1
                JMP     err9c                   ;室  訡
disable_DMA_alter_reg1:
                JMP     noerr                   ;室

;--------------------------------------------------------------------
; ஢ ॣ 
; 室
;       BL      :  ॣ
; 室
;       AH      : 
;--------------------------------------------------------------------
dealloc_DMA_reg:
                CMP     BL,0
                JZ      dealloc_DMA_reg1
                JMP     err9c                   ;室  訡
dealloc_DMA_reg1:
                JMP     noerr                   ;室

;------ 㭪  5Ch ------------------------------------------------
; ਣ⮢ EMS  १㧪 ⥬
;--------------------------------------------------------------------
func29:
                MOV     AX,CS
                MOV     ES,AX
                MOV     DS,AX
                MOV     DI,OFFSET map_table     ; 䨧.࠭...
                MOV     CX,PHYS_PAGES
f291:
                MOV     [DI].emm_handle ,UNMAP
                MOV     [DI].log_page_data,0
                ADD     DI,SIZE phys_page_struct
                LOOP    f291
                CALL    set_pages_map
                JNB     f292
                JMP     err81                   ;室  訡
f292:
                MOV     DI,OFFSET handle_flag   ; ਯ
                MOV     CX,HANDLE_CNT
                XOR     AX,AX
                REPZ    STOSW
                MOV     DI,OFFSET alloc_page_count; ਯ
                MOV     CX,HANDLE_CNT
                REPZ    STOSW
                MOV     DI,OFFSET page_address  ; ਯ
                MOV     CX,HANDLE_CNT
                REPZ    STOSW
                MOV     DI,OFFSET back_address  ; ਯ
                MOV     CX,HANDLE_CNT
                REPZ    STOSW
                MOV     DI,OFFSET handle_name   ; ਯ
                MOV     CX,HANDLE_CNT
                SHL     CX,1
                SHL     CX,1
                REPZ    STOSW
                MOV     DI,OFFSET alloc_page    ;  .࠭
                MOV     CX,PAGE_MAX
                MOV     AX,0FFFFH
                REPZ    STOSW
                XOR     DI,DI                   ;⠭ ⥬ 䫠
                MOV     [DI].handle_flag,1
                MOV     DI,OFFSET log_page      ;஢  .࠭
                MOV     AX,NOT_USE
                MOV     CX,PAGE_MAX
                REPZ    STOSW
                XOR     AX,AX
                MOV     handle_count,1          ;⠭ 稪 ਯ஢
                MOV     backup_count,AL         ;⠭ 稪 ࠭
                MOV     AX,total_pages
                MOV     un_alloc_pages,AX       ;⠭ 稪 ᢮ ࠭
                MOV     AX,OFFSET alloc_page    ;⠭ 㪠⥫  ࠭
                MOV     page_ptr,AX
                MOV     AX,OFFSET backup_map    ;⠭ 㪠⥫ ࠭
                MOV     back_ptr,AX
                JMP     noerr                   ;室

;------ 㭪  5Dh ------------------------------------------------
; / OS/E 㭪樨
; 室
;       BX,CX   :  㯠
; 室
;       AH      : 
;       BX,CX   :  㯠
;--------------------------------------------------------------------
func30:
                CMP     AL,0
                JZ      enable_OSE_func
                CMP     AL,1
                JZ      disable_OSE_func
                CMP     AL,2
                JZ      return_access_key
                JMP     err84                   ;室  訡

;--------------------------------------------------------------------
;  OS/E 㭪樨
; 室
;       BX,CX   :  㯠
; 室
;       AH      : 
;       BX,CX   :  㯠
;--------------------------------------------------------------------
enable_OSE_func:
                CMP     OSE_fast,0              ;OS/E 䫠 ࠧ襭?
                JZ      enable_OSE_func1
                CMP     access_key_h,BX         ;ࠢ ...
                JNZ     enable_OSE_func2
                CMP     access_key_l,CX
                JZ      enable_OSE_func1
enable_OSE_func2:
                JMP     erra4                   ;室  訡
enable_OSE_func1:
                MOV     OSE_flag,0              ;ࠧ OS/E 㭪樨
                MOV     OSE_fast,0FFFFH
                MOV     BX,access_key_h
                MOV     [BP].bx_save,BX
                MOV     CX,access_key_l
                MOV     [BP].cx_save,CX
                JMP     noerr                   ;室

;--------------------------------------------------------------------
;  OS/E 㭪樨
; 室
;       BX,CX   :  㯠
; 室
;       AH      : 
;       BX,CX   :  㯠
;--------------------------------------------------------------------
disable_OSE_func:
                CMP     OSE_fast,0              ;OS/E 䫠 ࠧ襭?
                JZ      disable_OSE_func1
                CMP     access_key_h,BX         ;ࠢ ...
                JNZ     disable_OSE_func2
                CMP     access_key_l,CX
                JZ      disable_OSE_func1
disable_OSE_func2:
                JMP     erra4                   ;室  訡
disable_OSE_func1:
                MOV     OSE_flag,0FFFFH         ; OS/E 㭪樨
                MOV     OSE_fast,0FFFFH
                MOV     BX,access_key_h
                MOV     [BP].bx_save,BX
                MOV     CX,access_key_l
                MOV     [BP].cx_save,CX
                JMP     noerr                   ;室

;--------------------------------------------------------------------
;   㯠
; 室
;       BX,CX   :  㯠
; 室
;       AH      : 
;--------------------------------------------------------------------
return_access_key:
                CMP     OSE_flag,0              ;OS/E 䫠\ ࠧ襭?
                JNZ     return_access_key2
                CMP     access_key_h,BX         ;ࠢ ...
                JNZ     return_access_key2
                CMP     access_key_l,CX
                JZ      return_access_key1
return_access_key2:
                JMP     erra4                   ;室  訡
return_access_key1:
                MOV     OSE_flag,0              ;ࠧ OS/E 㭪樨
                MOV     OSE_fast,0
                XOR     AX,AX
                MOV     ES,AX
                MOV     SI,46CH
                MOV     AX,ES:[SI]
                ADD     BX,AX                   ;ᮧ  㯠
                MOV     access_key_h,BX
                MOV     SI,46EH
                ADC     AX,ES:[SI]
                ADD     CX,AX
                MOV     access_key_l,CX
                JMP     noerr                   ;室

;========================================================================
;--------------------------------------------------------------------
; ᫥ ᨬ쭮   筮 뫪
; 室
;       BL      : ⨯  (0=RAM,1=EMS)
;       AX      : ᬥ饭e 
; 室
;       AX      :  뫪
;--------------------------------------------------------------------
maxlen          PROC    NEAR
                cmp     bl,1
                je      max1
                test    [bp].direct_move,1      ; ᮢ⨬ ...
                jnz     max2
                neg     ax
                jmp     short max3
max2:
                inc     ax
max3:
                or      ax,ax
                jnz     max4
                mov     ax,0FFFFh
                jmp     short max4
max1:
                test    [bp].direct_move,1      ; EMS...
                jnz     max5
                mov     di,ax
                mov     ax,4000h
                sub     ax,di
                jmp     short max4
max5:
                inc     ax
max4:
                ret
maxlen          ENDP

;--------------------------------------------------------------------
; ஫  ஢
; 室
;       ES:DI   : 㪠⥫  
; 室
;       CF = 0  : OK
;       CF = 1  : 訡
;--------------------------------------------------------------------
check_map_data  PROC    NEAR
                PUSH    AX
                PUSH    CX
                PUSH    SI
                PUSH    DI
                MOV     SI,OFFSET map_table
                MOV     CX,PHYS_PAGES
check_map_data3:
                mov     ax,es:[di].Phys_Seg_Addr
                cmp     ax,cs:[si].Phys_Seg_Addr
                JNZ     check_map_data1
                ADD     SI,SIZE phys_page_struct
                ADD     DI,SIZE phys_page_struct
                LOOP    check_map_data3
                CLC
                JMP     check_map_data2
check_map_data1:
                STC
check_map_data2:
                POP     DI
                POP     SI
                POP     CX
                POP     AX
                RET
check_map_data  ENDP

;--------------------------------------------------------------------
; ஢ઠ ᪮ ࠭
; 室
;       BX      : ⭮⥫  ࠭  ਯ
;       DX      : ਯ
; 室
;       AX      :  .࠭  EMM
;       CF = 0  : OK
;       CF = 1  : 訡
;--------------------------------------------------------------------
check_log_page  PROC    NEAR
                PUSH    CX
                PUSH    SI
                MOV     SI,DX
                SHL     SI,1
                CMP     BX,CS:[SI].alloc_page_count
                JB      check_log_page1
                STC
                JMP     check_log_page2
check_log_page1:
                MOV     SI,CS:[SI].page_address
                MOV     AX,BX
                SHL     AX,1
                ADD     SI,AX
                MOV     AX,CS:[SI]              ;  ࠭  EMM
                CLC
check_log_page2:
                POP     SI
                POP     CX
                RET
check_log_page  ENDP

;--------------------------------------------------------------------
; ஢ઠ ਯ EMM
; 室
;       DX      : ਯ
; 室
;       CF = 0  : OK
;       CF = 1  : 訡
;--------------------------------------------------------------------
check_handle    PROC    NEAR
                PUSH    AX
                PUSH    DI
                CMP     DX,HANDLE_CNT
                JNB     check_handle1
                CLC
                MOV     DI,DX
                SHL     DI,1
                MOV     AX,CS:[DI].handle_flag  ;⨢ ਯ?
                OR      AX,AX
                JNZ     check_handle2
check_handle1:
                STC
check_handle2:
                POP     DI
                POP     AX
                RET
check_handle    ENDP

;--------------------------------------------------------------------
; ⠭ 䨧  
; 室
;       CF = 0  : OK
;       CF = 1  : 訡
;--------------------------------------------------------------------
set_pages_map   PROC    NEAR
                push    ax bx cx di
                mov     di,offset Map_Table
                mov     cx,PHYS_PAGES
set_pages_map2:
                mov     bx,cs:[di].Phys_Seg_Addr  ;஢ 䨧.࠭
                mov     al,cs:[di].Log_Page_Data
                call    ems_out
                add     di,SIZE phys_page_struct
                loop    set_pages_map2
                clc
set_pages_map1:
                pop     di cx bx ax
                ret
set_pages_map   ENDP

;--------------------------------------------------------------------
;  䨧 ࠭
; 室
;       AL      :  䨧᪮ ࠭
;--------------------------------------------------------------------
reset_phys_page PROC    NEAR
reset_page1:
                push    ax bx cx di
                xor     ah,ah
                mov     di,offset map_table
                mov     cl,SIZE phys_page_struct
                mul     cl
                add     di,ax
                mov     cs:[di].emm_handle,UNMAP        ; ਧ  ஢
                mov     cs:[di].log_page_data,al        ;  䨧. ࠭
                mov     bx,cs:[di].phys_seg_addr
                mov     al,DISABLE
                call    ems_out
                pop     di cx bx ax
                ret
reset_phys_page ENDP

;--------------------------------------------------------------------
; ⠭ 䨧 ࠭
; 室
;       AL      :  ࠭
;       BX      :  . ࠭ EMM (᫨ BX=FFFFH,)
;       DX      : ਯ
;--------------------------------------------------------------------
set_phys_page   PROC    NEAR
                cmp     bx,UNMAP                 ;  ࠭?
                je      reset_page1
                push    ax bx cx di
                xor     ah,ah
                mov     di,offset map_table
                mov     cl,SIZE phys_page_struct
                mul     cl                       ;     䨧. ࠭
                add     di,ax
                mov     al,bl
                mov     cs:[di].emm_handle,dx    ;  
                mov     cs:[di].log_page_data,bl
                mov     bx,cs:[di].phys_seg_addr ;  ᥣ  ࠭
                call    ems_out
                pop     di cx bx ax
                ret
set_phys_page   ENDP

;--------------------------------------------------------------------
;  㥬 ᥣ    䨧. ࠭
; 室
;       AX      : 㥬 ᥣ 
; 室
;       AX      :  䨧. ࠭
;--------------------------------------------------------------------
change_seg_page PROC    NEAR
                PUSH    BX
                PUSH    CX
                PUSH    DI
                CLC                             ; CF
                XOR     BX,BX
                MOV     DI,OFFSET map_table
                MOV     CX,PHYS_PAGES
change_seg_page2:
                CMP     AX,CS:[DI].phys_seg_addr
                JZ      change_seg_page1
                ADD     DI,SIZE phys_page_struct
                INC     BX
                LOOP    change_seg_page2
                STC                             ;⠭ CF
change_seg_page1:
                MOV     AX,BX
                POP     DI
                POP     CX
                POP     BX
                RET
change_seg_page ENDP

                include out_ibm.inc

;.........................................................................

;--------------------------------------------------------------------
;         ࠩ EMM
;--------------------------------------------------------------------
backup_count    DB      0               ;稪 ࠭ ⥪
OSE_flag        DW      0               ;OS/E 䫠 ࠧ襭
OSE_fast        DW      0               ;OS/E 䫠 㯠
access_key_h    DW      0               ;OS/E  㯠
access_key_l    DW      0
alter_map       LABEL   DWORD
alter_map_off   DW      0
alter_map_seg   DW      0
page_ptr        DW      alloc_page      ;㪠⥫  ࠭
back_ptr        DW      backup_map      ;㪠⥫ BACKUP 
f24_data        DB      SIZE phys_page_struct * 2 dup (0)

;
;        ᮢ ⮢ -뢮
;
;port_addr       LABEL   WORD
;                DW      PHYS_PAGES DUP (-1)

;
;         䨧᪨ ࠭
;
map_table       LABEL   phys_page_struct
                DB      SIZE phys_page_struct * PHYS_PAGES DUP (-1)
;
;         ਯ஢
;
handle_name     LABEL   BYTE
                DB      HANDLE_NAME_SIZE * HANDLE_CNT DUP (0)

;
;       䫠  ਯ஢
;
handle_flag     LABEL   WORD
                DW      HANDLE_CNT DUP(0)

;
;
;        ⢠ ᪨ ࠭,९  ਯࠬ
;
alloc_page_count LABEL  WORD
                DW      HANDLE_CNT DUP(0)

;
;        㪠⥫ ᮢ BACKUP
;
back_address    LABEL   WORD
                DW      HANDLE_CNT DUP(0)

;
;        BACKUP 
;
backup_map      LABEL   WORD
                DB      SIZE phys_page_struct * PHYS_PAGES * BACK_MAX DUP(-1)

;
;        㪠⥫  ᯨ᪨ ᪨ ࠭ ਯ஢
;
page_address    LABEL   WORD
                DW      HANDLE_CNT DUP(0)

;
;       ⠡ ஢ । ࠭
;
alloc_page      LABEL   WORD
                DW      PAGE_MAX DUP(-1)

;
;        ᪨ ࠭
;       55AAH:᢮ , 0 - 254: , FFFFH:  
;
log_page        LABEL   WORD
                DB      LOG_SIZE * PAGE_MAX DUP (-1)

;********************************************************************

;--------------------------------------------------------------------
; ணࠬ 樠樨 ࠩ EMM
;--------------------------------------------------------------------
emminit:
                push    cx dx si di es bp
                mov     ax,cs                   ;CS=DS
                mov     ds,ax

                DISPSTRING Start_Msg            ;뢥 ⮢ ᮮ饭
;
		cld
		xor	ax,ax
		mov	es,ax
		mov	di,19Eh
		mov	ax,es:[di]
		mov	es,ax
		mov	di,0Ah
		lea	si,Ems_ID
		mov	cx,8
		repe	cmpsb
		jne     set_vector
                DISPSTRING Manager_Err          ;ୠ ⠭ ࠩ
                jmp     error_init
set_vector:
                mov     si,EMS_VECTOR * 4       ;⠭  int67h
                mov     WORD PTR es:[si],offset int67
                mov     es:[si+2],cs

                GETPRM                          ; ࠬ  CONFIG.SYS
                EMS_SETUP                       ;砫쭠 ⠭   ६
                WINDSCAN                        ;   
                jnc     set_map_table
                jmp     error_init

; ᥣ ᮢ   䨧᪨ ࠭
set_map_table:
                mov     di,offset Map_Table     ;⠭  䨧᪨ ࠭
                mov     cx,PHYS_PAGES
                mov     ax,Page_Frame_Seg
write_seg_addr:
                mov     [di].phys_seg_addr,ax
                add     di,SIZE phys_page_struct
                add     ax,0400H                ; +16KB
                loop    write_seg_addr

                call    ramchk                  ;஢ઠ  EMS
                jc      error_init              ;室  訡

                INSTALLED                       ;뢥 ᮮ饭  ⠭
                xor     ax,ax
                mov     es,ax                   ;ES=0
                mov     si,46CH
                mov     ax,es:[si]
                add     bx,ax                   ;ᮧ  㯠 (OS/E)
                mov     Access_Key_H,bx
                mov     si,46EH
                adc     ax,es:[si]
                add     bx,ax
                mov     Access_Key_L,bx
                xor     di,di                   ;⠭ ⥬ ਯ
                mov     ax,cs
                mov     es,ax                   ;ES=CS
                mov     es:[di].Handle_Flag,1   ;⥬ ਯ ⨢
                inc     Handle_Count            ;handle count up
                mov     ax,offset emminit       ;ᮧ   ࠩ
                add     ax,0FH
                mov     cl,4
                shr     ax,cl
                mov     cx,ax
                mov     ax,cs
                add     ax,cx
                mov     Emm_Flag,1              ; 䫠 ⠭ EMM
                lds     bx,Ptrsav               ;⠭ 㪠⥫   
                mov     [bx].Brkoff,0           ;ᬥ饭   ࠩ
                mov     [bx].Brkseg,ax          ;ᥣ   ࠩ
                jmp     emmint1
error_init:
                DISPSTRING Notinst              ;ᮮ饭  訡
                mov     Emm_Flag,0              ; 䫠 ⠭ EMM
                mov     ax,cs
                mov     es,ax
                lea     di,Func_Table
                lea     ax,Err80
                mov     cx,30
                repz    stosw
                lds     bx,Ptrsav               ;⠭ 㪠⥫   
                lea     ax,Func2
                mov     [bx].brkoff,ax          ;ᬥ饭   ࠩ
                mov     [bx].brkseg,cs          ;ᥣ   ࠩ
emmint1:
                pop     bp es di si dx cx
                jmp     exit

;--------------------------------------------------------------------
; ஫ ⮡ࠦ 
; 室
;       cf = 0 : OK
;       cf = 1 : 訡
;--------------------------------------------------------------------
ramchk          PROC    NEAR
                DISPSTRING Page_Msg             ;ᮮ饭  ࠭
                mov     di,offset log_page
                mov     bx,Page_Frame_Seg
                mov     es,bx
                mov     cx,PAGE_MAX             ;ᨬ쭮 ᫮ ࠭
                xor     ax,ax                   ; 㥬 ࠭
                xor     si,si                   ;稪 ஢७ ࠭
ramchk1:
                call    ems_out                 ;  ࠭ EMS
                push    di
                mov     di,offset TestPage
                call    dbinasc
                DISPSTRING TestPage             ;ᮮ饭  ࠭
                call    pagetest                ;஢ ࠭
                pop     di
                jc      ramchk2                 ;室  訡
                mov     [di],NOT_USE            ;ਧ ᢮ ࠭
                inc     si
ramchk2:
                add     di,LOG_SIZE
                inc     ax                      ;᫥ ࠭ EMS
                loop    ramchk1

                mov     Total_Pages,si          ;ᥣ ࠭ ...
                mov     Un_Alloc_Pages,si       ;ᥣ  ࠭ ...

                mov     al,DISABLE              ; ࠭
                call    ems_out

                cmp     Total_Pages,0           ;ᥣ ࠭ 0 ?
                jne     ramchk3
                DISPSTRING Nopage_Err           ;ᮮ饭  ⢨ ࠭
                stc
                ret
ramchk3:
                clc
                ret
ramchk          ENDP

;--------------------------------------------------------------------
; 뢮  ᯫ ᮮ饭  ⠭ ࠩ EMM
;--------------------------------------------------------------------
instmsg         PROC    NEAR
                push    ax di
                mov     ax,Total_Pages
                mov     di,offset TotalPages
                call    dbinasc
                mov     ax,Page_Frame_Seg
                mov     di,offset SegAddr
                call    hbinasc
                DISPSTRING Install_Msg
                pop     di ax
                ret
instmsg         ENDP

;--------------------------------------------------------------------
; ஢ઠ ᪮ ࠭.
; 室
;       AX      :  ࠭.
;       BX      : ᥣ   
; 室
;       CY = 0  :  訡
;          = 1  : 㦥 訡
;--------------------------------------------------------------------
pagetest        PROC    NEAR
                cld
                push    ax cx
                xor     di,di
                test    Sysflag,00000010B       ;३  ஬  ?
                jnz     quick_test

                mov     WORD PTR es:[di],5AA5H
                cmp     WORD PTR es:[di],5AA5H
                jne     mem_error
                mov     cx,4000H
                mov     al,55H
                rep     stosb
                xor     di,di
                mov     cx,4000H
                repe    scasb
                jne     mem_error

                mov     cx,4000H
                xor     di,di
                mov     al,0AAH
                rep     stosb
                xor     di,di
                mov     cx,4000H
                repe    scasb
                jne     mem_error
test_ok:        clc
                jmp     short end_test
quick_test:
                mov     WORD PTR es:[di],5AA5H
                cmp     WORD PTR es:[di],5AA5H
                je      test_ok
mem_error:
                stc
end_test:
                pop     cx ax
                ret
pagetest        ENDP

;--------------------------------------------------------------------
; ८ࠧ     ଠ ASCII
; 室
;       AX      :  
; 室
;       DS:DI   : ப  
;--------------------------------------------------------------------
dbinasc         PROC    NEAR
                push    ax bx cx dx si di
                mov     si,di
                mov     cx,4
                mov     bx,1000
                xor     dx,dx
dbinas1:
                div     bx
                or      al,al
                jnz     dbinas2
                cmp     cl,4
                jz      dbinas4
                cmp     byte ptr [si],' '
                jnz     dbinas2
dbinas4:
                mov     al,' '
                cmp     cl,1
                jnz     dbinas3
                xor     al,al
dbinas2:
                add     al,'0'
dbinas3:
                mov     si,di
                mov     [di],al
                inc     di
                push    dx
                xor     dx,dx
                mov     ax,bx
                mov     bx,10
                div     bx
                mov     bx,ax
                pop     ax
                loop    dbinas1
                pop     di si dx cx bx ax
                ret
dbinasc         ENDP

;--------------------------------------------------------------------
; Change data BYNARY -> ASCII (HEX)
; input
;       AX      : binary data
; output
;       DS:DI   : ascii data (HEX)
;--------------------------------------------------------------------
hbinasc         PROC    NEAR
                push    ax bx cx dx si di
                mov     si,di
                mov     cx,4
                mov     bx,1000H
                xor     dx,dx
hbinas1:
                div     bx
                cmp     al,10
                jb      hbinas2
                add     al,7
hbinas2:
                add     al,'0'
hbinas3:
                mov     si,di
                mov     [di],al
                inc     di
                push    dx
                xor     dx,dx
                mov     ax,bx
                mov     bx,10H
                div     bx
                mov     bx,ax
                pop     ax
                loop    hbinas1
                pop     di si dx cx bx ax
                ret
hbinasc         ENDP

;--------------------------------------------------------------------
; Change data ASCII (DEC) -> BINARY
; input
;       DS:DI = ascii data address (DEC)
; output
;       AX = binary data
;--------------------------------------------------------------------
ascbin1         PROC    NEAR
                push    bx cx dx di
                xor     dl,dl
                mov     cx,4
                xor     bx,bx
ascbin11:
                mov     al,[di]
                cmp     al,' '
                jz      ascbin13
                cmp     al,TAB
                jnz     ascbin14
ascbin13:
                or      dl,dl
                jnz     ascbin12
                inc     di
                jmp     short ascbin11
ascbin12:
                or      dl,dl
                jnz     ascbin16
                stc
                jmp     short ascbin15
ascbin14:
                cmp     al,'0'
                jb      ascbin12
                cmp     al,':'
                jnb     ascbin12
                mov     dl,1
                sub     al,'0'
                xor     ah,ah
                xchg    bx,ax
                push    dx
                mov     dx,10
                mul     dx
                add     bx,ax
                pop     dx
                inc     di
                loop    ascbin11
ascbin16:
                mov     ax,bx
                clc
ascbin15:
                pop     di dx cx bx
                ret
ascbin1         ENDP

;--------------------------------------------------------------------
; Change data ASCII (HEX) -> BINARY
; input
;       DS:DI = ascii data address (HEX)
; output
;       AX = binary data
;--------------------------------------------------------------------
ascbin2         PROC    NEAR
                push    bx cx dx di
                xor     dl,dl
                mov     cx,4
                xor     bx,bx
ascbin21:
                mov     al,[DI]
                cmp     al,' '
                jz      ascbin23
                cmp     al,TAB
                jnz     ascbin24
ascbin23:
                or      dl,dl
                jnz     ascbin22
                inc     di
                jmp     short ascbin21
ascbin22:
                or      dl,dl
                jnz     ascbin27
                stc
                jmp     short ascbin25
ascbin24:
                cmp     al,'0'
                jb      ascbin22
                cmp     al,':'
                jb      ascbin26
                cmp     al,'A'
                jb      ascbin22
                cmp     al,'G'
                jnb     ascbin22
                sub     al,7
ascbin26:
                mov     dl,1
                sub     al,'0'
                xor     ah,ah
                xchg    bx,ax
                push    dx
                mov     dx,10H
                mul     dx
                add     bx,ax
                pop     dx
                inc     di
                loop    ascbin21
ascbin27:
                mov     ax,bx
                clc
ascbin25:
                pop     di dx cx bx
                ret
ascbin2         ENDP

;--------------------------------------------------------------------
;         楤 樠樨 ࠩ EMM
;--------------------------------------------------------------------
Install_Msg     DB      'Total pages EMM     : '
TotalPages      DB      '0000',CR,LF
Segment_Msg     DB      'Segment address EMM : '
SegAddr         DB      '0000H',CR,LF,'$'
Start_Msg       DB      'ͻ',CR,LF
                DB      '         Expanded Memory Manager V1.3          ',CR,LF
                DB      '    Expanded Memory Specification LIM 4.0      ',CR,LF
                DB      ' Written by W.Kouts, (037) 3-79-67, Chernovtsy ',CR,LF
                DB      'ͼ',CR,LF,LF,'$'
Manager_Err     DB      ' EMM driver already installed in this system !',CR,LF,'$'
Nopage_Err      DB      ' Any EMS page not found.',CR,LF,'$'
Nomem_Err       DB      ' Free 64 Kb segment not found.',CR,LF,'$'
Notinst         DB      ' EMM driver not installed !',CR,LF,'$'
Page_Msg        DB      '0000 page(s) tested',CR,'$'
TestPage        DB      '0000',CR,'$'

Pageseg         DW      0               ;physical page segment
Sysflag         DB      0               ;system option flag

ok              db      'All right!',CR,LF,'$'
code            ENDS
                END
