		NAME	SEMS4
                page  ,132
;************************************************************************
;*									*
;*									*
;*	EMM/EMS driver program for SUNTAC-62 chip set version B1	*
;*									*
;*			EVALUATION ONLY					*
;*			NOT FOR SALE					*
;*									*
;*               sample program - Version 4.0/Release 0.1  03/22/1988	*
;*									*
;************************************************************************



;
;	EMM handle struct
;
emm_handle_struct		STRUC
    alloc_page_count		DB	?
    handle_name			DB	8 DUP (?)
    handle_flag			DB	?
emm_handle_struct		ENDS

;
;	logical pages struct
;
log_page_struct			STRUC
    emm_handle1			DW	?	;EMM handle
    handle_page_no1		DW	?	;logical page no. to EMM handle
    log_page_number		DW	?	;logical page no.
log_page_struct			ENDS

;
;	physical pages struct
;
phys_page_struct		STRUC
    emm_handle2			DW	?	;EMM handle
    phys_page_port		DW	?	;physical page i/o port address
    phys_seg_addr		DW	?	;physical page segment address
    log_page_data		DB	?	;logical page no. data
phys_page_struct		ENDS



handle_page_struct		STRUC
    emm_handle3			DW	?
    page_alloc_to_handle	DW	?
handle_page_struct		ENDS

partial_page_map_struct		STRUC
    mappable_segment_count	DW	?
    mappable_segment		DW	4 DUP (?)
partial_page_map_struct		ENDS

log_to_phys_map_struct		STRUC
    log_page_number1		DW	?
    phys_page_number1		DW	?
log_to_phys_map_struct		ENDS

log_to_seg_map_struct		STRUC
    log_page_number2		DW	?
    mappable_seg_addr		DW	?
log_to_seg_map_struct		ENDS

handle_dir_struct		STRUC
    handle_value		DW	?
    handle_name1		DB	8 DUP (?)
handle_dir_struct		ENDS

map_and_jump_struct		STRUC
    target_address1		DD	?
    log_phys_map_len		DB	?
    log_phys_map_ptr		DD	?
map_and_jump_struct		ENDS

map_and_call_struct		STRUC
    target_address2		DD	?
    new_page_map_len		DB	?
    new_page_map_ptr		DD	?
    old_page_map_len		DB	?
    old_page_map_ptr		DD	?
    reserved			DW	4 DUP (?)
map_and_call_struct		ENDS

move_source_dest_struct		STRUC
    region_length1		DD	?
    source_memory_type1		DB	?
    source_handle1		DW	?
    source_initial_offset1	DW	?
    source_initial_seg_page1	DW	?
    dest_memory_type1		DB	?
    dest_handle1		DW	?
    dest_initial_offset1	DW	?
    dest_initial_seg_page1	DW	?
move_source_dest_struct		ENDS

xchg_source_dest_struct		STRUC
    region_length2		DD	?
    source_memory_type2		DB	?
    source_handle2		DW	?
    source_initial_offset2	DW	?
    source_initial_seg_page2	DW	?
    dest_memory_type2		DB	?
    dest_handle2		DW	?
    dest_initial_offset2	DW	?
    dest_initial_seg_page2	DW	?
xchg_source_dest_struct		ENDS

mappable_phys_page_struct	STRUC
    phys_page_segment		DW	?
    phys_page_number2		DW	?
mappable_phys_page_struct	ENDS

hardware_info_struct		STRUC
    raw_page_size		DW	?
    alternate_register_sets	DW	?
    context_save_area_size	DW	?
    DMA_register_sets		DW	?
    DMA_channel_operation	DW	?
hardware_info_struct		ENDS

MAX_HNDL		EQU	255	;max handle count
PAGE_MAX		EQU	216	;max logical page count
BACK_MAX		EQU	40	;max mapping data backup count
EMSIOA			EQU	0E8H	;EMS i/o port address A
EMSIOB			EQU	98H	;EMS i/o port address B
CHKIOA			EQU	9DH	;EMS i/o port A check data
CHKIOB			EQU	93H	;EMS i/o port B check data
I8042			EQU	60H	;i8042 i/o port address
TIME_OUT		EQU	1000	;
STATSEG			EQU	0C000H	;defult start page frame address
ROMSEG			EQU	0E000H	;option ROM area segment address
ENDSEG			EQU	0F000H	;BIOS ROM area segment address
NOT_USE			EQU	0AA55H	;not used logical page code
CR			EQU	0DH	;Carriage Return code
LF			EQU	0AH	;Line Feed code
TAB			EQU	09H	;TAB code
MEMSIZE			EQU	413H	;system memory size data area address
DIS_EMS			EQU	0	;physical page disable data
EMSVER			EQU	40H	;EMS version 4.0
HANDLE_NAME_SIZE	EQU	8	;EMM handle name byte size
UNMAP			EQU	0FFFFH	;unmap code
PUSH_REG		EQU	8 * 2	;push register size
EMMWORK                 EQU     80      ; was 60
RET_SP			EQU	EMMWORK+PUSH_REG+6	;int67 stack size
PHYS_PAGES		EQU	4	;physical page count
RAW_PAGES		EQU	400H	;raw page size (16KB)
CONTEXT_SIZE		EQU	SIZE phys_page_struct * PHYS_PAGES
ALTER_REGS		EQU	0	;alter map register set count
DMA_REGS		EQU	0	;alter DMA register set count
DMA_CHANNEL		EQU	0	;DMA channel number
VOLATILE		EQU	0	;volatile
NON_VOLATILE		EQU	1	;non volatile
BACK_SIZE		EQU	SIZE log_page_struct * 4 + 2

;
;	function 24 struct
;
f24_struct			STRUC
				DW	8 DUP (?)
source_off			DW	?
source_seg			DW	?
dest_off			DW	?
dest_seg			DW	?
source_pno			DW	?
dest_pno			DW	?
region_low			DW	?
region_high			DW	?
source_handle			DW	?
dest_handle			DW	?
source_type			DW	?
dest_type			DW	?
f24_ax_save			DW	?
overlap_flag			DW	?
get_source_f			DW	?
get_dest_f			DW	?
forward                         db      ?
save_map_data                   db  size phys_page_struct * PHYS_PAGES  dup (?)
f24_struct			ENDS


;-- EMS REGISTERS -----------------------------------------------------------:
;									     :
; EMS_R0 : 76543210 (Read/Write)					     :
;          |+-----+--- EMS i/o port address A9 - A3 (defult 13H or 1DH)	     :
;          |                                        * 13H(98H),1DH(E8H)      :
;          +-(Write)-- [98H/E8H] port read flag (0:not read, 1:read)	     :
;          +-(Read)--- Register data transmit flag (0:end, 1:not end)	     :
;									     :
; EMS_R1 : 76543210 (Reserved)						     :
;									     :
; EMS_R2 : 76543210 (Write only)					     :
;          |    |++--- EMS flag (00:EMS enable , 11:EMS disable)	     :
;          +----+----- System memory size A19 - A14 (A0H = 640KB)	     :
;									     :
; EMS_R3 : 76543210 (Write only)					     :
;          |    |++--- Bank size (00:16KB)				     :
;          +----+----- EMS page frame segment address A19 - A14 (C0H = C000H):
;									     :
; EMS_R4 : 76543210 (Write only)					     :
;          +------+--- Bank 0 page number data (1 - 255)		     :
;		       * Data 0 = bank 0 disable			     :
;									     :
; EMS_R5 : 76543210 (Write only)					     :
;          +------+--- Bank 1 page number data (1 - 255)		     :
;		       * Data 0 = bank 1 disable			     :
;									     :
; EMS_R6 : 76543210 (Write only)					     :
;          +------+--- Bank 2 page number data (1 - 255)		     :
;		       * Data 0 = bank 2 disable			     :
;									     :
; EMS_R7 : 76543210 (Write only)					     :
;          +------+--- Bank 3 page number data (1 - 255)		     :
;		       * Data 0 = bank 3 disable			     :
;									     :
;----------------------------------------------------------------------------:


code		SEGMENT
		ASSUME	CS:code

		ORG	0000H

		; DEVICE header block
emmdrv		DW	-1,-1		;Link to next device
		DW	8000H		;
		DW	OFFSET emmstat	;
		DW	OFFSET emmint	;
		DB	'EMMXXXX0'	;

ptrsav		LABEL	DWORD
parofs		DW	0		;
parseg		DW	0		;

page_frame_seg	DW	0C000H		;physical page frame address
total_pages	DW	PAGE_MAX	;total logical page count
un_alloc_pages	DW	PAGE_MAX	;unallocate logical page count
handle_count	DW	0		;EMM handle used count
jump_addr	DW	0		;EMM function jump address data area
emm_flag	DB	0		;EMM driver install status

;
;	Define offsets for io data packet
;
iodat		STRUC
	cmdlen	DB	?	;LENGTH OF THIS COMMAND
	unit	DB	?	;SUB UNIT SPECIFIER
	cmd	DB	?	;COMMAND CODE
	status	DW	?	;STATUS
		DB	8 DUP (?)
	media	DB	?	;MEDIA DESCRIPTOR
	trans	DD	?	;TRANSFER ADDRESS
	count	DW	?	;COUNT OF BLOCKS OR CHARACTERS
	start	DW	?	;FIRST BLOCK TO TRANSFER
iodat		ENDS

;
;	Define offsets for io data packet 2
;
iodat2		STRUC
		DB	13 DUP (?)
		DB	?
	brkoff	DW	?	;BREAK ADDRESS (OFFSET)
	brkseg	DW	?	;BREAK ADDRESS (SEGMENT)
iodat2		ENDS


;
; Simplistic Strategy routine for non-multi-Tasking system.
;
;	Currently just saves I/O packet pointers in PTRSAV for
;	later processing by the individual interrupt routines.
;
emmstat		PROC	FAR
		MOV	CS:parofs,BX	;
		MOV	CS:parseg,ES	;
		RET			;
emmstat		ENDP


;
; Common program for handling the simplistic I/O packet
;	processing scheme in MSDOS
;
emmint		PROC	FAR
		PUSH	SI
		PUSH	AX		;Save all nessacary registers.
		PUSH	CX
		PUSH	DX
		PUSH	DI
		PUSH	BP
		PUSH	DS
		PUSH	ES
		PUSH	BX
		LDS	BX,CS:ptrsav	;Retrieve pointer to I/O Packet.
		MOV	CX,[BX].count	;CX = Contains byte/sector count.
		MOV	AL,[BX].cmd	;Retrieve Command type. (1 => 11)
		CBW			;
		MOV	SI,OFFSET emstbl;
		ADD	SI,AX		;Compute entry pointer
		ADD	SI,AX		; in dispatch table.
		CMP	AL,11		;Verify that not more than 11 commands.
		JA	cmderr		;Ah, well, error out.
		LES	DI,[BX].trans	;DI contains addess
		PUSH	CS		; of Transfer address.
		POP	DS		;Data segment same as Code segment.
		JMP	WORD PTR [SI]	;Perform I/O packet command.

bus_exit:				;Device busy exit.
		MOV	AH,00000011B	;Set busy and done bits.
		JMP	exit1

cmderr:		MOV	AL,3		;Set unknown command error #.

;
;	Common error processing routine.
;	AL contains actual error code.
;
;	Error # 0 = Write Protect violation.
;		1 = Unkown unit.
;		2 = Drive not ready.
;		3 = Unknown command in I/O packet.
;		4 = CRC error.
;		5 = Bad drive request structure length.
;		6 = Seek error.
;		7 = Unknown media discovered.
;		8 = Sector not found.
;		9 = Printer out of paper.
;		10 = Write fault.
;		11 = Read fault.
;		12 = General failure.
;
err_exit:
		MOV	AH,10000001B	;Set error and done bits.
		STC			;Set carry bit also.
		JMP	exit1		;Quick way out.

exit:		MOV	AH,00000001B	;Set done bit for MSDOS.
exit1:		LDS	BX,CS:ptrsav
		MOV	[BX].status,AX	;Save operation compete and status.
		POP	BX		;Restore registers.
		POP	ES
		POP	DS
		POP	BP
		POP	DI
		POP	DX
		POP	CX
		POP	AX
		POP	SI
		RET
emmint		ENDP

;
;
;
emstbl		DW	emminit	;0  - Init. (Not used)
		DW	emmchk	;1  - Media check (Not used)
		DW	emmchk	;2  - Get Bios Parameter Block (Not used)
		DW	emmchk	;3  - Reserved. (Currently returns error)
		DW	exit	;4  - Character read. (Destructive)
		DW	exit	;5  - Character read. (Non-destructive)
		DW	exit	;6  - Return status. (Not used)
		DW	exit	;7  - Flush Input buffer.
		DW	exit	;8  - Character write.
		DW	exit	;9  - Character write with Verify.
		DW	exit	;10 - Character write status.
		DW	exit	;11 - Flush output buffer. (Not used.)
		DW	exit	;12 - IO Control.

;
;	EMM driver install check routine
;
emmchk:
		CMP	emm_flag,1	;EMM install flag on?
		JNZ	err_exit	;no
		JMP	exit		;yes

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

;  뢠 ᮤন in ax or ds:[si+sm]
;
deb_str         macro  arg
                push ax
                push di
                push si

                ifdif <arg>,<ax>
;;                 if type arg gt 1
                  mov ax, arg
;;                 else
;;                  mov al, arg
;;                  cbw
;;                 endif
                endif

                push es
                push cs
                pop es
                mov di,offset cs:number_str
                call hbinasc
                pop es

                push ds
                push cs
                pop ds
                mov si,offset cs:display_str
                call strdsp_direct
                pop ds

                pop si
                pop di
                pop ax
                endm

ifdef display_int

loc_offset      dw  0
screen_seg = 0b800h

;
;       ds:si - ப  ⮡ࠦ
; ⮡ࠦ   ࠭,  ⥪饥
; ᬥ饭  쭮
;  ࠭ SI

strdsp_direct   proc near
                cli
                push di
                push es
                push ax

                mov ax,screen_seg       ;  es:di - 孨  㣮 ࠭
                mov es,ax
                mov di,cs:loc_offset

dsp_loop :      lodsb
                cmp al,'$'
                jz dsp_all
                mov ah,7
                stosw
                jmp short dsp_loop
dsp_all :
                add di,2
                mov cs:loc_offset, di      ;   祭 ᬥ饭

                pop ax
                pop es
                pop di
                sti
                ret
strdsp_direct   endp

;--------------------------------------------------------------------
; Change data BYNARY -> ASCII (HEX)
; input
;	AX	: binary data
; output
;	ES:DI	: ascii data (HEX)
;   ࠭ DI
;--------------------------------------------------------------------
hbinasc:
		PUSH	AX
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		MOV	SI,DI
		MOV	CX,4
		MOV	BX,1000H
		XOR	DX,DX
hbinas1:
		DIV	BX
		CMP	AL,10
		JB	hbinas2
		ADD	AL,7
hbinas2:
		ADD	AL,'0'
hbinas3:
		MOV	SI,DI
		STOSB
		PUSH	DX
		XOR	DX,DX
		MOV	AX,BX
		MOV	BX,10H
		DIV	BX
		MOV	BX,AX
		POP	AX
		LOOP	hbinas1
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		DEC	DI
		RET
endif



;--------------------------------------------------------------------
;	int 67H EMM driver main routine
;--------------------------------------------------------------------
int67		PROC	FAR
		CLI			;
		SUB	SP,EMMWORK	;
		PUSH	DS		;
		PUSH	ES		;
		PUSH	BP		;
		PUSH	DI		;
		PUSH	SI		;
		PUSH	DX		;
		PUSH	CX		;
		PUSH	BX		;
		MOV	BP,SP		;
		CLD			;
		PUSH	CS		;
		POP	DS		;

		ASSUME	DS:code

		CMP	AH,40H		;--- function code check ---
		JB	err84		; FUNCTION 1 - 30 ?
		CMP	AH,5EH		;
		JNB	err84		;---------------------------
		PUSH	BX		;
		MOV	jump_addr,AX	;
		XCHG	AH,AL		;
		XOR	AH,AH		;
		SUB	AX,40H		;
		SHL	AX,1		;
		MOV	BX,OFFSET func_table;
		ADD	BX,AX		;
		MOV	AX,[BX]		;
		XCHG	AX,jump_addr	;
		POP	BX		;
;                sti                     ; for debugging 06/16/92 04:59pm
		JMP	jump_addr	;---- jump functions -----

;------ function 1 --------------------------------------------------
; Get status
; output
;	AH	: status
;--------------------------------------------------------------------
func1:
		STI			;
noerr:					;normal return point.
		XOR	AH,AH		;
err_ret:				;error return point.
		POP	BX		;
		POP	CX		;
		POP	DX		;
		POP	SI		;
		POP	DI		;
		POP	BP		;
		POP	ES		;
		POP	DS		;
		ADD	SP,EMMWORK	;
		IRET			;
int67		ENDP

;--------------------------------------------------------------------
;	register back area struct
;--------------------------------------------------------------------
retreg		STRUC
    bx_save	DW	?	;BX save area
    cx_save	DW	?	;CX save area
    dx_save	DW	?	;DX save area
    si_save	DW	?	;SI save area
    di_save	DW	?	;DI save area
    bp_save	DW	?	;BP save area
    es_save	DW	?	;ES save area
    ds_save	DW	?	;DS save area
retreg		ENDS

;
;	function 22 struct
;
f22_struct			STRUC
				DW	8 DUP (?)
                                DB      EMMWORK DUP (?) ; was DW 07/19/92 04:44pm
    ret_offset			DW	?		;return offset address
    ret_segment			DW	?		;return segment address
    ret_flag			DW	?		;return flags
f22_struct			ENDS

;
;	function 23 struct
;
f23_struct			STRUC
				DW	8 DUP (?)
;                                DB      EMMWORK DUP (?) ; 03/01/93 06:27pm
    f23_off			DW	?
    f23_seg			DW	?
    f23_flag			DW	?
    f23_retoff			DW	?
    f23_retseg			DW	?
    f23_ax_save			DW	?
f23_struct			ENDS

;--------------------------------------------------------------------
;	EMM driver function jump table
;		(40H - 5DH)
;--------------------------------------------------------------------
func_table	LABEL	WORD
		DW	OFFSET func1	;function 1
		DW	OFFSET func2	;function 2
		DW	OFFSET func3	;function 3
		DW	OFFSET func4	;function 4
		DW	OFFSET func5	;function 5
		DW	OFFSET func6	;function 6
		DW	OFFSET func7	;function 7
		DW	OFFSET func8	;function 8
		DW	OFFSET func9	;function 9
		DW	OFFSET func10	;function 10
		DW	OFFSET func11	;function 11
		DW	OFFSET func12	;function 12
		DW	OFFSET func13	;function 13
		DW	OFFSET func14	;function 14
		DW	OFFSET func15	;function 15
		DW	OFFSET func16	;function 16
		DW	OFFSET func17	;function 17
		DW	OFFSET func18	;function 18
		DW	OFFSET func19	;function 19
		DW	OFFSET func20	;function 20
		DW	OFFSET func21	;function 21
		DW	OFFSET func22	;function 22
		DW	OFFSET func23	;function 23
		DW	OFFSET func24	;function 24
		DW	OFFSET func25	;function 25
		DW	OFFSET func26	;function 26
		DW	OFFSET func27	;function 27
		DW	OFFSET func28	;function 28
		DW	OFFSET func29	;function 29
		DW	OFFSET func30	;function 30

;--------------------------------------------------------------------
;	error status set routine
;--------------------------------------------------------------------

;The manager detected a malfunction in the EMM software.
err80:
		MOV	AH,80H
		JMP	err_ret

;The manager detected a malfunction in the expanded memory hardware.
err81:
		MOV	AH,81H
		JMP	err_ret

;The EMM couldn't find the EMM handle your program specified.
err83:
		MOV	AH,83H
		JMP	err_ret

;The function code passed to the EMM is not defined.
err84:
		MOV	AH,84H
		JMP	err_ret

;All EMM handles are being used.
err85:
		MOV	AH,85H
		JMP	err_ret

;The EMM detected a "save" or "restore" page mapping context error.
err86:
		MOV	AH,86H
		JMP	err_ret

;There aren't enough expanded memory pages to satisfy your program's request.
err87:
		MOV	AH,87H
		JMP	err_ret

;There aren't enough unallocated pages to satisfy your program's request.
err88:
		MOV	AH,88H
		JMP	err_ret

;Can't allocate zero (0) pages.
err89:
		MOV	AH,89H
		JMP	err_ret

;The logical page is out of the range of logical pages which are allocated to
;the EMM handle.
err8a:
		MOV	AH,8AH
		JMP	err_ret

;The physical page to which the logical page is mapped is out of the range of
;physical pages.
err8b:
		MOV	AH,8BH
		JMP	err_ret

;The page mapping hardware state save area is full.
err8c:
		MOV	AH,8CH
		JMP	err_ret

;The page mapping hardware state save area already has a state associated with
;the EMM handle.
err8d:
		MOV	AH,8DH
		JMP	err_ret

;The page mapping hardware state save area doesn't have a state associated with
;the EMM handle.
err8e:
		MOV	AH,8EH
		JMP	err_ret

;The subfunction parameter passed to the function isn't defined.
err8f:
		MOV	AH,8FH
		JMP	err_ret

;
err90:
		MOV	AH,90H
		JMP	err_ret

;
err91:
		MOV	AH,91H
		JMP	err_ret

;
err92:
		MOV	AH,92H
		JMP	err_ret

;
err93:
		MOV	AH,93H
		JMP	err_ret

;
err94:
		MOV	AH,94H
		JMP	err_ret

;
err95:
		MOV	AH,95H
		JMP	err_ret

;
err96:
		MOV	AH,96H
		JMP	err_ret

;
err97:
		MOV	AH,97H
		JMP	err_ret

;
err98:
		MOV	AH,98H
		JMP	err_ret

;
err99:
		MOV	AH,99H
		JMP	err_ret

;
err9a:
		MOV	AH,9AH
		JMP	err_ret

;
err9b:
		MOV	AH,9BH
		JMP	err_ret

;
err9c:
		MOV	AH,9CH
		JMP	err_ret

;
err9d:
		MOV	AH,9DH
		JMP	err_ret

;
err9e:
		MOV	AH,9EH
		JMP	err_ret

;
err9f:
		MOV	AH,9FH
		JMP	err_ret

;
erra0:
		MOV	AH,0A0H
		JMP	err_ret

;
erra1:
		MOV	AH,0A1H
		JMP	err_ret

;
erra2:
		MOV	AH,0A2H
		JMP	err_ret

;
erra3:
		MOV	AH,0A3H
		JMP	err_ret

;
erra4:
		MOV	AH,0A4H
		JMP	err_ret

;------ function 2 --------------------------------------------------
; Get page frame address
; output
;	AH	: status
;	BX	: page segment address
;--------------------------------------------------------------------
func2:
		STI				;
		MOV	BX,page_frame_seg	;get EMM physical page segment
f21:						; address.
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;------ function 3 --------------------------------------------------
; Get unallocated page count
; output
;	AH	: status
;	BX	: unallocate page
;	DX	: all page
;--------------------------------------------------------------------
func3:
		MOV	SI,OFFSET log_page	;
		XOR	BX,BX			;
		MOV	DX,BX			;
		MOV	CX,PAGE_MAX		;
f33:						;
		CMP	WORD PTR [SI],UNMAP	;logical page end ?
		JZ	f31			;
		INC	DX			;
		CMP	WORD PTR [SI],NOT_USE	;unallocated page ?
		JNZ	f32			;
		INC	BX			;
f32:						;
		ADD	SI,SIZE log_page_struct	;
		LOOP	f33			;
f31:						;
		MOV	total_pages,DX		;Save total page count
		MOV	un_alloc_pages,BX	;Save unallocated page count
		MOV	[BP].dx_save,DX		;Save all page count
		JMP	f21			;

;------ function 4 --------------------------------------------------
; Allocate pages
; input
;	BX	: request allocate page
; output
;	AH	: status
;	DX	: EMM handle
;--------------------------------------------------------------------
func4:
		OR	BX,BX			;request page size 0 ?
		JZ	f49			;yes
f41:						;
		CMP	total_pages,BX		;request total size over ?
		JB	f42			;yes
		CMP	un_alloc_pages,BX	;request unallocate size over ?
		JB	f43			;yes
		XOR	DX,DX			;
		MOV	SI,OFFSET handle	;
		MOV	CX,MAX_HNDL		;
f45:						;
		CMP	[SI].handle_flag,0	;not used EMM handle ? v2.00
		JZ	f44			;
		INC	DX			;
		ADD	SI,SIZE emm_handle_struct;v2.00
		LOOP	f45			;
		JMP	err85			;error exit
f44:						;
		MOV	[SI].handle_flag,1	;handle active flag set v2.00
		INC	handle_count		;used EMM handle count up
		SUB	un_alloc_pages,BX	;unallocated page - BX
		MOV	[SI].alloc_page_count,BL;EMM handle used page count set
		MOV	SI,OFFSET log_page	; v2.00
		XOR	DI,DI			;
		MOV	CX,BX			;
		JCXZ	f48			;CX = 0?
f47:						;
		CMP	WORD PTR [SI],NOT_USE	;unallocated page ?
		JZ	f46			;
		ADD	SI,SIZE log_page_struct	;
		JMP	f47			;
f46:						;
		MOV	[SI],DX			;EMM handle set
		MOV	[SI].handle_page_no1,DI	;logical page no. set
		INC	DI			;
		ADD	SI,SIZE log_page_struct	;
		LOOP	f47			;
f48:
		MOV	[BP].dx_save,DX		;return EMM handle
		MOV	[BP].bx_save,BX		;allocated pages count set
		JMP	noerr			;exit
f49:						;
		JMP	err89			;error exit
f42:						;
		JMP	err87			;error exit
f43:						;
		JMP	err88			;error exit

;------ function 5 --------------------------------------------------
; Map handle pages
; input
;	AL	: physical page no.
;	BX	: logical page no. (if BX=FFFFH then unmap)
;	DX	: EMM handle
; output
;	AH	: status
;--------------------------------------------------------------------
func5:
		CMP	AL,PHYS_PAGES		;physical page no. ok ?
		JNB	f51			;no
		XOR	AH,AH			;get phys_page_struct pointer..
		MOV	DI,OFFSET map_table	;
		MOV	CX,AX			;AX * 7 -> AX...
		SHL	CX,1			;
		ADD	CX,AX			;
		SHL	CX,1			;
		ADD	AX,CX			;
		ADD	DI,AX			;
		CMP	DX,MAX_HNDL		;check handle data...
		JNB	f5a			;
		MOV	SI,OFFSET handle	;
		MOV	AX,DX			;DX * 10 -> AX...
		SHL	AX,1			;
		SHL	AX,1			;
		ADD	AX,DX			;
		SHL	AX,1			;
		ADD	SI,AX			;
		CMP	[SI].handle_flag,0	;active handle ?
		JZ	f5a			;
		CMP	BX,UNMAP		;unmap ?
		JZ	f57			;
		MOV	CX,PAGE_MAX		;
		MOV	SI,OFFSET log_page	;
f55:
		CMP	[SI],DX			;EMM handle same ?
		JNZ	f53			;no
		CMP	[SI].handle_page_no1,BX	;logical page no. same ?
		JZ	f54			;yes
f53:
		ADD	SI,SIZE log_page_struct	;
		LOOP	f55			;
		JMP	err8a			;error exit
f54:
		PUSH	DX			;
		MOV	AX,[SI].log_page_number	;
		ADD	AL,pageofs		;
		MOV	DX,[DI].phys_page_port	;
		CALL	emsout			;
		POP	DX			;
		JB	f59			;error?
f58:
		MOV	[DI],DX			;set handle
		MOV	[DI].log_page_data,AL	;set logical page no. data
		JMP	noerr			;exit
f57:
		MOV	DX,[DI].phys_page_port	;unmapping...
		XOR	AL,AL			;
		CALL	emsout			;
		JB	f59			;error?
		MOV	DX,UNMAP		;
		JMP	f58			;
f51:
		JMP	err8b			;error exit
f59:
		JMP	err81			;error exit
f5a:
		JMP	err83			;error exit

;------ function 6 --------------------------------------------------
; Deallocate pages
; input
;	DX	: EMM handle
; output
;	AH	: status
;--------------------------------------------------------------------
func6:
		CALL	check_handle		;check handle data...
		JB	f61			;
		MOV	SI,OFFSET backup_map	;
		MOV	CX,BACK_MAX		;
f62:
		CMP	[SI],DX			;EMM handle same ?
		JZ	f63			;yes
		ADD	SI,BACK_SIZE		;
		LOOP	f62			;
		CALL	get_alloc_page		;
		MOV	BX,AX			;
		OR	BX,BX			;page = 0?
		JZ	f6c			;
		XOR	AX,AX			;
		MOV	SI,OFFSET log_page	;deallocate logical page
		MOV	CX,PAGE_MAX		;
f65:
		CMP	WORD PTR [SI],UNMAP	;
		JZ	f6b			;
		CMP	[SI],DX			;
		JNZ	f64			;
		MOV	WORD PTR [SI],NOT_USE	;
		INC	AX			;
		CMP	AX,BX			;
		JZ	f66			;
f64:
		ADD	SI,SIZE log_page_struct	;
		LOOP	f65			;
f6b:
		JMP	err80			;error exit
f61:
		JMP	err83			;error exit
f63:
		JMP	err86			;error exit
f66:
		XOR	AX,AX			;
		MOV	CX,PHYS_PAGES		;deallocate physical page
		MOV	SI,OFFSET map_table	;
f6a:
		CMP	[SI],DX			;
		JNZ	f67			;
		MOV	WORD PTR [SI],UNMAP	;
		MOV	[SI].log_page_data,AL	;
f67:
		ADD	SI,SIZE phys_page_struct;
		LOOP	f6a			;
f6c:
		ADD	un_alloc_pages,BX	;add unallocate pages
		MOV	DI,OFFSET handle	;clear handle use flag
		MOV	AX,SIZE emm_handle_struct;
		MUL	DL			;
		ADD	DI,AX			;
		PUSH	CS			;
		POP	ES			;
		PUSH	DI			;
		XOR	AL,AL			;clear handle data
		MOV	CX,SIZE emm_handle_struct;
		REPZ	STOSB			;
		POP	DI			;
		CMP	DX,0			;system handle?
		JZ	f6d			;
		DEC	handle_count		;not use handle count up
		JMP	noerr			;exit
f6d:
		MOV	[DI].handle_flag,1	;
		JMP	noerr			;exit

;------ function 7 --------------------------------------------------
; Get EMS version
; output
;	AH	: status
;	AL	: EMS version number
;--------------------------------------------------------------------
func7:
		STI				;
		MOV	AL,EMSVER		;get version no.
		JMP	noerr			;

;------ function 8 --------------------------------------------------
; Save page map
; input
;	DX	: EMM handle
; output
;	AH	: status
;--------------------------------------------------------------------
func8:
		CALL	check_handle		;check handle data
		JB	f81			;
		MOV	DI,OFFSET backup_map	;check backup handle
		MOV	CX,BACK_MAX		;
f83:						;
		CMP	[DI],DX			;
		JZ	f82			;
		ADD	DI,BACK_SIZE		;
		LOOP	f83			;
		CMP	backup_count,BACK_MAX	;
		JZ	f84			;
		MOV	DI,OFFSET backup_map	;found mapping data save area
		MOV	CX,BACK_MAX		;
f86:
		CMP	WORD PTR [DI],UNMAP	;
		JZ	f85			;
		ADD	DI,BACK_SIZE		;
		LOOP	f86			;
f84:						;
		JMP	err8c			;error exit
f85:						;
		PUSH	DS			;copy mapping data -> [DI]
		POP	ES			;
		MOV	SI,OFFSET map_table	;
		MOV	[DI],DX			;
		INC	DI			;
		INC	DI			;
		MOV	CX,CONTEXT_SIZE		;
		REPZ	MOVSB			;
		INC	backup_count		;
		JMP	noerr			;exit
f81:						;
		JMP	err83			;error exit
f82:						;
		JMP	err8d			;error exit

;------ function 9 --------------------------------------------------
; Restore page map
; input
;	DX	: EMM handle
; output
;	AH	: status
;--------------------------------------------------------------------
func9:
		CALL	check_handle		;check handle data...
		JB	f91			;
		PUSH	DS			;
		POP	ES			;
		CMP	backup_count,0		;backup count = 0 ?
		JZ	f92			;
		MOV	SI,OFFSET backup_map	;found backup map...
		MOV	CX,BACK_MAX		;
f94:
		CMP	[SI],DX			;
		JZ	f93			;
		ADD	SI,BACK_SIZE		;
		LOOP	f94			;
f92:
		JMP	err8e			;error exit
f93:						;
		MOV	WORD PTR [SI],UNMAP	;clear handle data
		INC	SI			;
		INC	SI			;
		MOV	DI,OFFSET map_table	;disable physical pages...
		MOV	CX,PHYS_PAGES		;
f96:
		MOV	DX,[DI].phys_page_port	;
		MOV	AL,DIS_EMS		;
		CALL	emsout			;
		JB	f97			;
		ADD	DI,SIZE phys_page_struct;
		LOOP	f96			;
		MOV	CX,CONTEXT_SIZE		;move mapping data...
		MOV	DI,OFFSET map_table	;
		PUSH	DI			;
		REPZ	MOVSB			;
		POP	DI			;
		CALL	set_pages_map		;enable physical pages...
		JB	f97			;
		DEC	backup_count		;backup mapping count DEC
		JMP	noerr			;exit
f91:
		JMP	err83			;error exit
f97:
		JMP	err81			;error exit

;------ function 10 -------------------------------------------------
; Get page mapping register I/O port array
; input
;	ES:DI	: buffer address point
; output
;	AH	: status
;	AL	: board count
;--------------------------------------------------------------------
func10:
		STI				;
		MOV	SI,OFFSET port_addr	;
		MOV	CX,PHYS_PAGES		;
		REPZ	MOVSW			;
		MOV	AL,1			;
		JMP	noerr			;

;------ function 11 -------------------------------------------------
; Get logical-to-physical page translation array
; input
;	DX	: EMM handle
;	ES:DI	: buffer address point
; output
;	AH	: status code
;	BX	: number of pages allocated EMM handle.
;--------------------------------------------------------------------
func11:
		STI				;
		MOV	SI,OFFSET log_page	;
		MOV	CX,PAGE_MAX		;
		XOR	BX,BX			;
f113:						;
		CMP	WORD PTR [SI],UNMAP	;
		JZ	f111			;
		CMP	[SI],DX			;
		JNZ	f112			;
		MOV	AX,[SI].log_page_number	;
		ADD	AL,pageofs		;
		XCHG	AH,AL			;
		STOSW				;
		INC	BX			;
f112:						;
		ADD	SI,SIZE log_page_struct	;
		LOOP	f113			;
f111:						;
		OR	BX,BX			;
		JZ	f114			;
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit
f114:						;
		JMP	err83			;error exit

;------ function 12 -------------------------------------------------
; Get EMM handle count
; output
;	AH	: status
;	BX	: active EMM handles
;--------------------------------------------------------------------
func12:
		STI				;
		MOV	BX,handle_count		;
f121:						;
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;------ function 13 -------------------------------------------------
; Get EMM handle pages
; input
;	DX	: EMM handle
; output
;	AH	: status
;	BX	: pages EMM handle
;--------------------------------------------------------------------
func13:
		STI				;
		CALL	check_handle		;check handle data
		JB	func131			;
		CALL	get_alloc_page		;
		MOV	BX,AX			;
		JMP	f121			;exit
func131:
		JMP	err83			;error exit

;------ function 14 -------------------------------------------------
; Get all EMM handle pages
; input
;	ES:DI	: buffer address point
; output
;	AH	: status
;	BX	: number of active EMM handles
;--------------------------------------------------------------------
func14:
		STI				;
		MOV	SI,OFFSET handle	;
		MOV	CX,MAX_HNDL		;
		XOR	BX,BX			;
		XOR	DX,DX			;
f142:						;
		CMP	[SI].handle_flag,0	;
		JZ	f141			;
		MOV	AX,DX			;
		STOSW				;
		CALL	get_alloc_page		;
		STOSW				;
		INC	BX			;
f141:						;
		INC	DX			;
		ADD	SI,SIZE emm_handle_struct;
		LOOP	f142			;
		JMP	f121			;

;------ function 15 -------------------------------------------------
; Get/set page map
; input
;	AL	: request subfunction no.
;	ES:DI	: mapping registers buffer address point
; output
;	AH	: status
;--------------------------------------------------------------------
func15:
		CMP	AL,0			;
		JZ	get_page_map		;
		CMP	AL,1			;
		JZ	set_page_map		;
		CMP	AL,2			;
		JZ	get_set_page_map	;
		CMP	AL,3			;
		JZ	get_size_page_map	;
		JMP	err8f			;error exit

;--------------------------------------------------------------------
; Get page map.
; input
;	ES:DI	: dest_page_map
; output
;	AH	: status
;--------------------------------------------------------------------
get_page_map:
		MOV	SI,OFFSET map_table	;
		MOV	CX,CONTEXT_SIZE		;
		REPZ	MOVSB			;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Set page map.
; input
;	DS:SI	: source_page_map
; output
;	AH	: status
;--------------------------------------------------------------------
set_page_map:
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		MOV	CX,CONTEXT_SIZE		;
		MOV	AX,SS			;
		MOV	ES,AX			;
		LEA	DI,[BP]+PUSH_REG	;
		REPZ	MOVSB			;
set_page_map3:
		LEA	DI,[BP]+PUSH_REG	;
		CALL	check_map_data		;
		JNB	set_page_map2		;
		JMP	erra3			;error exit
set_page_map2:
		MOV	AX,ES			;
		MOV	DS,AX			;
		MOV	SI,DI			;
		PUSH	CS			;
		POP	ES			;
		MOV	DI,OFFSET map_table	;
		MOV	CX,CONTEXT_SIZE		;
		REPZ	MOVSB			;
		CALL	set_pages_map		;mapping physical pages.
		JB	set_page_map1		;
		JMP	noerr			;exit
set_page_map1:
		JMP	err81			;error exit

;--------------------------------------------------------------------
; Get & set page map.
; input
;	DS:SI	: source_page_map
;	ES:DI	: dest_page_map
; output
;	AH	: status
;--------------------------------------------------------------------
get_set_page_map:
		PUSH	DI			;move mapping data...
		PUSH	DS			;
		PUSH	ES			;
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		MOV	CX,CONTEXT_SIZE		;
		MOV	AX,SS			;
		MOV	ES,AX			;
		LEA	DI,[BP]+PUSH_REG	;
		REPZ	MOVSB			;
		POP	ES			;
		POP	DS			;
		POP	DI			;
		MOV	SI,OFFSET map_table	;move current map data...
		MOV	CX,CONTEXT_SIZE		;
		REPZ	MOVSB			;
		MOV	AX,SS			;
		MOV	ES,AX			;
		JMP	set_page_map3		;

;--------------------------------------------------------------------
; Get size of page map save array.
; output
;	AH	: status
;	AL	: size_of_array
;--------------------------------------------------------------------
get_size_page_map:
		MOV	AL,CONTEXT_SIZE		;mapping data size set
		JMP	noerr			;

;------ function 16 -------------------------------------------------
; Get/set partial page map
;--------------------------------------------------------------------
func16:
		CMP	AL,0			;
		JZ	get_partial_map		;
		CMP	AL,1			;
                jnz     f16001
                Jmp      set_partial_map         ;
f16001:         CMP     AL,2                    ;
		JZ	get_size_partial_map	;
		JMP	err84			;error exit

;--------------------------------------------------------------------
; Get size of partial page map save array
; input
;	BX	: number of pages in the partial array
; output
;	AH	: status
;	AL	: size_of_partial_save_array
;--------------------------------------------------------------------
get_size_partial_map:
		OR	BX,BX			;BX = 0?
		JZ	get_size_partial_map1	;
		CMP	BX,PHYS_PAGES		;BX > physical page count?
		JG	get_size_partial_map2	;
		MOV	AX,SIZE phys_page_struct;get size of partial map array.
		MUL	BL			;
		ADD	AX,2			;
		JMP	noerr			;exit
get_size_partial_map1:
		JMP	err8f			;error exit
get_size_partial_map2:
		JMP	err8b			;error exit

;--------------------------------------------------------------------
; Get partial page map
; input
;	DS:SI	: partial_page_map
;	ES:DI	: dest_array
; output
;	AH	: status
;--------------------------------------------------------------------
get_partial_map:
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;

ifdef display_int

                push cx
                push bx

                mov bx,si
                mov cx,[bx]
                deb_str cx
dsp :           jcxz up
                add bx,2
                deb_str  <word ptr [bx]>
                dec cx
                jmp short dsp

up:
                pop bx
                pop cx

endif

		LODSW				;
		CMP	AX,PHYS_PAGES		;
                Ja      get_partial_map1        ;  04/05/93 08:49pm
		MOV	CX,AX			;
		JCXZ	get_partial_map5	;page count = 0?
		STOSW				;
get_partial_map4:
		LODSW				;
		PUSH	CX			;
		MOV	BX,OFFSET map_table	;
		MOV	CX,PHYS_PAGES		;
get_partial_map3:
		CMP	AX,CS:[BX].phys_seg_addr;
		JZ	get_partial_map2	;
		ADD	BX,SIZE phys_page_struct;
		LOOP	get_partial_map3	;
		POP	CX			;
		JMP	err8b			;error exit
get_partial_map2:
		PUSH	SI			;move map data...
		PUSH	DS			;
		PUSH	CS			;
		POP	DS			;
		MOV	SI,BX			;
		MOV	CX,SIZE phys_page_struct;
		REPZ	MOVSB			;
		POP	DS			;
		POP	SI			;
		POP	CX			;
		LOOP	get_partial_map4	;
get_partial_map5:
		JMP	noerr			;exit
get_partial_map1:
                JMP     erra3                   ;error exit

;--------------------------------------------------------------------
; Set partial page map
; input
;	DS:SI	: source_array
; output
;	AH	: status
;--------------------------------------------------------------------
set_partial_map:
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		LODSW				;
		MOV	DX,AX			;
		MOV	CX,SIZE phys_page_struct;
		MUL	CL			;
		MOV	CX,AX			;
		JCXZ	set_partial_map1	;
		MOV	AX,SS			;copy page mapping data...
		MOV	ES,AX			;
		LEA	DI,[BP]+PUSH_REG	;
		REPZ	MOVSB			;
		LEA	SI,[BP]+PUSH_REG	;set page mapping data...
		MOV	AX,ES			;
		MOV	DS,AX			;
		MOV	AX,CS			;
		MOV	ES,AX			;
		MOV	CX,DX			;
set_partial_map4:
		MOV	AX,[SI].phys_seg_addr	;
		CALL	change_seg_page		;change segment -> phys_page_no
		JB	set_partial_map3	;
		MOV	DI,OFFSET map_table	;
		PUSH	CX			;
		MOV	CX,SIZE phys_page_struct;
		MUL	CL			;
		ADD	DI,AX			;
		REPZ	MOVSB			;
		POP	CX			;
		LOOP	set_partial_map4	;
		CALL	set_pages_map		;mapping physical pages.
		JB	set_partial_map2	;
set_partial_map1:
		JMP	noerr			;exit
set_partial_map2:
		JMP	err81			;error exit
set_partial_map3:
		JMP	err8b			;error exit

;------ function 17 -------------------------------------------------
; Map/unmap multiple handle pages
;--------------------------------------------------------------------
func17:
		STI				;
		CMP	AL,0			;
		JZ	log_phys_map		;
		CMP	AL,1			;
		JZ	log_seg_map		;
		JMP	err84			;error exit

;--------------------------------------------------------------------
; Logical page/physical page method
; input
;	DX	: EMM handle
;	CX	: logical to physical map length
;	DS:SI	: pointer to logical to physical map array
; output
;	AH	: status
;--------------------------------------------------------------------
log_phys_map:
		MOV	AX,[BP].ds_save		;
		MOV	ES,AX			;
		OR	CX,CX			;
		JNZ	log_phys_map1		;
		JMP	err8F			;error exit
log_phys_map1:
		CALL	check_handle		;check handle data
		JNB	log_phys_map2		;
		JMP	err83			;error exit
log_phys_map2:
		MOV	BX,ES:[SI].log_page_number1;
		CMP	BX,UNMAP		;unmapping?
		JZ	log_phys_map6		;
		CALL	check_log_page		;check logical page no.
		JNB	log_phys_map3		;
		JMP	err8a			;error exit
log_phys_map3:
		MOV	BX,AX			;
log_phys_map6:
		MOV	AX,ES:[SI].phys_page_number1;get physical page no.
		CMP	AX,PHYS_PAGES		;check physical page no.
		JB	log_phys_map4		;
		JMP	err8b			;error exit
log_phys_map4:
		CMP	BX,UNMAP		;unmapping?
		JZ	log_phys_map7		;
		CALL	set_phys_page		;set physical page
		JNB	log_phys_map5		;
		JMP	err81			;error exit
log_phys_map7:
		CALL	reset_phys_page		;reset physical page
		JNB	log_phys_map5		;
		JMP	err81			;error exit
log_phys_map5:
		ADD	SI,SIZE log_to_phys_map_struct;
		LOOP	log_phys_map2		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Logical page/segment address method
; input
;	DX	: EMM handle
;	CX	: logical to segment map length
;	DS:SI	: pointer to logical to segment map array
; output
;	AH	: status
;--------------------------------------------------------------------
log_seg_map:
		MOV	AX,[BP].ds_save		;get DS
		MOV	ES,AX			;set ES
		OR	CX,CX			;page count zero ?
		JNZ	log_seg_map1		;
		JMP	err8F			;error exit
log_seg_map1:
		CALL	check_handle		;check handle data
		JNB	log_seg_map2		;
		JMP	err83			;error exit
log_seg_map2:
		MOV	BX,ES:[SI].log_page_number2;get logical page no.
		CMP	BX,UNMAP		;unmapping?
		JZ	log_seg_map6		;
		CALL	check_log_page		;
		JNB	log_seg_map3		;
		JMP	err8a			;error exit
log_seg_map3:
		MOV	BX,AX			;
log_seg_map6:
		MOV	AX,ES:[SI].mappable_seg_addr;get mappable seg_address.
		CALL	change_seg_page		;change segment -> phys_page_no
		JNB	log_seg_map4		;
		JMP	err8b			;error exit
log_seg_map4:
		CMP	BX,UNMAP		;unmapping?
		JZ	log_seg_map7		;
		CALL	set_phys_page		;set physical page
		JNB	log_seg_map5		;error ?
		JMP	err81			;error exit
log_seg_map7:
		CALL	reset_phys_page		;reset physical page
		JNB	log_seg_map5		;error ?
		JMP	err81			;error exit
log_seg_map5:
		ADD	SI,SIZE log_to_seg_map_struct;
		LOOP	log_seg_map2		;
		JMP	noerr			;exit

;------ function 18 ------------------------------------------------------
; Reallocate pages
; input
;	DX	: EMM handle
;	BX	: reallocation count
; output
;	AH	: status
;	BX	: number of pages allocated to handle after reallocation
;-------------------------------------------------------------------------
func18:
		CALL	check_handle		;check handle data
		JNB	func181			;
		XOR	BX,BX			;
		MOV	[BP].bx_save,BX		;
		JMP	err83			;error exit
func181:
		CALL	get_alloc_page		;get page size to handle
		OR	BX,BX			;reallocate count = 0?
		JNZ	func182			;
		MOV	CX,AX			;BX = 0 case...
		JCXZ	func18a			;CX = 0 case?
		MOV	CX,PAGE_MAX		;BX = 0 case...
		MOV	DI,OFFSET log_page	;
func18c:
		CMP	WORD PTR [DI],UNMAP	;logical page end?
		JZ	func18d			;
		CMP	[DI],DX			;same handle?
		JNZ	func18b			;
		MOV	WORD PTR [DI],NOT_USE	;unallocate logical page
		INC	un_alloc_pages		;add unallocated pages
		DEC	AX			;
		JZ	func18a			;
func18b:
		ADD	DI,SIZE log_page_struct	;
		LOOP	func18c			;
		JMP	func18d			;
func182:
		CMP	AX,BX			;check reallocation/allocated
		JNZ	func183			;pages.
		JMP	noerr			;same size case.
func183:
		JB	func184			;BX > allocated count?
		MOV	CX,PAGE_MAX		;BX < allocated pages case...
		MOV	SI,AX			;
		MOV	DI,OFFSET log_page	;
func186:
		CMP	WORD PTR [DI],UNMAP	;logical page end?
		JZ	func18d			;
		CMP	[DI],DX			;same handle?
		JNZ	func185			;
		CMP	[DI].handle_page_no1,BX	;reallocation count end?
		JB	func18e			;
		MOV	WORD PTR [DI],NOT_USE	;
		INC	un_alloc_pages		;add unallocate pages
func18e:
		DEC	SI			;
		JZ	func18a			;
func185:
		ADD	DI,SIZE log_page_struct	;
		LOOP	func186			;
func18d:
		XOR	BX,BX			;
		MOV	[BP].bx_save,BX		;
		JMP	err80			;error exit
func18a:
		MOV	SI,OFFSET handle	;
		MOV	AX,SIZE emm_handle_struct;
		MUL	DL			;
		ADD	SI,AX			;
		MOV	[SI].alloc_page_count,BL;set EMM handle used page count
		JMP	noerr			;exit
func184:
		MOV	DI,AX			;BX > allocated pages case...
		SUB	BX,AX			;
		CMP	un_alloc_pages,BX	;request unallocate size over ?
		JNB	func187			;no
		CALL	get_alloc_page		;get page size to handle
		MOV	[BP].bx_save,AX		;
		JMP	err88			;error exit
func187:
		SUB	un_alloc_pages,BX	;unallocated page - BX
		MOV	SI,OFFSET handle	;
		MOV	AX,SIZE emm_handle_struct;
		MUL	DL			;
		ADD	SI,AX			;
		ADD	[SI].alloc_page_count,BL;set EMM handle used page count
		MOV	SI,OFFSET log_page	;
		MOV	CX,BX			;
func188:
		CMP	WORD PTR [SI],UNMAP	;logical page end?
		JZ	func18d			;
		CMP	WORD PTR [SI],NOT_USE	;unallocated page ?
		JZ	func189			;
		ADD	SI,SIZE log_page_struct	;
		JMP	func188			;
func189:
		MOV	[SI],DX			;set EMM handle
		MOV	[SI].handle_page_no1,DI	;set logical page no. (handle)
		INC	DI			;
		ADD	SI,SIZE log_page_struct	;
		LOOP	func188			;
		MOV	BX,[BP].bx_save		;
		JMP	func18a			;

;------ function 19 -------------------------------------------------
; Get/set handle attribute
;--------------------------------------------------------------------
func19:
		STI				;
		CMP	AL,0			;
		JZ	get_handle_attr		;
		CMP	AL,1			;
		JZ	set_handle_attr		;
		CMP	AL,2			;
		JZ	get_attr_cap		;
		JMP	err84			;error exit

;--------------------------------------------------------------------
; Get handle attribute
; input
;	DX	: EMM handle
; output
;	AH	: status
;	AL	: handle attribute
;--------------------------------------------------------------------
get_handle_attr:
		CALL	check_handle		;check handle data
		JNB	get_handle_attr1	;
		JMP	err83			;error exit
get_handle_attr1:
		MOV	AL,VOLATILE		;handle attribute set
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Set handle attribute
; input
;	DX	: EMM handle
;	BL	: new handle attribute
; output
;	AH	: status
;--------------------------------------------------------------------
set_handle_attr:
		CALL	check_handle		;check handle data
		JNB	set_handle_attr2	;
		JMP	err83			;error exit
set_handle_attr2:
		CMP	BL,VOLATILE		;
		JNZ	set_handle_attr1	;
		JMP	noerr			;exit
set_handle_attr1:
		CMP	BL,NON_VOLATILE		;handle attribute check
		JZ	set_handle_attr3	;
		JMP	err90			;error exit
set_handle_attr3:
		JMP	err91			;error exit

;--------------------------------------------------------------------
; Get attribute capability
; output
;	AH	: status
;	AL	: attribute capability
;--------------------------------------------------------------------
get_attr_cap:
                jmp short get_attr_cap1
		CALL	check_handle		;check handle data
		JNB	get_attr_cap1		;
		JMP	err83			;error exit
get_attr_cap1:
		MOV	AL,VOLATILE		;set attribute capability
		JMP	noerr			;exit

;------ function 20 -------------------------------------------------
; Get/set handle name
;--------------------------------------------------------------------
func20:
		CMP	AL,0			;
		JZ	get_handle_name		;
		CMP	AL,1			;
		JZ	set_handle_name		;
		JMP	err84			;error exit

;--------------------------------------------------------------------
; Get handle name
; input
;	DX	: EMM handle
;	ES:DI	: pointer to handle name array
; output
;	AH	: status
;--------------------------------------------------------------------
get_handle_name:
		CALL	check_handle		;check handle data
		JNB	get_handle_name1	;
		JMP	err83			;error exit
get_handle_name1:
		MOV	SI,OFFSET handle.handle_name;
		MOV	AX,SIZE emm_handle_struct;
		MUL	DL			;
		ADD	SI,AX			;
		MOV	DI,[BP].di_save		;
		MOV	CX,HANDLE_NAME_SIZE	;
		REPZ	MOVSB			;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Set handle name
; input
;	DX	: EMM handle
;	DS:SI	: pointer to handle name
; output
;	AH	: status
;--------------------------------------------------------------------
set_handle_name:
		CALL	check_handle		;check handle data
		JNB	set_handle_name1	;
		JMP	err83			;error exit
set_handle_name1:
		PUSH	CS			;
		POP	ES			;
		MOV	DI,OFFSET handle.handle_name;
		MOV	AX,SIZE emm_handle_struct;
		MUL	DL			;
		ADD	DI,AX			;
		MOV	CX,HANDLE_NAME_SIZE	;
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		REPZ	MOVSB			;
		JMP	noerr			;exit

;------ function 21 -------------------------------------------------
; Get handle directory
;--------------------------------------------------------------------
func21:
		CMP	AL,0			;
		JZ	get_handle_dir		;
		CMP	AL,1			;
		JZ	search_for_name		;
		CMP	AL,2			;
		JZ	get_total_handle	;
		JMP	err84			;error exit

;--------------------------------------------------------------------
; Get handle directory
; input
;	ES:DI	: pointer to handle_dir
; output
;	AH	: status
;	AL	: number of entries in the handle_dir array
;--------------------------------------------------------------------
get_handle_dir:
		MOV	CX,MAX_HNDL		;
		MOV	SI,OFFSET handle.handle_name;
		XOR	DX,DX			;
		XOR	BL,BL			;
get_handle_dir1:
		CALL	check_handle		;check handle data
		JB	get_handle_dir2		;
		MOV	AX,DX			;set EMM handle.
		STOSW				;
		PUSH	CX			;set handle name...
		PUSH	SI			;
		MOV	CX,HANDLE_NAME_SIZE	;
		REPZ	MOVSB			;
		POP	SI			;
		POP	CX			;
		INC	BL			;inc handle count.
get_handle_dir2:
		ADD	SI,SIZE emm_handle_struct;
		INC	DX			;
		LOOP	get_handle_dir1		;
		MOV	AL,BL			;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Search for named handle
; input
;	DS:SI	: handle_name
; output
;	AH	: status
;	DX	: EMM handle
;--------------------------------------------------------------------
search_for_name:
		MOV	CX,MAX_HNDL		;
		MOV	DI,OFFSET handle.handle_name;
		PUSH	CS			;
		POP	ES			;
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		XOR	DX,DX			;
search_for_name1:
		ADD	DI,SIZE emm_handle_struct;
		INC	DX			;
		PUSH	CX			;
		PUSH	SI			;
		PUSH	DI			;
		MOV	CX,HANDLE_NAME_SIZE	;
		REPZ	CMPSB			;
		POP	DI			;
		POP	SI			;
		POP	CX			;
		JZ	search_for_name2	;
		LOOP	search_for_name1	;
		JMP	erra0			;error exit
search_for_name2:
		MOV	CX,HANDLE_NAME_SIZE	;
		XOR	AL,AL			;
		REPZ	SCASB			;
		JNZ	search_for_name3	;
		JMP	erra1			;error exit
search_for_name3:
		PUSH	CS			;
		POP	DS			;
		MOV	[BP].dx_save,DX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Get total handle
; output
;	AH	: status
;	BX	: total_handles
;--------------------------------------------------------------------
get_total_handle:
		MOV	BX,MAX_HNDL		;set max handle count.
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;------ function 22 -------------------------------------------------
; Alter page map & jump.
; input
;	AL	: physical page number/segment selector
;	DX	: EMM handle
;	DS:SI	: pointer to map_and_jump structure
; output
;	AH	: status
;--------------------------------------------------------------------
func22:
		STI				;
		MOV	[BP].f23_ax_save,AX	;
		CALL	check_handle		;check handle data.
		JNB	func221			;
		JMP	err83			;error exit
func221:
		PUSH	DS			;copy calling parameters...
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		MOV	CX,SIZE map_and_jump_struct;
		PUSH	CS			;
		POP	ES			;
		MOV	DI,OFFSET map_jump	;
		REPZ	MOVSB			;
		POP	DS			;
		MOV	CL,map_jump.log_phys_map_len;get mapping data length.
		XOR	CH,CH			;
		JCXZ	func222			;
		LES	DI,map_jump.log_phys_map_ptr;get mapping data pointer.
		MOV	AX,[BP].f23_ax_save	;get phys_page_no/seg_selector.
		CMP	AL,0			;
		JZ	func223			;
		JMP	func227			;
func223:
		MOV	BX,ES:[DI].log_page_number1;get logical page no.
		CALL	check_log_page		;check logical page no.
		JNB	func224			;
		JMP	err8a			;error exit
func224:
		MOV	BX,AX			;
		MOV	AX,ES:[DI].phys_page_number1;get physical page no.
		CMP	AX,PHYS_PAGES		;
		JB	func225			;
		JMP	err8b			;error exit
func225:
		CALL	set_phys_page		;set physical page
		JNB	func226			;
		JMP	err81			;error exit
func226:
		ADD	DI,SIZE log_to_phys_map_struct;
		LOOP	func223			;
func222:
		LES	BX,map_jump.target_address1;get target address.
		MOV	AX,ES			;
		MOV	[BP].ret_segment,AX	;set FAR:JUMP segment.
		MOV	[BP].ret_offset,BX	;set FAR:JUMP offset.
		JMP	noerr			;exit
func227:
		CMP	AL,1			;
		JZ	func228			;
		JMP	err8f			;error exit
func228:
		MOV	BX,ES:[DI].log_page_number2;get logical page no.
		CALL	check_log_page		;check logical page no.
		JNB	func229			;
		JMP	err8a			;error exit
func229:
		MOV	BX,AX			;
		MOV	AX,ES:[DI].mappable_seg_addr;get mappable segment.
		CALL	change_seg_page		;change segment -> log_page_no.
		JNB	func22a			;
		JMP	err8b			;error exit
func22a:
		CALL	set_phys_page		;set physical page
		JNB	func22b			;error ?
		JMP	err81			;error exit
func22b:
		ADD	DI,SIZE log_to_seg_map_struct;
		LOOP	func227			;
		JMP	func222			;

;------ function 23 -------------------------------------------------
; Alter page map & call
;--------------------------------------------------------------------
func23:
		STI				;
		CMP	AL,0			;
		JZ	alter_page_map_call	;
		CMP	AL,1			;
		JZ	alter_page_map_call	;
		CMP	AL,2			;
		JZ	get_page_map_stack	;
		JMP	err84			;error exit

;--------------------------------------------------------------------
; Get page map stack space size
; output
;	AH	: status
;	BX	: stack space required
;--------------------------------------------------------------------
get_page_map_stack:
		MOV	BX,RET_SP		;set stack space...
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Alter page map & call
; input
;	AL	: physical page number/segment selector
;	DX	: EMM handle
;	DS:SI	: pointer to map_and_call structure
; output
;	AH	: status
;	AL	: number of entries in the handle_dir array
;--------------------------------------------------------------------
alter_page_map_call:
		MOV	[BP].f23_ax_save,AX	;
		CALL	check_handle		;check handle data
		JNB	alter_page_map_call1	;
		JMP	err83			;error exit
alter_page_map_call1:
		MOV	AX,[BP].ds_save		;
		MOV	DS,AX			;
		MOV	CX,SIZE map_and_call_struct;
		MOV	AX,SS			;
		MOV	ES,AX			;
		LEA	DI,[BP]+SIZE f23_struct	;
		REPZ	MOVSB			;
		LEA	DI,[BP]+SIZE f23_struct	;
		MOV	CL,ES:[DI].new_page_map_len;get new_page_map_len.
		XOR	CH,CH			;
		JCXZ	alter_page_map_call7	;mapping page length = 0?
		LDS	SI,ES:[DI].new_page_map_ptr;get new_page_map_ptr.
		MOV	AX,[BP].f23_ax_save	;
		CMP	AL,0			;
		JZ	alter_page_map_call3	;
		CMP	AL,1			;
		JZ	alter_page_map_call2	;
		JMP	err8f			;error exit
alter_page_map_call2:
		MOV	BX,[SI].log_page_number2;get logical page no.
		CALL	check_log_page		;
		JNB	alter_page_map_calla	;
		JMP	err8a			;error exit
alter_page_map_calla:
		MOV	BX,AX			;
		MOV	AX,[SI].mappable_seg_addr;
		CALL	change_seg_page		;
		JNB	alter_page_map_callb	;
		JMP	err8b			;error exit
alter_page_map_callb:
		CALL	set_phys_page		;set physical page
		JNB	alter_page_map_call8	;error ?
		JMP	err81			;error exit
alter_page_map_call8:
		ADD	SI,SIZE log_to_seg_map_struct;
		LOOP	alter_page_map_call2	;
		JMP	alter_page_map_call7	;
alter_page_map_call3:
		MOV	BX,[SI].log_page_number1;get logical page no.
		CALL	check_log_page		;check logical page no.
		JNB	alter_page_map_call4	;
		JMP	err8a			;error exit
alter_page_map_call4:
		MOV	BX,AX			;
		MOV	AX,[SI].phys_page_number1;get physical page no.
		CMP	AX,PHYS_PAGES		;
		JB	alter_page_map_call5	;
		JMP	err8b			;error exit
alter_page_map_call5:
		CALL	set_phys_page		;set physical page.
		JNB	alter_page_map_call6	;
		JMP	err81			;error exit
alter_page_map_call6:
		ADD	SI,SIZE log_to_phys_map_struct;
		LOOP	alter_page_map_call3	;
alter_page_map_call7:
		MOV	BX,OFFSET alter_page_map_callc;get FAR:CALL return_addr
		MOV	[BP].f23_retoff,BX	;set offset.
		MOV	AX,CS			;
		MOV	[BP].f23_retseg,AX	;set segment.
		MOV	AX,[BP].ret_flag	;get flags.
		MOV	[BP].f23_flag,AX	;set flags.
		LDS	BX,ES:[DI].target_address2;get FAR:CALL target_addr.
		MOV	[BP].f23_off,BX		;set offset.
		MOV	AX,DS			;
		MOV	[BP].f23_seg,AX		;set segment.
		MOV	AH,0			;
		POP	BX			;
		POP	CX			;
		POP	DX			;
		POP	SI			;
		POP	DI			;
		POP	BP			;
		POP	ES			;
		POP	DS			;
		IRET				;FAR:CALL to target
;
;
alter_page_map_callc:
                sub sp,10                       ; because we delete f23_struct
                                                ; - f23_axsave
		PUSH	DS			;PUSH registers...
		PUSH	ES			;
		PUSH	BP			;
		PUSH	DI			;
		PUSH	SI			;
		PUSH	DX			;
		PUSH	CX			;
		PUSH	BX			;
		MOV	BP,SP			;
		PUSHF				;push flags.
		POP	AX			;pop flags.
		MOV	[BP].ret_flag,AX	;set return_flags.
		MOV	AX,SS			;
		MOV	ES,AX			;
		LEA	DI,[BP]+SIZE f23_struct	;
		LDS	SI,ES:[DI].old_page_map_ptr;get old_page_map_ptr.
		MOV	CL,ES:[DI].old_page_map_len;get old_page_map_len.
		XOR	CH,CH			;
		JCXZ	alter_page_map_calld	;mapping page length = 0?
		MOV	AX,[BP].f23_ax_save	;
		CMP	AL,0			;
		JZ	alter_page_map_callf	;
		CMP	AL,1			;
		JZ	alter_page_map_callg	;
		JMP	err8f			;error exit
alter_page_map_callg:
		MOV	BX,[SI].log_page_number2;get logical page no.
		CALL	check_log_page		;
		JNB	alter_page_map_callh	;
		JMP	err8a			;error exit
alter_page_map_callh:
		MOV	BX,AX			;
		MOV	AX,[SI].mappable_seg_addr;
		CALL	change_seg_page		;
		JNB	alter_page_map_calli	;
		JMP	err8b			;error exit
alter_page_map_calli:
		CALL	set_phys_page		;set physical page
		JNB	alter_page_map_callj	;error ?
		JMP	err81			;error exit
alter_page_map_callj:
		ADD	SI,SIZE log_to_seg_map_struct;
		LOOP	alter_page_map_callg	;
		JMP	alter_page_map_calld	;
alter_page_map_callf:
		MOV	BX,[SI].log_page_number1;get logical page no.
		CALL	check_log_page		;check logical page no.
		JNB	alter_page_map_calll	;
		JMP	err8a			;error exit
alter_page_map_calll:
		MOV	BX,AX			;
		MOV	AX,[SI].phys_page_number1;get physical page no.
		CMP	AX,PHYS_PAGES		;
		JB	alter_page_map_callm	;
		JMP	err8b			;error exit
alter_page_map_callm:
		CALL	set_phys_page		;set physical page.
		JNB	alter_page_map_calln	;
		JMP	err81			;error exit
alter_page_map_calln:
		ADD	SI,SIZE log_to_phys_map_struct;
		LOOP	alter_page_map_callf	;
alter_page_map_calld:
		JMP	noerr			;exit

;------ function 24 -------------------------------------------------
; Move/exchange memory region
; input
;	AL	: move/xchg select data (00 = move,01 = xchg)
;	DS:SI	: pointer to move/xchg_source_dest structure
; output
;	AH	: status
;--------------------------------------------------------------------
func24:
		CMP	AL,0			;
		JZ	f2400			;
		CMP	AL,1			;
		JZ	f2400			;
		JMP	err84			;error exit
f2400:
		MOV	[BP].f24_ax_save,AX	;
		MOV	AX,[BP].ds_save		;get calling parameters...
		MOV	DS,AX			;
		MOV	AX,[SI].source_initial_offset1;get source offset.
		MOV	[BP].source_off,AX	;
		XOR	AH,AH			;
		MOV	AL,[SI].source_memory_type1;get source memory type.
		MOV	[BP].source_type,AX	;
		CMP	AX,0			;conventional?
		JZ	f2401			;
		MOV	AX,[SI].source_handle1	;get source handle.
		MOV	[BP].source_handle,AX;
		MOV	AX,[SI].source_initial_seg_page1;get source page no.
		MOV	[BP].source_pno,AX	;
		MOV	AX,CS:page_frame_seg	;
		MOV	[BP].source_seg,AX	;
		JMP	f2402			;
f2401:
		MOV	AX,[SI].source_initial_seg_page1;get source segment.
		MOV	[BP].source_seg,AX	;
f2402:
		MOV	AX,[SI].dest_initial_offset1;get dest offset.
		MOV	[BP].dest_off,AX	;
		XOR	AH,AH			;
		MOV	AL,[SI].dest_memory_type1;get dest memory type.
		MOV	[BP].dest_type,AX	;
		CMP	AX,0			;conventional?
		JZ	f2403			;
		MOV	AX,[SI].dest_handle1	;get dest handle.
		MOV	[BP].dest_handle,AX;
		MOV	AX,[SI].dest_initial_seg_page1;get dest page no.
		MOV	[BP].dest_pno,AX	;
		MOV	AX,CS:page_frame_seg	;
		ADD	AX,400H			;
		MOV	[BP].dest_seg,AX	;
		JMP	f2404			;
f2403:
		MOV	AX,[SI].dest_initial_seg_page1;get dest segment.
		MOV	[BP].dest_seg,AX	;
f2404:
		LES	DI,[SI].region_length1	;get region length...
		MOV	[BP].region_low,DI	;
		MOV	AX,ES			;
		MOV	[BP].region_high,AX	;
		CMP	AX,10H			;check region size...
		JB	f2405			;
		JZ	f2406			;
f2407:
		JMP	err96			;error exit
f2406:
                MOV     AX,DI                   ; was es
		OR	AX,AX			;
		JNZ	f2407			;
f2405:
		CMP	[BP].source_type,0	;check source data...
                jz tmp_001
                Jmp     f2408                   ;
tmp_001 :       XOR     DX,DX                   ;
		MOV	AX,[BP].source_seg	;conventional case...
		MOV	BX,10H			;
		MUL	BX			;
		ADD	AX,[BP].source_off	;
		ADC	DX,0			;
		CMP	DX,10H			;check source address...
		JB	f2409			;
;                debug_mac 0fffeh
		JMP	erra2			;error exit
f2409:
		ADD	DX,[BP].region_high	;add region length...
		ADD	AX,[BP].region_low	;
		ADC	DX,0			;
		CMP	DX,10H			;check address...
                JB      f2412                   ;
                jz f2410
f2411:
;                debug_mac 0fffdh
                JMP     erra2                   ;error exit    !!!!!
f2410:
                OR      AX,AX                   ;
                JNZ     f2411                   ;
		JMP	f2412			;
f2408:
		MOV	DX,[BP].source_handle	;
		CALL	check_handle		;check handle data.
		JNB	f2413			;
		JMP	err83			;error exit
f2413:
		MOV	BX,[BP].source_pno	;
		CALL	check_log_page		;
		JNB	f2414			;
		JMP	err8a			;error exit
f2414:
		MOV	DI,DX			;
		MOV	AX,[BP].source_off	;
		CMP	AX,4000H		;
		JB	f2415			;
		JMP	err95			;error exit
f2415:
		MOV	DX,[BP].region_high	;
		ADD	AX,[BP].region_low	;
		ADC	DX,0			;
		MOV	CX,4000H		;
		DIV	CX			;
                CMP     dX,0                    ;    was  cmp ax,0
		JZ	f2416			;
                INC     aX                      ;         inc dx
f2416:
                ADD     BX,aX                   ;         add bx,dx
                dec     bx
		MOV	DX,DI			;
		CALL	check_log_page		;
		JNB	f2412			;
;                debug_mac 0ffaah
		JMP	err93			;error exit
f2412:
		MOV	AX,[BP].dest_type	;check dest data...
		CMP	AL,0			;conventional?
		JNZ	f2417			;
		XOR	DX,DX			;conventional memory case...
		MOV	AX,[BP].dest_seg	;
		MOV	BX,10H			;
		MUL	BX			;
		ADD	AX,[BP].dest_off	;
		ADC	DX,0			;
		CMP	DX,10H			;check dest address...
		JB	f2418			;
;               debug_mac 0fffch
		JMP	erra2			;error exit
f2418:
		ADD	DX,[BP].region_high	;add region length...
		ADD	AX,[BP].region_low	;
		ADC	DX,0			;
		CMP	DX,10H			;check address...
                JB      f2421                   ;
                jz f2419
f2420:
;                debug_mac 0fffbh
		JMP	erra2			;error exit
f2419:
                OR      AX,AX                   ;
                JNZ     f2420                   ;
		JMP	f2421			;
f2417:
		MOV	DX,[BP].dest_handle	;expanded memory case...
		CALL	check_handle		;check handle data.
		JNB	f2422			;
		JMP	err83			;error exit
f2422:
		MOV	BX,[BP].dest_pno	;
		CALL	check_log_page		;check logical page no.
		JNB	f2423			;
		JMP	err8a			;error exit
f2423:
		MOV	DI,DX			;
		MOV	AX,[BP].dest_off	;
		CMP	AX,4000H		;
		JB	f2424			;
		JMP	err95			;error exit
f2424:
		MOV	DX,[BP].region_high	;
		ADD	AX,[BP].region_low	;
		ADC	DX,0			;
		MOV	CX,4000H		;
		DIV	CX			;
                CMP     dX,0                    ;   was cmp ax,0
		JZ	f2425			;
                INC     aX                      ;       inc dx
f2425:
                ADD     BX,aX                   ;       add bx,dx
                dec     bx
		MOV	DX,DI			;
		CALL	check_log_page		;
		JNB	f2421			;
;                debug_mac 0ffbbh
		JMP	err93			;error exit
f2421:
		MOV	[BP].overlap_flag,0	;
		MOV	[BP].get_source_f,0	;
		MOV	[BP].get_dest_f,0	;
                mov     [bp].forward,1
		MOV	AX,[BP].source_type	;check data overlap...
		CMP	AX,[BP].dest_type	;source and dest same type?
		JZ	f2435			;
		CMP	AX,0			;conventional memory?
		JZ	f2436			;
		MOV	[BP].get_source_f,1	;
		JMP	f2426			;
f2436:
		MOV	[BP].get_dest_f,1	;
		JMP	f2426			;
f2435:
		CMP	AX,0			;conventional memory?
		JZ	f2427			;
		MOV	AX,[BP].source_handle	;expanded memory case...
		CMP	AX,[BP].dest_handle	;
		JNZ	f2426			;
		MOV	AX,[BP].source_pno	;
		MOV	BX,4000H		;
		MUL	BX			;
		ADD	AX,[BP].source_off	;
		ADC	DX,0			;
		MOV	SI,AX			;
		MOV	CX,DX			;
		MOV	AX,[BP].dest_pno	;
		MOV	BX,4000H		;
		MUL	BX			;
		ADD	AX,[BP].dest_off	;
		ADC	DX,0			;
		MOV	DI,AX			;
		MOV	[BP].get_source_f,1	;
		MOV	[BP].get_dest_f,1	;
		JMP	f2428			;
f2427:
                MOV     aX,[BP].source_seg      ;
                mov     bx,10h
                mul     bx
                add     ax,[BP].source_off      ;conventional memory case...
                adc     dx,0
                mov     si,ax
                mov     cx,dx
                MOV     ax,[BP].dest_seg        ;
                mul     bx
                add     aX,[BP].dest_off        ;
                adc     dx,0
                mov     di,ax
f2428:
                mov     [bp].forward,0
		CMP	DX,CX			;CX:SI = source
		JB	f2429			;DX:DI = dest
		JNZ	f2430			;
		CMP	DI,SI			;
                Jae      f2430                  ; was jb
f2429:
                mov     [bp].forward,1
		XCHG	SI,DI			;
		XCHG	CX,DX			;
f2430:
		SUB	DI,SI			;DX:DI - CX:SI...
		SBB	DX,CX			;
		SUB	DI,[BP].region_low	;
		SBB	DX,[BP].region_high	;
		JNB	f2426			;ok
f2431:
		MOV	AX,[BP].f24_ax_save	;get AX
		CMP	AL,0			;
		JZ	f2432			;
		JMP	err97			;error exit
f2432:
		MOV	[BP].overlap_flag,1	;
f2426:
                call    save_context
                                                ; set initial address
                cmp     [bp].overlap_flag,1
                jne     f24261
                cmp     [bp].forward,1
                jne     f24264
f24261:         CALL    get_source              ;
                CALL    get_dest                ;
                jmp     f24462
f24264:         cmp     [bp].source_type,0
                jne     f24463
                                                ; conventional case
                MOV     AX,[BP].source_seg      ; source last address
		MOV	BX,10H			;
		MUL	BX			;
		ADD	AX,[BP].source_off	;
		ADC	DX,0			;
                ADD     DX,[BP].region_high     ; add region length...
		ADD	AX,[BP].region_low	;
		ADC	DX,0			;
                dec     ax
                mov     cl,12
                shl     dx,cl
                mov     ds,dx
                mov     si,ax
                                                ;
                MOV     AX,[BP].dest_seg        ; dest last address
		MOV	BX,10H			;
		MUL	BX			;
                ADD     AX,[BP].dest_off        ;
		ADC	DX,0			;
                ADD     DX,[BP].region_high     ; add region length...
		ADD	AX,[BP].region_low	;
		ADC	DX,0			;
                dec     ax
                mov     cl,12
                shl     dx,cl
                mov     es,dx
                mov     di,ax
                jmp     short f24462

f24463:         mov     ax,[bp].dest_off
                mov     dx,[bp].region_high
                add     ax,[bp].region_low
                adc     dx,0
                sub     ax,1
                sbb     dx,0
                mov     cx,4000h
                div     cx
                add     [bp].dest_pno,ax
                mov     [bp].dest_pno,ax
                mov     [bp].dest_off,dx

                mov     ax,[bp].source_off
                mov     dx,[bp].region_high
                add     ax,[bp].region_low
                adc     dx,0
                sub     ax,1
                sbb     dx,0
                mov     cx,4000h
                div     cx
                add     [bp].source_pno,ax
                mov     [bp].source_pno,ax
                mov     [bp].source_off,dx

f24462:
		CLI				;move/xchg memory...
f2449:
		CMP	[BP].get_source_f,1	;
                JNZ     f2433                   ;
		CALL	get_source		;
		JNB	f2433			;
f2434:
                call    restore_context
		JMP	err80			;error exit
f2433:
		CMP	[BP].get_dest_f,1	;
                JNZ     f2445                   ;
		CALL	get_dest		;
		JB	f2434			;
f2445:
		MOV	AX,[BP].source_type	;
		CMP	AX,[BP].dest_type	;
		JNZ	f2437			;
		CMP	AL,0			;
		JNZ	f2438			;
		MOV	DX,[BP].region_high	;conventional
		MOV	CX,[BP].region_low	;
		JMP	f2440			;
f2437:
		XOR	DX,DX			;expanded/conventional
		MOV	CX,4000H		;
		CMP	AL,0			;
		JNZ	f2439			;
		MOV	[BP].get_dest_f,1	;
		SUB	CX,DI			;
		JMP	f2440			;
f2439:
		MOV	[BP].get_source_f,1	;
		SUB	CX,SI			;
		JMP	f2440
f2438:
                xor     dx,dx
                cmp     [bp].forward,1
                jne     f24381
                MOV     cX,4000H                ;expanded
                MOV     AX,cX                   ;
                SUB     cX,DI                   ;
		SUB	AX,SI			;
                jmp     short f24382
f24381:         mov     cx,di
                mov     ax,si
f24382:         MOV     [BP].get_dest_f,1       ;
                mov     [bp].get_source_f,0
                CMP     AX,cX                   ;
                Ja      f2440                   ;
                jb      f24401
                mov     [bp].get_source_f,1
                jmp     short f2440
f24401:         MOV     CX,AX                   ;
		MOV	[BP].get_source_f,1	;
		MOV	[BP].get_dest_f,0	;
f2440:
		CMP	DX,0			;
		JNZ	f2441			;
;                JCXZ    f2448                   ;
                cmp     cx,0
                jne     f2441
                jmp     f2448
f2441:
		MOV	AX,[BP].f24_ax_save	;
		CMP	AL,0			;
		JNZ	f2443			;
		MOV	AL,[SI]			;
		MOV	ES:[DI],AL		;
		JMP	f2444			;
f2443:
		MOV	AL,[SI]			;
		XCHG	AL,ES:[DI]		;
		MOV	[SI],AL			;
f2444:
                cmp     [bp].overlap_flag,1
                jne     f24440
                cmp     [bp].forward,1
                jne     f24443
f24440:         MOV     AX,DS                   ;DS:SI + 1...
		ADD	SI,1			;
                jnc     f24441
                add     ax,1000h

f24441:         MOV     DS,AX                   ;
		MOV	AX,ES			;ES:DI + 1...
		ADD	DI,1			;
                jnc     f24442
                add     ax,1000h
f24443:
                MOV     AX,DS                   ;DS:SI - 1...
                sub     SI,1                    ;
                jnc     f24444
                sub     ax,1000h

f24444:         MOV     DS,AX                   ;
                MOV     AX,ES                   ;ES:DI - 1...
                sub     DI,1                    ;
                jnc     f24442
                sub     ax,1000h

f24442:         MOV     ES,AX                   ;
		MOV	AX,[BP].region_low	;region_low - 1...
		SUB	AX,1			;
		MOV	[BP].region_low,AX	;
		MOV	AX,[BP].region_high	;region_high - 1...
		SBB	AX,0			;
		MOV	[BP].region_high,AX	;
		OR	AX,[BP].region_low	;
		JZ	f2448			;
		SUB	CX,1			;DX:CX - 1...
		SBB	DX,0			;
		MOV	AX,CX			;
		OR	AX,DX			;
		JNZ	f2441			;
		CMP	[BP].get_source_f,1	;
		JNZ	f2446			;
                cmp     [bp].forward,1
                jne     f24461
                INC     [BP].source_pno         ; source next pno
		MOV	[BP].source_off,0	;
                jmp     short f2446
f24461:         DEC     [bp].source_pno         ; source prev pno
                mov     [bp].source_off,3fffh
f2446:
		CMP	[BP].get_dest_f,1	;
		JNZ	f2447			;
                cmp     [bp].forward,1
                jne     f24471
                INC     [BP].dest_pno           ; dest next pno
                MOV     [BP].dest_off,0         ;
                jmp     short f2447
f24471:         dec     [bp].dest_pno           ; dest prev pno
                mov     [bp].dest_off,3fffh
f2447:
		JMP	f2449			;
f2448:
		CMP	[BP].overlap_flag,1	;overlap flag on?
		JNZ	f2450			;
                call    restore_context
		JMP	err92			;error exit
f2450:
                call    restore_context
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Get mappable physical address array
; output
;	DS:SI	: source data address
;--------------------------------------------------------------------
get_source:
		CLC				;
		MOV	AX,[BP].source_type	;
		CMP	AL,0			;
		JZ	get_source2		;
		MOV	DX,[BP].source_handle	;
		MOV	BX,[BP].source_pno	;
		CALL	check_log_page		;
		JB	get_source1		;
		MOV	BX,AX			;
		MOV	AL,0			;set physical page no.
		CALL	set_phys_page		;
		JB	get_source1		;
get_source2:
		MOV	SI,[BP].source_off	;set offset address.
		MOV	AX,[BP].source_seg	;set segment address..
		MOV	DS,AX			;
get_source1:
		RET

;--------------------------------------------------------------------
; Get mappable physical address array
; output
;	ES:DI	: source data address
;--------------------------------------------------------------------
get_dest:
		CLC				;
		MOV	AX,[BP].dest_type	;
		CMP	AL,0			;
		JZ	get_dest2		;
		MOV	DX,[BP].dest_handle	;
		MOV	BX,[BP].dest_pno	;
		CALL	check_log_page		;
		JB	get_dest1		;
		MOV	BX,AX			;
		MOV	AL,1			;set physical page no.
		CALL	set_phys_page		;
		JB	get_dest1		;
get_dest2:
		MOV	DI,[BP].dest_off	;set offset address.
		MOV	AX,[BP].dest_seg	;set segment address..
		MOV	ES,AX			;
get_dest1:
		RET				;

;--------------------------------------------------------------------
;  save page map context
;---------------------------------------------------------------------
save_context    proc near
                push ds
                push es
                push cx
                push si
                push di

                push cs
                pop ds
                push ss
                pop es

		MOV	SI,OFFSET map_table	;
                lea     DI,[bp].save_map_data   ;
		MOV	CX,CONTEXT_SIZE		;
		REPZ	MOVSB			;

                pop di
                pop si
                pop cx
                pop es
                pop ds
                ret
save_context    endp

;--------------------------------------------------------------------
;  restore page map context
;---------------------------------------------------------------------
restore_context proc near
                push ds
                push es
                push ax
                push cx
                push si
                push di

                push cs
                pop es
                push ss
                pop ds

                lea     si, [bp].save_map_data
		MOV	DI,OFFSET map_table	;disable physical pages...
		MOV	CX,PHYS_PAGES		;
r1:
		MOV	DX,[DI].phys_page_port	;
		MOV	AL,DIS_EMS		;
		CALL	emsout			;
		ADD	DI,SIZE phys_page_struct;
                LOOP    r1                      ;
		MOV	CX,CONTEXT_SIZE		;move mapping data...
		MOV	DI,OFFSET map_table	;
		PUSH	DI			;
		REPZ	MOVSB			;
		POP	DI			;
		CALL	set_pages_map		;enable physical pages...

                pop di
                pop si
                pop cx
                pop ax
                pop es
                pop ds
                ret
restore_context endp

;------ function 25 -------------------------------------------------
; Get mappable physical address array
;--------------------------------------------------------------------
func25:
		STI				;
		CMP	AL,0			;
		JZ	get_map_phys_addr	;
		CMP	AL,1			;
		JZ	get_map_phys_ent	;
		JMP	err84			;error exit

;--------------------------------------------------------------------
; Get mappable physical address array
; input
;	ES:DI	: mappable_phys_page
; output
;	AH	: status
;	CX	: number of entries in the mappable_phys_page
;--------------------------------------------------------------------
get_map_phys_addr:
		MOV	AX,[BP].es_save		;
		MOV	ES,AX			;
		MOV	CX,PHYS_PAGES		;
		MOV	SI,OFFSET map_table	;
		XOR	DX,DX			;
get_map_phys_addr1:
		MOV	AX,[SI].phys_seg_addr	;
		STOSW				;
		MOV	AX,DX			;
		STOSW				;
		INC	DX			;
		ADD	SI,SIZE phys_page_struct;
		LOOP	get_map_phys_addr1	;
get_map_phys_addr2:
		MOV	CX,PHYS_PAGES		;
		MOV	[BP].cx_save,CX		;set segment addr entrie
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Get mappable physcal address array entries
; output
;	AH	: status
;	CX	: number of entries in the mappable_phys_page
;--------------------------------------------------------------------
get_map_phys_ent:
		JMP	get_map_phys_addr2	;

;------ function 26 -------------------------------------------------
; Get expanded memory hardware infomation
;--------------------------------------------------------------------
func26:
		STI				;
		CMP	AL,0			;
		JZ	get_hardware_config	;
		CMP	AL,1			;
		JZ	get_unalloc_raw_page	;
		JMP	err84			;error exit

;--------------------------------------------------------------------
; Get hardware configration array
; input
;	ES:DI	: hardware_info
; output
;	AH	: status
;--------------------------------------------------------------------
get_hardware_config:
		CMP	OSE_flag,0		;OS/E flag enable?
		JZ	get_hardware_config1	;
		JMP	erra4			;error exit
get_hardware_config1:
		MOV	AX,[BP].es_save		;
		MOV	ES,AX			;
		MOV	AX,RAW_PAGES		;
		STOSW				;
		MOV	AX,ALTER_REGS		;
		STOSW				;
		MOV	AX,CONTEXT_SIZE		;
		STOSW				;
		MOV	AX,DMA_REGS		;
		STOSW				;
		MOV	AX,DMA_CHANNEL		;
		STOSW				;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Get unallocated raw page count
; output
;	AH	: status
;	BX	: unallocated raw pages
;	DX	: total raw pages
;--------------------------------------------------------------------
get_unalloc_raw_page:
		MOV	SI,OFFSET log_page	;
		XOR	BX,BX			;
		MOV	DX,BX			;
		MOV	CX,PAGE_MAX		;
get_unalloc_raw_page3:
		CMP	WORD PTR [SI],UNMAP	;logical page end ?
		JZ	get_unalloc_raw_page1	;
		INC	DX			;
		CMP	WORD PTR [SI],NOT_USE	;unallocated page ?
		JNZ	get_unalloc_raw_page2	;
		INC	BX			;
get_unalloc_raw_page2:
		ADD	SI,SIZE log_page_struct	;
		LOOP	get_unalloc_raw_page3	;
get_unalloc_raw_page1:
		MOV	total_pages,DX		;Save total page count
		MOV	un_alloc_pages,BX	;Save unallocate page count
		MOV	[BP].dx_save,DX		;Save all page count
		MOV	[BP].bx_save,BX		;Save unallocate page count
		JMP	noerr			;exit

;------ function 27 -------------------------------------------------
; Allocate raw pages
; input
;	BX	: num_of_raw_pages_to_alloc
; output
;	AH	: status
;	DX	: raw handle
;--------------------------------------------------------------------
func27:
		JMP	f41			;goto function 4

;------ function 28 -------------------------------------------------
; Alternate map register set
;--------------------------------------------------------------------
func28:
		STI				;
		CMP	OSE_flag,0		;OS/E flag enable?
		JZ	func280			;
		JMP	erra4			;error exit
func280:
		CMP	AL,0			;
		JNZ	func281			;
		JMP	get_alter_map_reg	;
func281:
		CMP	AL,1			;
		JNZ	func282			;
		JMP	set_alter_map_reg	;
func282:
		CMP	AL,2			;
		JNZ	func283			;
		JMP	get_alter_map_size	;
func283:
		CMP	AL,3			;
		JNZ	func284			;
		JMP	alloc_alter_map_reg	;
func284:
		CMP	AL,4			;
		JNZ	func285			;
		JMP	dealloc_alter_map_reg	;
func285:
		CMP	AL,5			;
		JNZ	func286			;
		JMP	alloc_DMA_reg		;
func286:
		CMP	AL,6			;
		JNZ	func287			;
		JMP	enable_DMA_alter_reg	;
func287:
		CMP	AL,7			;
		JNZ	func288			;
		JMP	disable_DMA_alter_reg	;
func288:
		CMP	AL,8			;
		JNZ	func289			;
		JMP	dealloc_DMA_reg		;
func289:
		JMP	err84			;error exit

;--------------------------------------------------------------------
; Get alternate map register set
; output
;	AH	: status
;	BL	: current active alternate map register set number
;	ES:DI	: pointer to a map register context save area
;--------------------------------------------------------------------
get_alter_map_reg:
		MOV	DI,CS:alter_map_off	;
		MOV	AX,CS:alter_map_seg	;
		MOV	ES,AX			;
		OR	AX,DI			;
		JNZ	get_alter_map_reg1	;
		JMP	get_alter_map_reg2	;
get_alter_map_reg1:
		MOV	SI,OFFSET map_table	;
		PUSH	CS			;
		POP	DS			;
		MOV	CX,CONTEXT_SIZE		;
		REPZ	MOVSB			;
get_alter_map_reg2:
		MOV	DI,CS:alter_map_off	;
		MOV	AX,CS:alter_map_seg	;
		MOV	[BP].di_save,DI		;
		MOV	[BP].es_save,AX		;
		MOV	BX,[BP].bx_save		;
		MOV	BL,0			;
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Get hardware configration array
; input
;	BL	: new alternate map register set number
;	ES:DI	: pointer to a map register context restore area
; output
;	AH	: status
;--------------------------------------------------------------------
set_alter_map_reg:
		CLI				;
		CMP	BL,0			;
		JZ	set_alter_map_reg1	;
		JMP	err9c			;error exit
set_alter_map_reg1:
		MOV	CS:alter_map_off,DI	;
		MOV	AX,ES			;
		MOV	CS:alter_map_seg,AX	;
		OR	AX,DI			;
		JNZ	set_alter_map_reg2	;
		JMP	noerr			;exit
set_alter_map_reg2:
		MOV	AX,ES			;
		MOV	DS,AX			;
		MOV	SI,DI			;
		MOV	CX,CONTEXT_SIZE		;
		MOV	AX,SS			;
		MOV	ES,AX			;
		LEA	DI,[BP]+PUSH_REG	;
		REPZ	MOVSB			;
		LEA	DI,[BP]+PUSH_REG	;
		CALL	check_map_data		;
		JNB	set_alter_map_reg3	;
		JMP	erra3			;error exit
set_alter_map_reg3:
		MOV	SI,DI			;
		MOV	AX,ES			;
		MOV	DS,AX			;
		MOV	CX,CONTEXT_SIZE		;
		MOV	DI,OFFSET map_table	;
		PUSH	CS			;
		POP	ES			;
		PUSH	DI			;
		REPZ	MOVSB			;
		POP	DI			;
		MOV	CX,PHYS_PAGES		;
set_alter_map_reg5:
		MOV	DX,CS:[DI].phys_page_port;mapping physical pages...
		MOV	AL,CS:[DI].log_page_data;
		CALL	emsout			;
		JNB	set_alter_map_reg4	;
		JMP	err81			;error exit
set_alter_map_reg4:
		ADD	DI,SIZE phys_page_struct;
		LOOP	set_alter_map_reg5	;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Get alternate map save array size
; output
;	AH	: status
;	DX	: size_of_array
;--------------------------------------------------------------------
get_alter_map_size:
		MOV	DX,CONTEXT_SIZE		;
		MOV	[BP].dx_save,DX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Allocate alternate map register set
; output
;	AH	: status
;	BL	: alternate map register set number
;--------------------------------------------------------------------
alloc_alter_map_reg:
		MOV	BL,0			;
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Deallocate alternate map register set
; input
;	BL	: alternate map register set number
; output
;	AH	: status
;--------------------------------------------------------------------
dealloc_alter_map_reg:
		CMP	BL,0			;
		JZ	dealloc_alter_map_reg1	;
		JMP	err9c			;error exit
dealloc_alter_map_reg1:
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Allocate DMA register set
; output
;	AH	: status
;	BL	: DMA register set number
;--------------------------------------------------------------------
alloc_DMA_reg:
		MOV	BL,0			;
		MOV	[BP].bx_save,BX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Enable DMA on alternate map register set
; input
;	BL	: DMA register set number
;	DL	: DMA channel number
; output
;	AH	: status
;--------------------------------------------------------------------
enable_DMA_alter_reg:
		CMP	BL,0			;
		JZ	enable_DMA_alter_reg1	;
		JMP	err9c			;error exit
enable_DMA_alter_reg1:
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Disable DMA on alternate map register set
; input
;	BL	: alternate register set number
; output
;	AH	: status
;--------------------------------------------------------------------
disable_DMA_alter_reg:
		CMP	BL,0			;
		JZ	disable_DMA_alter_reg1	;
		JMP	err9c			;error exit
disable_DMA_alter_reg1:
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Deallocate DMA register set
; output
;	AH	: status
;	BL	: DMA register set number
;--------------------------------------------------------------------
dealloc_DMA_reg:
		CMP	BL,0			;
		JZ	dealloc_DMA_reg1	;
		JMP	err9c			;error exit
dealloc_DMA_reg1:
		JMP	noerr			;exit

;------ function 29 -------------------------------------------------
; Prepare expanded memory hardware for warm boot
;--------------------------------------------------------------------
func29:
		MOV	AX,CS			;
		MOV	ES,AX			;
		MOV	DS,AX			;
		MOV	DI,OFFSET map_table	;disable physical pages...
		MOV	CX,PHYS_PAGES		;
f291:
		MOV	[DI].emm_handle2,UNMAP	;
		MOV	[DI].log_page_data,0	;
		ADD	DI,SIZE phys_page_struct;
		LOOP	f291			;
		CALL	set_pages_map		;
		JNB	f292			;
		JMP	err81			;error exit
f292:
		MOV	DI,OFFSET backup_map	;clear backup map data
		MOV	CX,BACK_MAX		;
f293:
		MOV	WORD PTR [DI],UNMAP	;
		ADD	DI,BACK_SIZE		;
		LOOP	f293			;
		MOV	DI,OFFSET handle	;clear handles...
		ADD	DI,SIZE emm_handle_struct;
		MOV	CX,MAX_HNDL - 1		;
		XOR	AX,AX			;
f294:
		PUSH	CX			;
		MOV	CX,SIZE emm_handle_struct;
		REPZ	STOSB			;
		POP	CX			;
		LOOP	f294			;
		MOV	DI,OFFSET log_page	;unallocate all logical pages...
		MOV	AX,NOT_USE		;
		MOV	CX,PAGE_MAX		;
f295:
		CMP	WORD PTR [DI],UNMAP	;
		JZ	f296			;
		MOV	[DI],AX			;
		ADD	DI,SIZE log_page_struct	;
		LOOP	f295			;
f296:
		XOR	AX,AX			;
		MOV	handle_count,1		;set active handle count
		MOV	backup_count,AL		;set backup map count
		MOV	AX,total_pages		;
		MOV	un_alloc_pages,AX	;set unallocate page count
		JMP	noerr			;exit

;------ function 30 -------------------------------------------------
; Enable/disable OS/E function set functions
; input
;	BX,CX	: alternate register set number
; output
;	AH	: status
;	BX,CX	: alternate register set number
;--------------------------------------------------------------------
func30:
		STI				;
		CMP	AL,0			;
		JZ	enable_OSE_func		;
		CMP	AL,1			;
		JZ	disable_OSE_func	;
		CMP	AL,2			;
		JZ	return_access_key	;
		JMP	err84			;error exit

;--------------------------------------------------------------------
; Enable OS/E function set
; input
;	BX,CX	: access_key
; output
;	AH	: status
;	BX,CX	: access_key
;--------------------------------------------------------------------
enable_OSE_func:
		CMP	OSE_fast,0		;OS/E fast access flag enable?
		JZ	enable_OSE_func1	;
		CMP	access_key_h,BX		;compare access key high
		JNZ	enable_OSE_func2	;
		CMP	access_key_l,CX		;compare access key low
		JZ	enable_OSE_func1	;
enable_OSE_func2:
		JMP	erra4			;error exit
enable_OSE_func1:
		MOV	OSE_flag,0		;enable OS/E function
		MOV	OSE_fast,0FFFFH		;set OS/E fast access flag
		MOV	BX,access_key_h		;
		MOV	[BP].bx_save,BX		;
		MOV	CX,access_key_l		;
		MOV	[BP].cx_save,CX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Disable OS/E function set
; input
;	BX,CX	: access_key
; output
;	AH	: status
;	BX,CX	: access_key
;--------------------------------------------------------------------
disable_OSE_func:
		CMP	OSE_fast,0		;OS/E fast access flag enable?
		JZ	disable_OSE_func1	;
		CMP	access_key_h,BX		;compare access key high
		JNZ	disable_OSE_func2	;
		CMP	access_key_l,CX		;compare access key low
		JZ	disable_OSE_func1	;
disable_OSE_func2:
		JMP	erra4			;error exit
disable_OSE_func1:
		MOV	OSE_flag,0FFFFH		;disable OS/E function
		MOV	OSE_fast,0FFFFH		;set OS/E fast access flag
		MOV	BX,access_key_h		;
		MOV	[BP].bx_save,BX		;
		MOV	CX,access_key_l		;
		MOV	[BP].cx_save,CX		;
		JMP	noerr			;exit

;--------------------------------------------------------------------
; Return access key
; input
;	BX,CX	: access_key
; output
;	AH	: status
;--------------------------------------------------------------------
return_access_key:
		CMP	OSE_flag,0		;OS/E flag enable?
		JNZ	return_access_key2	;
		CMP	access_key_h,BX		;compare access key high
		JNZ	return_access_key2	;
		CMP	access_key_l,CX		;compare access key low
		JZ	return_access_key1	;
return_access_key2:
		JMP	erra4			;error exit
return_access_key1:
		MOV	OSE_flag,0		;enable OS/E function
		MOV	OSE_fast,0		;reset OS/E fast access flag
		XOR	AX,AX			;
		MOV	ES,AX			;
		MOV	SI,46CH			;
		MOV	AX,ES:[SI]		;
		ADD	BX,AX			;make access key...
		MOV	access_key_h,BX		;
		MOV	SI,46EH			;
		ADC	AX,ES:[SI]		;
		ADD	CX,AX			;
		MOV	access_key_l,CX		;
		JMP	noerr			;exit

;========================================================================

;--------------------------------------------------------------------
; Check mapping data.
; input
;	ES:DI	: pointer to mapping data
; output
;	CF = 0	: OK
;	CF = 1	: NG
;--------------------------------------------------------------------
check_map_data	PROC	NEAR
		PUSH	AX			;
		PUSH	CX			;
		PUSH	SI			;
		PUSH	DI			;
		MOV	SI,OFFSET map_table	;
		MOV	CX,PHYS_PAGES		;
check_map_data3:
		MOV	AX,ES:[DI].phys_page_port;
		CMP	AX,CS:[SI].phys_page_port;
		JNZ	check_map_data1		;
		MOV	AX,ES:[DI].phys_seg_addr;
		CMP	AX,CS:[SI].phys_seg_addr;
		JNZ	check_map_data1		;
		ADD	SI,SIZE phys_page_struct;
		ADD	DI,SIZE phys_page_struct;
		LOOP	check_map_data3		;
		CLC				;
		JMP	check_map_data2		;
check_map_data1:
		STC				;
check_map_data2:
		POP	DI			;
		POP	SI			;
		POP	CX			;
		POP	AX			;
		RET				;
check_map_data	ENDP

;--------------------------------------------------------------------
; Check logical page no.
; input
;	BX	: logical page number in handle
;	DX	: EMM handle
; output
;	AX	: logical page number in EMM
;	SI	: logical page struct pointer
;	CF = 0	: OK
;	CF = 1	: NG
;--------------------------------------------------------------------
check_log_page 	PROC	NEAR
		PUSH	CX			;
		PUSH	SI			;
		MOV	CX,PAGE_MAX		;
		MOV	SI,OFFSET log_page	;
check_log_page1:
		CMP	CS:[SI],DX		;EMM handle same ?
		JNZ	check_log_page3		;no
		CMP	CS:[SI].handle_page_no1,BX;logical page no. same ?
		JZ	check_log_page2		;yes
check_log_page3:
		ADD	SI,SIZE log_page_struct	;
		LOOP	check_log_page1		;
		STC				;
		JMP	check_log_page4		;
check_log_page2:
		CLC				;
		MOV	AX,CS:[SI].log_page_number;
check_log_page4:
		POP	SI			;
		POP	CX			;
		RET				;
check_log_page 	ENDP

;--------------------------------------------------------------------
; Check EMM handle no.
; input
;	DX	: EMM handle
; output
;	CF = 0	: OK
;	CF = 1	: NG
;--------------------------------------------------------------------
check_handle 	PROC	NEAR
		CLC				;reset CF
		PUSH	AX			;
		PUSH	DI			;
		CMP	DX,MAX_HNDL		;
		JNB	check_handle1		;
		MOV	DI,OFFSET handle	;
		MOV	AX,SIZE emm_handle_struct;
		MUL	DL			;
		ADD	DI,AX			;
		MOV	AL,CS:[DI].handle_flag	;active handle ?
		OR	AL,AL			;
		JNZ	check_handle2		;
check_handle1:
		STC				;set CF
check_handle2:
		POP	DI			;
		POP	AX			;
		RET				;
check_handle 	ENDP

;--------------------------------------------------------------------
; Get handle page count.
; input
;	DX	: EMM handle
; output
;	AX	: page count
;--------------------------------------------------------------------
get_alloc_page 	PROC	NEAR
		PUSH	DI			;
		MOV	DI,OFFSET handle	;
		MOV	AX,SIZE emm_handle_struct;
		MUL	DL			;
		ADD	DI,AX			;
		MOV	AL,CS:[DI].alloc_page_count;page size to handle
		XOR	AH,AH			;
		POP	DI			;
		RET				;
get_alloc_page 	ENDP

;--------------------------------------------------------------------
; Set physical page map.
; output
;	CF = 0	: OK
;	CF = 1	: NG
;--------------------------------------------------------------------
set_pages_map	PROC	NEAR
		PUSH	AX			;
		PUSH	CX			;
		PUSH	DX			;
		PUSH	DI			;
		MOV	DI,OFFSET map_table	;
		MOV	CX,PHYS_PAGES		;
set_pages_map2:
		MOV	DX,CS:[DI].phys_page_port;mapping physical pages...
		MOV	AL,CS:[DI].log_page_data;
		CALL	emsout			;
		JB	set_pages_map1		;
		ADD	DI,SIZE phys_page_struct;
		LOOP	set_pages_map2		;
		CLC				;
set_pages_map1:
		POP	DI			;
		POP	DX			;
		POP	CX			;
		POP	AX			;
		RET				;
set_pages_map	ENDP

;--------------------------------------------------------------------
; Reset physical page.
; input
;	AL	: physical page no.
;--------------------------------------------------------------------
reset_phys_page	PROC	NEAR
		PUSH	AX			;
		PUSH	CX			;
		PUSH	DX			;
		PUSH	DI			;
		XOR	AH,AH			;
		MOV	DI,OFFSET map_table	;
		MOV	CL,SIZE phys_page_struct;
		MUL	CL			;
		ADD	DI,AX			;
		MOV	DX,CS:[DI].phys_page_port;
		MOV	AL,DIS_EMS		;
		CALL	emsout			;
		JB	reset_phys_page1	;error ?
		MOV	CS:[DI].emm_handle2,UNMAP;handle
		MOV	CS:[DI].log_page_data,AL;logical page no.
reset_phys_page1:
		POP	DI			;
		POP	DX			;
		POP	CX			;
		POP	AX			;
		RET
reset_phys_page	ENDP

;--------------------------------------------------------------------
; Set physical page.
; input
;	AL	: physical page no.
;	BX	: logical page no. (if BX=FFFFH then unmap)
;	DX	: EMM handle
;--------------------------------------------------------------------
set_phys_page	PROC	NEAR
		PUSH	AX			;
		PUSH	CX			;
		PUSH	DX			;
		PUSH	DI			;
		XOR	AH,AH			;
		MOV	DI,OFFSET map_table	;
		MOV	CL,SIZE phys_page_struct;
		MUL	CL			;
		ADD	DI,AX			;
		PUSH	DX			;
		MOV	DX,CS:[DI].phys_page_port;
		MOV	AX,BX			;
                ADD     AL,cs:pageofs           ; 09/25/92 10:47am
		CALL	emsout			;
		POP	DX			;
		JB	set_phys_page1		;error ?
		MOV	CS:[DI].emm_handle2,DX	;handle
		MOV	CS:[DI].log_page_data,AL;logical page no.
set_phys_page1:
		POP	DI			;
		POP	DX			;
		POP	CX			;
		POP	AX			;
		RET				;
set_phys_page	ENDP

;--------------------------------------------------------------------
; Change mappable segment address to physical page number.
; input
;	AX	: mappable segment address
; output
;	AX	: physical page number
;--------------------------------------------------------------------
change_seg_page	PROC	NEAR
		PUSH	BX			;
		PUSH	CX			;
		PUSH	DI			;
		CLC				;reset CF
		XOR	BX,BX			;
		MOV	DI,OFFSET map_table	;
		MOV	CX,PHYS_PAGES		;
change_seg_page2:
		CMP	AX,CS:[DI].phys_seg_addr;
		JZ	change_seg_page1	;
		ADD	DI,SIZE phys_page_struct;
		INC	BX			;
		LOOP	change_seg_page2	;
		STC				;set CF
change_seg_page1:
		MOV	AX,BX			;
		POP	DI			;
		POP	CX			;
		POP	BX			;
		RET				;
change_seg_page	ENDP

;--------------------------------------------------------------------
; Output EMS i/o port.
; input
;	DX	: i/o port address
;	AL	: output data
; output
;	CF = 0	: OK
;	CF = 1	: NG
;--------------------------------------------------------------------
emsout		PROC	NEAR
		PUSH	AX			;
		PUSH	CX			;
		PUSH	DX			;
		OUT	DX,AL			;
		MOV	CX,1000			;
		MOV	DX,CS:emsio		;get EMS status port address.
emsout2:					;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JZ	emsout1			;
		LOOP	emsout2			;
		INC	DX			;v1.02 - out 00 -> R1
		XOR	AL,AL			;v1.02
		OUT	DX,AL			;v1.02
		STC				;set CF
		JMP	emsout3			;
emsout1:					;
		INC	DX			;v1.02 - out 00 -> R1
		XOR	AL,AL			;v1.02
		OUT	DX,AL			;v1.02
		CLC				;reset CF
emsout3:					;
		POP	DX			;
		POP	CX			;
		POP	AX			;
		RET				;
emsout		ENDP

;.........................................................................

;--------------------------------------------------------------------
;	EMM driver work data area
;--------------------------------------------------------------------
emsio		LABEL	WORD
ems_io		DW	98H		;EMS i/o port address
pageofs		DB	?		;logical page no. offset data
backup_count	DB	0		;mapping data backup count
OSE_flag	DW	0		;OS/E function enable flag
OSE_fast	DW	0		;OS/E fast access flag
access_key_h	DW	0		;OS/E access key high
access_key_l	DW	0		;OS/E access key low
alter_map	LABEL	DWORD
alter_map_off	DW	0		;
alter_map_seg	DW	0		;
map_jump	map_and_jump_struct	<>
move_mem	move_source_dest_struct	<>
xchg_mem	xchg_source_dest_struct	<>
display_str     db '  '
number_str      db 'test', '$'

;
;	physical page status data area
;
map_table	LABEL	phys_page_struct
		DB	SIZE phys_page_struct * PHYS_PAGES DUP (-1)

;
;	handle used flag
;
handle		LABEL	emm_handle_struct
		DB	(SIZE emm_handle_struct) * (MAX_HNDL + 1) DUP (0)

;
;	mapping data backup area
;
backup_map	LABEL	WORD
		DB	(SIZE phys_page_struct * PHYS_PAGES + 2) * BACK_MAX DUP(-1)

;
;	logical page kanri data
;
log_page	LABEL	log_page_struct
		DB	(SIZE log_page_struct) * PAGE_MAX DUP (-1)

;
;	i/o port address buffer
;
port_addr	LABEL	WORD
		DW	PHYS_PAGES DUP (-1)

;********************************************************************

;--------------------------------------------------------------------
; EMM driver initilize program
;	v1.02 - three nop delete
;--------------------------------------------------------------------
emminit:
		MOV	SI,OFFSET start_msg	;display start messege.
		CALL	strdsp			;
		CALL	getprm			;get parameters
		CALL	ckemsio			;check EMS i/o port
		JB	errems			;error ?
		CALL	ramchk			;check EMS memory
		JB	errems			;error ?
		XOR	AX,AX			;
		MOV	ES,AX			;
		MOV	SI,19CH			;
		MOV	WORD PTR ES:[SI],OFFSET int67;set int67 offset.
		MOV	ES:[SI+2],CS		;set int67 segment.
		CALL	instmsg			;display install message.
		XOR	AX,AX			;
		MOV	ES,AX			;
		MOV	SI,46CH			;
		MOV	AX,ES:[SI]		;
		ADD	BX,AX			;make access key...
		MOV	access_key_h,BX		;
		MOV	SI,46EH			;
		ADC	AX,ES:[SI]		;
		ADD	BX,AX			;
		MOV	access_key_l,BX		;
		MOV	DI,OFFSET handle	;set system handle...
		PUSH	CS			;
		POP	ES			;
		MOV	ES:[DI].handle_flag,1	;set system handle active.
		INC	CS:handle_count		;handle count up
		MOV	AX,OFFSET emminit	;make break address...
		ADD	AX,0FH			;
		MOV	CL,4			;
		SHR	AX,CL			;
		MOV	CX,AX			;
		MOV	AX,CS			;
		ADD	AX,CX			;
		MOV	emm_flag,1		;set EMM install flag.
		LDS	BX,ptrsav		;
		MOV	[BX].brkoff,0		;break address offset set.
		MOV	[BX].brkseg,AX		;break address segment set.
		JMP	exit			;exit initial program.
errems:						;
		MOV	SI,OFFSET notinst	;display error message
		CALL	strdsp			;
		MOV	emm_flag,0		;reset EMM install flag.
		LDS	BX,ptrsav		;
		MOV	AX,OFFSET int67		;set break address offset.
		MOV	[BX].brkoff,AX		;set break address offset.
		MOV	[BX].brkseg,CS		;set break address segment.
		JMP	exit			;exit initial program.

;--------------------------------------------------------------------
; Get CONFIG.SYS parameters.
;--------------------------------------------------------------------
getprm		PROC	NEAR
		PUSH	DS		;
		INT	12H		;get system memory size.
		MOV	sysmem,AX	;
		LES	BX,ptrsav	;
		MOV	DI,ES:[BX].count;
		MOV	AX,ES:[BX].start;
		MOV	ES,AX		;
		XOR	CL,CL		;
getpr2:					;
		MOV	AL,ES:[DI]	;
		CMP	AL,'/'		;option switch?
		JNZ	getpr3		;
		INC	DI		;
		MOV	AL,ES:[DI]	;
		CMP	AL,'M'		;set system memory size?
		JNZ	getpr1		;
		INC	DI		;
		MOV	AL,ES:[DI]	;
		CMP	AL,':'		;
		JNZ	getpr3		;
		INC	DI		;
		CALL	ascbin1		;change data ascii -> binary.
		JB	getpr5		;
		MOV	sysmem,AX	;set system memory size data.
		JMP	getpr5		;next.
getpr1:					;
		CMP	AL,'P'		;set page frame address?
		JNZ	getpr3		;
		INC	DI		;
		MOV	AL,ES:[DI]	;
		CMP	AL,':'		;
		JNZ	getpr1		;
		INC	DI		;
		CALL	ascbin2		;change data ascii -> binary.
		JNB	getpr8		;error ?
		JMP	getpr5		;
getpr8:					;
		MOV	pageseg,AX	;
		MOV	page_frame_seg,AX;
		OR	CL,2		;set page frame address change flag.
		JMP	getpr5		;
getpr3:					;
		CMP	AL,'I'		;set EMS i/o port address?
		JNZ	getpr6		;
		INC	DI		;
		MOV	AL,ES:[DI]	;
		CMP	AL,':'		;
		JNZ	getpr1		;
		INC	DI		;
		CALL	ascbin2		;change data ascii -> binary.
		MOV	rqioadr,AX	;
		MOV	emsio,AX	;
		OR	CL,1		;set EMS i/o port address change flag.
		JMP	getpr5		;
getpr6:					;
		CMP	AL,CR		;
		JZ	getpr4		;
getpr5:					;
		INC	DI		;
		JMP	getpr2		;
getpr4:					;
		MOV	sysflg,CL	;set system option flag.
		POP	DS		;
		RET			;
getprm		ENDP

;--------------------------------------------------------------------
; Check EMS i/o port.
; output
;	cf = 0 : OK
;	cf = 1 : NG
;--------------------------------------------------------------------
ckemsio		PROC	NEAR
		MOV	DX,EMSIOA		;
		MOV	AL,CHKIOA		;
		OUT	DX,AL			;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JNZ	ckems7			;
		MOV	AL,CHKIOA		;
		OUT	DX,AL			;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JZ	ckems1			;
ckems7:
		MOV	CX,1000			;
ckems5:						;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JZ	ckems6			;
		LOOP	ckems5			;
		JMP	ckems1			;
ckems6:						;
		MOV	BL,CHKIOA		;
		AND	BL,7FH			;
		CMP	AL,BL			;
		JZ	ckems2			;
ckems1:						;
		MOV	DX,EMSIOB		;
		MOV	AL,CHKIOB		;
		OUT	DX,AL			;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JNZ	ckems8			;
		MOV	AL,CHKIOB		;
		OUT	DX,AL			;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JZ	ckems3			;
ckems8:
		MOV	CX,1000			;
ckems9:						;
		IN	AL,DX			;
		TEST	AL,80H			;check TRS flag
		JZ	ckemsa			;
		LOOP	ckems9			;
		JMP	ckems3			;
ckemsa:						;
		MOV	BL,CHKIOB		;
		AND	BL,7FH			;
		CMP	AL,BL			;
		JNZ	ckems3			;
ckems2:						;
		MOV	CS:emsio,DX		;set i/o port address.
		TEST	BYTE PTR CS:sysflg,1	;
		JZ	ckems4			;
		MOV	AX,CS:rqioadr		;
		MOV	BX,AX			;change EMS i/o port addess.
		MOV	DX,CS:emsio		;
		MOV	CL,3			;
		SHR	AX,CL			;
		OR	AL,80H			;
		CALL	emsout			;
		MOV	CS:emsio,BX		;
ckems4:						;
		CLC				;reset CF
		RET				;
ckems3:						;
		MOV	SI,OFFSET hard_w_err	;display wardware error messege.
		CALL	strdsp			;
		STC				;set CF
		RET				;
ckemsio		ENDP

;--------------------------------------------------------------------
; Check system memory size.
;	v1.02 - three nop delete
;--------------------------------------------------------------------
sysram		PROC	NEAR
		PUSH	CS			;
		POP	DS			;
		PUSH	ES			;
		XOR	AX,AX			;set system memory size.
		MOV	ES,AX			;
		MOV	AX,sysmem		;
		CMP	ES:WORD PTR MEMSIZE,AX	;memory size same ?
		JZ	sysram1			;
		MOV	ES:WORD PTR MEMSIZE,AX	;
		INT	19H			;reboot...
sysram1:					;
		POP	ES			;
		MOV	BX,40H			;
		MUL	BX			;
		MOV	DX,emsio		;
		ADD	DX,2			;
		MOV	AL,AH			;
		CALL	emsout			;output EMS i/o port data.
		SHR	AL,1			;
		SHR	AL,1			;
		MOV	pageofs,AL		;set page no. offset data
		MOV	DX,STATSEG 		;;;v1.01
		RET				;
sysram		ENDP

;--------------------------------------------------------------------
; Check expanded memory.
; output
;	cf = 0 : OK
;	cf = 1 : NG
;--------------------------------------------------------------------
ramchk		PROC	NEAR
		PUSH	AX			;
		PUSH	BX			;
		PUSH	CX			;
		PUSH	DX			;
		PUSH	BP			;
		PUSH	CS			;
		POP	DS			;
		MOV	SI,OFFSET port_addr	;set phys_page i/o port address
		MOV	DI,OFFSET map_table	;
		MOV	CX,PHYS_PAGES		;
		MOV	BX,emsio		;
		ADD	BX,4			;
ramch14:					;
		MOV	[SI],BX			;
		MOV	[DI].phys_page_port,BX	;
		MOV	[DI].log_page_data,0	;v2.00
		ADD	DI,SIZE phys_page_struct;
		MOV	DX,BX			;disable physical pages ---
		MOV	AL,DIS_EMS		;v2.00
		CALL	emsout			;--------------------------
		INC	SI			;
		INC	SI			;
		INC	BX			;
		LOOP	ramch14			;------------------------------
		CALL	SYSRAM    		;;;v1.01 set system memory size
ramch4:						;found 64KB free area...
		MOV	BP,DX			;
		XOR	BX,BX			;
ramch6:						;
		CALL	ckromram		;
		JNB	ramch1			;
		INC	BX			;
		CMP	BX,20H			;
		JNB	ramch2			;
		CMP	DX,ROMSEG		;
		JB	ramch6			;
		JMP	ramch3			;
ramch1:						;
		CMP	DX,ENDSEG		;
		JB	ramch4			;
ramch3:						;
		PUSH	CS			;
		POP	DS			;
		MOV	SI,OFFSET nomem		;
		CALL	strdsp			;
		STC				;
		JMP	ramch5			;........................
ramch2:						;
		PUSH	CS			;
		POP	DS			;
		MOV	AX,BP			;
		MOV	page_frame_seg,AX	;
		TEST	BYTE PTR sysflg,2	;
		JZ	ramch12			;
		MOV	AX,pageseg		;physical page segment set
		MOV	page_frame_seg,AX	;------------------------------
ramch12:					;
		MOV	AX,page_frame_seg	;segment start address set
		MOV	AL,AH			;
		MOV	DX,emsio		;
		ADD	DX,3			;
		CALL	emsout			;EMS i/o port data out
		MOV	DI,OFFSET map_table	;set physical page frame address
		MOV	CX,PHYS_PAGES		;v2.00
		MOV	AX,page_frame_seg	;+
ramch18:					;+
		MOV	[DI].phys_seg_addr,AX	;+
		ADD	DI,SIZE phys_page_struct;+
		ADD	AX,0400H		;+
		LOOP	ramch18			;------------------------------
		MOV	SI,OFFSET pagemsg	;display page test msg..
		CALL	strdsp			;
		IN	AL,I8042+1		;logical page test...
		OR	AL,4			;system memory parity disable
		OUT	I8042+1,AL		;
		MOV	SI,OFFSET port_addr	;
		MOV	DI,OFFSET log_page	;
		MOV	DX,[SI]			;
		CMP	DX,0FFFFH		;
		JZ	ramch7			;
		XOR	AH,AH			;
		MOV	AL,pageofs		;get EMS logical page start no.
		MOV	CX,PAGE_MAX		;
		XOR	BX,BX			;
ramch9:						;
		PUSH	CX			;
		CALL	emsout			;EMS i/o port data out
		CALL	imgchk			;
		JNB	ramch17			;
		POP	CX			;
		JMP	ramch16			;
ramch17:					;
		CALL	pagetst			;
		JB	ramch8			;
		MOV	[DI],NOT_USE		;
		MOV	[DI].log_page_number,BX	;
		INC	BX			;
		ADD	DI,SIZE log_page_struct	;
ramch8:						;
		POP	CX			;
		INC	AL			;
		LOOP	ramch9			;
ramch16:					;
		MOV	total_pages,BX		;
		MOV	un_alloc_pages,BX	;
		MOV	CX,PHYS_PAGES		;disable physical pages...
		MOV	DX,CS:emsio		;
		ADD	DX,4			;
ramch19:
		MOV	AL,DIS_EMS		;
		CALL	emsout			;
		INC	DX			;
		LOOP	ramch19			;
		IN	AL,I8042+1		;enable system memory parity..
		AND	AL,0FBH			;
		OUT	I8042+1,AL		;
ramch7:						;
		CLC				;
ramch5:						;
		POP	BP			;
		POP	DX			;
		POP	CX			;
		POP	BX			;
		POP	AX			;
		RET				;
ramchk		ENDP

;--------------------------------------------------------------------
; Display EMM install opening message.
;--------------------------------------------------------------------
instmsg		PROC	NEAR
		PUSH	AX			;
		PUSH	BX			;
		PUSH	CX			;
		PUSH	DI			;
		PUSH	CS			;
		POP	ES			;
		MOV	SI,OFFSET openmsg	;
		CALL	strdsp			;
		MOV	AX,total_pages		;
		MOV	DI,OFFSET total_pg	;
		CALL	dbinasc			;
		MOV	SI,OFFSET install_msg	;
		CALL	strdsp			;
		MOV	AX,page_frame_seg	;
		MOV	DI,OFFSET segadr	;
		CALL	hbinasc			;
		MOV	SI,OFFSET page_msg	;
		CALL	strdsp			;
		MOV	AX,emsio		;
		MOV	DI,OFFSET pioadr	;
		CALL	hbinasc			;
		MOV	SI,OFFSET port_msg	;
		CALL	strdsp			;
		POP	DI			;
		POP	CX			;
		POP	BX			;
		POP	AX			;
		RET				;
instmsg		ENDP

;--------------------------------------------------------------------
; Check rom/ram area.
; input
;	DX : segment address
; output
;	cf = 0 : OK
;	cf = 1 : NG
;--------------------------------------------------------------------
ckromram	PROC	NEAR
		MOV	ES,DX			;
		XOR	SI,SI			;
		MOV	WORD PTR ES:[SI],0000H	;
		CMP	WORD PTR ES:[SI],0AA55H	;
		JNZ	ckrom1			;
		XOR	AH,AH			;
		MOV	AL,ES:[SI+2]		;
		MOV	CL,5			;
		SHL	AX,CL			;
		ADD	DX,AX			;
ckrom3:
		CLC				;reset CF
		RET				;
ckrom1:
		ADD	DX,80H			;
		MOV	WORD PTR ES:[SI],55AAH	;
		CMP	WORD PTR ES:[SI],55AAH	;
		JZ	ckrom3			;
		STC				;set CF
		RET				;
ckromram	ENDP

;--------------------------------------------------------------------
; check memory size (1024 KByte)
;--------------------------------------------------------------------
imgchk		PROC	NEAR
		CLD				;
		PUSH	AX			;
		PUSH	CX			;
		PUSH	SI			;
		PUSH	DI			;
		PUSH	DS			;
		MOV	AX,page_frame_seg	;
		MOV	ES,AX			;
		PUSH	CX			;
		XOR	AX,AX			;
		MOV	DS,AX			;
		XOR	SI,SI			;
		XOR	DI,DI			;
		MOV	CX,2000H		;
		REPZ	CMPSW			;
		CMP	CX,0			;
		JNZ	imgch1			;
		POP	CX			;
		STC				;
		JMP	imgch3			;
imgch1:
		POP	CX			;
		CLC				;reset CF
imgch3:
		POP	DS			;
		POP	DI			;
		POP	SI			;
		POP	CX			;
		POP	AX			;
		RET				;
imgchk		ENDP

;--------------------------------------------------------------------
; check logical page memory.
; input
;	AX	: logical page no.
;--------------------------------------------------------------------
pagetst		PROC	NEAR
		CLD				;reset DF
		PUSH	AX			;push registers...
		PUSH	BX			;
		PUSH	CX			;
		PUSH	DX			;
		PUSH	SI			;
		PUSH	DI			;
		PUSH	DS			;
		PUSH	CS			;set ES <- CS..
		POP	ES			;
		SUB	AL,pageofs		;sub page no. - page offset.
		MOV	DI,OFFSET tstpage	;
		CALL	dbinasc			;change binary -> ascii.
		MOV	SI,OFFSET tstpage	;display message..
		CALL	strdsp			;
		MOV	AX,page_frame_seg	;set page frame address -> ES..
		MOV	ES,AX			;
		PUSH	CX			;
		XOR	AX,AX			;check 0:0 image data in page_
		MOV	DS,AX			;frame...
		XOR	SI,SI			;
		XOR	DI,DI			;
		MOV	CX,2000H		;
		REPZ	CMPSW			;
		CMP	CX,0			;check ok?
		JZ	pagets2			;
		PUSH	CS			;
		POP	DS			;
		MOV	BX,OFFSET chkchr	;fill pattan data...
		MOV	AX,CS:[BX]		;
		XOR	DI,DI			;
		MOV	CX,2000H		;
		REPZ	STOSW			;
		MOV	CX,2000H		;check pattan data...
		XOR	DI,DI			;
		REPZ	SCASW			;
		CMP	CX,0			;check ok?
		JZ	pagets1			;
pagets2:
		POP	CX			;pop CX
		STC				;set CF
		JMP	pagets3			;
pagets1:
		XOR	AX,AX			;clear expand memory...
		XOR	DI,DI			;
		MOV	CX,2000H		;
		REPZ	STOSW			;
		POP	CX			;pop CX
		CLC				;reset CF
pagets3:
		POP	DS			;pop registers...
		POP	DI			;
		POP	SI			;
		POP	DX			;
		POP	CX			;
		POP	BX			;
		POP	AX			;
		RET				;return.
pagetst		ENDP

;--------------------------------------------------------------------
; set logical page.
; input
;	DX	: I/O port address
;	SI	: logical page number
;--------------------------------------------------------------------
pageset		PROC	NEAR
		PUSH	AX			;
		MOV	AX,SI			;
		CALL	emsout			;
		POP	AX			;
		RET				;
pageset		ENDP

;--------------------------------------------------------------------
; Change data BYNARY -> ASCII (DEC)
; input
;	AX	: binary data
; output
;	ES:DI	: ascii data (DEC)
;--------------------------------------------------------------------
dbinasc:
		PUSH	AX
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		MOV	SI,DI
		MOV	CX,4
		MOV	BX,1000
		XOR	DX,DX
dbinas1:
		DIV	BX
		OR	AL,AL
		JNZ	dbinas2
		CMP	CL,4
		JZ	dbinas4
		CMP	BYTE PTR [SI],' '
		JNZ	dbinas2
dbinas4:
		MOV	AL,' '
		CMP	CL,1
		JNZ	dbinas3
		XOR	AL,AL
dbinas2:
		ADD	AL,'0'
dbinas3:
		MOV	SI,DI
		STOSB
		PUSH	DX
		XOR	DX,DX
		MOV	AX,BX
		MOV	BX,10
		DIV	BX
		MOV	BX,AX
		POP	AX
		LOOP	dbinas1
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		DEC	DI
		RET

ifndef display_int

;--------------------------------------------------------------------
; Change data BYNARY -> ASCII (HEX)
; input
;	AX	: binary data
; output
;	ES:DI	: ascii data (HEX)
;   DI !!!
;--------------------------------------------------------------------
hbinasc:
		PUSH	AX
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		MOV	SI,DI
		MOV	CX,4
		MOV	BX,1000H
		XOR	DX,DX
hbinas1:
		DIV	BX
		CMP	AL,10
		JB	hbinas2
		ADD	AL,7
hbinas2:
		ADD	AL,'0'
hbinas3:
		MOV	SI,DI
		STOSB
		PUSH	DX
		XOR	DX,DX
		MOV	AX,BX
		MOV	BX,10H
		DIV	BX
		MOV	BX,AX
		POP	AX
		LOOP	hbinas1
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		DEC	DI
		RET
endif

;--------------------------------------------------------------------
; Change data ASCII (DEC) -> BINARY
; input
;	ES:DI = ascii data address (DEC)
; output
;	AX = binary data
;--------------------------------------------------------------------
ascbin1:
		PUSH	BX
		PUSH	CX
		PUSH	DX
		XOR	DL,DL
		MOV	CX,4
		XOR	BX,BX
ascbin11:
		MOV	AL,ES:[DI]
		CMP	AL,' '
		JZ	ascbin13
		CMP	AL,TAB
		JNZ	ascbin14
ascbin13:
		OR	DL,DL
		JNZ	ascbin12
		INC	DI
		JMP	ascbin11
ascbin12:
		OR	DL,DL
		JNZ	ascbin16
		STC
		JMP	ascbin15
ascbin14:
		CMP	AL,'0'
		JB	ascbin12
		CMP	AL,':'
		JNB	ascbin12
		MOV	DL,1
		SUB	AL,'0'
		XOR	AH,AH
		XCHG	BX,AX
		PUSH	DX
		MOV	DX,10
		MUL	DX
		ADD	BX,AX
		POP	DX
		INC	DI
		LOOP	ascbin11
ascbin16:
		MOV	AX,BX
		CLC
ascbin15:
		POP	DX
		POP	CX
		POP	BX
		RET

;--------------------------------------------------------------------
; Change data ASCII (HEX) -> BINARY
; input
;	ES:DI = ascii data address (HEX)
; output
;	AX = binary data
;--------------------------------------------------------------------
ascbin2:
		PUSH	BX
		PUSH	CX
		PUSH	DX
		XOR	DL,DL
		MOV	CX,4
		XOR	BX,BX
ascbin21:
		MOV	AL,ES:[DI]
		CMP	AL,' '
		JZ	ascbin23
		CMP	AL,TAB
		JNZ	ascbin24
ascbin23:
		OR	DL,DL
		JNZ	ascbin22
		INC	DI
		JMP	ascbin21
ascbin22:
		OR	DL,DL
		JNZ	ascbin27
		STC
		JMP	ascbin25
ascbin24:
		CMP	AL,'0'
		JB	ascbin22
		CMP	AL,':'
		JB	ascbin26
		CMP	AL,'A'
		JB	ascbin22
		CMP	AL,'G'
		JNB	ascbin22
		SUB	AL,7
ascbin26:
		MOV	DL,1
		SUB	AL,'0'
		XOR	AH,AH
		XCHG	BX,AX
		PUSH	DX
		MOV	DX,10H
		MUL	DX
		ADD	BX,AX
		POP	DX
		INC	DI
		LOOP	ascbin21
ascbin27:
		MOV	AX,BX
		CLC
ascbin25:
		POP	DX
		POP	CX
		POP	BX
		RET

;--------------------------------------------------------------------
; STRINGS DISPLAY SUB
; input
;	DS:SI	: strings datas
;--------------------------------------------------------------------
strdsp:
		PUSH	AX			;
		PUSH	DX			;
		PUSH	ES			;
		PUSH	CS			;
		POP	ES			;
		MOV	DX,SI			;
		MOV	AH,9			;
		CALL	bdos			;bdos call
		POP	ES			;
		POP	DX			;
		POP	AX			;
		RET				;

;--------------------------------------------------------------------
;  BDOS CALL SUB
;--------------------------------------------------------------------
bdos:
		INT	21H			;
		RET				;

;____________________________________________________________________

;--------------------------------------------------------------------
;	EMM driver initial routine work data area
;--------------------------------------------------------------------
openmsg		DB	CR
		DB	'SUNTAC-62 Chip Set EMS Driver Version 4.0 ',CR,LF
		DB	'SUN ELECTRONICS CORP. 1988    Release 0.1 ',CR,LF
		DB	'        -- EVALUATION ONLY --          ',CR,LF
		DB	'            NOT FOR SALE               ',CR,LF
		DB	'$'
install_msg	DB	'EMM DRIVER INSTALL TOTAL PAGES : '
total_pg	DB	'0000',CR,LF,'$'
page_msg	DB	'EMM PAGE SEGMENT : '
segadr		DB	'0000H',CR,LF,'$'
port_msg	DB	'EMM PORT ADDRESS : '
pioadr		DB	'0000H',CR,LF,LF,'$'
start_msg	DB	'SUNTAC-62 Chip Set EMS Driver Version 4.0 Release 0.1'
		DB	' -- EVALUATION ONLY --'
		DB	CR,LF,LF,'$'
hard_w_err	DB	'EMS HARDWARE NOT FOUND !',CR,LF,'$'
notinst		DB	'EMM DRIVER FAIL TO INSTALL ABORTED !',CR,LF,'$'
nomem		DB	'NO FREE MEMORY SEGMENT, EMM DRIVER CAN NOT INSTALL !'
		DB	CR,LF,'$'
pagemsg		DB	'0000 PAGES TESTING',CR,'$'
tstpage		DB	'0000',CR,'$'
pageseg		DW	0	;physical page segment
rqioadr		DW	0	;request EMS i/o port address
sysflg		DB	0	;system option flag
sysmem		DW	0	;system memory size
chkchr		DW	55AAH

code		ENDS
		END

