/*********************************************************************
*
*  IPCNST.H
*
*  Copyright (c) 1989 Matrox Electronic Systems, Ltd.
*  All rights reserved.
*
*  Global constants set by the initialization function and maintain by
*  some other library function. They should be access for read only.
*
**********************************************************************/

/* Pointer to the beginning of the permanent library memory allocated
 * by the driver */

VG_IMPORT VG_DRVLIBMEM VG_FAR *_DV_ _VG_DrvVar;

#ifdef DOS
   #define _VG_XDispSize   _VG_DrvVar->XDispSize
   #define _VG_YDispSize   _VG_DrvVar->YDispSize
   #define _VG_XDispPixel  _VG_DrvVar->XDispPixel
   #define _VG_YDispPixel  _VG_DrvVar->YDispPixel
   #define _VG_SelectBoard _VG_DrvVar->SelectBoard
#endif


/*
*  Horizontal and vertical current resolution. These two user variables
*  are updated by the library function SetResolution() and SetDispMode()
*  according to the X and Y resolution and display mode. These two
*  variables are not affected by the zoom factor.
*/

#ifndef DOS
   VG_IMPORT const VG_WORD _DV_ _VG_XDispSize;
   VG_IMPORT const VG_WORD _DV_ _VG_YDispSize; 
#endif

/*
*  Horizontal and vertical number of pixel currently display
*  according to the X and Y DispSize and the zoom factor.
*/

#ifndef DOS
   VG_IMPORT const VG_WORD _DV_ _VG_XDispPixel;
   VG_IMPORT const VG_WORD _DV_ _VG_YDispPixel; 
#endif

/*
*  Horizontal and vertical memory size in pixel according to
*  the type of memory you have on your Iluminator board.
*/
VG_IMPORT const VG_WORD _DV_ _VG_XMemSize;
VG_IMPORT const VG_WORD _DV_ _VG_YMemSize;

#ifdef IP
/* Number of memory bank */
VG_IMPORT const VG_UBYTE _DV_ _VG_MemBank;
#endif

/*
*  IP board type   0 -> IP 8
*                    1 -> IP 16
*                    2 -> IP 24
*                    3 -> IP 32
*/
VG_IMPORT const VG_UBYTE _DV_ _VG_Type;

/* IP board version number */
VG_IMPORT const VG_UBYTE _DV_ _VG_Version;

#ifdef IP
/* IP RAMDAC chip type */
VG_IMPORT const VG_UBYTE _DV_ _VG_RamDACType;
#endif

/*
*  Pixel size in byte.
*/
VG_IMPORT const VG_UBYTE _DV_ _VG_PixelSize;

/*
*  Two access buffer pointer and one size in byte (both buffer have
*  same size) select by IPINIT program.
*/
VG_IMPORT VG_UBYTE VG_FAR   *_DV_ _VG_AcsBufAdd[2];
VG_IMPORT const VG_UWORD  _DV_ _VG_AcsBufSize;

/*
*  Keep the current CRT mode (NTSC_CRT or PAL_CRT) according to
*  the type of board.
*/
VG_IMPORT const VG_UBYTE _DV_ _VG_CRTMode;

#ifdef IP
/*
*  Predefined Kernel for imaging function.
*/
VG_IMPORT const VG_BYTE _DV_ _VG_SH1Ker[9];
VG_IMPORT const VG_BYTE _DV_ _VG_SH2Ker[9];
VG_IMPORT const VG_BYTE _DV_ _VG_LP1Ker[9];
VG_IMPORT const VG_BYTE _DV_ _VG_LP2Ker[9];
VG_IMPORT const VG_BYTE _DV_ _VG_HoriKer[9];
VG_IMPORT const VG_BYTE _DV_ _VG_VertKer[9];
VG_IMPORT const VG_BYTE _DV_ _VG_AverageKer[9];
VG_IMPORT const VG_BYTE _DV_ _VG_PW1Ker[9];
VG_IMPORT const VG_BYTE _DV_ _VG_PW2Ker[9];
VG_IMPORT const VG_BYTE _DV_ _VG_SB1Ker[9];
VG_IMPORT const VG_BYTE _DV_ _VG_SB2Ker[9];

/*
*  IP multiboard variables
*/
/* Maximum number of IP board content in the system ( this global
 * variable is set by the InitIPLib() function ). */
VG_IMPORT const VG_UBYTE _DV_ _VG_MaxBoard;
                                     
/* Current selected IP board */  
#ifndef DOS                                   
   VG_IMPORT const VG_UBYTE _DV_ _VG_SelectBoard;
#endif

/* IP board with a VGA connected to it */
VG_IMPORT const VG_UBYTE _DV_ _VG_VGATrapBoard;

/*
*  Horizontal and vertical histogram size in pixel.
*/
VG_IMPORT const VG_UWORD _DV_ _VG_XHistoSize;
VG_IMPORT const VG_UWORD _DV_ _VG_YHistoSize;
#endif

#ifndef UPD_COUNTER
 /* Flag to avoid several Initialization function call */
 VG_IMPORT const VG_UBYTE _DV_ _VG_LocalInitCounter;
#endif

#ifdef ILUM
 VG_IMPORT const VG_WORD _DV_  _VG_VshiftDefault[2];
 VG_IMPORT const VG_WORD _DV_  _VG_VclipDefault [2];

 #ifdef WIN30
  VG_IMPORT const VG_VS_CRT _DV_ *_VG_CustomVsCrt;
 #else
  VG_IMPORT VG_VS_CRT _DV_ *_VG_CustomVsCrt;
 #endif
#endif
