/****************************************************************/
/*                      GLOBALS.C                               */
/****************************************************************/
/*
*  By:		Michel Pelletier
*		Matrox Electronic Systems ltd.
*
*  Date:	Apr. 29, 1993.
*
*  These are the global variables for GRABTEST.  It contains global
*  variable declarations for menu buttons and labels, as well as
*  Look-Up Table data.
*/
/****************************************************************/

#include	<grabtest.h>

/* The following initializes the button[] structure. Please refer to the
 * typedef in OVRMENU.H for a complete description of BUTTON. */
BUTTON  button[] = {
  /* function key F1 */ {
    BX_F1, BY_F1, BW_F1, BH_F1,
    {OVR_WHITE,  	OVR_WHITE},
    {OVR_GRAY,   	OVR_GRAY },
    {OVR_WHITE,  	OVR_GRAY },
    {OVR_BRIGHTWHITE,   OVR_GRAY },
    {OVR_GRAY,   	OVR_GRAY },
    {OVR_GRAY,   	OVR_WHITE},
    {OVR_GRAY,   	OVR_WHITE},
  
    OVR_DrawLabel
  },

  /* function key F2 */ {
    BX_F2, BY_F2, BW_F2, BH_F2,
    {OVR_WHITE,  OVR_WHITE},
    {OVR_GRAY,   OVR_GRAY },
    {OVR_WHITE,  OVR_GRAY },
    {OVR_BRIGHTWHITE,      OVR_GRAY },
    {OVR_GRAY,   OVR_GRAY },
    {OVR_GRAY,   OVR_WHITE},
    {OVR_GRAY,   OVR_WHITE},
  
    OVR_DrawLabel
  },

  /* function key F3 */ {
    BX_F3, BY_F3, BW_F3, BH_F3,
    {OVR_WHITE,  OVR_WHITE},
    {OVR_GRAY,   OVR_GRAY },
    {OVR_WHITE,  OVR_GRAY },
    {OVR_BRIGHTWHITE,      OVR_GRAY },
    {OVR_GRAY,   OVR_GRAY },
    {OVR_GRAY,   OVR_WHITE},
    {OVR_GRAY,   OVR_WHITE},
  
    OVR_DrawLabel
  },

  /* function key F4 */ {
    BX_F4, BY_F4, BW_F4, BH_F4,
    {OVR_WHITE,  OVR_WHITE},
    {OVR_GRAY,   OVR_GRAY },
    {OVR_WHITE,  OVR_GRAY },
    {OVR_BRIGHTWHITE,      OVR_GRAY },
    {OVR_GRAY,   OVR_GRAY },
    {OVR_GRAY,   OVR_WHITE},
    {OVR_GRAY,   OVR_WHITE},
  
    OVR_DrawLabel
  },

  /* function key F5 */ {
    BX_F5, BY_F5, BW_F5, BH_F5,
    {OVR_WHITE,  OVR_WHITE},
    {OVR_GRAY,   OVR_GRAY },
    {OVR_WHITE,  OVR_GRAY },
    {OVR_BRIGHTWHITE,      OVR_GRAY },
    {OVR_GRAY,   OVR_GRAY },
    {OVR_GRAY,   OVR_WHITE},
    {OVR_GRAY,   OVR_WHITE},
  
    OVR_DrawLabel
  },

  /* function key F6 */ {
    BX_F6, BY_F6, BW_F6, BH_F6,
    {OVR_WHITE,  OVR_WHITE},
    {OVR_GRAY,   OVR_GRAY },
    {OVR_WHITE,  OVR_GRAY },
    {OVR_BRIGHTWHITE,      OVR_GRAY },
    {OVR_GRAY,   OVR_GRAY },
    {OVR_GRAY,   OVR_WHITE},
    {OVR_GRAY,   OVR_WHITE},
  
    OVR_DrawLabel
  },

  /* function key F7 */ {
    BX_F7, BY_F7, BW_F7, BH_F7,
    {OVR_WHITE,  OVR_WHITE},
    {OVR_GRAY,   OVR_GRAY },
    {OVR_WHITE,  OVR_GRAY },
    {OVR_BRIGHTWHITE,      OVR_GRAY },
    {OVR_GRAY,   OVR_GRAY },
    {OVR_GRAY,   OVR_WHITE},
    {OVR_GRAY,   OVR_WHITE},
  
    OVR_DrawLabel
  },

  /* function key F8 */ {
    BX_F8, BY_F8, BW_F8, BH_F8,
    {OVR_WHITE,  OVR_WHITE},
    {OVR_GRAY,   OVR_GRAY },
    {OVR_WHITE,  OVR_GRAY },
    {OVR_BRIGHTWHITE,      OVR_GRAY },
    {OVR_GRAY,   OVR_GRAY },
    {OVR_GRAY,   OVR_WHITE},
    {OVR_GRAY,   OVR_WHITE},
  
    OVR_DrawLabel
  },

  /* function key F9 */ {
    BX_F9, BY_F9, BW_F9, BH_F9,
    {OVR_WHITE,  OVR_WHITE},
    {OVR_GRAY,   OVR_GRAY },
    {OVR_WHITE,  OVR_GRAY },
    {OVR_BRIGHTWHITE,      OVR_GRAY },
    {OVR_GRAY,   OVR_GRAY },
    {OVR_GRAY,   OVR_WHITE},
    {OVR_GRAY,   OVR_WHITE},
  
    OVR_DrawLabel
  },

  /* function key F10 */ {
    BX_F10, BY_F10, BW_F10, BH_F10,
    {OVR_WHITE,  OVR_WHITE},
    {OVR_GRAY,   OVR_GRAY },
    {OVR_WHITE,  OVR_GRAY },
    {OVR_BRIGHTWHITE,      OVR_GRAY },
    {OVR_GRAY,   OVR_GRAY },
    {OVR_GRAY,   OVR_WHITE},
    {OVR_GRAY,   OVR_WHITE},
  
    OVR_DrawLabel
  }
};

/* Extra buttons definitions to be used when */
/* grabbing_mode is defferent from NORMAL    */
BUTTON  Sbutton[] = {
  /* function key F5 */ {
    SBX_F5, SBY_F5, SBW_F5, SBH_F5,
    {OVR_WHITE,  OVR_WHITE},
    {OVR_GRAY,   OVR_GRAY },
    {OVR_WHITE,  OVR_GRAY },
    {OVR_BRIGHTWHITE,      OVR_GRAY },
    {OVR_GRAY,   OVR_GRAY },
    {OVR_GRAY,   OVR_WHITE},
    {OVR_GRAY,   OVR_WHITE},
  
    OVR_DrawLabel
  },

  /* function key F6 */ {
    SBX_F6, SBY_F6, SBW_F6, SBH_F6,
    {OVR_WHITE,  OVR_WHITE},
    {OVR_GRAY,   OVR_GRAY },
    {OVR_WHITE,  OVR_GRAY },
    {OVR_BRIGHTWHITE,      OVR_GRAY },
    {OVR_GRAY,   OVR_GRAY },
    {OVR_GRAY,   OVR_WHITE},
    {OVR_GRAY,   OVR_WHITE},
  
    OVR_DrawLabel
  }
};

/* The following initializes the label[] structure. LABEL is used 
 * inconjunction with BUTTON. Please refer to the typedef's in
 * OVRMENU.H for a complete description of LABEL and BUTTON. */
LABEL label[] = {
  /* function key F1 */ {
    F1, OFF, DISABLED,
    BX_F1 +9, BY_F1 +6,
    {OVR_GRAY, OVR_RED},
    {"F1 W+",  "F1 W+" },
  
    NULL
  },

  /* function key F2 */ {
    F2, OFF, DISABLED,
    BX_F2 +9, BY_F2 +6,
    {OVR_GRAY, OVR_RED},
    {"F2 W-",  "F2 W-"},
  
    NULL
  },

  /* function key F3 */ {
    F3, OFF, DISABLED,
    BX_F3 +9, BY_F3 +6,
    {OVR_GRAY, OVR_RED},
    {"F3 B+",  "F3 B+"},
  
    NULL
  },

  /* function key F4 */ {
    F4, OFF, DISABLED,
    BX_F4 +9, BY_F4 +6,
    {OVR_GRAY, OVR_RED},
    {"F4 B-",  "F4 B-"},
  
    NULL
  },

  /* function key F5 */ {	/* NOTE: This definition is valid when */
    F5, OFF, DISABLED,		/* grabbing_mode is set to NORMAL only */
    BX_F5 +9, BY_F5 +6,
    {OVR_GRAY, OVR_RED},
    {"F5  - Auto Calibrate",  "F5  - Auto Calibrate"},
  
    NULL
  },

  /* function key F6 */ {	/* NOTE: This definition is valid when */
    F6, OFF, DISABLED,		/* grabbing_mode is set to NORMAL only */
    BX_F6 +9, BY_F6 +6,
    {OVR_GRAY, OVR_RED},
    {"F6  - View Image",  "F6  - View Image"},
  
    NULL
  },

  /* function key F7 */ {
    F7, OFF, DISABLED,
    BX_F7 +9, BY_F7 +6,
    {OVR_GRAY, OVR_RED},
    {"F7  - Histogram", "F7  - No Histogram"},
  
    NULL
  },

  /* function key F8 */ {
    F8, OFF, DISABLED,
    BX_F8 +9, BY_F8 +6,
    {OVR_GRAY, OVR_RED},
    {"F8  - Smoothing", "F8  - No Smoothing"},
  
    NULL
  },

  /* function key F9 */ {
    F9, OFF, ENABLED,
    BX_F9 +9, BY_F9 +6,
    {OVR_GRAY, OVR_RED},
    {"F9  - Continuous Grab", "F9  - Stop Grabbing"},
  
    NULL
  },

  /* function key F10 */ {
    F10, OFF, DISABLED,
    BX_F10 +9, BY_F10 +6,
    {OVR_GRAY,           OVR_RED},
    {"F10 - Exit Program",   "F10 - Exit Program"},
  
    NULL
  }
};

/* Extra label definitions to be used when */
/* grabbing_mode is defferent from NORMAL  */
LABEL Slabel[] = {
  /* function key F5 */ {
    F5, OFF, DISABLED,
    SBX_F5 +9, SBY_F5 +6,
    {OVR_GRAY, OVR_RED},
    {"F5 X+",  "F5 X+"},
  
    NULL
  },

  /* function key F6 */ {
    F6, OFF, DISABLED,
    SBX_F6 +9, SBY_F6 +6,
    {OVR_GRAY, OVR_RED},
    {"F6 X-",  "F6 X-"},
  
    NULL
  }
};

/********************************************************************/
/* Image-Series overlay Look-Up-Table data.  Here, we are using the */
/* universal color dosages defined in GRAPH.H in order to           */
/* always get the same colors whether we use the                    */
/* IM-640/IM-1280 overlay buffer or the VGA for displaying          */
/* the user-interface menus.                                        */
/********************************************************************/
unsigned short	OVR_lutreddata[16] = {
	(unsigned short)(     _BLACK << 2L >> 0L & 0xffL), (unsigned short)(        _BLUE << 2L >> 0L & 0xffL),
	(unsigned short)(     _GREEN << 2L >> 0L & 0xffL), (unsigned short)(        _CYAN << 2L >> 0L & 0xffL),
	(unsigned short)(       _RED << 2L >> 0L & 0xffL), (unsigned short)(     _MAGENTA << 2L >> 0L & 0xffL),
	(unsigned short)(     _BROWN << 2L >> 0L & 0xffL), (unsigned short)(       _WHITE << 2L >> 0L & 0xffL),
	(unsigned short)(      _GRAY << 2L >> 0L & 0xffL), (unsigned short)(   _LIGHTBLUE << 2L >> 0L & 0xffL), 
	(unsigned short)(_LIGHTGREEN << 2L >> 0L & 0xffL), (unsigned short)(   _LIGHTCYAN << 2L >> 0L & 0xffL),
	(unsigned short)(  _LIGHTRED << 2L >> 0L & 0xffL), (unsigned short)(_LIGHTMAGENTA << 2L >> 0L & 0xffL),   
	(unsigned short)(    _YELLOW << 2L >> 0L & 0xffL), (unsigned short)( _BRIGHTWHITE << 2L >> 0L & 0xffL) };

unsigned short	OVR_lutgreendata[16] = {
	(unsigned short)(     _BLACK << 2L >> 8L & 0xffL), (unsigned short)(        _BLUE << 2L >> 8L & 0xffL),
	(unsigned short)(     _GREEN << 2L >> 8L & 0xffL), (unsigned short)(        _CYAN << 2L >> 8L & 0xffL),
	(unsigned short)(       _RED << 2L >> 8L & 0xffL), (unsigned short)(     _MAGENTA << 2L >> 8L & 0xffL),
	(unsigned short)(     _BROWN << 2L >> 8L & 0xffL), (unsigned short)(       _WHITE << 2L >> 8L & 0xffL),
	(unsigned short)(      _GRAY << 2L >> 8L & 0xffL), (unsigned short)(   _LIGHTBLUE << 2L >> 8L & 0xffL), 
	(unsigned short)(_LIGHTGREEN << 2L >> 8L & 0xffL), (unsigned short)(   _LIGHTCYAN << 2L >> 8L & 0xffL),
	(unsigned short)(  _LIGHTRED << 2L >> 8L & 0xffL), (unsigned short)(_LIGHTMAGENTA << 2L >> 8L & 0xffL),   
	(unsigned short)(    _YELLOW << 2L >> 8L & 0xffL), (unsigned short)( _BRIGHTWHITE << 2L >> 8L & 0xffL) };

unsigned short	OVR_lutbluedata[16] = {
	(unsigned short)(     _BLACK << 2L >> 16L & 0xffL), (unsigned short)(        _BLUE << 2L >> 16L & 0xffL),
	(unsigned short)(     _GREEN << 2L >> 16L & 0xffL), (unsigned short)(        _CYAN << 2L >> 16L & 0xffL),
	(unsigned short)(       _RED << 2L >> 16L & 0xffL), (unsigned short)(     _MAGENTA << 2L >> 16L & 0xffL),
	(unsigned short)(     _BROWN << 2L >> 16L & 0xffL), (unsigned short)(       _WHITE << 2L >> 16L & 0xffL),
	(unsigned short)(      _GRAY << 2L >> 16L & 0xffL), (unsigned short)(   _LIGHTBLUE << 2L >> 16L & 0xffL), 
	(unsigned short)(_LIGHTGREEN << 2L >> 16L & 0xffL), (unsigned short)(   _LIGHTCYAN << 2L >> 16L & 0xffL),
	(unsigned short)(  _LIGHTRED << 2L >> 16L & 0xffL), (unsigned short)(_LIGHTMAGENTA << 2L >> 16L & 0xffL),   
	(unsigned short)(    _YELLOW << 2L >> 16L & 0xffL), (unsigned short)( _BRIGHTWHITE << 2L >> 16L & 0xffL) };

/* This function returns the total number of elements in the button[] array */
int GetNumButtons( void )
{
return( (int) (sizeof( button ) / sizeof( button[0])) );
}

/* This function returns the total number of elements in the label[] array */
int GetNumLabels( void )
{
return( (int) (sizeof( label ) / sizeof( label[0])) );
}

