/*/  Function name:  lsdclpl
*
*    Author:   Francois Vigneautl
*    Date:     July 22, 1988
*
*    Modification history:
*
*    Calls:  ioputmbuf:  send multiple buffers of words to the board.
*
*    Uses:  None
*
*    Return value:  None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;
IMPORT  unsigned short _I_PTYPE *i_buffers[];
IMPORT  unsigned short i_ns[];

#define BUFFER_SIZE 3 /* parameters buffer size in words */

#ifdef ANSI
void FTYPE lsdclpl(short id, unsigned short num_clpr, short _I_PTYPE *clip_ptr)
#else
FTYPE lsdclpl(id,num_clpr,clip_ptr)
short  id;
unsigned short num_clpr;
short _I_PTYPE *clip_ptr;
#endif

    {
	unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns;

	
    /* set buffer for parameters */
	ptrbuff = buff;

    *ptrbuff++ = 0x0136;
    *ptrbuff++ = id;
    *ptrbuff = num_clpr;


    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short _I_PTYPE *)buff;
    /* then the clipping list */
    *buffers = (unsigned short _I_PTYPE *)clip_ptr;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = (unsigned short) BUFFER_SIZE;
    /* number of clipping rectangles ( in words ) */
    *ns = num_clpr << 2;

    /* send buffers */
    ioputmbuf ( i_buffers, i_ns, 2 );

    }


