#
# make file to build the IM-1280 C-binding libraries under Microsoft C 5.1
#
# library made : io level, large model, imdrv_l.lib

# Path for the destination libraries
LIBPATH = ..\..\library\msc

# Path for the sources
SRCPATH = ..\..\drivers

# Path for the include files
INC = ..\..\include

# Path for object files
OBJ = ..\..\obj\msc\drivers

# Librarie name
LIBNAME = imdrv_l

# C compiler
CC = cl

# C compiler flags
CFLAGS = -c -AL -Zp1 -G2 -Gs /W3 /DI_USE_ASM /I$(INC)

# librarian
LIB = lib

# librarian flags
LFLAGS =

# objects for the image drivers library
DRVOBJ1 = $(OBJ)\close.obj \
	  $(OBJ)\dmfbarea.obj \
	  $(OBJ)\etag.obj \
	  $(OBJ)\glob.obj \
	  $(OBJ)\ioflush.obj \
	  $(OBJ)\iogetbuf.obj \
	  $(OBJ)\iogeterr.obj \
	  $(OBJ)\iogetf.obj \
	  $(OBJ)\iogetfbu.obj \
	  $(OBJ)\iogetw.obj

DRVOBJ2 = $(OBJ)\ioputbuf.obj \
	  $(OBJ)\ioputf.obj \
	  $(OBJ)\ioputfbu.obj \
	  $(OBJ)\ioputmbu.obj \
	  $(OBJ)\ioputtxt.obj \
	  $(OBJ)\ioputw.obj \
	  $(OBJ)\iostcrps.obj \
	  $(OBJ)\iqrdfifo.obj \
	  $(OBJ)\iqwrfifo.obj \
	  $(OBJ)\itag.obj

DRVOBJ3 = $(OBJ)\ldfbarea.obj \
	  $(OBJ)\lcxiload.obj \
	  $(OBJ)\ldshell.obj \
	  $(OBJ)\lscold.obj \
	  $(OBJ)\lslibsyn.obj \
	  $(OBJ)\lswarm.obj \
	  $(OBJ)\open.obj \
	  $(OBJ)\rdfbarea.obj \
	  $(OBJ)\rdline.obj \
	  $(OBJ)\rdpixel.obj 

DRVOBJ4 = $(OBJ)\rlmemdev.obj \
	  $(OBJ)\rsdevice.obj \
	  $(OBJ)\select.obj \
	  $(OBJ)\slmemdev.obj \
	  $(OBJ)\wrfbarea.obj \
	  $(OBJ)\wrline.obj \
	  $(OBJ)\wrpixel.obj \
	  $(OBJ)\ismovmem.obj \
	  $(OBJ)\imov386.obj \
	  $(OBJ)\mvdword.obj
       
DRVOBJ5 = $(OBJ)\cpuid.obj \
	  $(OBJ)\iostrmsk.obj \
	  $(OBJ)\iostwmsk.obj \
	  $(OBJ)\iostomsk.obj \
	  $(OBJ)\pcabort.obj  \
	  $(OBJ)\pchlpro.obj  \
	  $(OBJ)\jprdmem.obj  \
	  $(OBJ)\jpwrmem.obj  


# make the image drivers library
$(LIBPATH)\$(LIBNAME).lib  : $(DRVOBJ1) $(DRVOBJ2) $(DRVOBJ3) $(DRVOBJ4)\
			     $(DRVOBJ5)

$(OBJ)\CLOSE.obj    : $(SRCPATH)\CLOSE.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DMFBAREA.obj : $(SRCPATH)\DMFBAREA.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\ETAG.obj     : $(SRCPATH)\ETAG.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\GLOB.obj     : $(SRCPATH)\GLOB.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOFLUSH.obj  : $(SRCPATH)\IOFLUSH.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOGETERR.obj : $(SRCPATH)\IOGETERR.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOGETF.obj   : $(SRCPATH)\IOGETF.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOGETFBU.obj : $(SRCPATH)\IOGETFBU.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOGETBUF.obj : $(SRCPATH)\IOGETBUF.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOGETW.obj   : $(SRCPATH)\IOGETW.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOPUTF.obj   : $(SRCPATH)\IOPUTF.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOPUTFBU.obj : $(SRCPATH)\IOPUTFBU.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOPUTMBU.obj : $(SRCPATH)\IOPUTMBU.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOPUTTXT.obj : $(SRCPATH)\IOPUTTXT.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOPUTW.obj   : $(SRCPATH)\IOPUTW.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOSTCRPS.obj : $(SRCPATH)\IOSTCRPS.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOSTRMSK.obj : $(SRCPATH)\IOSTRMSK.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOSTWMSK.obj : $(SRCPATH)\IOSTWMSK.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOSTOMSK.obj : $(SRCPATH)\IOSTOMSK.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IQRDFIFO.obj : $(SRCPATH)\IQRDFIFO.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IQWRFIFO.obj : $(SRCPATH)\IQWRFIFO.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\ITAG.obj     : $(SRCPATH)\ITAG.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\LCXILOAD.obj  : $(SRCPATH)\LCXILOAD.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\LDFBAREA.obj : $(SRCPATH)\LDFBAREA.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\LDSHELL.obj  : $(SRCPATH)\LDSHELL.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\LSCOLD.obj   : $(SRCPATH)\LSCOLD.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\LSLIBSYN.obj : $(SRCPATH)\LSLIBSYN.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\LSWARM.obj   : $(SRCPATH)\LSWARM.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\OPEN.obj     : $(SRCPATH)\OPEN.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\RDFBAREA.obj : $(SRCPATH)\RDFBAREA.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\RDLINE.obj   : $(SRCPATH)\RDLINE.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\RDPIXEL.obj  : $(SRCPATH)\RDPIXEL.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\RLMEMDEV.obj : $(SRCPATH)\RLMEMDEV.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\RSDEVICE.obj : $(SRCPATH)\RSDEVICE.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\SELECT.obj   : $(SRCPATH)\SELECT.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\SLMEMDEV.obj : $(SRCPATH)\SLMEMDEV.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\WRFBAREA.obj : $(SRCPATH)\WRFBAREA.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\WRLINE.obj   : $(SRCPATH)\WRLINE.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\WRPIXEL.obj  : $(SRCPATH)\WRPIXEL.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IOPUTBUF.obj : $(SRCPATH)\IOPUTBUF.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\ISMOVMEM.obj : $(SRCPATH)\ISMOVMEM.asm
	MASM /Ml $(SRCPATH)\$*.asm, $(OBJ)\$*.obj,,;
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\CPUID.obj    : $(SRCPATH)\CPUID.asm
	MASM /Ml $(SRCPATH)\$*.asm, $(OBJ)\$*.obj,,;
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\MVDWORD.obj  : $(SRCPATH)\MVDWORD.asm
	MASM /Ml $(SRCPATH)\$*.asm, $(OBJ)\$*.obj,,;
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\IMOV386.obj  : $(SRCPATH)\IMOV386.asm
	MASM /Ml $(SRCPATH)\$*.asm, $(OBJ)\$*.obj,,;
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCABORT.obj  : $(SRCPATH)\PCABORT.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCHLPRO.obj  : $(SRCPATH)\PCHLPRO.c
    $(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
    $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\JPRDMEM.obj  : $(SRCPATH)\JPRDMEM.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\JPWRMEM.obj  : $(SRCPATH)\JPWRMEM.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

#$(OBJ)\IOPUTBUF.obj : $(SRCPATH)\IOPUTBUF.asm
#       MASM /Ml $(SRCPATH)\$*.asm, $(OBJ)\$*.obj,,;
#       $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;
#

#$(OBJ)\IOGETBUF.obj : $(SRCPATH)\IOGETBUF.asm
#       MASM /Ml $(SRCPATH)\$*.asm, $(OBJ)\$*.obj,,;
#       $(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;
#
