/*
    filename :  iogeterr.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#define ERRBITCLR   0x40

extern  I_IMGLOB    i_glob;

/*/     Function:   iogeterror()
*       Synopsis:   This routine returns a words from the error buffer.
*
*       Date:       Febuary 17th 1990.
*       param:      --- none ---
*                                               
*       returns:    error code.
*
*       Anything requiring clarification:   Calling this error with an
*                                           empty error buffer will apparently
*                                           hang the system.
**/

#ifdef ANSI
short FTYPE iogeterror(void)
#else
short FTYPE iogeterror()
#endif
{
    short   error;

    /* get error from register */
    error = i_glob.imghra -> error;

    /* clear error condition */
    i_glob.imghra -> error = 0;

    /* clear interrupt condition */
    i_glob.imghra -> host_iid = ERRBITCLR;

    /* MTX: 93/10/04 */
    /* MTX: Added this line to clear again the error condition register */
    i_glob.imghra -> error = 0;

    return( error );

} /* iogeterror() */ 

