#
# makefile to build the im-1280 C-binding libraries under Turbo C++ 1.0
#
# library made : image drivers , imdrv_l.lib

# Path for library
LIBPATH= ..\..\library\tcpp

# Path for the sources
.PATH.c = ..\..\drivers

.PATH.asm = ..\..\drivers

# Path for the include files
INC = ..\..\include

# Path for object files
.PATH.obj = ..\..\obj\tcpp\drivers

# librarie name
LIBNAME = imdrv_l

# C compiler
CC = tcc

# C compiler flags
CFLAGS = -c -1 -ml -K -N- -ff- -I$(INC) -DI_USE_ASM

# librarian
LIB = tlib

# librarian flags
LFLAGS =

# implicit rules
.c.obj:
    $(CC) $(CFLAGS) -o$(.PATH.obj)\$& $<
	$(LIB) $(LIBPATH)\$(LIBNAME).lib $(LFLAGS) -+$(.PATH.obj)\$&

.asm.obj:
    TASM -Ml $<, $(.PATH.obj)\$&
	$(LIB) $(LIBPATH)\$(LIBNAME).lib $(LFLAGS) -+$(.PATH.obj)\$&

# objects for the image drivers library
DRVOBJ = close.obj \
        dmfbarea.obj \
        etag.obj \
        glob.obj \
        ioflush.obj \
        iogetbuf.obj \
        iogeterr.obj \
        iogetf.obj \
        iogetfbu.obj \
        iogetw.obj \
        ioputbuf.obj \
        ioputf.obj \
        ioputfbu.obj \
        ioputmbu.obj \
        ioputtxt.obj \
        ioputw.obj \
        iostcrps.obj \
        iostrmsk.obj \
        iostwmsk.obj \
        iostomsk.obj \
        iqrdfifo.obj \
        iqwrfifo.obj \
        itag.obj \
        ldfbarea.obj \
	lcxiload.obj\
	ldshell.obj \
        lscold.obj \
        lslibsyn.obj \
        lswarm.obj \
        open.obj \
        rdfbarea.obj \
        rdline.obj \
        rdpixel.obj \
        rlmemdev.obj \
        rsdevice.obj \
        select.obj \
        slmemdev.obj \
        wrfbarea.obj \
        wrline.obj \
        wrpixel.obj \
        ismovmem.obj \
        imov386.obj \
	cpuid.obj \
        mvdword.obj \
       	pcabort.obj \
       	pchlpro.obj \
	jprdmem.obj \
	jpwrmem.obj 

# make the image drivers library
$(LIBPATH)\$(LIBNAME).lib  : $(DRVOBJ)



