/**************************START OF SPECIFICATIONS *************************
 *
 * SOURCE FILE NAME: AUDDEF.H
 *
 * DESCRIPTIVE NAME: All #define's for AUDIO DD common routines
 *
 * STATUS: OS/2 Release 2.0, 1.3, and DOS 3.3+
 *
 * NOTE:
 *   DEPENDENCIES:
 *   RESTRICTIONS:
 *
 * MODIFICATION HISTORY:
 * DATE      DATE   CHANGE DESCRIPTION
 * 05/29/92  BRR??? - Creation of this file from AUDIODD2.H
 *****************************************************************************/
#define DEBUG        0

#ifndef NUM_TRACKS            /* If number of tracks was not specified       */
#define NUM_TRACKS   1        /* then default to just one track              */
#endif

#if IS_OS2
   #if IS_K12
      #define OS2_K12 1
   #else
      #define OS2_K12 0
   #endif

   #define NOT_DOS_K12 1
   #define NOT_OS2 0
#else
   #if IS_K12
      #define DOS_K12 1
      #define NOT_DOS_K12 0
   #else
      #define DOS_K12 0
      #define NOT_DOS_K12 1
   #endif

   #define NOT_OS2 1
#endif

#if IS_K12                    /* For K12 drivers, use small buffers to       */
#define RBUFFERSIZE     16    /* conserve space/size                         */
#define XBUFFERSIZE     16
#define NOT_K12 0
#else
#define RBUFFERSIZE     512
#define XBUFFERSIZE     512
#define NOT_K12 1
#endif

#if IS_WIN
#define NOT_WIN 0
#else
#define NOT_WIN 1
#endif

/*****************************************************************************/
/* More than one track - then variables are defined as arrays                */
/*****************************************************************************/
#if NUM_TRACKS > 1
#define APP_VERSION           app_version[trk]
#define BITS_PER_SAMPLE_G     bits_per_sample[trk]
#define BSIZE_G               bsize[trk]
#define BYTE2                 byte2[trk]
#define CALLBACK_FUNC         callback_func[trk]
#define CALLBACK_SEM          callback_sem[trk]
#define CB_STATUS             cb_status[trk]
#define CHANNELS_G            channels[trk]
#define CUROUTSTAT            curoutstat[trk]
#define FLAGS_G               flags[trk]
#define FREE_REQ              free_req[trk]
#define GDTRECBUF             GDTrecbuf[trk]
#define GDTRECIO              GDTrecio[trk]
#define GDTSELECTOR1          GDTselector1[trk]
#define GDTSELECTOR2          GDTselector2[trk]
#define GDTSELECTOR3          GDTselector3[trk]
#define GDTSELECTOR4          GDTselector4[trk]
#define GDTXMITBUF            GDTxmitbuf[trk]
#define GDTXMITIO             GDTxmitio[trk]
#define HPILOCK               hpilock[trk]
#define INITFLAGS             initflags[trk]
#define IRDATA                irdata[trk]
#define IRIOBUF               iriobuf[trk]
#define IXDATA                ixdata[trk]
#define IXIOBUF               ixiobuf[trk]
#define LAST_REC_HEAD_SEGNUM  last_rec_head_segnum[trk]
#define LAST_REC_TAIL_SEGNUM  last_rec_tail_segnum[trk]
#define LAST_TIME             last_time[trk]
#define LAST_XMIT_HEAD_SEGNUM last_xmit_head_segnum[trk]
#define LAST_XMIT_TAIL_SEGNUM last_xmit_tail_segnum[trk]
#define MAX_BUFFER_COUNT      max_buffer_count[trk]
#define MIDIFLAGS             midiflags[trk]
#define MODE_G                mode[trk]
#define NUM_REQS              num_reqs[trk]
#define OPENCOUNT             opencount[trk]
#define OPERATION_G           operation[trk]
#define POS_BUFFER_COUNT      pos_buffer_count[trk]
#define POSITION_TYPE_G       position_type[trk]
#define PPQN                  ppqn[trk]
#define PPQNCNTR              ppqncntr[trk]
#define PPQNDIV               ppqndiv[trk]
#define PREV_RECIO_COUNT      prev_recio_count[trk]
#define PREV_XMITIO_COUNT     prev_xmitio_count[trk]
#define PRVTIMECOUNTLO        prvtimecountlo[trk]
#define PRVTIMECOUNTHI        prvtimecounthi[trk]
#define PRVTIMEMSG            prvtimemsg[trk]
#define QUEUE_LOCK            queue_lock[trk]
#define REC_BUFFER_ARRAY      rec_buffer_array[trk]
#define REC_INTERNAL          rec_internal[trk]
#define REC_MAX_NUM_BUFFERS   rec_max_num_buffers[trk]
#define RECBUF                recbuf[trk]
#define RECIO                 recio[trk]
#define RECMAX                recmax[trk]
#define REQ_Q                 req_q[trk]
#define REQ_Q_HEAD            req_q_head[trk]
#define ROLLOVER_TIME         rollover_time[trk]
#define SRATE_G               srate[trk]
#define SRHEAD                Srhead[trk]
#define SRTAIL                Srtail[trk]
#define SXHEAD                Sxhead[trk]
#define SXTAIL                Sxtail[trk]
#define SYSEX_COUNT           sysex_count[trk]
#define SYSEX_SAVE            sysex_save[trk]
#define TEMPO                 tempo[trk]
#define TIMINGFLAGS           timingflags[trk]
#define TRK_ARRAY             trk_array[trk]
#define TRK_HVDM              trk_hvdm[trk]
#define TRK_MODE              trk_mode[trk]
#define V86_MODE              V86_mode[trk]
#define VCB_HNDL              VCB_Hndl[trk]
#define XMIT_BUFFER_ARRAY     xmit_buffer_array[trk]
#define XMIT_INTERNAL         xmit_internal[trk]
#define XMIT_MAX_NUM_BUFFERS  xmit_max_num_buffers[trk]
#define XMITBUF               xmitbuf[trk]
#define XMITIO                xmitio[trk]
#define XMITMAX               xmitmax[trk]
/*****************************************************************************/
/* OS/2 Specific for more than 1 track                                       */
/*****************************************************************************/
#if IS_OS2
#define TRK_ASSIGNED_AT_INIT  trk_assigned_at_init[trk]
#define LAST_REPORTED_TIME    last_reported_time[trk]
#endif
/*****************************************************************************/
/* NON-K12 Specific for more than 1 track                                    */
/*****************************************************************************/
#if NOT_K12
#define CATCHUP_COUNT         catchup_count[trk]
#define DELAY                 delay[trk]
#endif
/*****************************************************************************/
/* NON-DOS-K12 Specific for more than 1 track                                */
/*****************************************************************************/
#if NOT_DOS_K12
#define NOTIFY_DEN            notify_den[trk]
#define NOTIFY_NUM            notify_num[trk]
#endif

/*****************************************************************************/
/* 1 Track                                                                   */
/*****************************************************************************/
#else
#define APP_VERSION           app_version
#define BITS_PER_SAMPLE_G     bits_per_sample
#define BSIZE_G               bsize
#define BYTE2                 byte2
#define CALLBACK_FUNC         callback_func
#define CALLBACK_SEM          callback_sem
#define CB_STATUS             cb_status
#define CHANNELS_G            channels
#define CUROUTSTAT            curoutstat
#define FLAGS_G               flags
#define FREE_REQ              free_req
#define GDTRECBUF             GDTrecbuf
#define GDTRECIO              GDTrecio
#define GDTSELECTOR1          GDTselector1
#define GDTSELECTOR2          GDTselector2
#define GDTSELECTOR3          GDTselector3
#define GDTSELECTOR4          GDTselector4
#define GDTXMITBUF            GDTxmitbuf
#define GDTXMITIO             GDTxmitio
#define HPILOCK               hpilock
#define INITFLAGS             initflags
#define IRDATA                irdata
#define IRIOBUF               iriobuf
#define IXDATA                ixdata
#define IXIOBUF               ixiobuf
#define LAST_REC_HEAD_SEGNUM  last_rec_head_segnum
#define LAST_REC_TAIL_SEGNUM  last_rec_tail_segnum
#define LAST_TIME             last_time
#define LAST_XMIT_HEAD_SEGNUM last_xmit_head_segnum
#define LAST_XMIT_TAIL_SEGNUM last_xmit_tail_segnum
#define MAX_BUFFER_COUNT      max_buffer_count
#define MIDIFLAGS             midiflags
#define MODE_G                mode
#define NUM_REQS              num_reqs
#define OPENCOUNT             opencount
#define OPERATION_G           operation
#define POS_BUFFER_COUNT      pos_buffer_count
#define POSITION_TYPE_G       position_type
#define PPQN                  ppqn
#define PPQNCNTR              ppqncntr
#define PPQNDIV               ppqndiv
#define PREV_RECIO_COUNT      prev_recio_count
#define PREV_XMITIO_COUNT     prev_xmitio_count
#define PRVTIMECOUNTLO        prvtimecountlo
#define PRVTIMECOUNTHI        prvtimecounthi
#define PRVTIMEMSG            prvtimemsg
#define QUEUE_LOCK            queue_lock
#define REC_BUFFER_ARRAY      rec_buffer_array
#define REC_INTERNAL          rec_internal
#define REC_MAX_NUM_BUFFERS   rec_max_num_buffers
#define RECBUF                recbuf
#define RECIO                 recio
#define RECMAX                recmax
#define REQ_Q                 req_q
#define REQ_Q_HEAD            req_q_head
#define ROLLOVER_TIME         rollover_time
#define SRATE_G               srate
#define SRHEAD                Srhead
#define SRTAIL                Srtail
#define SXHEAD                Sxhead
#define SXTAIL                Sxtail
#define SYSEX_COUNT           sysex_count
#define SYSEX_SAVE            sysex_save
#define TEMPO                 tempo
#define TIMINGFLAGS           timingflags
#define TRK_ARRAY             trk_array
#define TRK_HVDM              trk_hvdm
#define TRK_MODE              trk_mode
#define V86_MODE              V86_mode
#define VCB_HNDL              VCB_Hndl
#define XMIT_BUFFER_ARRAY     xmit_buffer_array
#define XMIT_INTERNAL         xmit_internal
#define XMIT_MAX_NUM_BUFFERS  xmit_max_num_buffers
#define XMITBUF               xmitbuf
#define XMITIO                xmitio
#define XMITMAX               xmitmax
/*****************************************************************************/
/* OS/2 Specific for 1 track                                                 */
/*****************************************************************************/
#if IS_OS2
#define TRK_ASSIGNED_AT_INIT  trk_assigned_at_init
#define LAST_REPORTED_TIME    last_reported_time
#endif
/*****************************************************************************/
/* NON-K12 Specific for 1 track                                              */
/*****************************************************************************/
#if NOT_K12
#define CATCHUP_COUNT         catchup_count
#define DELAY                 delay
#endif
/*****************************************************************************/
/* NON-DOS-K12 Specific for 1 track                                          */
/*****************************************************************************/
#if NOT_DOS_K12
#define NOTIFY_DEN            notify_den
#define NOTIFY_NUM            notify_num
#endif

#endif

#define POS_SEL             0x96
#define POS0                0x100
#define POS1                0x101
#define POS2                0x102

#define EOI                 0x20
#define EOI_PORT            0x20

#define MIDI_MODE           0 /* MIDI must always be 1st entry in mode_table */

#define MAXREQS             8 /* 48 bytes per request */
#define MAX_NUM_BUFFERS     16

#define error               0x8000
#define busy                0x0200
#define done                0x0100

#define write_protect       0
#define device_not_ready    2
#define unknown_command     3
#define write_fault         10
#define read_fault          11
#define general_failure     12

/* midiflags equates        */
#define TIMING_SYSEX_QUEUED 1
#define TIMER_QUEUED        4
#define OUTSYNC             8
#define SYSEX_IN_PROG       0x10
#define THIRDBYTE           0x20
#define ACPA_INOP           0x40
#define ACPA_OPENED         0x80
#define NEW_STATUS          0x100

#define MIDI_ACTIVE         0x200
#define SEM_ACTIVE          0x400
#define ADPCM_ACTIVE        0x800
#define OUTPUT_WAITING      0x1000
#define INPUT_WAITING       0x2000

/* timingflags equates */
#define EXTCLOCKS    0x4000         /* 4000 = Slave to external Timing Clocks*/
#define OUTPUT_TIMING_CLOCKS 0x2000 /* 2000 = Output Timing Clocks         */
#define INPUT_TIMING_CLOCKS 0x1000  /* 1000 = Input Timing Clocks          */
#define SYNC_OUTPUT  0x0800         /* 0800 = Sync Output to Timing Clocks */
#define COMPRESS_TIMING_CLOCKS 0x0400 /* 0400 = Compress Timing Clocks     */
#define EXTERNAL_MTC 0x0040         /* 0040 = Slave to external MTC        */
#define OUTPUT_MTC   0x0020         /* 0020 = Output MTC messages          */
#define INPUT_MTC    0x0010         /* 0010 = Input MTC messages           */
#define SYNC_OUTPUT_MTC 0x0008      /* 0008 = Sync Output to MTC           */
#define COMPRESS_MTC 0x0004         /* 0004 = Compress MTC (drop middle messages)*/
#define MTC_24       0x0000         /* 0003 = 0 24 frames/second           */
#define MTC_25       0x0001         /*        1 25 frames/second           */
#define MTC_29       0x0002         /*        2 30 frames/second (Non-drop)*/
#define MTC_30       0x0003         /*        3 30 frames/second (drop frame)*/

/* Defines for check_wrap call */
#define  HEAD     0
#define  TAIL     1
#define  TX       0
#define  RX       1

#define VERSION_01000005 0x01000005

/* mode_data.dont_care definitions */
#define  DATAFLAGS   0x01           /* If set, then ignore flags           */
#define  BPS         0x02           /* If set, then ignore bits_per_sample */
#define  SRATE       0x04           /* If set, then ignore srate           */
#define  CHANNELS    0x08           /* If set, then ignore channels        */
#define  BSIZE       0x10           /* If set, then ignore bsize           */


/* initflags definitions */
#define  INITED         1
#define  WAITING        2

#if IS_OS2

#define VERSION20 0x14

/* GetDOSInfo defines */
#define SysINFOseg      1
#define LocINFOseg      2

/* typeProcess defines */
#define LIS_PT_REALMODE 1

/* Trk_Mode defines */
#define PROTMODE 0
#define REALMODE 1

#endif
