;*****************************************************************************
;                                 DOSDD.ASM
;
;                          Written by Ron Lisle
;
; This module contains the skeleton for a DOS mode AUDIO Device Driver.
; All routines and data are device-independent.  Functions and/or data
; unique to any given device are contained in a separate file named so
; as to identify the specific device (for example, ACPA.C).
;
; Refer to the AUDIODD SCRIPT file for detailed information about AUDIODD.
;
;                          Last update:  07/12/91
;
; 61491  RJL  Added @K12 changes for K12 Wave-Only driver (no MIDI)
; 71091  RJL  Added shared int support, and global rearm for IRQ7
; 71291  RJL  FreeDevInt changed to restore bit to previous level
; 8/19/91 RJL83 Fixed problem with IRQ's > 9
; 9/11/91 BRR63 Don't call aud_control - done in ACPA.C DevInt now
; 9/12/91 BRR64 Timer accuracy modifications - support of PS/1
; 9/19/91 BRR79 Change Int1C_* vars to capital letters
; 9/24/91 BRR84 Change message display
;10/07/91 BRR109 Modifications for PS1 not recording correctly
;10/17/91 DHH911017 added support for position to record
;10/22/91 BRR108 Combined Windows
;11/12/91 BRR185 Push TRACK onto the stack in DIRECT_CALL
;11/15/91 BRR191 Return error in status if INIT fails
;1/20/92  DHH910120 added support to stop multiple device driver loads with same name
;2/19/92  BRR186 Add two track support
;4/09/92  BRR368 Fix 2 track problems
;*****************************************************************************

       TITLE  MIDI DOS Device Driver
       .seq                                      ; Use segments in order listed
;************
; Equates
;************
@DEBUG equ 1

IFDEF @K12
@NOT_K12 equ 0
        %out K12 version
ELSE
@NOT_K12 equ 1
ENDIF

IFDEF @ACPA
@NOT_ACPA equ 0
ELSE
@NOT_ACPA equ 1
ENDIF

EOI           equ    20h
EOI_PORT      equ    20h
EOI_PORT2     equ    0a0h
TIMER         equ    40h           ; PC system timer

error         equ    8000H         ; Request block flags bits
busy          equ    0200H
done          equ    0100H
unknown_command equ  0004H
general_failure equ  000CH

;  IOCtl request id definitions
AUDIO_INIT         equ  0
AUDIO_STATUS       equ  1
AUDIO_CONTROL      equ  2
AUDIO_BUFFER       equ  3
AUDIO_LOAD         equ  4
AUDIO_WAIT         equ  5
AUDIO_HPI          equ  6
AUDIO_UPDATE       equ  7
AUDIO_DIAG8_READ   equ  12
AUDIO_DIAG8_WRITE  equ  13
AUDIO_DIAG16_READ  equ  14
AUDIO_DIAG16_WRITE equ  15

;***********************
; Structure definitions
;***********************
RH            struc                ; Request Header
RHlen         db     ?
RHunit        db     ?
RHcommand     db     ?
RHstatus      dw     ?
RHres         db     8 dup (?)
RHdata        db     ?             ; Input/Output media descriptor byte
IOBufAddr     dd     ?             ; Input/Output buffer address
IOBufLen      dw     ?
RH            ends

;****************
; Segment layout
;****************
dgroup  group   NULL,_DATA,CONST,_BSS,far_BSS
cgroup  group   _TEXT,INIT

NULL    segment word public 'BEGDATA'
NULL    ends

_DATA   segment word public 'DATA'      ; All code and data segments must be
                                        ; named and declared public
_DATA   ends

CONST   segment word public 'CONST'
CONST   ends

FAR_BSS segment word public 'FAR_BSS'
FAR_BSS ends

_BSS   segment word public 'BSS'
_BSS   ends

_TEXT  segment  byte public 'CODE'        ;Define code segment
_TEXT  ends

;***************************************************************************
; Everything in this segment gets thrown away following INIT
;***************************************************************************
INIT   segment word public 'CODE'
resident_end equ $                        ; This defines the end of this module
INIT   ends


;***************
;* Data Segment
;***************
_DATA segment
       assume CS:dgroup,ds:dgroup,es:NOTHING,SS:NOTHING

; Device Header
IFDEF TWO_TRACKS
       dd     head2
ELSE
       dd     -1                   ; -1 dword pointer to next header
ENDIF
       dw     0C840H               ; Char, IOCTL, Open/Close/RM, Out 'til busy
       dw     Offset dgroup:Strat1
       dw     offset dgroup:Int1
aud_name db     'AUDIO'              ; 1st part of device name added name for load check DHH920120
_midinum db   '1$ ',0              ; 2nd part of device name
       public _midinum;

IFDEF TWO_TRACKS                   ; BRR186
head2 equ $
       dd     -1
       dw     0C840H               ; Char, IOCTL, Open/Close/RM, Out 'til busy
       dw     Offset dgroup:Strat2
       dw     Offset dgroup:Int2
       db     'AUDIO'              ; 1st part of device name
_midinum2 db   '2$ ',0             ; 2nd part of device name
       public _midinum2;
ENDIF

extrn _trk_array:word

_num_opens         dw 0             ; current number OPEN
        public  _num_opens          ;
IFDEF TWO_TRACKS
_max_num_opens     dw 2             ; maximum number of OPENs allowed
ELSE
_max_num_opens     dw 1             ; maximum number of OPENs allowed
ENDIF
        public  _max_num_opens

_INT1C_COUNTER      dw     0
       public   _INT1C_COUNTER
_INT1C_DIVISOR      dd     0
       public   _INT1C_DIVISOR
_INT1C_ORIGINAL     dw     0
       public   _INT1C_ORIGINAL
_INT1C_FASTER       dw     0
       public   _INT1C_FASTER
_INT1C_SAVE         dd     0
       public   _INT1C_SAVE

Strat1 proc far
       mov    word ptr cs:rbq1,bx
       mov    word ptr cs:rbq1+2,es
       ret
Strat1 endp

IFDEF TWO_TRACKS
Strat2 proc far
       mov    word ptr cs:rbq2,bx
       mov    word ptr cs:rbq2+2,es
       ret
Strat2 endp
ENDIF

Int1 proc far                 ; rbq -> reqeust block
       push   ax
       push   bx
       push   cx
       push   dx
       push   di
       push   si
       push   bp
       push   ds
       push   es
       mov    ax,dgroup
       mov    ds,ax

       mov    ax,word ptr rbq1+2   ; es:bx = request block
       mov    word ptr rbq+2,ax    ;
       mov    ax,word ptr rbq1     ;
       mov    word ptr rbq,ax      ;
       lea    si,track             ;
       mov    word ptr [si],0      ;
       jmp    short Interrupt

Int1 endp

IFDEF TWO_TRACKS              ;BRR186
Int2 proc far                 ; rbq -> reqeust block
       push   ax
       push   bx
       push   cx
       push   dx
       push   di
       push   si
       push   bp
       push   ds
       push   es
       mov    ax,dgroup
       mov    ds,ax

       mov    ax,word ptr rbq2+2   ; es:bx = request block
       mov    word ptr rbq+2,ax    ;
       mov    ax,word ptr rbq2     ;
       mov    word ptr rbq,ax      ;
       lea    si,track             ;
       mov    word ptr [si],1      ;
       jmp    short Interrupt

Int2 endp
ENDIF

Interrupt proc far                 ; si -> addr of reqeust block queue to use
       public Interrupt

       cmp    stacklock,0                 ; See if we've already been entered
       je     stack_ok
       les    bx,rbq                      ; Get pointer to request block
       mov    es:[bx].RHstatus,busy       ; Set busy bit
       jmp    short stack_err

stack_ok:
       mov    byte ptr stacklock,1                 ; Lock the stack
; Switch Stacks
       mov    ax,dgroup
       mov    SSSAVE,ss
       mov    SPSAVE,sp
       cli                                 ; (redundant)
       mov    ss,ax
       mov    sp,offset dgroup:STACKTOP
       sti                                 ; Ints ON!

       call   far ptr Interrupt_c

       cli
       mov    ss,SSSAVE     ; Restore system stack
       mov    sp,SPSAVE

       mov    byte ptr stacklock,0   ; Release the stack lock
       sti

stack_err:
       pop    es            ; Now restore all other regs
       pop    ds
       pop    bp
       pop    si
       pop    di
       pop    dx
       pop    cx
       pop    bx
       pop    ax
       ret
Interrupt endp

dcstacklock   db     0
dcp    dd     0

__acrtused   dw     0             ; C .OBJ files want one.  They never use it.
      public __acrtused

rbq          dd     0             ; Request Block Queue
rbq1         dd     0             ; Request Block Queue for 1st track
IFDEF TWO_TRACKS                  ; BRR186
rbq2         dd     0             ; Request Block Queue for 2nd track
ENDIF

stacklock     db     0             ; Serialize access to STACK

devstacklock  db     0             ; Serialize access to DevInt stack

IRQnum        db     7             ; Interrupt level = IRQ7
Intmask       db     80h           ; 8259 int bit mask
PrvIntBitmap  db     0
DevVectAddr   dw     0

track        dw     0
IFDEF PS1
segnum        dw     0             ;segnum for check wrap for record
ENDIF
match_found   dw     0
_initcount     dw     0
       public _initcount

_resident_end equ this dword
       public _resident_end
       dw     offset cgroup:resident_end  ; Offset
       dw     cgroup                      ; Segment

      EXTRN  _startmsg0:byte,_startmsg1:byte,_startmsg2:byte,_err_msg_1:byte
      EXTRN _err_msg_2:byte
IFDEF PS1
      EXTRN  _ps1_contrl_flg:word,_cur_ADC_head:dword,_top_of_ADCFIFO:dword
      EXTRN  _bot_of_ADCFIFO:dword,_pcm_underun:byte ;BRR64
      EXTRN  _recio:byte,_recbuf:byte,_adc_stoped:byte
      EXTRN  _cb_status:byte
      EXTRN  _pcm_temp_byte_count:WORD,_bytes_per_millisecond:WORD
      PS1_RELOAD equ 500
ENDIF


ISTACK       dw     256 dup (0)   ; Internal stack
STACKTOP     dw     0             ; Top of stack

IFDEF IS_WIN                      ; BRR108
IHSTACK      dw   8096 dup (0)   ; Interrupt handler stack     KOB
ELSE                             ; BRR108
IHSTACK      dw     256 dup (0)   ; Interrupt handler stack
ENDIF                             ; BRR108
IHSTACKTOP   dw     0             ; Top of int hndlr stack

;IF @NOT_K12                                                           ; 61491
IF @NOT_ACPA
IH0STACK     dw     256 dup (0)   ; Timer Interrupt handler stack
IH0STACKTOP  dw     0             ; Top of int hndlr stack
ENDIF                                                                 ; 61491

DCSTACK      dw     256 dup (0)   ; Direct Call stack
DCSTACKTOP   dw     0             ; Top of direct call stack

SSSAVE       dw     0
SPSAVE       dw     0
IHSSSAVE     dw     0
IHSPSAVE     dw     0
;IF @NOT_K12                                                           ; 61491
IF @NOT_ACPA
IH0SSSAVE    dw     0
IH0SPSAVE    dw     0
ENDIF                                                                 ; 61491
DCSSSAVE     dw     0
DCSPSAVE     dw     0

;***********************************************
; Dummy packet for use by direct call interface
;***********************************************
DPlen         db     0
DPunit        db     0
DPcommand     db     0
DPstatus      dw     0
DPres         db     8 dup (?)
; Union of read/write and general IOCTL packets
DPmedesc      equ    this byte     ; Input/Output media descriptor byte
DPcat         db     80h           ; Gen IOCTL category
DPBufAddr     equ    this dword    ; Input/Output buffer address
DPfunc        db     40h           ; Gen IOCTL function code
DPsi          equ    this word     ; Gen IOCTL SI
              db     0
              db     0
DPdi          equ    this word     ; Gen IOCTL DI
IFDEF  IS_WIN                      ; BRR108
              db     ?             ; KOB
              db     ?
DPBufLen      equ    this word
ELSE                               ; BRR108
              db     0
DPBufLen      equ    this word
              db     0
ENDIF                              ; BRR108
DPData        dd     0             ; Gen IOCTL address of data


NUMFUNCS      equ    12                                            ;BRR206
functbl       dw     offset dc_open              ; 0 = Open
              dw     offset dc_close             ; 1 = Close
              dw     offset dc_read              ; 2 = Read
              dw     offset dc_write             ; 3 = Write
              dw     offset dc_init              ; 4 = AUDIO_INIT
              dw     offset dc_status            ; 5 = AUDIO_STATUS
              dw     offset dc_control           ; 6 = AUDIO_CONTROL
              dw     offset dc_buffer            ; 7 = AUDIO_BUFFER
              dw     offset dc_load              ; 8 = AUDIO_LOAD
              dw     offset dc_wait              ; 9 = AUDIO_WAIT
              dw     offset dc_hpi               ; 10= AUDIO_HPI
              dw     offset dc_update            ; 11= AUDIO_UPDATE  BRR206


IF @DEBUG
TestMsg1 db     'Looking for dup '
TestMsg2 db     'found match     '
TestMsg3 db     'init_err        '
TestMsg4 db     'init_ok         '
TestMsg5 db     'Interrupt       '
TestMsg6 db     'Direct_call_1   '
TestMsg7 db     'Direct_call_2   '
TestMsg8 db     'Entering Init   '
TestMsg9 db     'Exiting Init    '
TestMsg10 db    'Test 10         '
TestRow db      0
TestCol db      0
ENDIF

IFDEF IS_WIN
INTSAVE       dd     0             ; Previous MIDI interrupt vector     KOB
;IF @NOT_K12                       ; 61491                              KOB
IF @NOT_ACPA                                                           ;KOB
INT0SAVE      dd     0             ; Previous Timer interrupt vector    KOB
ENDIF                                                                  ;KOB
ENDIF

_DATA   ends


_TEXT   segment
       assume  CS:_TEXT

       EXTRN  _Strategy_c:NEAR
       EXTRN  _DevInt:NEAR,_DevInit:NEAR
;      EXTRN  _Get_Track:far                                   ; BRR186
;BRR63 EXTRN  _aud_control:near
;IF @NOT_K12
IF @NOT_ACPA
       EXTRN  _TimerInt:NEAR
ENDIF

IFDEF IS_WIN
ELSE
INTSAVE       dd     0             ; Previous MIDI interrupt vector    KOB
;IF @NOT_K12                       ; 61491                             KOB
IF @NOT_ACPA                                                          ;KOB
INT0SAVE      dd     0             ; Previous Timer interrupt vector   KOB
ENDIF                                                                 ;KOB
ENDIF

Interrupt_c proc far
       mov    ax,word ptr rbq+2    ; es:bx = request block  BRR186
       mov    es,ax                ;                        BRR186
       mov    bx,word ptr rbq      ;                        BRR186
;      sub    ax,ax                ; Track ID = 0           BRR186
       mov    ax,track             ;                        BRR368
       push   ax
       push   word ptr rbq+2       ; *rb
       push   word ptr rbq
       call   _Strategy_c
       add    sp,6                 ; discard parms
       ret
Interrupt_c endp

_direct_call_1 proc far            ;BRR186
       public _direct_call_1
       push   bp
       mov    bp,sp
       push   di
       push   si
       push   ds
       push   es
       mov    ax,dgroup                   ; set-up DS
       mov    ds,ax
       lea    si,track
       mov    word ptr [si],0
       jmp    short _direct_call
_direct_call_1 endp

IFDEF TWO_TRACKS                   ;BRR186
_direct_call_2 proc far
       public _direct_call_2
       push   bp
       mov    bp,sp
       push   di
       push   si
       push   ds
       push   es
       mov    ax,dgroup                   ; set-up DS
       mov    ds,ax
       lea    si,track
       mov    word ptr [si],1
       jmp    short _direct_call
_direct_call_2 endp
ENDIF

_direct_call proc far       ; direct_call(int funcid,void far *data, int len)
       public _direct_call

       cmp    dcstacklock,0               ; See if we've already been entered
       je     dc_stack_ok
       jmp    dcstack_err

dc_stack_ok:
       mov    dcstacklock,1               ; Lock the stack
;BRR186IFDEF  IS_WIN                            ; BRR185
;BRR186       mov    ax,+14[bp]                  ; Get Track KOB
;BRR186       mov    track, ax                   ; Store track in local variable KOB
;BRR186ENDIF                                    ; BRR185

; Now build the dummy packet
       mov    bx,+6[bp]                   ; AX = funcid
       cmp    bx,NUMFUNCS
       jl     funcid_ok
       jmp    funcid_err

funcid_ok:
       shl    bx,1                        ; Convert to word
       add    bx,offset functbl           ; Add base of table
       mov    bx,[bx]
       jmp    bx                          ; Go to routine address

dc_open:
       mov    DPlen,13             ; packet size = 13
       mov    DPcommand,13         ; OPEN command
       jmp    dc_doit

dc_close:
       mov    DPlen,13             ; packet size = 13
       mov    DPcommand,14         ; CLOSE command
       jmp    dc_doit

dc_read:
       mov    DPlen,20             ; packet size = 13+7
       mov    DPcommand,4          ; READ command
       mov    ax,+8[bp]            ; Data offset
       mov    dx,+10[bp]           ; Data segment
       mov    word ptr DPBufAddr,ax
       mov    word ptr DPBufAddr+2,dx
       mov    cx,+12[bp]           ; Data length
       mov    DPBufLen,cx
       jmp    dc_doit

dc_write:
       mov    DPlen,20             ; packet size = 13+7
       mov    DPcommand,8          ; WRITE command
       mov    ax,+8[bp]            ; Data offset
       mov    dx,+10[bp]           ; Data segment
       mov    word ptr DPBufAddr,ax
       mov    word ptr DPBufAddr+2,dx
       mov    cx,+12[bp]           ; Data length
       mov    DPBufLen,cx
       jmp    dc_doit

dc_init:
       mov    DPlen,23             ; packet size = 13+10
       mov    DPcommand,19         ; Generic IOCTL command
       mov    DPfunc,40h
       mov    ax,+8[bp]            ; Data offset
       mov    dx,+10[bp]           ; Data segment
       mov    word ptr DPData,ax
       mov    word ptr DPData+2,dx
       jmp    dc_doit

dc_status:
       mov    DPlen,23             ; packet size = 13+10
       mov    DPcommand,19         ; Generic IOCTL command
       mov    DPfunc,41h
       mov    ax,+8[bp]            ; Data offset
       mov    dx,+10[bp]           ; Data segment
       mov    word ptr DPData,ax
       mov    word ptr DPData+2,dx
       jmp    dc_doit

dc_control:
       mov    DPlen,23             ; packet size = 13+10
       mov    DPcommand,19         ; Generic IOCTL command
       mov    DPfunc,42h
       mov    ax,+8[bp]            ; Data offset
       mov    dx,+10[bp]           ; Data segment
       mov    word ptr DPData,ax
       mov    word ptr DPData+2,dx
       jmp    dc_doit

dc_buffer:
       mov    DPlen,23             ; packet size = 13+10
       mov    DPcommand,19         ; Generic IOCTL command
       mov    DPfunc,43h
       mov    ax,+8[bp]            ; Data offset
       mov    dx,+10[bp]           ; Data segment
       mov    word ptr DPData,ax
       mov    word ptr DPData+2,dx
       jmp    short dc_doit


dc_load:
       mov    DPlen,23             ; packet size = 13+10
       mov    DPcommand,19         ; Generic IOCTL command
       mov    DPfunc,44h
       mov    ax,+8[bp]            ; Data offset
       mov    dx,+10[bp]           ; Data segment
       mov    word ptr DPData,ax
       mov    word ptr DPData+2,dx
       jmp    short dc_doit


dc_wait:
       mov    DPlen,23             ; packet size = 13+10
       mov    DPcommand,19         ; Generic IOCTL command
       mov    DPfunc,45h
       mov    ax,+8[bp]            ; Data offset
       mov    dx,+10[bp]           ; Data segment
       mov    word ptr DPData,ax
       mov    word ptr DPData+2,dx
       jmp    short dc_doit

dc_hpi:
       mov    DPlen,23             ; packet size = 13+10
       mov    DPcommand,19         ; Generic IOCTL command
       mov    DPfunc,46h
       mov    ax,+8[bp]            ; Data offset
       mov    dx,+10[bp]           ; Data segment
       mov    word ptr DPData,ax
       mov    word ptr DPData+2,dx
       jmp    short dc_doit

dc_update:
       mov    DPlen,23             ; packet size = 13+10
       mov    DPcommand,19         ; Generic IOCTL command
       mov    DPfunc,47h
       mov    ax,+8[bp]            ; Data offset
       mov    dx,+10[bp]           ; Data segment
       mov    word ptr DPData,ax
       mov    word ptr DPData+2,dx

       ; fall thru to dc_doit

dc_doit:
; Switch Stacks
;      mov    ax,dgroup            ; es:bx = request block  BRR186
;      mov    es,ax                ;                        BRR186
;      mov    bx,offset DPlen      ;                        BRR186
;      call   _Get_Track           ;                        BRR186
;      cmp    ax,-1                ; check if error         BRR186
;      je     funcid_err           ; exit if error          BRR186
       mov    cx,dgroup                   ; dgroup is already in ax
       mov    DCSSSAVE,ss
       mov    DCSPSAVE,sp
       cli                                 ; (redundant)
       mov    ss,cx
       mov    sp,offset dgroup:DCSTACKTOP
       sti                                 ; Ints ON!
;BRR186 IFDEF  IS_WIN                             ; BRR108 BRR185
       mov    ax,track                     ; Get Track KOB
;BRR186ELSE
;BRR186       xor    ax,ax
;BRR186ENDIF                                     ; BRR108 BRR185
       push   ax                           ; KOB

;ENDIF                                     ; BRR108 BRR185
       mov    ax,dgroup
       push   ax
       mov    ax,offset DPlen
       push   ax

       call   _Strategy_c
       mov    ax,DPstatus                   ; BRR188 set up the return code
       xor    ax,0100h                      ; BRR188

       cli
       mov    ss,DCSSSAVE   ; Restore system stack
       mov    sp,DCSPSAVE
       sti

funcid_err:
       mov    dcstacklock,0 ; Release the stack lock

dcstack_err:
       pop    es            ; Now restore all other regs
       pop    ds
       pop    si
       pop    di
       pop    bp
       ret

_direct_call endp

; This is a replacement for the C compiler's stack checking routine.
; It is declared as external by the compiler, but it should never be
; called as we compile with all stack probes removed.
__chkstk proc   near
        public  __chkstk
        pop     cx
        mov     bx,sp
        sub     bx,ax
        mov     sp,bx
        jmp     cx
__chkstk endp

_inpw  proc   near                        ; unsigned int inpw(unsigned int addr);
       public _inpw
       push   bp
       mov    bp,sp
       mov    dx,+4[bp]
       in     ax,dx
       pop    bp
       ret
_inpw  endp

_inp   proc   near                        ; int inp(unsigned int addr);
       public _inp
       push   bp
       mov    bp,sp
       mov    dx,+4[bp]
       in     al,dx
       sub    ah,ah
       pop    bp
       ret
_inp   endp

_outpw  proc  near          ; unsigned int outpw(unsigned addr,unsigned data);
       public _outpw
       push   bp
       mov    bp,sp
       mov    dx,+4[bp]
       mov    ax,+6[bp]
       out    dx,ax
       sub    ax,ax
       pop    bp
       ret
_outpw endp

_outp  proc   near          ; int outp(unsigned int addr,unsigned char data);
       public _outp
       push   bp
       mov    bp,sp
       mov    dx,+4[bp]
       mov    al,+6[bp]
       out    dx,al
       sub    ax,ax
       pop    bp
       ret
_outp  endp

_eoi   proc   near
       public _eoi
       cli                                ; Ints off here!!!
       mov    dx,EOI_PORT                 ; Issue non-specific EOI
       mov    AL,EOI
       out    dx,AL

       cmp    IRQnum,7                    ; RJL-begin
       jg     eoi_high
       ret

eoi_high:
       mov    dx,EOI_PORT2
       out    dx,al                       ; RJL-end
       ret                                ; Return with int's still off
_eoi   endp

_global_rearm proc near                   ; global_rearm(IRQ#)        71291
       public _global_rearm
       push   bp
       mov    bp,sp
       mov    al,+4[bp]                   ; get IRQ#
       cmp    al,9                        ; If IRQ 9, then use 2
       jne    rearm_not9
       mov    al,2
rearm_not9:
       cmp    al,7                        ; IRQ# > 7?                 71091
       ja     rearm_high
       mov    dx,2f0h                     ; For IRQ's 3-7, or 2F2 for IRQ9.
       add    dl,al
       out    dx,al                       ; contents of AL don't matter
       pop    bp
       ret                                ; Return with int's still off
rearm_high:                               ;                           71091
       mov    dx,6f0h                     ; For IRQ's 10-15
       sub    al,8                        ; convert 10-15 to 2-7
       add    dl,al
       out    dx,al
       pop    bp
       ret
_global_rearm endp

;_int3 proc   NEAR                 ; int3(parm1, parm2, parm3, parm4);
;      public _int3
;      push   bp
;      mov    bp,sp
;      mov    ax,+4[bp]
;      mov    bx,+6[bp]
;      mov    cx,+8[bp]
;      mov    dx,+10[bp]
;      int    3
;      pop    bp
;      ret
;_int3 endp

_INIT proc   near          ; init(rb)
      public _INIT
      push   bp
      mov    bp,sp
      push   es

IFDEF TWO_TRACKS                                ;BRR186
      cmp    _initcount,0                       ; Is this the first call? BRR186
      je     first_init                         ;BRR186
      jmp    not_first_init                     ;BRR186
ENDIF                                           ;BRR186
first_init:                                     ;BRR186
IFDEF  IS_WIN
ELSE
      mov   dx,offset dgroup:_startmsg0         ;BRR84
; mov   ah,9
; int   21h                                     ;BRR84
      call write_string

      mov   dx,offset dgroup:_startmsg1
; mov ah,9
; int   21h
      call write_string
ENDIF
      les    bx,+4[bp]
      les    bx,dword ptr es:[bx].IOBufLen  ;  DevInit(((IPKT)rb)->IPktParms);
      push   es
      push   bx
      call   _DevInit
      add    sp,4

      or     ax,ax
      jz     check_dup  ;DHH920120
      jmp    short _init_err

;start DHH920120
check_dup:
        push  ds
        push  bx
        push  di
        push  si
        push  es
        pushf
        cld
        mov ah,52h      ;get list of list
        int 21h
        add bx,22h      ;driver offset, 3.1 and up
        mov ax,es
        push ax
        mov ax,ds
        mov es,ax
        pop ax
dev1:   mov ds,ax
        lea si,[bx+10]  ;load the offset of the device header into di
        mov di,10       ;load the offset of our device name
        test byte ptr [bx+5],80h ;check driver type
        jz dev3         ;is it a bloc
        mov cx,8        ;is char driver
        push di
        push si
        repe cmpsb      ;check if the strings are equal
        pop si
        pop di
        jcxz found_match ;the two strings matched

dev3:
        mov si,bx
        lodsw
        xchg    ax,bx
        lodsw
        cmp bx,0ffffh
        jne dev1
        popf
        pop es
        pop si
        pop di
        pop bx
        pop ds
        jmp short _init_ok

;end DHH 920120
found_match:
        popf
        pop es
        pop si
        pop di
        pop bx
        pop ds
        mov dx,offset dgroup:_err_msg_2
        call write_string

;end DHH 920120

_init_err:
; Issue error message
IFDEF  IS_WIN
ELSE
      mov    dx,offset dgroup:_err_msg_1
; mov    ah,9
; int    21h
      call write_string
ENDIF
      les    bx,+4[bp]                   ; rb->IOBufAddr = NULL;
      mov    word ptr es:[bx].IOBufAddr,0
      mov    word ptr es:[bx].IOBufAddr+2,ds
      or     es:[bx].RHstatus,error+general_failure ; Set error bit   BRR191
      mov    ax,-1                      ; Return an error  RJL 1/31/92
      pop    es
      pop    bp
      ret

_init_ok:
IFDEF  IS_WIN
ELSE
       mov    dx,offset dgroup:_startmsg2
; mov    ah,9
; int    21h
       call write_string
ENDIF
not_first_init:                               ;BRR186
       les    bx,+4[bp]                       ; rb->IOBufAddr = resident_end;
IFDEF  IS_WIN
       mov    ax,0
       mov    word ptr es:[bx].IOBufAddr,ax
       mov    ax,0
       mov    word ptr es:[bx].IOBufAddr+2,ax
ELSE
       mov    ax,word ptr _resident_end
       mov    word ptr es:[bx].IOBufAddr,ax
       mov    ax,word ptr _resident_end+2
       mov    word ptr es:[bx].IOBufAddr+2,ax
       inc    _initcount                      ;BRR186
       mov    ax,0                        ; Return 0 = ok   RJL 1/31/92
ENDIF
       pop    es
       pop    bp
       ret
_INIT endp

;*****************************************
; Hook Device Interrupt   GetDevInt(IRQ#)
;*****************************************
_GetDevInt proc near
       public _GetDevInt

       push   bp
       mov    bp,sp
       push   es
       sub    ax,ax
       mov    es,ax

       mov    bx,+4[bp]                   ; Vector # (2-7)
       mov    IRQnum,bl                   ; Save it                   RJL83
       cmp    bl,7                        ; High irq number?
       jbe    low_irq                     ;  if not, go enable 1st PIC

       add    bx,68h                      ; Set high IRQ number (IRQ9 = 0x71)
       shl    bx,1
       shl    bx,1                        ;  * 4
       mov    DevVectAddr,bx              ;  save addr for later
       mov    ax,es:[bx]                  ; Get current vector
       mov    dx,es:[bx+2]
IFDEF IS_WIN
       mov    word ptr INTSAVE,ax         ; and save it away
       mov    word ptr INTSAVE+2,dx
ELSE
       mov    word ptr CS:INTSAVE,ax      ; and save it away
       mov    word ptr CS:INTSAVE+2,dx
ENDIF
       mov    word ptr es:[bx],offset _TEXT:DevInt       ; Set int handler
       mov    word ptr es:[bx+2],CS

       mov    dx,0a1h                     ;  if so, enable slave PIC
       in     AL,dx                       ; Get 8259 mask
       mov    PrvIntBitmap,AL             ; Save current bitmap
       mov    ah,1                        ;
       mov    CL,IRQnum                   ;                           RJL83
       sub    cl,8                        ; convert 8-f to 0-7 range
       shl    ah,cl
       mov    IntMask,ah                  ; Save our mask for later
       not    ah
       and    AL,ah                       ; Enable IRQ
       out    dx,AL

       sub    ax,ax                       ; Return OK
       pop    es
       pop    bp
       ret

low_irq:                                  ;                           End RJL83
IFDEF  IS_WIN
       mov    ah,35H                      ; Call DOS Get Interrupt Vector
       mov    al,+4[bp]                   ; Vector # (2-7)
       add    al,8                        ; convert IRQ # to vector #
       mov    DevVectAddr,ax              ;  save addr for restore later
       int    21h                         ; Get current vector
       mov    word ptr INTSAVE,bx         ; and save it away KOB
       mov    word ptr INTSAVE+2,es       ; KOB
       push   ds                          ; save DS
       mov    ax,DevVectAddr              ; Call DOS Set Interrupt Vector
       mov    ah,25H
       mov    dx,offset _TEXT:DevInt      ; Set DS:DX = our int handler
       mov    bx,cs
       mov    ds,bx
       int    21h
       pop    ds                          ; restore DS
ELSE
       add    bx,8
       shl    bx,1
       shl    bx,1                        ;  * 4
       mov    DevVectAddr,bx              ;  save addr for later
       mov    ax,es:[bx]                  ; Get current vector
       mov    dx,es:[bx+2]
       mov    word ptr CS:INTSAVE,ax      ; and save it away
       mov    word ptr CS:INTSAVE+2,dx
       mov    word ptr es:[bx],offset _TEXT:DevInt       ; Set int handler
       mov    word ptr es:[bx+2],CS


ENDIF

       in     AL,21H                      ; Get 8259 mask
       mov    PrvIntBitmap,AL             ; Save current bitmap
       mov    ah,1                        ;
       mov    cl,IRQnum                   ;                           RJL83
       shl    ah,cl
       mov    IntMask,ah                  ; Save our mask for later
       not    ah
       and    AL,ah                       ; Enable IRQ
       out    21H,AL

       sub    ax,ax                       ; Return OK
       pop    es
       pop    bp
       ret
_GetDevInt endp

;************************
;* Free Device Interrupt
;************************
_FreeDevInt proc near
       public _FreeDevInt

       push   es

; See if any new ints have been enabled                               71291
       cmp    IRQnum,7                    ;                           RJL83
       jbe    FDlow

       mov    dx,0a1h
       in     AL,dx                       ; Get current int bitmap
       mov    ah,IntMask                  ; Clear our int level bit
       not    ah
       and    al,ah
       mov    ah,IntMask                  ; Now set it if it was before
       and    ah,PrvIntBitmap
       or     AL,ah                       ; Restore 8259 bitmap for our irq
       out    dx,AL
       jmp    short FDall

FDlow:                                    ;                           End RJL83
       in     AL,21h                      ; Get current int bitmap
       mov    ah,IntMask                  ; Clear our int level bit
       not    ah
       and    al,ah
       mov    ah,IntMask                  ; Now set it if it was before
       and    ah,PrvIntBitmap
       or     AL,ah                       ; Restore 8259 bitmap for our irq
       out    21H,AL

FDall:
       sub    ax,ax                       ; Restore Interrupt vector
       mov    es,ax

       mov    bx,DevVectAddr              ; Restore previous vector
IFDEF  IS_WIN                    ; KOB
       mov    ax,word ptr INTSAVE
       mov    dx,word ptr INTSAVE+2
       push   ds                          ; save DS
       mov    ax,DevVectAddr              ; Call DOS Set Interrupt Vector
       mov    ah,25H
       lds    dx,INTSAVE                  ; Set DS:DX = old int handler KOB
       int    21h
       pop    ds                          ; restore DS
ELSE
       mov    ax,word ptr CS:INTSAVE
       mov    dx,word ptr CS:INTSAVE+2
       mov    es:[bx],ax
       mov    es:[bx+2],dx
ENDIF
       pop    es
       ret
_FreeDevInt endp

;IF @NOT_K12                                                           ; 61491
IF @NOT_ACPA
;***************************************
; Get Timer Interrupt     GetTimerInt()
;***************************************
_GetTimerInt proc near
       public _GetTimerInt

       push   es
       sub    ax,ax
       mov    es,ax

       push bx                 ;added to get the aproximate timer setting on entry DHH 8/23/91 BRR64
       push dx
       push cx
       mov  cx,5000h
timegetloop:
       mov al,0
       out TIMER+3,al
       in  al,TIMER
       mov bl,al
       in  al,TIMER
       mov bh,al
       cmp dx,bx
       ja loopout
       mov dx,bx
       mov word ptr _INT1C_ORIGINAL,dx
loopout:
       loop   timegetloop
       pop    cx
       pop    dx
       pop    bx                 ;end added 8/23/91 DHH BRR64


       mov    bx,8*4                      ; Go get Timer interrupt Vector (IRQ0)
       mov    ax,es:[bx]
       mov    dx,es:[bx+2]
IFDEF IS_WIN
       mov    word ptr INT0SAVE,ax
       mov    word ptr INT0SAVE+2,dx
ELSE
       mov    word ptr CS:INT0SAVE,ax
       mov    word ptr CS:INT0SAVE+2,dx
ENDIF

       mov    word ptr es:[bx],offset _TEXT:TimerInt    ; Set IRQ to our hndlr
       mov    word ptr es:[bx+2],CS

       pop    es
       ret
_GetTimerInt endp

;*****************************************
;* Free Timer Interrupt    FreeTimerInt()
;*****************************************
_FreeTimerInt proc near
       public _FreeTimerInt

       push   es
       cli

       mov    AL,36H                      ; Restore Timer values
       out    TIMER+3,AL
       mov    AL,byte ptr _INT1C_ORIGINAL     ;set the original LSB  BRR64
       out    TIMER+0,AL          ;modified to support putting back divisor 8/23/91 DHH BRR64
       jmp    $+2                                               ;BRR64
       mov   AL,byte ptr _INT1C_ORIGINAL+1      ;set the originale MSB devisor BRR64
       out    TIMER+0,AL                  ;  and MSB

       sub    ax,ax                       ; Restore Interrupt vector
       mov    es,ax

       mov    bx,8*4                      ; Restore TIMER int
IFDEF IS_WIN
       mov    ax,word ptr INT0SAVE
       mov    dx,word ptr INT0SAVE+2
ELSE
       mov    ax,word ptr CS:INT0SAVE
       mov    dx,word ptr CS:INT0SAVE+2
ENDIF
       mov    es:[bx],ax
       mov    es:[bx+2],dx
 sti

       pop    es
       ret
_FreeTimerInt endp
ENDIF                                                                 ; 61491

;****************************************************************************
;                       Device Interrupt Handler
; This routine is invoked by the device interrupt.
; It will call the C language interrupt handler _DevInt()
;****************************************************************************

DevInt proc     far
 public DevInt
       push   ax
       push   dx
       push   ds                          ; Save regs needed during EOI at end

       mov    ax,dgroup                   ; Setup ds
       mov    ds,ax

IFDEF PS1                                 ; BRR109 - replaced entire section
       push   bx
       push   es
;       cmp    _pcm_record,0
;       jnz    adc_int                ;then handle the midi int else
        cmp    _adc_stoped,0
        jz    adc_int
        mov    dx,200h                  ;load the port address of the adc
        in     al,dx                    ;read the adc port to reset interrupt
        jmp    not_adc_int

adc_int:
       mov    dx,200h                  ;load the port address of the adc
       cli
       les      bx,DWORD PTR _recio
       les      bx,DWORD PTR es:[bx+4]  ;set bx to the current head of the fifo
       in     al,dx                                                ;read the adc port
;       out    dx,al

       mov    byte ptr es:[bx],al                  ;save the byte to the fifo
;*** ((IOB)RECIO.Ptr)->head++;
        les     bx,DWORD PTR _recio
        inc     WORD PTR es:[bx+4]
;*** ++((IOB)RECIO.Ptr)->count;
        les     bx,DWORD PTR _recio        ;increment the count
        add     WORD PTR es:[bx+16],1      ;
        adc     WORD PTR es:[bx+18],0      ;
        mov     ax,word ptr _top_of_ADCFIFO  ;is this the top of the buffer
        les     bx,DWORD PTR _recio
        cmp     WORD PTR es:[bx+4],ax
        jb      no_wrap1             ;if not the top skip over wrap routine
        jmp     wrap_it
no_wrap1:
        jmp     no_wrap
;       mov     ax,WORD PTR _recbuf+4
;       mov     dx,WORD PTR _recbuf+6
;       les     bx,DWORD PTR _recio
;       mov     WORD PTR es:[bx+4],ax
;       mov     WORD PTR es:[bx+6],dx
;       jmp     jump_over
wrap_it:
;|***  if(segnum >= ((IOB)RECIO.Ptr)->num_buffers-1)
        les     bx,DWORD PTR _recio
        mov     ax,WORD PTR es:[bx+38]
        dec     ax
        cmp     ax,WORD PTR segnum
        ja      no_wrap_segnum
;|***     segnum = 0;
        mov     WORD PTR segnum,0
;|***  else
        jmp     wrapped_segnum
no_wrap_segnum:
;|***    segnum ++;
        inc     WORD PTR segnum
wrapped_segnum:
;|***
;|***  ((IOB)RECBUF.Virt) = ((IOB)RECIO.Ptr)->buf[segnum].Virt;
        mov     cl,4
        mov     bx,WORD PTR segnum
        shl     bx,cl
        add     bx,WORD PTR _recio
        mov     ax,WORD PTR es:[bx+44]
        mov     dx,WORD PTR es:[bx+46]
        mov     WORD PTR _recbuf+4,ax
        mov     WORD PTR _recbuf+6,dx
;|***  RECBUF.length = ((IOB)RECIO.Ptr)->buf[segnum].length;
; Line 19
        mov     ax,WORD PTR es:[bx+40]
        mov     dx,WORD PTR es:[bx+42]
        mov     WORD PTR _recbuf+8,ax
        mov     WORD PTR _recbuf+10,dx

;|***  RECBUF.Ptr = RECBUF.Virt;
; Line 20
        mov     ax,WORD PTR _recbuf+4
        mov     dx,WORD PTR _recbuf+6
        mov     WORD PTR _recbuf,ax
        mov     WORD PTR _recbuf+2,dx

;|***  if(((IOB)RECBUF.Ptr)->runflags & CBIOBUF)
; Line 21
        mov     es,dx
        mov     bx,ax
        test    BYTE PTR es:[bx+29],4
        je      no_status_change
;|***           CB_STATUS |= CBIOBUF;
; Line 22
        or      BYTE PTR _cb_status+1,cl
no_status_change:

;top_of_ADCFIFO = RECBUF.Virt+(unsigned long)(IOB)RECBUF.length;
        mov     ax,WORD PTR _recbuf+4
        add     ax,WORD PTR _recbuf+8
        mov     WORD PTR _top_of_ADCFIFO,ax

;|***                            ((IOB)RECIO.Ptr)->head = RECBUF.Virt;
        mov     ax,WORD PTR _recbuf+4
        mov     dx,WORD PTR _recbuf+6
        les     bx,DWORD PTR _recio
        mov     WORD PTR es:[bx+4],ax
        mov     WORD PTR es:[bx+6],dx
no_wrap:
       sti

; this code is inserted to support position updates on record DHH911017
;|***            if(pcm_temp_byte_count++ >= bytes_per_millisecond)
        mov     ax,WORD PTR _pcm_temp_byte_count
        inc     WORD PTR _pcm_temp_byte_count
        cmp     ax,WORD PTR _bytes_per_millisecond
        jl      no_pos_inc
        mov     WORD PTR _pcm_temp_byte_count,1
;|***       ((IOB)RECIO.Ptr)->position++;             /*  in both buffers           */
        les     bx,DWORD PTR _recio
        add     WORD PTR es:[bx+20],1
        adc     WORD PTR es:[bx+22],0
no_pos_inc:                                                   ;end DHH911017


not_adc_int:
       mov    dx,EOI_PORT          ; Issue non-specific EOI
       mov    AL,EOI
       out    dx,AL
       pop    es
       pop    bx
       jmp    devstack_err
call_int:
       mov    dx,EOI_PORT          ; Issue non-specific EOI
       mov    AL,EOI
       out    dx,AL
       pop    es
       pop    bx

ENDIF                                     ; BRR64 end

       cmp    devstacklock,0              ; See if we've already been entered
       je     dev_stack_ok
       jmp    short devstack_err

dev_stack_ok:
       mov    devstacklock,1              ; Lock the stack

       push   es                          ; Save all other regs
       push   bp
       push   si
       push   di
       push   cx
       push   bx

                                          ; Ints are still off from Int Resp
       mov    IHSSSAVE,ss                 ; Setup our stack
       mov    IHSPSAVE,sp
       mov    ss,ax                       ;  to dgroup:STACKTOP
       mov    sp,offset dgroup:IHSTACKTOP

       sti                                ; Ints on here !!!

;BRR63 mov    ax,0
;BRR63 push   ax
;BRR63 call   _aud_control                ; Go check request_block queue
;BRR63 add    sp,2
       call   _DevInt                     ; Call C interrupt handler

                                          ; ints were turned of in eoi()
       mov    ss,IHSSSAVE                 ; Restore previous stack
       mov    sp,IHSPSAVE
       pop    bx                          ; Restore regs
       pop    cx
       pop    di
       pop    si
       pop    bp
       pop    es

       mov    devstacklock,0       ; Release the stack lock

;!!! Ints not sharable on ISA bus
       or     ax,ax                ; Was this our int?
       jnz    devint_not_ours

       pop    ds
       pop    dx
       pop    ax
       Iret

devint_not_ours:
       pop    ds
       pop    dx
       pop    ax
IFDEF IS_WIN
       jmp    dword ptr INTSAVE
ELSE
       jmp    dword ptr CS:INTSAVE
ENDIF

devstack_err:
       cli                         ; It was our int, so finish up
IFNDEF PS1                         ; BRR64
       mov    dx,EOI_PORT          ; Issue non-specific EOI
       mov    AL,EOI
       out    dx,AL
ENDIF                              ; BRR64
       pop    ds
       pop    dx
       pop    ax
       Iret
DevInt endp

;IF @NOT_K12                                                           ; 61491
IF @NOT_ACPA
;****************************************************************************
;                       System Timer Interrupt handler
; This routine is invoked by the 8253 timer 0 interrupt.  It will down-scale
; the input frequency to 18.2, and pass it on to the original timer interrupt
; handler.
;****************************************************************************

TimerInt proc far                         ; IRQ0 handler
       public TimerInt
       push   ds                          ; Save regs needed during EOI at end
       push   dx
       push   ax
       mov    ax,dgroup                   ; Setup ds
       mov    ds,ax

       push   es                          ; Save all other regs
       push   bp
       push   si
       push   di
       push   cx
       push   bx

                                          ; Ints were turned off by int resp
       mov    IH0SSSAVE,ss                ; Setup our stack
       mov    IH0SPSAVE,sp
       mov    ss,ax                       ;  to dgroup:STACKTOP
       mov    sp,offset dgroup:IH0STACKTOP

       sti                                ; Ints on here!!!

       cmp    _INT1C_FASTER,0             ;is the int1c handler at a higher rate BRR64
       jnz    INT1C_FASTER                ;if at higher rate the call            BRR64

       call   _TimerInt                   ; Call C interrupt handler

       cli                                ; Ints off here!!!
       mov    ss,IH0SSSAVE                ; Restore previous stack
       mov    sp,IH0SPSAVE
       pop    bx                          ; Restore regs
       pop    cx
       pop    di
       pop    si
       pop    bp
       pop    es

       cmp    _INT1C_COUNTER,0            ; BRR64
       jz     no_timer_serv               ;if _int1c_counter already 0 then don't decrement BRR64
       dec    _INT1C_COUNTER              ; divide clock to 18.2 rate                       BRR64
       jz     DO_18_2_int1C               ; Time to call clock tick?                        BRR64

       mov    dx,EOI_PORT                 ; Issue non-specific EOI
       mov    AL,EOI
       out    dx,AL

       pop    ax                          ; All done here
       pop    dx
       pop    ds
       Iret

DO_18_2_int1C:     ;BRR64 - whole function changed
       mov    ax,word ptr _INT1C_DIVISOR                ; Call original int0 vector
       add    ax,word ptr _INT1C_SAVE                   ;add the old remainder
       mov    dx,word ptr _INT1C_DIVISOR+2      ;load the msb of divisor int dx
       adc    dx,word ptr _INT1C_SAVE+2                 ;add the msb of the divisor
       mov    _INT1C_COUNTER,dx
       mov    word ptr _INT1C_SAVE+2,0                  ;be sure the msb of save is clear
       pop    ax
       pop    dx
       pop    ds
IFDEF IS_WIN
       jmp    dword ptr INT0SAVE
ELSE
       jmp    dword ptr CS:INT0SAVE
ENDIF


INT1C_FASTER:
       dec    _INT1C_COUNTER                            ;decrement the count
       jnz    no_timer_serv                             ;jump over the timeint call if not zereo

       call   _TimerInt                                 ; Call C interrupt handler
       mov    ax,word ptr _INT1C_DIVISOR        ; Call original int0 vector
       add    ax,word ptr _INT1C_SAVE           ;add the old remainder
       mov    dx,word ptr _INT1C_DIVISOR+2              ;load the msb of divisor int dx
       adc    dx,word ptr _INT1C_SAVE+2                 ;add the msb of the divisor
       mov    _INT1C_COUNTER,dx         ;reset the counter
       mov    word ptr _INT1C_SAVE+2,0                  ;be sure the msb of save is clear


no_timer_serv:

       cli                                                      ; Ints off here!!!
       mov    ss,IH0SSSAVE                              ; Restore previous stack
       mov    sp,IH0SPSAVE
       pop    bx                                        ; Restore regs
       pop    cx
       pop    di
       pop    si
       pop    bp
       pop    es                                        ;this will call the original int0
       pop    ax                                                ;vector every time through since it
       pop    dx                                                ;is calculated to be at a higer rate
       pop    ds
IFDEF IS_WIN
       jmp    dword ptr INT0SAVE             ;jump to the old vector
ELSE
       jmp    dword ptr CS:INT0SAVE          ;jump to the old vector
ENDIF

TimerInt endp
ENDIF

;***********************
;* DEBUG test routines
;***********************
IF @DEBUG
_TestMsg proc NEAR              ; testmsg(char *msg);
        public  _TestMsg
        push    bp
        mov     bp,sp
        mov     dx,+4[bp]       ; Message must be 16 bytes long!
        call    TestMsg
        pop     bp
        ret
_TestMsg endp

TestMsg proc NEAR               ; dx = offset of Message
        push    ax
        push    bx
        push    cx
        push    bp
        push    es
        mov     ax,dgroup
        mov     es,ax
        mov     bp,dx
        mov     AH,19
        mov     AL,1
        mov     cx,16
        mov     DH,TestRow
        mov     DL,TestCol
        inc     TestRow
        cmp     DH,24
        jb      TestMsg_ROK
        mov     TestRow,0
        add     TestCol,10
        cmp     TestCol,70
        jb      TestMsg_ROK
        mov     TestCol,0
TestMsg_ROK:
        mov     BH,0
        mov     BL,7
        int     10H
        pop     es
        pop     bp
        pop     cx
        pop     bx
        pop     ax
        ret
TestMsg endp
ENDIF
write_string proc near
        push    ax
        push    si
        mov     si,dx
        mov     ah,0eh
        mov     bh,0
next_char:
        mov     al,[si]
        cmp     al,0
        jz      write_done
        int     10h
        inc     si
        jmp     next_char
write_done:
        pop     si
        pop     ax
        ret
write_string endp
_TEXT   ends
        END
