;                               PSPCODE1.PSP
;                       *** IBM INTERNAL USE ONLY ***
;
; This module contains the PSP code for the Color Organ demo program.
; It will input from mic, or line inputs, and determine the energy
; level in 4 audio bands.

; Signed arithmetic:    7FFF = +32768
;                       0000 = +0
;                       FFFF = -1
;                       8000 = -32767

;********************************************
; PSP Internal Data Memory Location equates
;********************************************
; Data page 0 (60-7F)
SST0SAVE        EQU     60H     ; Timer int handler
SST1SAVE        EQU     61H
HOSTINT         EQU     62H     ; 1BCh (line) 1B8h (mic)
HOSTACK         EQU     63H     ; 1DCh (line) 1D8h (mic)
SST0SAVE2       EQU     64H     ; Host int handler
SST1SAVE2       EQU     65H
SST0SAVE3       EQU     66H     ; DAC int handler
SST1SAVE3       EQU     67H
TTEMP           EQU     68H
MAX7FFF         EQU     69H     ; 7FFFH

PAGE4   EQU     200H
PAGE5   EQU     280H
PAGE6   EQU     300H
PAGE7   EQU     380H

; Data Page 4 (B0 200-27F) used during waveform generation

ZERO            EQU     0
ONE             EQU     1
HIGHBIT         EQU     2
TEMP            EQU     3
INPUT           EQU     4       ; Input sample
TSUMHI          EQU     5       ; Temporary sum
TSUMLO          EQU     6       ;
PREVL           EQU     7       ; prev left value for interp
PREVR           EQU     8       ; Prev right value for interp
; High filter - 3200Hz
YN1A            EQU     9       ;
YN2A            EQU     10      ;
YN3A            EQU     11
YN4A            EQU     12
YN5A            EQU     13
B1A             EQU     14      ;
B2A             EQU     15
B3A             EQU     16
B4A             EQU     17
B5A             EQU     18
GAIN1A          EQU     19      ;
GAIN2A          EQU     20      ;
GAIN3A          EQU     21
; mid filter - 800Hz
YN1B            EQU     22      ;
YN2B            EQU     23      ;
YN3B            EQU     24
YN4B            EQU     25
YN5B            EQU     26
B1B             EQU     27      ;
B2B             EQU     28
B3B             EQU     29
B4B             EQU     30
B5B             EQU     31
GAIN1B          EQU     32      ;
GAIN2B          EQU     33      ;
GAIN3B          EQU     34
; low filter - 200Hz
YN1C            EQU     35      ;
YN2C            EQU     36      ;
YN3C            EQU     37
YN4C            EQU     38
YN5C            EQU     39
B1C             EQU     40      ;
B2C             EQU     41
B3C             EQU     42
B4C             EQU     43
B5C             EQU     44
GAIN1C          EQU     45      ;
GAIN2C          EQU     46      ;
GAIN3C          EQU     47
;
TSUMHIA         EQU     48      ; Filter A sum
TSUMLOA         EQU     49      ;
TSUMHIB         EQU     50      ; B
TSUMLOB         EQU     51      ;
TSUMHIC         EQU     52      ; C
TSUMLOC         EQU     53      ;
;
OUTSUM          EQU     54      ; Sum output
OUTSM1          EQU     55      ;       "       minus 1
OUTSM2          EQU     56      ;       "       minus 2
OUTSM3          EQU     57      ;       "       minus 3
OUTA            EQU     58      ; Filter A output
OUTAM1          EQU     59      ;       "       minus 1
OUTAM2          EQU     60      ;       "       minus 2
OUTAM3          EQU     61      ;       "       minus 3
OUTB            EQU     62      ; Filter B output
OUTBM1          EQU     63      ;       "       minus 1
OUTBM2          EQU     64      ;       "       minus 2
OUTBM3          EQU     65      ;       "       minus 3
OUTC            EQU     66      ; Filter C output
OUTCM1          EQU     67      ;       "       minus 1
OUTCM2          EQU     68      ;       "       minus 2
OUTCM3          EQU     69      ;       "       minus 3

; External communication area: 1F80-1FFFH (page 63)
HONE            EQU     0
FREECNTR        EQU     1       ; Free time counter low word
HTEMP           EQU     2
INT0ACK         EQU     3       ; Initialized to int0 ack
DACPTR1         EQU     4       ; current DAC1 bank pointer (4600-47FF)
DACPTR2         EQU     5       ; current DAC2 bank pointer (4200-43FF)
DAC1CMPR        EQU     6       ; AR0 cmpr value for DAC1 (4800)
ACC0SAVEL       EQU     7       ; ACC save during INT0
ACC0SAVEH       EQU     8       ;  "    "       "
READY           EQU     9       ; DAC ready for update flag
ACC1SAVEL       EQU     10      ; ACC save during INT1
ACC1SAVEH       EQU     11      ; "     "       "
ACC2SAVEL       EQU     12      ; ACC save during INT0
ACC2SAVEH       EQU     13      ; "     "       "
ACC3SAVEL       EQU     14      ; ACC save during Timer Int
ACC3SAVEH       EQU     15      ;       "       "       "
PINGPONG        EQU     16      ;
FREECNTRHI      EQU     17      ;

TOTLVL          EQU     114     ; 1FF2 Total sound level
FILLVLA         EQU     115     ; 1FF3 High filter level
FILLVLB         EQU     116     ; 1FF4 mid-high
FILLVLC         EQU     117     ; 1FF5 low-mid

SYSTIMELO       EQU     119     ; 1FF7 systime low word (600 Hz increments)
SYSTIMEHI       EQU     120     ; 1FF8 systime high word
TESTMODE        EQU     121     ; 1FF9  1 if testmode (int check only)
TEST1           EQU     122     ; Tscope Test1 (1FFAH)
TEST2           EQU     123
INPSEL          EQU     124     ; Input Selector (4 = line, 0 = Mic )
FREETIMEHI      EQU     125     ; 1FFD Free time counter high
FREETIME        EQU     126     ; 1FFE Free time counter low word
HOSTFLAG        EQU     127     ; 1FFF presence flag AA55H


        INCLUDE PSPCODE.INC     ; Include PSP opcode equates

; Segment layout

_TEXT SEGMENT BYTE PUBLIC 'CODE'
_TEXT ENDS

NULL    SEGMENT PARA PUBLIC 'BEGDATA'
NULL    ENDS

_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS

CONST SEGMENT WORD PUBLIC 'CONST'
CONST ENDS

_BSS SEGMENT WORD PUBLIC 'BSS'
_BSS ENDS

DGROUP GROUP NULL, _DATA,CONST,_BSS

_TEXT SEGMENT BYTE PUBLIC 'CODE'
        ASSUME  CS:_TEXT,DS:DGROUP,ES:DGROUP,SS:DGROUP
_TEXT   ENDS

_DATA   SEGMENT

        PUBLIC  PSPCODE1,PSPCODE1_END

PSPCODE1 EQU THIS WORD
                        ;       Label   Opcode  Comments
                        ;       _____   ____________    ______________

        DW      B       ; 0     RESETV  B INIT  Branch to RESET routine
        DW      _INIT
        DW      B       ; 2             B INT0  Branch to WFGEN routine
        DW      _INT0
        DW      B       ; 4             B INT1  Branch to HOST INT routine
        DW      _INT1
        DW      B       ; 6             B INT2  Branch to int 2 routine
        DW      _INT2

        DW 16 DUP (0)   ; 8-23  reserved

        DW      B       ; 24            B TIMINT Branch to timer int routine
        DW      _TIMINT
        DW      B       ; 26            B RECINT Branch to receive int routine
        DW      _RECINT
        DW      B       ; 28            B XMITINT Branch to xmit int routine
        DW      _XMITINT
        DW      B       ; 30            B TRAP  Branch to trap int routine
        DW      _TRAP

_RECINT EQU 32          ; Dummy interrupt handler for unused ints
_XMITINT EQU 32
_TRAP   EQU 32
_INT2   EQU 32
        DW      EINT            ; 32    _RECINT EINT    Restore ints
        DW      PSPRET          ; 33            RET     return

;************************************************************************
; Host interrupt routine
;************************************************************************
_INT1 EQU 34                    ; Host interrupt routine - Ack interrupt
        DW      SST+SST0SAVE2   ; 0     SST SST0SAVE    Save regs
        DW      SST1+SST1SAVE2  ; 1     SST1 SST1SAVE
        DW      LDPK+63         ; 2     LDPK 63
        DW      SACL+ACC1SAVEL  ; 3     SACL ACC1SAVEL
        DW      SACH0+ACC1SAVEH ; 4     SACH ACC1SAVEH
_INT1A EQU _INT1+5
        DW      LDPK+63         ;0
        DW      LALK0           ;1      LALK 5A5A       Write Ack flag 5A5A
        DW      5A5AH           ;2
        DW      SACL+HOSTFLAG   ;3      SACL HOSTFLAG
        DW      ZALS+ACC1SAVEL  ;4                      Restore regs
        DW      ADDH+ACC1SAVEH  ;5
        DW      LDPK+0          ;6      LDPK >0
        DW      OUT0+HOSTACK    ;7      OUT HOSTACK,0   output >DC/D8 Ack
        DW      LST1+SST1SAVE2  ;8      LST1 SST1SAVE
        DW      LST+SST0SAVE2   ;9      LST SST0SAVE
        DW      EINT            ;10     EINT
        DW      PSPRET          ;11     RET

;**************************************************************************
;               Timer interrupt routine
;**************************************************************************
_TIMINT EQU _INT1A+12           ; Timer interrupt routine - interrupt host
        DW      SST+SST0SAVE    ;0      Save regs
        DW      SST1+SST1SAVE   ;1
        DW      LDPK+63         ;2
        DW      SACL+ACC3SAVEL  ;3
        DW      SACH0+ACC3SAVEH ;4
        DW      ZALS+SYSTIMELO  ;5      Get 32 bit systime
        DW      ADDH+SYSTIMEHI  ;6
        DW      ADDK+1          ;7      Increment it
        DW      SACL+SYSTIMELO  ;8      and write it back out
        DW      SACH0+SYSTIMEHI ;9
        DW      LDPK+63         ;10
        DW      ZALS+ACC3SAVEL  ;11     Restore ACC
        DW      ADDH+ACC3SAVEH  ;12
        DW      LDPK+0          ;13
        DW      OUT0+HOSTINT    ;14     Int to PC (output >BC/>B8)
        DW      LST1+SST1SAVE   ;15
        DW      LST+SST0SAVE    ;16
        DW      EINT            ;17
        DW      PSPRET          ;18

;***********************************************
; DAC Interrupt routine - approx. 172*2 = 344 Hz
;***********************************************
_INT0 EQU _TIMINT+19
        DW      SST+SST0SAVE3   ;0 _INT0 SST SST0SAVE3  Save
        DW      SST1+SST1SAVE3  ;1      SST1 SST1SAVE3
        DW      LDPK+63         ;2      LDPK >63        Set READY flag
        DW      SACL+ACC0SAVEL  ;3
        DW      SACH0+ACC0SAVEH ;4
        DW      IN0+HTEMP       ;5      IN HTEMP,0      Is DAC1 interrupting us?
        DW      LACK+1          ;6      LACK >1
        DW      PSPAND+HTEMP    ;7      AND HTEMP
        DW      BZ              ;8      BZ _INT0X
        DW      _INT0X          ;9
        DW      SACL+READY      ;10     SACL READY      Yep, set ready flag (1)
        DW      PSPXOR+PINGPONG ;11     XOR PINGPONG    Update pingpong pointer
        DW      SACL+PINGPONG   ;12     SACL PINGPONG   (0=low, 1=high)
_INT0X EQU _INT0+13
        DW      OUT0+INT0ACK    ;13     OUT 0,INT0ACK   Ack interrupt
        DW      ZALS+ACC0SAVEL  ;14
        DW      ADDH+ACC0SAVEH  ;15
        DW      LDPK+0          ;16     LDPK >0         Now return
        DW      LST1+SST1SAVE3  ;17     LST1 SST1SAVE3
        DW      LST+SST0SAVE3   ;18     LST SST0SAVE3
        DW      EINT            ;19     EINT
        DW      PSPRET          ;20     RET
;************************************************************************
;                       Initialization
;************************************************************************
_INIT   EQU     _INT0+21        ; INIT
        DW      SOVM            ;0      Set overflow mode
        DW      SSXM            ;1      Set sign extension mode
        DW      SPML1           ;2      Set P shift mode = 1
        DW      RHM             ;3      Reset hold mode
        DW      CNFD            ;4      Config mem = Data
        DW      LDPK+4          ;5      Initialize to page 4
        DW      ZAC             ;6
        DW      SACL+ZERO       ;7      Set data constants
        DW      SACL+PREVL      ;8
        DW      SACL+PREVR      ;9
        DW      LACK+1          ;10
        DW      SACL+ONE        ;11
        DW      LDPK+63         ;12
        DW      SACL+HONE       ;13
        DW      LDPK+4          ;14

        DW      ZAC             ;15
        DW      SUB0+ONE        ;16
        DW      LDPK+0          ;17     Page 0
        DW      SACL+MAX7FFF    ;18
        DW      LDPK+4          ;19     back to page 4

INIT2 EQU _INIT+20
        DW      LALK0           ;0      Initialize filter constants (4k)
        DW      39030/2         ;1      B1A
        DW      SACL+B1A        ;2
        DW      LALK0           ;3
        DW      -13030          ;4      B2A
        DW      SACL+B2A        ;5
        DW      LALK0           ;6
        DW      47077/2         ;7      B3A
        DW      SACL+B3A        ;8
        DW      LALK0           ;9
        DW      -23040          ;10     B4A
        DW      SACL+B4A        ;11
        DW      LALK0           ;12
        DW      18532           ;13     B5A
        DW      SACL+B5A        ;14
        DW      LALK0           ;15
        DW      6768            ;16     GAIN1A
        DW      SACL+GAIN1A     ;17
        DW      LALK0           ;18
        DW      8730            ;19     GAIN2A
        DW      SACL+GAIN2A     ;20
        DW      LALK0           ;21
        DW      14235           ;22     GAIN3A
        DW      SACL+GAIN3A     ;23
INIT3 EQU INIT2+24
        DW      LALK0           ;0      Initialize filter B constants (1khz)
        DW      58196/2         ;1      B1B
        DW      SACL+B1B        ;2
        DW      LALK0           ;3
        DW      -26021          ;4      B2B
        DW      SACL+B2B        ;5
        DW      LALK0           ;6
        DW      62138/2         ;7      B3B
        DW      SACL+B3B        ;8
        DW      LALK0           ;9
        DW      -30006          ;10     B4B
        DW      SACL+B4B        ;11
        DW      LALK0           ;12
        DW      28417           ;13     B5B
        DW      SACL+B5B        ;14
        DW      LALK0           ;15
        DW      593             ;16     GAIN1B
        DW      SACL+GAIN1B     ;17
        DW      LALK0           ;18
        DW      636             ;19     GAIN2B
        DW      SACL+GAIN2B     ;20
        DW      LALK0           ;21
        DW      4351            ;22     GAIN3B
        DW      SACL+GAIN3B     ;23
INIT4 EQU INIT3+24
        DW      LALK0           ;0      Initialize filter C constants (250Hz)
        DW      63660/2         ;1      B1C
        DW      SACL+B1C        ;2
        DW      LALK0           ;3
        DW      -30932          ;4      B2C
        DW      SACL+B2C        ;5
        DW      LALK0           ;6
        DW      64781/2         ;7      B3C
        DW      SACL+B3C        ;8
        DW      LALK0           ;9
        DW      -32054          ;10     B4C
        DW      SACL+B4C        ;11
        DW      LALK0           ;12
        DW      31621           ;13     B5C
        DW      SACL+B5C        ;14
        DW      LALK0           ;15
        DW      40              ;16     GAIN1C
        DW      SACL+GAIN1C     ;17
        DW      LALK0           ;18
        DW      41              ;19     GAIN2C
        DW      SACL+GAIN2C     ;20
        DW      LALK0           ;21
        DW      1147            ;22     GAIN3C
        DW      SACL+GAIN3C     ;23
INIT5 EQU INIT4+24
        DW      LRLK0           ;0      Clear sample buffers
        DW      4000H           ;1
        DW      LARP0           ;2      select AR0
        DW      ZAC             ;3
        DW      RPTK+255        ;4
        DW      SACL+ARPLUS     ;5      DAC2 0  4000-40FF
        DW      RPTK+255        ;6
        DW      SACL+ARPLUS     ;7      DAC2 1  4100-41FF
        DW      RPTK+255        ;8
        DW      SACL+ARPLUS     ;9      DAC1 0  4200-42FF
        DW      RPTK+255        ;10
        DW      SACL+ARPLUS     ;11     DAC1 1  4300-43FF
        DW      RPTK+255        ;12
        DW      SACL+ARPLUS     ;13     SCR 0   4400-44FF
        DW      RPTK+255        ;14
        DW      SACL+ARPLUS     ;15     SCR 1   4500-45FF
        DW      RPTK+255        ;16
        DW      SACL+ARPLUS     ;17     ADC 0   4600-46FF
        DW      RPTK+255        ;18
        DW      SACL+ARPLUS     ;19     ADC 1   4700-47FF

INIT10 EQU INIT5+20

        DW      LALK0           ;0      Set HOSTINT
        DW      00B7H           ;1      (1BF if line, 0B7 if mic)
        DW      LDPK+63         ;2      Add INPSEL
        DW      PSPOR+INPSEL    ;3
        DW      LDPK+0          ;4
        DW      SACL+HOSTINT    ;5
        DW      LDPK+63         ;6
        DW      LALK0           ;7      Set HOSTACK
        DW      00D7H           ;8      (1DF if line, 1D7 if mic)
        DW      PSPOR+INPSEL    ;9
        DW      LDPK+0          ;10
        DW      SACL+HOSTACK    ;11
        DW      LALK0           ;12     Timer period    (1.6 Msec = 600Hz)
        DW      16666           ;13
        DW      SACL+3          ;14     (TIMEPERIOD)
        DW      SACL+2          ;15     (TIMERREG)

        DW      LDPK+63         ;16
        DW      LALK0           ;17     1EF line, 1EB mic
        DW      00E7H           ;18
        DW      PSPOR+INPSEL    ;19
        DW      SACL+INT0ACK    ;20
        DW      LALK0           ;21
        DW      4000H           ;22
        DW      SACL+DACPTR1    ;23
        DW      LALK0           ;24
        DW      4200H           ;25
        DW      SACL+DACPTR2    ;26
        DW      SACL+DAC1CMPR   ;27
        DW      LALK0           ;28     Write present flag
        DW      55AAH           ;29
        DW      SACL+HOSTFLAG   ;30
;
; Enable ADC & Ints
;
INIT11 EQU INIT10+31
        DW      LDPK+0          ;0      Set IMR = TINT, INT1, INT0
        DW      LACK+0BH        ;1       (INT1=Host, INT0=SP/B)
        DW      SACL+4          ;2
        DW      LDPK+63         ;3
        DW      LALK0           ;4      Reset Cntr, enable ADC, Line input
        DW      0077H           ;5
        DW      PSPOR+INPSEL    ;6
        DW      SACL+READY      ;7
        DW      OUT0+READY      ;8
        DW      LACK+1          ;9
        DW      SACL+READY      ;10     Set ready flag
        DW      EINT            ;11

FREELOOP EQU INIT11+12          ; Page=63, AR=?
        DW      LDPK+63         ;0
        DW      LAC0+READY      ;1      Is DAC ready            2
        DW      BNZ             ;2      If so, go do it 2
        DW      DO_FILTERS      ;3
        DW      ZALS+FREECNTR   ;4      Continuously inc cntr   2
        DW      ADDH+FREECNTRHI ;5
        DW      ADDK+1          ;6
        DW      SACL+FREECNTR   ;7
        DW      SACH0+FREECNTRHI;8
        DW      B               ;9      Endless loop            2
        DW      FREELOOP        ;10
;**************************************************************************
DO_FILTERS EQU  FREELOOP+11
        DW      LAC0+FREECNTR   ;0
        DW      SACL+FREETIME   ;1
        DW      LAC0+FREECNTRHI ;2
        DW      SACL+FREETIMEHI ;3
        DW      ZAC             ;4
        DW      SACL+READY      ;5
        DW      SACL+FREECNTR   ;6
        DW      SACL+FREECNTRHI ;7
;
; Set AR0 = current input block, AR6 = left DAC, AR7 = right DAC
;
        DW      LDPK+4          ;8 Page 4
        DW      LARP0           ;9      AR0 = input pointer     ARP = 0
        DW      LRLK0           ;10
        DW      4700H           ;11
        DW      LRLK6           ;12
        DW      4100H           ;13
        DW      LRLK7           ;14
        DW      4300H           ;15
        DW      BIOZ            ;16
        DW      DO_HIGH         ;17
        DW      LRLK0           ;18
        DW      4600H           ;19
        DW      LRLK6           ;20
        DW      4000H           ;21
        DW      LRLK7           ;22
        DW      4200H           ;23
DO_HIGH EQU     DO_FILTERS+24
;
; Sum up data (abs)
;
        DW      ZAC             ;0      Clear out sums
        DW      SACL+TSUMHI     ;1
        DW      SACL+TSUMLO     ;2
        DW      SACL+TSUMHIA    ;3
        DW      SACL+TSUMLOA    ;4
        DW      SACL+TSUMHIB    ;5
        DW      SACL+TSUMLOB    ;6
        DW      SACL+TSUMHIC    ;7
        DW      SACL+TSUMLOC    ;8
        DW      LRLK1           ;9      AR1 = loop counter
        DW      127             ;10
SHIFT_SUMS EQU DO_HIGH+11       ;       Shift previous values
        DW      DMOV+OUTSM2     ;0
        DW      DMOV+OUTSM1     ;1
        DW      DMOV+OUTSUM     ;2
        DW      DMOV+OUTAM2     ;3
        DW      DMOV+OUTAM1     ;4
        DW      DMOV+OUTA       ;5
        DW      DMOV+OUTBM2     ;6
        DW      DMOV+OUTBM1     ;7
        DW      DMOV+OUTB       ;8
        DW      DMOV+OUTCM2     ;9
        DW      DMOV+OUTCM1     ;10
        DW      DMOV+OUTC       ;11

IN_LOOP EQU SHIFT_SUMS+12
        DW      LAC0+ARPLUS6    ;0      Get input sample
        DW      SACL+TEMP       ;1      Stash it
        DW      SACL+INPUT      ;2
        DW      ADD0+PREVL      ;3      Interpolate
        DW      SACL+ARPLUS     ;4       and output
        DW      LAC9+TEMP       ;5      get value again
        DW      SACH7+PREVL     ;6        and save it for next time
        DW      SACH7+ARPLUS0   ;7       and copy it to the DAC
; Total Level
        DW      PSPABS          ;8      Convert to absolute
        DW      ADDH+TSUMHI     ;9      Sum
        DW      ADDS+TSUMLO     ;10
        DW      SACH0+TSUMHI    ;11
        DW      SACL+TSUMLO     ;12
        DW      LAC0+ARPLUS7    ;13     Get other channels input sample
        DW      SACL+TEMP       ;14      save it in htemp
        DW      ADD0+PREVR      ;15     Interpolate
        DW      SACL+ARPLUS     ;16      and output
        DW      LAC9+TEMP       ;17     get value again
        DW      SACH7+PREVR     ;18      and save it for next time
        DW      SACH7+ARPLUS1   ;19      and copy it to the DAC
        DW      PSPABS          ;20     Convert to absolute
        DW      ADDH+TSUMHI     ;21     Sum
        DW      ADDS+TSUMLO     ;22
        DW      SACH0+TSUMHI    ;23
        DW      SACL+TSUMLO     ;24
;
; Sum signals and filter
;
DO_SUM  EQU IN_LOOP+25
        DW      LAC0+TEMP       ;0      Get right
        DW      ADD0+INPUT      ;1      add left
        DW      SACL+INPUT      ;2      This is our combined input sample
;
HIGH_FILTER EQU DO_SUM+3                ;  4000Hz filter
        DW      PSPLT+INPUT             ;0
;  1st Pole Pair
        DW      MPY+GAIN1A              ;1
        DW      LTP+YN2A                ;2
        DW      MPY+B2A                 ;3
        DW      LTD+YN1A                ;4
        DW      MPY+B1A                 ;5
        DW      LTA+GAIN2A              ;6
        DW      APAC                    ;7
        DW      SACH0+YN1A              ;8
;* 2nd pole pair
        DW      MPY+YN1A                ;9
        DW      LTP+YN4A                ;10
        DW      MPY+B4A                 ;11
        DW      LTD+YN3A                ;12
        DW      MPY+B3A                 ;13
        DW      LTA+GAIN3A              ;14
        DW      APAC                    ;15
        DW      SACH0+YN3A              ;16
; 5th pole
        DW      MPY+YN3A                ;17
        DW      LTP+YN5A                ;18
        DW      MPY+B5A                 ;19
        DW      APAC                    ;20
        DW      SACH0+YN5A              ;21
; Sum with previous samples
        DW      LAC9+YN5A               ;22 YN5A is the output?
        DW      PSPABS                  ;23     Convert to absolute
        DW      ADDH+TSUMHIA            ;24     Sum
        DW      ADDS+TSUMLOA            ;25
        DW      SACH0+TSUMHIA           ;26
        DW      SACL+TSUMLOA            ;27
;
MID_FILTER EQU HIGH_FILTER+28           ;       1000Hz
        DW      PSPLT+INPUT             ;0
;  1st Pole Pair
        DW      MPY+GAIN1B              ;1
        DW      LTP+YN2B                ;2
        DW      MPY+B2B                 ;3
        DW      LTD+YN1B                ;4
        DW      MPY+B1B                 ;5
        DW      LTA+GAIN2B              ;6
        DW      APAC                    ;7
        DW      SACH0+YN1B              ;8
;* 2nd pole pair
        DW      MPY+YN1B                ;9
        DW      LTP+YN4B                ;10
        DW      MPY+B4B                 ;11
        DW      LTD+YN3B                ;12
        DW      MPY+B3B                 ;13
        DW      LTA+GAIN3B              ;14
        DW      APAC                    ;15
        DW      SACH0+YN3B              ;16
; 5th pole
        DW      MPY+YN3B                ;17
        DW      LTP+YN5B                ;18
        DW      MPY+B5B                 ;19
        DW      APAC                    ;10
        DW      SACH0+YN5B              ;11
; Sum with previous samples
        DW      LAC9+YN5B               ;22 YN5B is the output?
        DW      PSPABS                  ;23     Convert to absolute
        DW      ADDH+TSUMHIB            ;24     Sum
        DW      ADDS+TSUMLOB            ;25
        DW      SACH0+TSUMHIB           ;26
        DW      SACL+TSUMLOB            ;27
;
LOW_FILTER EQU MID_FILTER+28            ;       250 Hz
        DW      PSPLT+INPUT             ;0
;  1st Pole Pair
        DW      MPY+GAIN1C              ;1
        DW      LTP+YN2C                ;2
        DW      MPY+B2C                 ;3
        DW      LTD+YN1C                ;4
        DW      MPY+B1C                 ;5
        DW      LTA+GAIN2C              ;6
        DW      APAC                    ;7
        DW      SACH0+YN1C              ;8
; 2nd pole pair
        DW      MPY+YN1C                ;9
        DW      LTP+YN4C                ;10
        DW      MPY+B4C                 ;11
        DW      LTD+YN3C                ;12
        DW      MPY+B3C                 ;13
        DW      LTA+GAIN3C              ;14
        DW      APAC                    ;15
        DW      SACH0+YN3C              ;16
; 5th pole
        DW      MPY+YN3C                ;17
        DW      LTP+YN5C                ;18
        DW      MPY+B5C                 ;19
        DW      APAC                    ;20
        DW      SACH0+YN5C              ;21
; Sum with previous samples
        DW      LAC9+YN5C               ;22 YN5C is the output?
        DW      PSPABS                  ;23     Convert to absolute
        DW      ADDH+TSUMHIC            ;24     Sum
        DW      ADDS+TSUMLOC            ;25
        DW      SACH0+TSUMHIC           ;26
        DW      SACL+TSUMLOC            ;27
;
END_FILTERS EQU LOW_FILTER+28
        DW      BANZ+(ARMINUS0-AR) ;0
        DW      IN_LOOP         ;1

DO_OUTS EQU END_FILTERS+2
        DW      LAC0+TSUMHI     ;0      Get upper bits of TSUM
        DW      SACL+OUTSUM     ;1
        DW      LAC14+OUTSUM    ;2
        DW      ADD14+OUTSM1    ;3
        DW      ADD14+OUTSM2    ;4
        DW      ADD14+OUTSM3    ;5
        DW      LDPK+63         ;6 Page 63
        DW      SACH0+TOTLVL    ;7      Write it out for host to read

DO_OUTA EQU DO_OUTS+8
        DW      LDPK+4          ;0
        DW      LAC0+TSUMHIA    ;1
        DW      SACL+OUTA       ;2
        DW      LAC14+OUTA      ;3
        DW      ADD14+OUTAM1    ;4
        DW      ADD14+OUTAM2    ;5
        DW      ADD14+OUTAM3    ;6
        DW      LDPK+63         ;7
        DW      SACH0+FILLVLA   ;8

DO_OUTB EQU DO_OUTA+9
        DW      LDPK+4          ;0
        DW      LAC0+TSUMHIB    ;1
        DW      SACL+OUTB       ;2
        DW      LAC14+OUTB      ;3
        DW      ADD14+OUTBM1    ;4
        DW      ADD14+OUTBM2    ;5
        DW      ADD14+OUTBM3    ;6
        DW      LDPK+63         ;7
        DW      SACH0+FILLVLB   ;8

DO_OUTC EQU DO_OUTB+9
        DW      LDPK+4          ;0
        DW      LAC0+TSUMHIC    ;1
        DW      SACL+OUTC       ;2
        DW      LAC14+OUTC      ;3
        DW      ADD14+OUTCM1    ;4
        DW      ADD14+OUTCM2    ;5
        DW      ADD14+OUTCM3    ;6
        DW      LDPK+63         ;7
        DW      SACH0+FILLVLC   ;8
        DW      B               ;9
        DW      FREELOOP        ;10

        DW      0               ;11 PAD

PSPCODE1_END EQU THIS BYTE

_DATA   ENDS
        END

