
/* 
djweis
acpa.h

contains defines relevant to driver

*/

#include "passthru.h"    /* default passthru code */
#include "ibmpcmp.h"     /* pcm playing code */
#include "ibmpcmr.h"     /* pcm record code */

#define PASSTHRU 0
#define PCM_PLAY 1
#define PCM_REC 2

#define NELEMS(x) (sizeof(x) / sizeof(x[0]))
#define RETRY_COUNT 10000

#define ACPA_ID  0x6e6c

#define MAILBOX1  0x0e18
#define MAILBOX2  0x0e20
#define MASTERCB  0x0e10
#define PCMCB1    0x0e30
#define PCMCB2    0x0e50
#define TRACK1CB  0x0e00
#define TRACK2CB  0x0e08



#define HOSTCOMREG 6
#define ADDREGLOW 4
#define ADDREGHI 5
#define DATAREGLOW 0
#define DATAREGHI 1
#define CLEARACCESSERR 7


/* host command register entries */
#define HINTENA 4 /* 1 = enable ints from host to c25 dsp */
#define TMSINT 8 /* 0 = interrupt c25 dsp */
#define TMSRES 1 /* 0 = reset dsp, 1 = dsp running */
#define SPKREN 16 /* 1 = enable speaker */

/* input definitions */
#define DSP_BOOSTED_MIC 0x00
#define DSP_LEFT_LINE 0x01
#define DSP_RIGHT_LINE 0x02
#define DSP_STEREO 0x03
#define DSP_MIC 0x04


/* function declarations */

static int acpa_audio_open(int, int);
static void acpa_audio_close(int);
static void acpa_set_output_parms(int, unsigned long, int,
				  int, int);
static void acpa_set_input_parms(int, unsigned long, int,
				 int, int);
static int acpa_audio_ioctl(int, unsigned int, caddr_t, int);
static int acpa_audio_prepare_for_input(int, int, int);
static int acpa_audio_prepare_for_output(int, int, int);
static void acpa_audio_reset(int);
static void acpa_audio_halt_xfer(int dev);
static int acpa_local_qlen(int);
static void acpa_copy_from_user(int, char *, int, const char *, int, int);

static void acpa_audio_trigger(int dev, int bits);
static int acpa_audio_set_speed(int dev, int speed);
static unsigned int acpa_audio_set_bits(int dev, unsigned int bits);
static short acpa_audio_set_channels(int dev, short channels);
void acpa_irq_handler(int irq, void * dev_id, struct pt_regs * dummy);

int attach_acpa(void);
void unload_acpa(void);
static void acpa_out(unsigned int addr, unsigned int data);
static unsigned int acpa_in(unsigned int addr);
static void acpa_command(char command);
static void dsp_run(void);
static void passthru(int inpsel);
static int load_pcm_play(void);
static int load_pcm_record(void);
