
/*=========================================================================*/
/* Konzept        : DATA BECKERs Sound Blaster Superbuch                   */
/* Prog. HexBin   : Ein Beispielprogramm, das die Umrechnung von hexadezi- */
/*                  malen und binren Zahlen in Dezimalzahlen demonstriert.*/
/*=========================================================================*/
/* Autor          : Arthur Burda                                           */
/* Dateiname      : HEXBIN.C                                               */
/* entwickelt am  : 23.04.1993                                             */
/* letztes Update : 01.09.1993                                             */
/* Version        : 1.01                                                   */
/* Compiler       : Turbo C, Turbo C++, Borland C++                        */
/*=========================================================================*/

#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <stdio.h>

/*-------------------------------------------------------------------------*/
/* Konstantendefinitionen                                                  */
/*-------------------------------------------------------------------------*/

#define TRUE  1
#define FALSE 0

/*=========================================================================*/
/* HexToDec: Wandelt eine hexadezimale Zahl, die als String vorliegt, in   */
/*           einen Dezimalwert um.                                         */
/*=========================================================================*/
/* Eingabe: HexStr = hexadezimale Zahl in String-Form                      */
/* Ausgabe: eine dezimale Zahl bzw. der Wert 0, wenn der Hex-String nicht  */
/*          korrekt oder leer ist                                          */
/*-------------------------------------------------------------------------*/

unsigned int HexToDec(char *HexStr)

{
  char         Len;                                 /* String-Lnge HexStr */
  int          Count;                                        /* ein Zhler */
  char         Fail;    /* TRUE, wenn ein Zeichen im Hex-String falsch ist */
  int          Mult;                                      /* Multiplikator */
  char         Ch;                 /* Zeichen, das gerade umgewandelt wird */
  unsigned int Decimal;                                     /* Dezimalwert */

  if (*HexStr != '\0')                           /* Hex-String nicht leer? */
    {                                          /* nein, Umwandlung starten */
      Len = strlen(HexStr);                  /* Lnge von HexStr ermitteln */
      Count = Len;                                        /* Zhler setzen */
      Fail = FALSE;                                     /* noch alles o.k. */
      Mult = 1;                              /* Multiplikator auf 1 setzen */
      Decimal = 0;                          /* Dezimalwert ist am Anfang 0 */
      while ((!Fail) && (Count > 0))                    /* Schleifenanfang */
        {
          Ch = toupper(HexStr[Count-1]);              /* Zeichen bestimmen */
          if (isdigit(Ch))                                      /* Ziffer? */
            Decimal += Mult*(Ch-48);                                 /* ja */
          else                                                     /* nein */
            if ((Ch >= 'A') && (Ch <= 'F'))                  /* Buchstabe? */
              Decimal += Mult*(Ch-55);                               /* ja */
            else                     /* ein falsches Zeichen im Hex-String */
              Fail = TRUE;                         /* Umwandlung abbrechen */
          Count--;                                   /* Zhler erniedrigen */
          Mult *= 16;                              /* Multiplikator mal 16 */
        }
    }
  if (!Fail)              /* wenn alles o.k., dann Dezimalwert zurckgeben */
    return Decimal;
  else                                       /* ein Fehler ist aufgetreten */
    return 0;                                           /* 0 zurckliefern */
}

/*=========================================================================*/
/* BinToDec: Wandelt eine Binrzahl in Form eines Strings in einen Dezi-   */
/*           malwert um. Die erste Stelle im String ist Bitwert 128 (2^7), */
/*           die letzte Bitwert 1 (2^0).                                   */
/*=========================================================================*/
/* Eingabe: Binrwert als String                                           */
/* Ausgabe: Dezimalwert bzw. 0, wenn der Binrstring nicht korrekt oder    */
/*          leer ist                                                       */
/*-------------------------------------------------------------------------*/

unsigned char BinToDec(char *BinStr)

{
  char          Len;                                /* String-Lnge BinStr */
  int           Count;                                       /* ein Zhler */
  char          Fail;  /* TRUE, wenn ein Zeichen im Binrstring falsch ist */
  int           BitVal;                                         /* Bitwert */
  char          Ch;                /* Zeichen, das gerade umgewandelt wird */
  unsigned char Decimal;                                    /* Dezimalwert */

  Len = strlen(BinStr);                      /* Lnge von HexStr ermitteln */
  if (Len == 8)                          /* BinStr mu 8 Zeichen lang sein */
    {
      Count = Len;                                        /* Zhler setzen */
      Fail = FALSE;                                     /* noch alles o.k. */
      BitVal = 1;                                  /* Bitwert auf 1 setzen */
      Decimal = 0;                          /* Dezimalwert ist am Anfang 0 */
      while ((!Fail) && (Count > 0))                    /* Schleifenanfang */
        {
          Ch = BinStr[Count-1];                       /* Zeichen bestimmen */
          if (Ch == '0')    /* "0" gefunden, Dezimalwert ndert sich nicht */
            {
            }
          else
            if (Ch == '1')           /* "1" gefunden, Bitwert dazuaddieren */
              Decimal += BitVal;
            else                    /* ein falsches Zeichen im Binrstring */
              Fail = TRUE;                         /* Umwandlung abbrechen */
          Count--;                                   /* Zhler erniedrigen */
          BitVal *= 2;                               /* Bitwert verdoppeln */
        }
    }
  if (!Fail)              /* wenn alles o.k., dann Dezimalwert zurckgeben */
    return Decimal;
  else                                       /* ein Fehler ist aufgetreten */
    return 0;                                           /* 0 zurckliefern */
}

/*-------------------------------------------------------------------------*/
/* main: Hauptprogramm                                                     */
/*-------------------------------------------------------------------------*/

void main()

{
  clrscr();                                          /* Bildschirm lschen */
  printf("Hex-Wert: 4F2Ch    Dezimalwert: %d\n", HexToDec("4F2C"));
  printf("Hex-Wert: 01FCh    Dezimalwert: %d\n", HexToDec("01FC"));
  printf("Hex-Wert: 6F34h    Dezimalwert: %d\n", HexToDec("6F34"));
  printf("Hex-Wert: 29D1h    Dezimalwert: %d\n", HexToDec("29D1"));
  printf("Hex-Wert: 7106h    Dezimalwert: %d\n", HexToDec("7106"));
  printf("\n");
  printf("Binrwert: 01100111b    Dezimalwert: %d\n", BinToDec("01100111"));
  printf("Binrwert: 11100011b    Dezimalwert: %d\n", BinToDec("11100011"));
  printf("Binrwert: 00010011b    Dezimalwert: %d\n", BinToDec("00010011"));
  printf("Binrwert: 10000100b    Dezimalwert: %d\n", BinToDec("10000100"));
  printf("Binrwert: 11110101b    Dezimalwert: %d\n", BinToDec("11110101"));
  while (!kbhit());                /* warten, bis eine Taste gedrckt wird */
  getch();                                                /* Zeichen lesen */
};
