
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Prog. CDPlayer : Ein kleiner CD-Player als Demo fr die Unit SBCD.        }
{                  Ist der Parameter "/R" angegeben, so wird nach dem Prog- }
{                  rammstart ein Gertetreiber-Reset ausgefhrt.            }
{                  Dieses Programm benutzt die Bibliothek Megagraphics      }
{                  Toolbox Version 1.1.                                     }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : CDPLAYER.PAS                                             }
{ entwickelt am  : 25.08.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.01                                                     }
{ Compiler       : Turbo bzw. Borland Pascal 7.0 (wegen SAA-Oberflche)     }
{===========================================================================}

PROGRAM CDPlayer;

{---------------------------------------------------------------------------}
{ Compiler-Schalter                                                         }
{---------------------------------------------------------------------------}

{$B-}                         { Kurzschluverfahren fr boolesche Ausdrcke }
{$D-}                                        { keine Debugger-Informationen }
{$F+}                                                { FAR-Aufrufe erlauben }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

USES GRAPH, Objects, MGDrv, MGSysInt, MGEvents, MGSystem, MGViews, MGApp,
     MGDlgs, SBCD;

CONST

  {-------------------------------------------------------------------------}
  { Befehlskonstanten                                                       }
  {-------------------------------------------------------------------------}

  cm_PauseContinue = 200;                 { Pause/Abspielvorgang fortsetzen }
  cm_Stop          = 201;                                            { Stop }
  cm_Forward       = 202;                                  { "weiterspulen" }
  cm_Backward      = 203;                                  { "zurckspulen" }

  {-------------------------------------------------------------------------}
  { Hilfekontext-Konstanten                                                 }
  {-------------------------------------------------------------------------}

  hc_Ok            = 100;
  hc_PauseContinue = 200;
  hc_Stop          = 201;
  hc_Forward       = 202;
  hc_Backward      = 203;

TYPE

  {=========================================================================}
  { PCDCurrTrack: Zeiger auf TCDCurrTrack                                   }
  {=========================================================================}
  { TCDCurrTrack: Ein direkter Nachfolger von TMGStaticLine, der zur Anzei- }
  {               ge der aktuellen Tracknummer dient.                       }
  {=========================================================================}

  PCDCurrTrack = ^TCDCurrTrack;
  TCDCurrTrack = OBJECT(TMGStaticLine)

    {=======================================================================}
    { Felder                                                                }
    {=======================================================================}
    { DriveNmb  = Nummer des CD-ROM-Laufwerkes                              }
    { LastTrack = alte Tracknummer                                          }
    {-----------------------------------------------------------------------}

    DriveNmb  : Word;
    LastTrack : Byte;

    {=======================================================================}
    { Methode Init: Initialisiert das TCDCurrTrack-Objekt.                  }
    {=======================================================================}
    { Eingabe: aDriveNmb = Nummer des CD-ROM-Laufwerkes                     }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    CONSTRUCTOR Init(aDriveNmb : Word);

    {=======================================================================}
    { Methode OutTrack: Gibt die angegebene Tracknummer auf dem Bildschirm  }
    {                   aus.                                                }
    {=======================================================================}
    { Eingabe: Track = Tracknummer                                          }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    PROCEDURE OutTrack(Track : Byte);

    {=======================================================================}
    { Methode Update: Aktualisiert die Tracknummer, wenn sich diese zwi-    }
    {                 schenzeitlich gendert hat.                           }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    PROCEDURE Update; VIRTUAL;

  END;

  {=========================================================================}
  { PCDTrackTime: Zeiger auf TCDTrackTime                                   }
  {=========================================================================}
  { TCDTrackTime: Ein Nachfolger von TMGStaticLine, der die Track-Zeit per- }
  {               manent anzeigt.                                           }
  {=========================================================================}

  PCDTrackTime = ^TCDTrackTime;
  TCDTrackTime = OBJECT(TMGStaticLine)

    {=======================================================================}
    { Felder                                                                }
    {=======================================================================}
    { DriveNmb = Nummer des CD-ROM-Laufwerkes                               }
    { LastMin  = alter Minutenwert                                          }
    { LastSec  = alter Sekundenwert                                         }
    {-----------------------------------------------------------------------}

    DriveNmb : Word;
    LastMin  : Byte;
    LastSec  : Byte;

    {=======================================================================}
    { Methode Init: Initialisiert das TCDTrackTime-Objekt.                  }
    {=======================================================================}
    { Eingabe: aDriveNmb = Nummer des CD-ROM-Laufwerkes                     }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    CONSTRUCTOR Init(aDriveNmb : Word);

    {=======================================================================}
    { Methode OutTime: Gibt die Track-Zeit auf dem Bildschirm aus.          }
    {=======================================================================}
    { Eingabe: Min = Minutenwert                                            }
    {          Sec = Sekundenwert                                           }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    PROCEDURE OutTime(Min, Sec : Byte);

    {=======================================================================}
    { Methode Update: Aktualisiert permanent die Track-Zeit.                }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    PROCEDURE Update; VIRTUAL;

  END;

  {=========================================================================}
  { PCDRelTime: Zeiger auf TCDRelTime                                       }
  {=========================================================================}
  { TCDRelTime: Ein direkter Nachfolger von TCDTrackTime, der die Methode   }
  {             OutTime dieses Objektes nutzt, um die Ausgabe der Zeit re-  }
  {             lativ zum Anfang einer CD zu realisieren.                   }
  {=========================================================================}

  PCDRelTime = ^TCDRelTime;
  TCDRelTime = OBJECT(TCDTrackTime)

    {=======================================================================}
    { Methode Init: Initialisiert das TCDRelTime-Objekt.                    }
    {=======================================================================}
    { Eingabe: aDriveNmb = Nummer des CD-ROM-Laufwerkes                     }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    CONSTRUCTOR Init(aDriveNmb : Word);

    {=======================================================================}
    { Methode Update: Aktualisiert permanent die Zeit relativ zum Anfang    }
    {                 der CD.                                               }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    PROCEDURE Update; VIRTUAL;

  END;

  {=========================================================================}
  { TCDPlayerApp: Ein Nachfolger von TMGApplication (SAA-Applikation im     }
  {               Grafikmodus)                                              }
  {=========================================================================}

  TCDPlayerApp = OBJECT(TMGApplication)

    {=======================================================================}
    { Felder                                                                }
    {=======================================================================}
    { Drives         = Anzahl der CD-ROM-Laufwerke                          }
    { Nmb            = Nummer des ersten Laufwerkes                         }
    { DevStatus      = Gertestatus                                         }
    { CDInfo         = CD-Info                                              }
    { TotalTime      = Gesamtdauer der CD                                   }
    { Paused         = TRUE, wenn sich das CD-ROM-Laufwerk im Pause-Modus   }
    {                  befindet, sonst FALSE                                }
    { Status         = Zustand, in dem sich das Laufwerk befindet           }
    { PauseButton    = Zeiger auf den Schalter fr Pause und Abspielvorgang }
    {                  fortsetzen                                           }
    { StopButton     = Zeiger auf den Stop-Schalter                         }
    { ForwardButton  = Zeiger auf Schalter, mit dessen Hilfe "weiterge-     }
    {                  spult" werden kann                                   }
    { BackwardButton = Zeiger auf den Schalter, mit dessen Hilfe "zurckge- }
    {                  spult" werden kann                                   }
    {-----------------------------------------------------------------------}

    Drives         : Word;
    Nmb            : Word;
    DevStatus      : DWord;
    CDInfo         : TCDInfo;
    TotalTime      : TCDTime;
    Paused         : Boolean;
    Status         : Word;
    PauseButton    : PMGButton3D;
    StopButton     : PMGButton3D;
    ForwardButton  : PMGButton3D;
    BackwardButton : PMGButton3D;

    {=======================================================================}
    { Methode Init: Initialisiert das TCDPlayerApp-Objekt.                  }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    CONSTRUCTOR Init;

    {=======================================================================}
    { Methode CheckError: Prft, ob vielleicht nicht ein Fehler aufgetre-   }
    {                     ten ist und gibt ggf. eine Meldung aus.           }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    PROCEDURE CheckError;

    {=======================================================================}
    { Methode GetCaption: Liefert einen Zeiger auf die Kopfzeile, in der    }
    {                     der Name des Programms steht.                     }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: Zeiger auf die Kopfzeile                                     }
    {-----------------------------------------------------------------------}

    FUNCTION GetCaption : PMGCaption; VIRTUAL;

    {=======================================================================}
    { Methode GetStatusLine: Liefert einen Zeiger auf die Statuszeile des   }
    {                        Programms zurck.                              }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: Zeiger auf die Statuszeile                                   }
    {-----------------------------------------------------------------------}

    FUNCTION GetStatusLine : PMGStatusLine; VIRTUAL;

    {=======================================================================}
    { Methode HandleEvent: Kmmert sich um die ankommenden Tastatur- und    }
    {                      Mausereignisse.                                  }
    {=======================================================================}
    { Eingabe: Event = Ereignis                                             }
    { Ausgabe: Event (Erluterung s. Eingabe)                               }
    {-----------------------------------------------------------------------}

    PROCEDURE HandleEvent(VAR Event : TEvent); VIRTUAL;

    {=======================================================================}
    { Methode OutMessage: Gibt eine Meldung auf dem Bildschirm aus.         }
    {=======================================================================}
    { Eingabe: CaptionText  = Text in der Kopfzeile                         }
    {          Text1, Text2 = Textzeilen                                    }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    PROCEDURE OutMessage(CaptionText : TCaptionStr; Text1, Text2 : String);

    {=======================================================================}
    { Methode ResetDrive: Fhrt einen Reset des Gertetreibers aus.         }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    PROCEDURE ResetDrive;

    {=======================================================================}
    { Methode Run: Startet das Programm.                                    }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    PROCEDURE Run; VIRTUAL;

  END;

{---------------------------------------------------------------------------}
{ Implementation von TCDCurrTrack                                           }
{---------------------------------------------------------------------------}

CONSTRUCTOR TCDCurrTrack.Init(aDriveNmb : Word);

VAR
  iRect : TRect;                              { Rechteck auf dem Bildschirm }

BEGIN
  iRect.Assign(40, 272, 200, 281);
  INHERITED Init(iRect, 'Track No.  : ', DefaultFont, HorizDir, 0,
    LeftText, TopText);              { Init-Methode des Vorgngers aufrufen }
  DriveNmb := aDriveNmb;
  LastTrack := 255;
END;

PROCEDURE TCDCurrTrack.OutTrack(Track : Byte);

VAR
  TrackStr : String;

BEGIN
  IF SVGAEvHandler <> NIL THEN
    SVGAEvHandler^.HideMouse;                      { Maus-Cursor verstecken }

  { alte Tracknummer ausblenden }

  GrSystem^.SetColor(7);                               { Textfarbe hellgrau }
  Str(LastTrack, TrackStr);          { alte Tracknummer in String umwandeln }
  IF LastTrack < 10 THEN
    Insert('0', TrackStr, 1);
  GrSystem^.OutTextXY(Rect.A.X+102, Rect.A.Y, TrackStr);

  { neue Tracknummer anzeigen }

  GrSystem^.SetColor(GetColor(1));         { Textfarbe ermitteln und setzen }
  Str(Track, TrackStr);              { neue Tracknummer in String umwandeln }
  IF Track < 10 THEN
    Insert('0', TrackStr, 1);
  GrSystem^.OutTextXY(Rect.A.X+102, Rect.A.Y, TrackStr);

  LastTrack := Track;
  IF SVGAEvHandler <> NIL THEN
    SVGAEvHandler^.ShowMouse;                        { Maus-Cursor anzeigen }
END;

PROCEDURE TCDCurrTrack.Update;

VAR
  Info : TQChannelInfo;

BEGIN
  SBCDGetQChannelInfo(DriveNmb, Info);

  { prfen, ob sich die Tracknummer gendert hat }
  { und ggf. die Anzeige aktualisieren           }

  IF Info.Track <> LastTrack THEN
    OutTrack(Info.Track);
END;

{---------------------------------------------------------------------------}
{ Implementation von TCDTrackTime                                           }
{---------------------------------------------------------------------------}

CONSTRUCTOR TCDTrackTime.Init(aDriveNmb : Word);

VAR
  iRect : TRect;                              { Rechteck auf dem Bildschirm }

BEGIN
  iRect.Assign(40, 282, 200, 291);
  INHERITED Init(iRect, 'Track Time : ', DefaultFont, HorizDir, 0,
    LeftText, TopText);              { Init-Methode des Vorgngers aufrufen }
  DriveNmb := aDriveNmb;
  LastMin := 255;
  LastSec := 255;
END;

PROCEDURE TCDTrackTime.OutTime(Min, Sec : Byte);

VAR
  MinStr, SecStr : String;

BEGIN
  IF SVGAEvHandler <> NIL THEN
    SVGAEvHandler^.HideMouse;                      { Maus-Cursor verstecken }

  { alte Track-Zeit ausblenden }

  GrSystem^.SetColor(7);                               { Textfarbe hellgrau }
  Str(LastMin, MinStr);             { alten Minutenwert in String umwandeln }
  Str(LastSec, SecStr);            { alten Sekundenwert in String umwandeln }
  IF LastMin < 10 THEN
    Insert('0', MinStr, 1);
  IF LastSec < 10 THEN
    Insert('0', SecStr, 1);
  GrSystem^.OutTextXY(Rect.A.X+102, Rect.A.Y, MinStr+':'+SecStr);

  { neue Track-Zeit anzeigen }

  GrSystem^.SetColor(GetColor(1));         { Textfarbe ermitteln und setzen }
  Str(Min, MinStr);                 { neuen Minutenwert in String umwandeln }
  Str(Sec, SecStr);                { neuen Sekundenwert in String umwandeln }
  IF Min < 10 THEN
    Insert('0', MinStr, 1);
  IF Sec < 10 THEN
    Insert('0', SecStr, 1);
  GrSystem^.OutTextXY(Rect.A.X+102, Rect.A.Y, MinStr+':'+SecStr);

  LastMin := Min;
  LastSec := Sec;
  IF SVGAEvHandler <> NIL THEN
    SVGAEvHandler^.ShowMouse;                        { Maus-Cursor anzeigen }
END;

PROCEDURE TCDTrackTime.Update;

VAR
  Info : TQChannelInfo;

BEGIN
  SBCDGetQChannelInfo(DriveNmb, Info);

  { prfen, ob sich die Track-Zeit gendert hat }
  { und ggf. die Anzeige aktualisieren          }

  IF (Info.Min <> LastMin) OR (Info.Sec <> LastSec) THEN
    OutTime(Info.Min, Info.Sec);
END;

{---------------------------------------------------------------------------}
{ Implementation von TCDRelTime                                             }
{---------------------------------------------------------------------------}

CONSTRUCTOR TCDRelTime.Init(aDriveNmb : Word);

VAR
  iRect : TRect;                              { Rechteck auf dem Bildschirm }

BEGIN
  iRect.Assign(40, 292, 200, 301);
  TMGStaticLine.Init(iRect, 'CD Time    : ', DefaultFont, HorizDir, 0,
    LeftText, TopText);
  DriveNmb := aDriveNmb;
  LastMin := 255;
  LastSec := 255;
END;

PROCEDURE TCDRelTime.Update;

VAR
  Info : TQChannelInfo;

BEGIN
  SBCDGetQChannelInfo(DriveNmb, Info);

  { prfen, ob sich die Zeit relativ zum Anfang der CD gendert hat }
  { und ggf. die Anzeige aktualisieren                              }

  IF (Info.CDMin <> LastMin) OR (Info.CDSec <> LastSec) THEN
    OutTime(Info.CDMin, Info.CDSec);
END;

{---------------------------------------------------------------------------}
{ Implementation von TCDPlayerApp                                           }
{---------------------------------------------------------------------------}

CONSTRUCTOR TCDPlayerApp.Init;

VAR
  iRect          : TRect;                     { Rechteck auf dem Bildschirm }
  View           : PMGView3D;         { Zeiger auf ein 3D-Darsteller-Objekt }
  Count          : Word;                                           { Zhler }
  Button         : PMGButton3D;              { Zeiger auf einen 3D-Schalter }
  S              : String;                                     { ein String }
  Max            : Byte;                                    { Hilfsvariable }
  Reset          : Boolean;    { TRUE, wenn ein Reset augefhrt werden soll }
  Text           : PMGStaticLine;   { Zeiger auf ein statisches Text-Objekt }
  MinStr, SecStr : String;                                 { Hilfsvariablen }

BEGIN
  INHERITED Init(gm_EGAVGA_640x350x16, '');   { Init-Methode des Vorgngers }

  { Standard-Paletten umdefinieren }

  vpMenuItem := #7#11#0#14#8;
  vpView3D := #7#2#5#3#9#6;
  vpButton3D := #7#11#5#3#9#6#0#14#8;
  vpMenuButton := #7#11#5#3#9#6#0#14#8;
  vpDesktop := #13;
  vpDlgButton := #7#2#5#3#9#6#0#14#8#0;
  vpDlgCaption := #1#12#0#14;
  vpDialog3D := #7#5#3#9#6;

  { Farbzuordnung festlegen }

  GrSystem^.SetPalette(3, 3);
  GrSystem^.SetPalette(5, 5);
  GrSystem^.SetPalette(6, 6);
  GrSystem^.SetPalette(9, 9);
  GrSystem^.SetPalette(11, 11);
  GrSystem^.SetPalette(12, 12);
  GrSystem^.SetPalette(13, 13);

  { Standard-Farbpalette ndern }

  GrSystem^.SetRGBPalette(3, 60, 60, 60);
  GrSystem^.SetRGBPalette(5, 54, 54, 54);
  GrSystem^.SetRGBPalette(6, 28, 28, 28);
  GrSystem^.SetRGBPalette(9, 24, 24, 24);
  GrSystem^.SetRGBPalette(11, 0, 30, 50);
  GrSystem^.SetRGBPalette(12, 20, 30, 60);
  GrSystem^.SetRGBPalette(13, 0, 30, 30);

  Reset := (ParamStr(1) = '/r') OR (ParamStr(1) = '/R');
  SetState(vsVisible, TRUE);                             { Desktop anzeigen }
  SBCDGetDriveNmb(Drives, Nmb);                          { Laufwerke prfen }
  IF Drives = 0 THEN   { Kein Laufwerk vorh. oder MSCDEX nicht installiert? }
    BEGIN                                                      { ja, Fehler }
      OutMessage('Fehler', 'Kein CD-ROM-Laufwerk vorhanden oder MSCDEX '+
        'nicht', 'installiert.');
      Done;                                    { Programm ber Done-Methode }
      Halt;                                                       { beenden }
    END;
  IF Reset THEN                       { Reset des Gertetreibers ausfhren? }
    ResetDrive;                                                        { ja }
  SBCDGetDriveNmb(Drives, Nmb);                          { Laufwerke prfen }
  SBCDGetDevStatus(Nmb, DevStatus);                { Gertestatus ermitteln }
  IF (DevStatus.LoWord AND devstat_DoorOpen) <> 0 THEN         { Tr offen? }
    BEGIN                                               { ja, Fehlermeldung }
      OutMessage('Fehler', 'Die Laufwerkstr ist offen.', '');
      Done;
      Halt;
    END;
  IF (DevStatus.LoWord AND devstat_DataAudioVideo) = 0 THEN     { Daten-CD? }
    BEGIN                                             { ja, Fehler anzeigen }
      OutMessage('Fehler', 'Im Laufwerk befindet sich eine reine Daten-CD.',
        '');
      Done;
      Halt;
    END;
  IF (DevStatus.LoWord AND devstat_HSGAndRedBook) = 0 THEN { nur HSG-Modus? }
    BEGIN                                               { ja, Fehlermeldung }
      OutMessage('Fehler', 'Das Laufwerk kann nur im HSG-Modus arbeiten.',
        '');
      Done;
      Halt;
    END;
  IF (DevStatus.LoWord AND devstat_NoCDInDrive) <> 0 THEN       { Keine CD? }
    BEGIN                                                            { nein }
      OutMessage('Fehler', 'Es ist keine CD eingelegt.',
        '');
      Done;
      Halt;
    END;
  SBCDGetInfo(Nmb, CDInfo);               { Informationen ber die CD holen }

  { Fenster fr die Tracks erzeugen }

  iRect.Assign(20, 60, GrSystem^.GetMaxX-190, 240);
  View := New(PMGView3D, Init(iRect, 4));
  View^.SetState(vsDisabled, TRUE);
  InsertView(View);
  iRect.Assign(40, 80, 200, 100);
  Text := New(PMGStaticLine, Init(iRect, 'Tracks', DefaultFont,
    HorizDir, 2, LeftText, TopText));
  InsertView(Text);

  { Track-Buttons erzeugen }

  IF CDInfo.MaxTrack >= 10 THEN
    Max := 10
  ELSE
    Max := CDInfo.MaxTrack;
  FOR Count := 1 TO Max DO
    BEGIN
      IF Count < 10 THEN
        BEGIN
          Str(Count, S);
          Insert('~', S, 1);
        END
      ELSE
        S := '10';
      iRect.Assign(40+((Count-1)*40), 110, 70+((Count-1)*40), 130);
      Button := New(PMGButton3D, Init(iRect, 4, Count+100, S, TRUE));
      Button^.HelpCtx := Count+100;
      InsertView(Button);
    END;
  IF CDInfo.MaxTrack >= 20 THEN
    Max := 20
  ELSE
    Max := CDInfo.MaxTrack;
  FOR Count := 11 TO Max DO
    BEGIN
      Str(Count, S);
      iRect.Assign(40+((Count-11)*40), 140, 70+((Count-11)*40), 160);
      Button := New(PMGButton3D, Init(iRect, 4, Count+100, S, TRUE));
      Button^.HelpCtx := Count+100;
      InsertView(Button);
    END;
  IF CDInfo.MaxTrack >= 30 THEN
    Max := 30
  ELSE
    Max := CDInfo.MaxTrack;
  FOR Count := 21 TO Max DO
    BEGIN
      Str(Count, S);
      iRect.Assign(40+((Count-21)*40), 170, 70+((Count-21)*40), 190);
      Button := New(PMGButton3D, Init(iRect, 4, Count+100, S, TRUE));
      Button^.HelpCtx := Count+100;
      InsertView(Button);
    END;
  IF CDInfo.MaxTrack >= 40 THEN
    Max := 40
  ELSE
    Max := CDInfo.MaxTrack;
  FOR Count := 31 TO Max DO
    BEGIN
      Str(Count, S);
      iRect.Assign(40+((Count-31)*40), 200, 70+((Count-31)*40), 220);
      Button := New(PMGButton3D, Init(iRect, 4, Count+100, S, TRUE));
      Button^.HelpCtx := Count+100;
      InsertView(Button);
    END;

  { Schalter fr Pause und Fortsetzen erzeugen }

  IF Reset THEN                               { Wurde ein Reset ausgefhrt? }
    Paused := FALSE                                  { ja, kein Pause-Modus }
  ELSE                                                   { nein, kein Reset }
    Paused := SBCDPaused(Nmb);                               { Pause-Modus? }
  Status := 0;
  iRect.Assign(GrSystem^.GetMaxX-170, 60, GrSystem^.GetMaxX-20, 90);
  PauseButton := New(PMGButton3D, Init(iRect, 4, cm_PauseContinue,
    'P~ause', TRUE));
  PauseButton^.HelpCtx := hc_PauseContinue;
  InsertView(PauseButton);

  { Stop-Schalter erzeugen }

  iRect.Assign(GrSystem^.GetMaxX-170, 110, GrSystem^.GetMaxX-20, 140);
  StopButton := New(PMGButton3D, Init(iRect, 4, cm_Stop, '~Stop', TRUE));
  StopButton^.HelpCtx := hc_Stop;
  InsertView(StopButton);

  { Schalter zum "Weiterspulen" erzeugen }

  iRect.Assign(GrSystem^.GetMaxX-170, 160, GrSystem^.GetMaxX-20, 190);
  ForwardButton := New(PMGButton3D, Init(iRect, 4, cm_Forward,
    '~Weiter', TRUE));
  ForwardButton^.HelpCtx := hc_Forward;
  InsertView(ForwardButton);

  { Schalter zum "Zurckspulen" erzeugen }

  iRect.Assign(GrSystem^.GetMaxX-170, 210, GrSystem^.GetMaxX-20, 240);
  BackwardButton := New(PMGButton3D, Init(iRect, 4, cm_Backward,
    '~Zurck', TRUE));
  BackwardButton^.HelpCtx := hc_Backward;
  InsertView(BackwardButton);

  { prfen, ob sich das Laufwerk im Pause-Modus befindet }
  { und ggf. Schalter "Weiter" und "Zurck" deaktivieren }

  IF Paused THEN
    BEGIN
      PauseButton^.NewText('~Fortsetzen');
      ForwardButton^.SetState(vsDisabled, TRUE);
      ForwardButton^.Draw;
      BackwardButton^.SetState(vsDisabled, TRUE);
      BackwardButton^.Draw;
    END;

  { Status-Fenster erzeugen }

  iRect.Assign(20, 260, GrSystem^.GetMaxX-190, 310);
  View := New(PMGView3D, Init(iRect, 4));
  View^.SetState(vsDisabled, TRUE);
  InsertView(View);

  { Status-Objekte erzeugen und einbinden }

  Text := New(PCDCurrTrack, Init(Nmb));
  InsertView(Text);
  Text := New(PCDTrackTime, Init(Nmb));
  InsertView(Text);
  Text := New(PCDRelTime, Init(Nmb));
  InsertView(Text);
  SBCDSectorToTime(SBCDVolumeSize(Nmb), TotalTime);
  Str(TotalTime.Min, MinStr);
  Str(TotalTime.Sec, SecStr);
  IF TotalTime.Min < 10 THEN
    Insert('0', MinStr, 1);
  IF TotalTime.Sec < 10 THEN
    Insert('0', SecStr, 1);
  iRect.Assign(260, 292, 460, 301);
  Text := New(PMGStaticLine, Init(iRect, 'Time Total : '+MinStr+':'+SecStr,
    DefaultFont, HorizDir, 0, LeftText, TopText));
  InsertView(Text);
END;

PROCEDURE TCDPlayerApp.CheckError;

BEGIN
  IF (Status AND cdstat_Error) <> 0 THEN              { Fehler aufgetreten? }
    OutMessage('Fehler', 'Ein weiter nicht spezifizierter Fehler ist', { ja }
      'aufgetreten.');
END;

FUNCTION TCDPlayerApp.GetCaption : PMGCaption;

BEGIN
  GetCaption := New(PMGCaption, Init(
    'Sound Blaster Superbuch  *  CD-Player  *  (c) 1993 by Arthur Burda',
    TRUE));
END;

FUNCTION TCDPlayerApp.GetStatusLine : PMGStatusLine;

BEGIN
  GetStatusLine := New(PMGStatusLine, Init(
    NewStatusItem(hcProgram, hcProgram, 'Programm ... Mit <ESC> '+
      'wechseln Sie zwischen Men und Schaltern.',
    NewStatusItem(hcQuitProgram, hcQuitProgram,
      'Beendet den CD-Player.',
    NewStatusItem(hc_Ok, hc_Ok, 'Drcken Sie <ENTER>, um die Meldung zu '+
      'besttigen.',
    NewStatusItem(101, 140, 'Klicken Sie den Track-Schalter an, '+
      'um den Abspielvorgang zu starten.',
    NewStatusItem(hc_PauseContinue, hc_PauseContinue,
      'Unterbricht/setzt den Abspielvorgang fort.',
    NewStatusItem(hc_Stop, hc_Stop, 'Stoppt den Abspielvorgang einer CD '+
      'endgltig.',
    NewStatusItem(hc_Forward, hc_Forward, 'Bewegt den Laufwerkskopf um '+
      'ca. 15 Sekunden vorwrts ("Weiterspulen").',
    NewStatusItem(hc_Backward, hc_Backward, 'Bewegt den Laufwerkskopf um '+
      'ca. 15 Sekunden rckwrts ("Zurckspulen").',
    NIL))))))))));
END;

PROCEDURE TCDPlayerApp.HandleEvent(VAR Event : TEvent);

VAR
  StartSector : LongInt;
  Pos         : LongInt;
  Sectors     : LongInt;

BEGIN
  INHERITED HandleEvent(Event);        { HandleEvent-Methode des Vorgngers }
  IF Event.What = evCommand THEN                     { ein Befehlsereignis? }
    CASE Event.Command OF                                   { ja, auswerten }
      101..140 :                                           { Track-Schalter }
        BEGIN
          StartSector := SBCDTrackToSector(Nmb, Event.Command-100);
          Status := SBCDSeek(Nmb, cdmode_RedBook, StartSector);
          Pos := SBCDHeadPos(Nmb, cdmode_HSG);
          Sectors := SBCDTimeToSector(TotalTime);
          Status := SBCDPlayAudio(Nmb, cdmode_HSG, Pos, Sectors-Pos);
          CheckError;
          IF Paused THEN
            BEGIN
              PauseButton^.NewText('P~ause');
              Paused := FALSE;
              IF ForwardButton^.GetState(vsDisabled) THEN
                BEGIN
                  ForwardButton^.SetState(vsDisabled, FALSE);
                  ForwardButton^.Draw;
                END;
              IF BackwardButton^.GetState(vsDisabled) THEN
                BEGIN
                  BackwardButton^.SetState(vsDisabled, FALSE);
                  BackwardButton^.Draw;
                END;
            END;
        END;
      cm_PauseContinue :                             { "Pause"/"Fortsetzen" }
        BEGIN
          IF Paused THEN                                     { Pause-Modus? }
            Status := SBCDContinueAudio(Nmb)     { ja, Abspielen fortsetzen }
          ELSE                                                       { nein }
            Status := SBCDStopAudio(Nmb);         { Pause-Modus einschalten }
          CheckError;
          Paused := SBCDPaused(Nmb);
          IF Paused THEN
            PauseButton^.NewText('~Fortsetzen')
          ELSE
            PauseButton^.NewText('P~ause');
          IF (GetIndex(SelectedView) = GetIndex(ForwardButton))
          OR (GetIndex(SelectedView) = GetIndex(BackwardButton)) THEN
            SelectView(GetIndex(PauseButton));
          IF Paused THEN
            ForwardButton^.SetState(vsDisabled, TRUE)
          ELSE
            ForwardButton^.SetState(vsDisabled, FALSE);
          ForwardButton^.Draw;
          IF Paused THEN
            BackwardButton^.SetState(vsDisabled, TRUE)
          ELSE
            BackwardButton^.SetState(vsDisabled, FALSE);
          BackwardButton^.Draw;
        END;
      cm_Stop :                                                    { "Stop" }
        BEGIN
          Status := SBCDStopAudio(Nmb);
          Status := SBCDSeek(Nmb, cdmode_HSG, 0);
          CheckError;
          IF Paused THEN
            BEGIN
              PauseButton^.NewText('P~ause');
              Paused := FALSE;
              IF ForwardButton^.GetState(vsDisabled) THEN
                BEGIN
                  ForwardButton^.SetState(vsDisabled, FALSE);
                  ForwardButton^.Draw;
                END;
              IF BackwardButton^.GetState(vsDisabled) THEN
                BEGIN
                  BackwardButton^.SetState(vsDisabled, FALSE);
                  BackwardButton^.Draw;
                END;
            END;
        END;
      cm_Forward :                                               { "Weiter" }
        IF NOT Paused THEN
          BEGIN
            Pos := SBCDHeadPos(Nmb, cdmode_HSG);
            Sectors := SBCDTimeToSector(TotalTime);
            IF Pos < Sectors-1000 THEN
              Inc(Pos, 1000)
            ELSE
              Pos := Sectors;
            Status := SBCDSeek(Nmb, cdmode_HSG, Pos);
            Status := SBCDPlayAudio(Nmb, cdmode_HSG, Pos, Sectors-Pos);
            CheckError;
          END;
      cm_Backward :                                              { "Zurck" }
        IF NOT Paused THEN
          BEGIN
            Pos := SBCDHeadPos(Nmb, cdmode_HSG);
            IF Pos > 1000 THEN
              Dec(Pos, 1000)
            ELSE
              Pos := 0;
            Status := SBCDSeek(Nmb, cdmode_HSG, Pos);
            Status := SBCDPlayAudio(Nmb, cdmode_HSG, Pos,
              SBCDTimeToSector(TotalTime)-Pos);
            CheckError;
          END;
    END;
END;

PROCEDURE TCDPlayerApp.OutMessage(CaptionText : TCaptionStr; Text1,
  Text2 : String);

VAR
  iRect  : TRect;                             { Rechteck auf dem Bildschirm }
  Dialog : PMGDialog3D;                         { Zeiger auf eine Dialogbox }
  Button : PMGDlgButton;              { Zeiger auf einen Dialogbox-Schalter }
  Text   : PMGStaticLine;           { Zeiger auf ein statisches Text-Objekt }

BEGIN
  iRect.Assign(100, 100, 540, 240);
  Dialog := New(PMGDialog3D, Init(iRect, 4, CaptionText, TRUE));
  IF Dialog^.Validate THEN                                { Dialogbox o.k.? }
    BEGIN                                                              { ja }
      Dialog^.SaveRect('DESKTOP.TMP');
      Dialog^.DeleteCloseField;                     { Schliefeld entfernen }
      iRect.Assign(20, 40, 420, 49);
      Text := New(PMGStaticLine, Init(iRect, Text1, DefaultFont, HorizDir, 0,
        LeftText, TopText));
      Dialog^.InsertView(Text);
      iRect.Assign(20, 50, 420, 59);
      Text := New(PMGStaticLine, Init(iRect, Text2, DefaultFont, HorizDir, 0,
        LeftText, TopText));
      Dialog^.InsertView(Text);
      iRect.Assign(170, 80, 250, 110);
      Button := New(PMGDlgButton, Init(iRect, 4, cmOk, '~Ok', TRUE));
      Button^.HelpCtx := hc_Ok;
      Dialog^.InsertButton(Button, TRUE);
      REPEAT
        Dialog^.SetState(vsEndState, FALSE);
      UNTIL Dialog^.Execute = cmOk;
    END;
  Dispose(Dialog, Done);
END;

PROCEDURE TCDPlayerApp.ResetDrive;

VAR
  iRect  : TRect;                             { Rechteck auf dem Bildschirm }
  Dialog : PMGDialog3D;                         { Zeiger auf eine Dialogbox }
  Text   : PMGStaticLine;           { Zeiger auf ein statisches Text-Objekt }

BEGIN
  iRect.Assign(100, 120, 540, 210);
  Dialog := New(PMGDialog3D, Init(iRect, 4, 'Information', TRUE));
  IF Dialog^.Validate THEN                                { Dialogbox o.k.? }
    BEGIN                                                              { ja }
      Dialog^.DeleteCloseField;                     { Schliefeld entfernen }
      iRect.Assign(20, 40, 420, 49);
      Text := New(PMGStaticLine, Init(iRect, 'Bitte einen Moment warten, '+
        'das CD-ROM-Laufwerk', DefaultFont, HorizDir, 0, LeftText, TopText));
      Dialog^.InsertView(Text);
      iRect.Assign(20, 50, 420, 59);
      Text := New(PMGStaticLine, Init(iRect, 'fhrt einen Reset aus ...',
        DefaultFont, HorizDir, 0, LeftText, TopText));
      Dialog^.InsertView(Text);
      Dialog^.SetState(vsVisible, TRUE);               { Dialogbox anzeigen }
    END;
  SBCDResetDrive(Nmb);                           { Reset des Gertetreibers }
  Dispose(Dialog, Done);
END;

PROCEDURE TCDPlayerApp.Run;

BEGIN
  TMGDesktop.Run;
END;

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

VAR
  CDPlayerApp : TCDPlayerApp;

BEGIN
  WITH CDPlayerApp DO
    BEGIN
      Init;                                       { Programm initialisieren }
      Run;                                               { Programm starten }
      Done;                                              { Programm beenden }
    END;
END.
