/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Interface for CH375 **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* CH375 ļϵͳӿ */
/* ֧: FAT12/FAT16/FAT32 */

/* MCS-51ƬCԵUļдʾ, 89C52߸ռĵƬ */
/* ʾļĿ¼,:޸ļ,ļĴںʱ */
/* CH375INT#Ųòѯʽ, ݸƷʽΪ"DPTR", ٶȽ, MCS51Ƭ
   V2.4ϰ汾CH375ӳ */


/* C51   CH375HFT.C */
/* LX51  CH375HFT.OBJ , CH375HF6.LIB */
/* OHX51 CH375HFT */

#include <reg52.h>
#include <stdio.h>
#include <string.h>

/* ¶ϸ˵뿴CH375HF6.Hļ */
#define LIB_CFG_DISK_IO			1		/* ̶дݵĸƷʽ,1Ϊ"DPTR",2Ϊ"˫DPTR",3Ϊ"DPTRP2+R0" */
#define LIB_CFG_FILE_IO			1		/* ļдݵĸƷʽ,0Ϊ"ⲿӳ",1Ϊ"DPTR",2Ϊ"˫DPTR",3Ϊ"DPTRP2+R0" */
#define LIB_CFG_INT_EN			0		/* CH375INT#ӷʽ,0Ϊ"ѯʽ",1Ϊ"жϷʽ" */
/*#define LIB_CFG_FILE_IO_DEFAULT	1*/		/* ʹCH375HF6.HṩĬ"ⲿӳ" */
/*#define LIB_CFG_UPD_SIZE		1*/		/* ݺǷԶļ: 0Ϊ"",1Ϊ"Զ" */
/* Ĭ,/ֽΪ0ôCH375FileWrite/CH375ByteWriteֻдݶ޸ļ,
   ҪÿдݺԶ޸/ļ,ôʹȫֱCH375LibConfigλ4Ϊ1,
   ʱ䲻дӦøļ,ֹͻȻϵǰдļȲ,
   ȷͻȻϵߺܿݲд򲻱ظļ,ٶȲU(Uڲڴ,Ƶд) */

#define CH375_CMD_PORT_ADDR		0xBDF1	/* CH375˿ڵI/Oַ */
#define CH375_DAT_PORT_ADDR		0xBCF0	/* CH375ݶ˿ڵI/Oַ */
/* 62256ṩ32KBRAMΪ: 0000H-01FFHΪ̶д, 0200H-7FFFHΪļݻ */
#define	DISK_BASE_BUF_ADDR		0x0000	/* ⲿRAMĴݻʼַ,ӸõԪʼĻΪSECTOR_SIZE */
#define DISK_BASE_BUF_LEN		4096	/* ĬϵĴݻСΪ512ֽ,ѡΪ20484096֧ĳЩU,Ϊ0ֹ.Hļж建ӦópDISK_BASE_BUFָ */

#define CH375_INT_WIRE			INT0	/* P3.2, INT0, CH375жINT#,CH375INT#,ڲѯж״̬ */

#define NO_DEFAULT_CH375_F_ENUM		1		/* δCH375FileEnumerʽֹԽԼ */

#include "..\CH375HF6.H"				/* Ҫ֧FAT32,ôѡCH375HF4.H */

/* P1.4һLEDڼʾĽ,͵ƽLED,U̲ */
sbit P1_4  = P1^4;
#define LED_OUT_INIT( )		{ P1_4 = 1; }	/* P1.4 ߵƽ */
#define LED_OUT_ACT( )		{ P1_4 = 0; }	/* P1.4 ͵ƽLEDʾ */
#define LED_OUT_INACT( )	{ P1_4 = 1; }	/* P1.4 ͵ƽLEDʾ */
sbit P1_5  = P1^5;
/* P1.5һLEDڼʾĽ,͵ƽLED,U̲ʱ */
#define LED_RUN_ACT( )		{ P1_5 = 0; }	/* P1.5 ͵ƽLEDʾ */
#define LED_RUN_INACT( )	{ P1_5 = 1; }	/* P1.5 ͵ƽLEDʾ */
sbit P1_6  = P1^6;
/* P1.6һLEDڼʾĽ,͵ƽLED,Uдʱ */
#define LED_WR_ACT( )		{ P1_6 = 0; }	/* P1.6 ͵ƽLEDʾ */
#define LED_WR_INACT( )		{ P1_6 = 1; }	/* P1.6 ͵ƽLEDʾ */

/* ԺΪλʱ,ȷ,24MHzʱ */
void	mDelaymS( unsigned char delay )
{
	unsigned char	i, j, c;
	for ( i = delay; i != 0; i -- ) {
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
	}
}

/* ռַƵڲRAM,ַ */
UINT8	mCopyCodeStringToIRAM( UINT8 idata *iDestination, UINT8 code *iSource )
{
	UINT8	i = 0;
	while ( *iDestination = *iSource ) {
		iDestination ++;
		iSource ++;
		i ++;
	}
	return( i );
}

/* ״̬,ʾ벢ͣ,Ӧ滻ΪʵʵĴʩ */
void	mStopIfError( UINT8 iError )
{
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
	printf( "Error: %02X\n", (UINT16)iError );  /* ʾ */
	while ( 1 ) {
		LED_OUT_ACT( );  /* LED˸ */
		mDelaymS( 200 );
		LED_OUT_INACT( );
		mDelaymS( 200 );
	}
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x21;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

/* ޸ָļļ,Cļ޸ΪTXTļ */
/* :   ԭʼļmCmdParam.Open.mPathName */
/* ״̬: ERR_SUCCESS = ޸ļɹ,
               ״̬οCH375HF?.H */
UINT8	RenameFileName( void )
{
	UINT8			i;
	P_FAT_DIR_INFO	mFileDir;
	i = CH375FileOpen( );  /* ļ */
	if ( i == ERR_SUCCESS ) {
		/* ļд... */
		i = CH375FileQuery( );  /* ѯļ,Ա㽫ݵڴ޸ */
		if ( i == ERR_SUCCESS ) {
			mFileDir = (P_FAT_DIR_INFO)( (PUINT8X)(&DISK_BASE_BUF[0]) + CH375vFdtOffset );  /* ڴ,ǰFDTʼַ */
			if ( mFileDir -> DIR_Name[8] == 'C' && mFileDir -> DIR_Name[9] == ' ' ) {  /* ļչC */
				mFileDir -> DIR_Name[8] = 'T';  /* ޸ļչΪTXT */
				mFileDir -> DIR_Name[9] = 'X';  /* ͬ޸ļ */
				mFileDir -> DIR_Name[10] = 'T';
			}
/* ½޸ĹݴڴˢµU */
			mCmdParam.Modify.mFileAttr = mFileDir -> DIR_Attr;  /* ׼޸ļ,ʵʱԭֵ */
			mCmdParam.Modify.mFileDate = mCmdParam.Modify.mFileTime = 0xFFFF;  /* ޸ļںʱ */
			mCmdParam.Modify.mFileSize = 0xFFFFFFFF;  /* ޸ļ */
			i = CH375FileModify( );  /* ʵǽڴиո޸Ĺļ */
			if ( i == ERR_SUCCESS ) {
				/* ļд... */
				mCmdParam.Close.mUpdateLen = 0;
				i = CH375FileClose( );  /* رļ */
			}
		}
	}
	return( i );
}

/* С˸ʽݴ,ļϵͳС,MCS51Ǵ,ԲҪת */
UINT16	SwapUINT16( UINT16 d )
{
	return( ( d << 8 ) & 0xFF00 | ( d >> 8 ) & 0xFF );
}

/* Ϊָļôںʱ */
/* :   ԭʼļmCmdParam.Open.mPathName, µĴںʱ: iCreateDate, iCreateTime */
/* ״̬: ERR_SUCCESS = óɹ,
               ״̬οCH375HF?.H */
UINT8	SetFileCreateTime( UINT16 iCreateDate, UINT16 iCreateTime )
{
	UINT8			i;
	P_FAT_DIR_INFO	mFileDir;
	i = CH375FileOpen( );  /* ļ */
	if ( i == ERR_SUCCESS ) {
		/* ļд... */
		i = CH375FileQuery( );  /* ѯļ,Ա㽫ݵڴ޸ */
		if ( i == ERR_SUCCESS ) {
			mFileDir = (P_FAT_DIR_INFO)( (PUINT8X)(&DISK_BASE_BUF[0]) + CH375vFdtOffset );  /* ڴ,ǰFDTʼַ */
//			mFileDir -> DIR_CrtTime = iCreateTime;  /* ļʱ,С˸ʽ */
			mFileDir -> DIR_CrtTime = SwapUINT16( iCreateTime );  /* MCS51ƬǴ˸ʽ */
//			mFileDir -> DIR_CrtDate = iCreateDate;  /* ļ,С˸ʽ */
			mFileDir -> DIR_CrtDate = SwapUINT16( iCreateDate );  /* MCS51ƬǴ˸ʽ */

//			mFileDir -> DIR_WrtTime = MAKE_FILE_TIME( ʱ, ,  );  /* ļ޸ʱ */
//			mFileDir -> DIR_LstAccDate = MAKE_FILE_DATE( , ,  );  /* һδȡ */

/* ½޸ĹݴڴˢµU */
			mCmdParam.Modify.mFileAttr = mFileDir -> DIR_Attr;  /* ׼޸ļ,ʵʱԭֵ */
			mCmdParam.Modify.mFileDate = mCmdParam.Modify.mFileTime = 0xFFFF;  /* ޸ļںʱ */
			mCmdParam.Modify.mFileSize = 0xFFFFFFFF;  /* ޸ļ */
			i = CH375FileModify( );  /* ʵǽڴиո޸Ĺļ */
			if ( i == ERR_SUCCESS ) {
				/* ļд... */
				mCmdParam.Close.mUpdateLen = 0;
				i = CH375FileClose( );  /* رļ */
			}
		}
	}
	return( i );
}

main( ) {
	UINT8	i;
	LED_OUT_INIT( );
	LED_OUT_ACT( );  /* LEDһʾ */
	mDelaymS( 100 );  /* ʱ100 */
	LED_OUT_INACT( );
	mInitSTDIO( );  /* Ϊüͨڼʾ */
	printf( "Start\n" );

#if DISK_BASE_BUF_LEN == 0
	pDISK_BASE_BUF = &my_buffer[0];  /* .HļжCH375רû,ûָָӦóĻںԽԼRAM */
#endif

	i = CH375LibInit( );  /* ʼCH375CH375оƬ,ɹ0 */
	mStopIfError( i );
/* ·ʼ */

	while ( 1 ) {
		printf( "Wait Udisk\n" );
		while ( CH375DiskStatus < DISK_CONNECT ) {  /* ѯCH375жϲж״̬,ȴU̲ */
			CH375DiskConnect( );
			mDelaymS( 100 );
		}
		LED_OUT_ACT( );  /* LED */
		mDelaymS( 200 );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */

/* UǷ׼,ЩU̲Ҫһ,ĳЩU̱Ҫִһܹ */
		for ( i = 0; i < 3; i ++ ) {  /* еUǷδ׼,Ա */
			mDelaymS( 100 );
			printf( "Ready ?\n" );
			if ( CH375DiskReady( ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
		}
#if DISK_BASE_BUF_LEN
		if ( DISK_BASE_BUF_LEN < CH375vSectorSize ) {  /* ݻǷ㹻,CH375vSectorSizeU̵ʵС */
			printf( "Too large sector size\n" );
			while ( CH375DiskConnect( ) == ERR_SUCCESS ) mDelaymS( 100 );
			continue;
		}
#endif
/* ѯ */
/*		printf( "DiskSize\n" );
		i = CH375DiskSize( );  
		mStopIfError( i );
		printf( "TotalSize = %u MB \n", (unsigned int)( mCmdParam.DiskSize.mDiskSizeSec * (CH375vSectorSize/512) / 2048 ) );  // ʾΪMBΪλ
		// ԭ㷽 (unsigned int)( mCmdParam.DiskSize.mDiskSizeSec * CH375vSectorSize / 1000000 ) пǰ˺, ޸ĳʽ
*/
		LED_RUN_ACT( );  /* ʼU */

		printf( "Open and rename CH375HFT.C to CH375HFT.TXT \n" );
		mCopyCodeStringToIRAM( mCmdParam.Open.mPathName, "/CH375HFT.C" );  /* ԭʼļ,ļڸĿ¼ */
		LED_WR_ACT( );  /* д */
		i = RenameFileName( );  /* ޸ļ, Cļ => TXTļ */
		mStopIfError( i );
		printf( "Set file create date & time to 2004.06.08 15:39:20 \n" );
		mCopyCodeStringToIRAM( mCmdParam.Open.mPathName, "/CH375HFT.TXT" );  /* ԭʼļ */
		i = SetFileCreateTime( MAKE_FILE_DATE( 2004, 6, 8 ), MAKE_FILE_TIME( 15, 39, 20 ) );  /* Ϊָļôںʱ */
		mStopIfError( i );
		LED_WR_INACT( );
		LED_RUN_INACT( );
		printf( "Take out\n" );
		while ( CH375DiskStatus >= DISK_CONNECT ) {  /* ѯCH375жϲж״̬,ȴṴγ */
			CH375DiskConnect( );
			mDelaymS( 100 );
		}
		LED_OUT_INACT( );  /* LED */
		mDelaymS( 200 );
	}
}
