/* CH374оƬ Ӧò V1.0 */
/* USB,ʼöٵǰӵUSB豸,ڵHUB˿HUB0еȫUSB豸 */

#include	<stdio.h>
#include	<string.h>
#include	"..\HAL.H"			// MCS51ΪƬ޸HAL*Ӳļļ
#include	"..\HAL_BASE.C"	// ӳжϲѯӳ

/* Ӳӿڲ,ӷʽѡһ */
#include "..\PARA_HW.C"	/* Ӳ׼8λ */
//#include "..\PARA_SW.C"	/* I/Oģ8λ */
//#include "..\SPI_HW.C"	/* Ӳ׼4SPI */
//#include "..\SPI_SW.C"	/* I/Oģ4SPI */
//#include "..\SPI3_SW.C"	/* I/Oģ3SPI,SDOSDIһ */

// ȡ豸
const	UINT8C	SetupGetDevDescr[] = { 0x80, 0x06, 0x00, 0x01, 0x00, 0x00, 0x12, 0x00 };
// ȡ
const	UINT8C	SetupGetCfgDescr[] = { 0x80, 0x06, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00 };
// USBַ
const	UINT8C	SetupSetUsbAddr[] = { 0x00, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 };
// USB
const	UINT8C	SetupSetUsbConfig[] = { 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

UINT8	UsbDevEndpSize = DEFAULT_ENDP0_SIZE;	/* USB豸Ķ˵0ߴ */

UINT8	FlagDeviceStatus;						/* ǰUSB豸״̬ͨжϷʽȫֱδʹ */

// CH374ĿĶ˵ַ/PID/ͬ־ͬCH375NAKԣʱ/
UINT8	HostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog );

// CH374ĿĶ˵ַ/PID/ͬ־/mSΪλNAKʱ(0xFFFF)ͬCH375NAKԣʱ
UINT8	WaitHostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog, UINT16 timeout );

UINT8	HostCtrlTransfer374( PUINT8 ReqBuf, PUINT8 DatBuf, PUINT8 RetLen );  // ִпƴ,ReqBufָ8ֽ,DatBufΪշ
// ҪպͷݣôDatBufָЧڴźݣʵʳɹշܳȱReqLenָֽڱ

// ѯǰǷUSB豸
//BOOL	Query374DeviceIn( void );
#define	Query374DeviceIn( )	( ( Read374Byte( REG_INTER_FLAG ) & BIT_IF_DEV_ATTACH ) ? TRUE : FALSE )

// ѯǰUSB豸ȫٻǵ, TRUEΪȫ
//BOOL	Query374DevFullSpeed( void );
#define	Query374DevFullSpeed( )	( ( Read374Byte( REG_SYS_INFO ) & BIT_INFO_USB_DP ) ? TRUE : FALSE )

void	HostDetectInterrupt( void );  // USB豸¼ж

void	SetHostUsbAddr( UINT8 addr );  // USBǰUSB豸ַ

void	HostSetBusFree( void );  // USB߿

void	HostSetBusReset( void );  // USB߸λ

void	HostSetFullSpeed( void );  // 趨ȫUSB豸л

void	HostSetLowSpeed( void );  // 趨USB豸л,οEMB_HUBеĵӴ

void	Init374Host( void );  // ʼUSB

UINT8	GetDeviceDescr( PUINT8 buf );  // ȡ豸

UINT8	GetConfigDescr( PUINT8 buf );  // ȡ

UINT8	SetUsbAddress( UINT8 addr );  // USB豸ַ

UINT8	SetUsbConfig( UINT8 cfg );  // USB豸


// CH374ĿĶ˵ַ/PID/ͬ־ͬCH375NAKԣʱ/
UINT8	HostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog )
{  // ӳ,ʵӦ,Ϊṩٶ,ӦöԱӳŻ
	UINT8	retry;
	UINT8	s, r, u;
	for ( retry = 0; retry < 3; retry ++ ) {
		Write374Byte( REG_USB_H_PID, M_MK_HOST_PID_ENDP( pid, endp_addr ) );  // ָPIDĿĶ˵
//		Write374Byte( REG_USB_H_CTRL, BIT_HOST_START | ( tog ? ( BIT_HOST_TRAN_TOG | BIT_HOST_RECV_TOG ) : 0x00 ) );  // ͬ־
		Write374Byte( REG_USB_H_CTRL, ( tog ? ( BIT_HOST_START | BIT_HOST_TRAN_TOG | BIT_HOST_RECV_TOG ) : BIT_HOST_START ) );  // ͬ־
//		Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE );  // ȡͣ
		s = Wait374Interrupt( );
		if ( s == ERR_USB_UNKNOWN ) return( s );  // жϳʱ,Ӳ쳣
		s = Read374Byte( REG_INTER_FLAG );  // ȡж״̬
		if ( s & BIT_IF_DEV_DETECT ) {  // USB豸¼
			mDelayuS( 200 );  // ȴ
			Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_DEV_DETECT | BIT_IF_TRANSFER );  // жϱ־
			if ( s & BIT_IF_DEV_ATTACH ) {  // USB豸¼
				u = Read374Byte( REG_USB_SETUP );
				if ( s & BIT_IF_USB_DX_IN ) {  // ٶƥ䣬Ҫлٶ
					if ( u & BIT_SETP_USB_SPEED ) return( USB_INT_CONNECT_LS );  // USB豸
					return( USB_INT_CONNECT );  // ȫUSB豸
				}
				else {  // ٶʧ䣬Ҫлٶ
					if ( u & BIT_SETP_USB_SPEED ) return( USB_INT_CONNECT );  // ȫUSB豸
					return( USB_INT_CONNECT_LS );  // USB豸
				}
			}
			else return( USB_INT_DISCONNECT );  // USB豸Ͽ¼
		}
		else if ( s & BIT_IF_TRANSFER ) {  // 
			Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_TRANSFER );  // жϱ־
			s = Read374Byte( REG_USB_STATUS );  // USB״̬
			r = s & BIT_STAT_DEV_RESP;  // USB豸Ӧ״̬
			switch ( pid ) {
				case DEF_USB_PID_SETUP:
				case DEF_USB_PID_OUT:
					if ( r == DEF_USB_PID_ACK ) return( USB_INT_SUCCESS );
					else if ( r == DEF_USB_PID_STALL || r == DEF_USB_PID_NAK ) return( r | 0x20 );
					else if ( ! M_IS_HOST_TIMEOUT( s ) ) return( r | 0x20 );  // ǳʱ/Ӧ
					break;
				case DEF_USB_PID_IN:
					if ( M_IS_HOST_IN_DATA( s ) ) {  // DEF_USB_PID_DATA0 or DEF_USB_PID_DATA1
						if ( s & BIT_STAT_TOG_MATCH ) return( USB_INT_SUCCESS );  // ͬ趪
					}
					else if ( r == DEF_USB_PID_STALL || r == DEF_USB_PID_NAK ) return( r | 0x20 );
					else if ( ! M_IS_HOST_TIMEOUT( s ) ) return( r | 0x20 );  // ǳʱ/Ӧ
					break;
				default:
					return( ERR_USB_UNKNOWN );  // ܵ
					break;
			}
		}
		else {  // ж,Ӧ÷
			mDelayuS( 200 );  // ȴ
			Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_INTER_FLAG );  /* жϱ־ */
			if ( retry ) return( ERR_USB_UNKNOWN );  /* ǵһμ⵽򷵻ش */
		}
	}
	return( 0x20 );  // Ӧʱ
}

// CH374ĿĶ˵ַ/PID/ͬ־/mSΪλNAKʱ(0xFFFF)ͬCH375NAKԣʱ
UINT8	WaitHostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog, UINT16 timeout )
{
	UINT8	i, s;
	while ( 1 ) {
		for ( i = 0; i < 40; i ++ ) {
			s = HostTransact374( endp_addr, pid, tog );
			if ( s != ( DEF_USB_PID_NAK | 0x20 ) || timeout == 0 ) return( s );
			mDelayuS( 20 );
		}
		if ( timeout < 0xFFFF ) timeout --;
	}
}

UINT8	HostCtrlTransfer374( PUINT8 ReqBuf, PUINT8 DatBuf, PUINT8 RetLen )  // ִпƴ,ReqBufָ8ֽ,DatBufΪշ
// ҪպͷݣôDatBufָЧڴźݣʵʳɹշܳȱReqLenָֽڱ
{
	UINT8	s, len, count, total;
	BOOL	tog;
	Write374Block( RAM_HOST_TRAN, 8, ReqBuf );
	Write374Byte( REG_USB_LENGTH, 8 );
	mDelayuS( 100 );
	s = WaitHostTransact374( 0, DEF_USB_PID_SETUP, FALSE, 200 );  // SETUP׶Σ200mSʱ
	if ( s == USB_INT_SUCCESS ) {  // SETUPɹ
		tog = TRUE;  // ĬDATA1,Ĭݹ״̬׶ΪIN
		total = *( ReqBuf + 6 );
		if ( total && DatBuf ) {  // Ҫշ
			len = total;
			if ( *ReqBuf & 0x80 ) {  // 
				while ( len ) {
					mDelayuS( 100 );
					s = WaitHostTransact374( 0, DEF_USB_PID_IN, tog, 200 );  // IN
					if ( s != USB_INT_SUCCESS ) break;
					count = Read374Byte( REG_USB_LENGTH );
					Read374Block( RAM_HOST_RECV, count, DatBuf );
					DatBuf += count;
					if ( count <= len ) len -= count;
					else len = 0;
					if ( count == 0 || ( count & ( UsbDevEndpSize - 1 ) ) ) break;  // ̰
					tog = tog ? FALSE : TRUE;
				}
				tog = FALSE;  // ״̬׶ΪOUT
			}
			else {  // 
				while ( len ) {
					mDelayuS( 100 );
					count = len >= UsbDevEndpSize ? UsbDevEndpSize : len;
					Write374Block( RAM_HOST_TRAN, count, DatBuf );
					Write374Byte( REG_USB_LENGTH, count );
					s = WaitHostTransact374( 0, DEF_USB_PID_OUT, tog, 200 );  // OUT
					if ( s != USB_INT_SUCCESS ) break;
					DatBuf += count;
					len -= count;
					tog = tog ? FALSE : TRUE;
				}
				tog = TRUE;  // ״̬׶ΪIN
			}
			total -= len;  // ȥʣ೤ȵʵʴ䳤
		}
		if ( s == USB_INT_SUCCESS ) {  // ݽ׶γɹ
			Write374Byte( REG_USB_LENGTH, 0 );
			mDelayuS( 100 );
			s = WaitHostTransact374( 0, ( tog ? DEF_USB_PID_IN : DEF_USB_PID_OUT ), TRUE, 200 );  // STATUS׶
			if ( tog && s == USB_INT_SUCCESS ) {  // IN״̬ݳ
				if ( Read374Byte( REG_USB_LENGTH ) ) s = USB_INT_BUF_OVER;  // ״̬׶δ
			}
		}
	}
	if ( RetLen ) *RetLen = total;  // ʵʳɹշܳ
	return( s );
}

// ѯǰǷUSB豸
//BOOL	Query374DeviceIn( void )
//#define	Query374DeviceIn( )	( ( Read374Byte( REG_INTER_FLAG ) & BIT_IF_DEV_ATTACH ) ? TRUE : FALSE )

// ѯǰUSB豸ȫٻǵ, TRUEΪȫ
//BOOL	Query374DevFullSpeed( void )
//#define	Query374DevFullSpeed( )	( ( Read374Byte( REG_SYS_INFO ) & BIT_INFO_USB_DP ) ? TRUE : FALSE )

void	HostDetectInterrupt( void )  // USB豸¼ж
{
	UINT8	s, u;
	s = Read374Byte( REG_INTER_FLAG );  // ȡж״̬
	if ( s & BIT_IF_DEV_DETECT ) {  // USB豸¼
		Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_DEV_DETECT );  // жϱ־
		if ( s & BIT_IF_DEV_ATTACH ) {  // USB豸¼
			u = Read374Byte( REG_USB_SETUP );
			if ( s & BIT_IF_USB_DX_IN ) {  // ٶƥ䣬Ҫлٶ
				if ( u & BIT_SETP_USB_SPEED ) FlagDeviceStatus = USB_INT_CONNECT_LS;  // USB豸
				else FlagDeviceStatus = USB_INT_CONNECT;  // ȫUSB豸
			}
			else {  // ٶʧ䣬Ҫлٶ
				if ( u & BIT_SETP_USB_SPEED ) FlagDeviceStatus = USB_INT_CONNECT;  // ȫUSB豸
				else FlagDeviceStatus = USB_INT_CONNECT_LS;  // USB豸
			}
		}
		else FlagDeviceStatus = USB_INT_DISCONNECT;  // USB豸Ͽ¼
	}
	else {  // ж
		Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_TRANSFER | BIT_IF_USB_SUSPEND | BIT_IF_WAKE_UP );  // жϱ־
	}
}

void	SetHostUsbAddr( UINT8 addr )  // USBǰUSB豸ַ
{
	Write374Byte( REG_USB_ADDR, addr );
}

void	HostSetBusFree( void )  // USB߿
{
//	Write374Byte( REG_USB_SETUP, M_SET_USB_BUS_FREE( Read374Byte( REG_USB_SETUP ) ) );  // USB߿
	Write374Byte( REG_USB_SETUP, BIT_SETP_HOST_MODE );  // USBʽ
	Write374Byte( REG_USB_SETUP, BIT_SETP_HOST_MODE | BIT_SETP_AUTO_SOF );  // USBʽ,SOF
}

void	HostSetBusReset( void )  // USB߸λ
{
	UsbDevEndpSize = DEFAULT_ENDP0_SIZE;  /* USB豸Ķ˵0ߴ */
	SetHostUsbAddr( 0x00 );
	Write374Byte( REG_USB_H_CTRL, 0x00 );
//	Write374Byte( REG_USB_SETUP, M_SET_USB_BUS_RESET( Read374Byte( REG_USB_SETUP ) & ~ BIT_SETP_AUTO_SOF ) );  // USB߸λ
	Write374Byte( REG_USB_SETUP, M_SET_USB_BUS_RESET( BIT_SETP_HOST_MODE ) );  // USB߸λ
	mDelaymS( 15 );  // USB߸λڼ,10mS20mS
//	Write374Byte( REG_USB_SETUP, M_SET_USB_BUS_FREE( Read374Byte( REG_USB_SETUP ) ) );  // USB߿
	HostSetBusFree( );  // USB߿
	mDelaymS( 1 );
	Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_DEV_DETECT | BIT_IF_USB_SUSPEND );  // жϱ־
}

void	HostSetFullSpeed( void )  // 趨ȫUSB豸л
{
	Write374Byte( REG_USB_SETUP, Read374Byte( REG_USB_SETUP ) & ~ BIT_SETP_USB_SPEED | BIT_SETP_AUTO_SOF );  // ȫҷSOF
}

void	HostSetLowSpeed( void )  // 趨USB豸л,οEMB_HUBеĵӴ
{
	Write374Byte( REG_USB_SETUP, Read374Byte( REG_USB_SETUP ) | BIT_SETP_USB_SPEED | BIT_SETP_AUTO_SOF );  // ҷSOF
}

void	Init374Host( void )  // ʼUSB
{
	Write374Byte( REG_USB_SETUP, 0x00 );
	SetHostUsbAddr( 0x00 );
	Write374Byte( REG_USB_H_CTRL, 0x00 );
	Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_INTER_FLAG );  // жϱ־
//	Write374Byte( REG_INTER_EN, BIT_IE_TRANSFER );  // ж,ΪʹòѯʽUSB豸,USB豸ж
	Write374Byte( REG_INTER_EN, BIT_IE_TRANSFER | BIT_IE_DEV_DETECT );  // жϺUSB豸ж
	Write374Byte( REG_SYS_CTRL, BIT_CTRL_OE_POLAR );  // CH374TUENյCH374SBIT_CTRL_OE_POLARΪ1
	HostSetBusFree( );  // USB߿
}

UINT8	GetDeviceDescr( PUINT8 buf )  // ȡ豸
{
	UINT8	s, len;
	s = HostCtrlTransfer374( SetupGetDevDescr, buf, &len );  // ִпƴ
	if ( s == USB_INT_SUCCESS ) {
		UsbDevEndpSize = ( (PUSB_DEV_DESCR)buf ) -> bMaxPacketSize0;  // ˵0,Ǽ򻯴,ӦȻȡǰ8ֽںUsbDevEndpSizeټ
		if ( len < ( (PUSB_SETUP_REQ)SetupGetDevDescr ) -> wLengthL ) s = USB_INT_BUF_OVER;  // ȴ
	}
	return( s );
}

UINT8	GetConfigDescr( PUINT8 buf )  // ȡ
{
	UINT8	s, len;
	UINT8	BufLogDescr[ sizeof( SetupGetCfgDescr ) ] ;
	s = HostCtrlTransfer374( SetupGetCfgDescr, buf, &len );  // ִпƴ
	if ( s == USB_INT_SUCCESS ) {
		if ( len < ( (PUSB_SETUP_REQ)SetupGetCfgDescr ) -> wLengthL ) s = USB_INT_BUF_OVER;  // سȴ
		else {
			memcpy ( BufLogDescr, SetupGetCfgDescr, sizeof( SetupGetCfgDescr ) );
			( (PUSB_SETUP_REQ)BufLogDescr ) -> wLengthL = ( (PUSB_CFG_DESCR)buf ) -> wTotalLengthL;  // ܳ
			s = HostCtrlTransfer374( BufLogDescr, buf, &len );  // ִпƴ
			if ( s == USB_INT_SUCCESS ) {
				if ( len < ( (PUSB_CFG_DESCR)buf ) -> wTotalLengthL ) s = USB_INT_BUF_OVER;  // ȴ
			}
		}
	}
	return( s );
}

UINT8	SetUsbAddress( UINT8 addr )  // USB豸ַ
{
	UINT8	s;
	UINT8	BufSetAddr[ sizeof( SetupSetUsbAddr ) ] ;
	memcpy ( BufSetAddr, SetupSetUsbAddr, sizeof( SetupSetUsbAddr ) );
	( (PUSB_SETUP_REQ)BufSetAddr ) -> wValueL = addr;  // USB豸ַ
	s = HostCtrlTransfer374( BufSetAddr, NULL, NULL );  // ִпƴ
	if ( s == USB_INT_SUCCESS ) {
		SetHostUsbAddr( addr );  // USBǰUSB豸ַ
	}
	mDelaymS( 3 );  // ȴUSB豸ɲ
	return( s );
}

UINT8	SetUsbConfig( UINT8 cfg )  // USB豸
{
	UINT8	BufSetCfg[ sizeof( SetupSetUsbConfig ) ] ;
	memcpy ( BufSetCfg, SetupSetUsbConfig, sizeof( SetupSetUsbConfig ) );
	( (PUSB_SETUP_REQ)BufSetCfg ) -> wValueL = cfg;  // USB豸
	return( HostCtrlTransfer374( BufSetCfg, NULL, NULL ) );  // ִпƴ
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TL2 = RCAP2L = 0 - 13; /* 24MHz, 57600bps */
	TH2 = RCAP2H = 0xFF;
	T2CON = 0x34;  /* ʱ2ڴڵĲʷ */
	TI = 1;
}

int	main( void )  // USB host
{
	UINT8	i, s;
	UINT8 idata	buf[64];
//	P1&=0xF8; // Uļдģñϱ
	mDelaymS( 50 );  // ȴCH374λ
	CH374_PORT_INIT( );  /* CH374ӿڳʼ */

	mInitSTDIO( );  /* Ϊüͨڼʾ */
	printf( "Start CH374 Host\n" );

	Init374Host( );  // ʼUSB
	while ( 1 ) {
		HostSetBusFree( );  // 趨USB
		printf( "Wait Device In\n" );
		while ( 1 ) {
			if ( Query374Interrupt( ) ) HostDetectInterrupt( );  // USBж
			if ( Query374DeviceIn( ) ) break;  // USB豸
		}
		mDelaymS( 250 );  // USB豸ղδȶʵȴUSB豸ٺ룬ζ
		if ( Query374Interrupt( ) ) HostDetectInterrupt( );  // USBж

		printf( "Reset Device\n" );
		HostSetBusReset( );  // USB߸λ
		for ( i = 0; i < 100; i ++ ) {  // ȴUSB豸λ
			if ( Query374DeviceIn( ) ) break;  // USB豸
			mDelaymS( 1 );
		}
		if ( Query374Interrupt( ) ) HostDetectInterrupt( );  // USBж
		if ( Query374DeviceIn( ) ) {  // USB豸
			if ( Query374DevFullSpeed( ) ) {
				HostSetFullSpeed( );  // ⵽ȫUSB豸
				printf( "Start Full-Speed Device\n" );
			}
			else {  // οEMB_HUBеĵӴ
				HostSetLowSpeed( );  // ⵽USB豸,οEMB_HUBеĵӴ
				printf( "Start Low-Speed Device\n" );
			}
		}
		else {
			printf( "Device gone !\n" );
			continue;  // 豸ѾϿ,ȴ
		}
		mDelaymS( 50 );

		printf( "GetDeviceDescr: " );
		s = GetDeviceDescr( buf );  // ȡ豸
		if ( s != USB_INT_SUCCESS ) {
			printf( "ERROR = %02X\n", (UINT16)s );
			goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
		}
		for ( i = 0; i < ( (PUSB_SETUP_REQ)SetupGetDevDescr ) -> wLengthL; i ++ ) printf( "%02X ", (UINT16)( buf[i] ) );
		printf( "\n" );

		printf( "SetUsbAddress: " );
		s = SetUsbAddress( 0x02 );  // USB豸ַ
		if ( s != USB_INT_SUCCESS ) {
			printf( "ERROR = %02X\n", (UINT16)s );
			goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
		}
		printf( "\n" );

		printf( "GetConfigDescr: " );
		s = GetConfigDescr( buf );  // ȡ
		if ( s != USB_INT_SUCCESS ) {
			printf( "ERROR = %02X\n", (UINT16)s );
			goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
		}
		for ( i = 0; i < ( (PUSB_CFG_DESCR)buf ) -> wTotalLengthL; i ++ ) printf( "%02X ", (UINT16)( buf[i] ) );
		printf( "\n" );
/* ȡ˵/˵ַ/˵Сȣ±endp_addrendp_size */

		printf( "SetUsbConfig: " );
		s = SetUsbConfig( ( (PUSB_CFG_DESCR)buf ) -> bConfigurationValue );  // USB豸
		if ( s != USB_INT_SUCCESS ) {
			printf( "ERROR = %02X\n", (UINT16)s );
			goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
		}
		printf( "\n" );

		printf( "USB device ready now\n" );
/* do something, read/write ...
		len = out_endp_size;
		Write374Block( RAM_HOST_TRAN, len, buf );
		Write374Byte( REG_USB_LENGTH, len );
		s = WaitHostTransact374( out_endp_addr, DEF_USB_PID_OUT, FALSE, 1000 );
		s = WaitHostTransact374( in_endp_addr, DEF_USB_PID_IN, FALSE, 1000 );
		len = Read374Byte( REG_USB_LENGTH );
		Read374Block( RAM_HOST_RECV, len, buf );
		len = out_endp_size;
		Write374Block( RAM_HOST_TRAN, len, buf );
		Write374Byte( REG_USB_LENGTH, len );
		s = WaitHostTransact374( out_endp_addr, DEF_USB_PID_OUT, TRUE, 1000 );
		s = WaitHostTransact374( in_endp_addr, DEF_USB_PID_IN, TRUE, 1000 );
		len = Read374Byte( REG_USB_LENGTH );
		Read374Block( RAM_HOST_RECV, len, buf );
*/
		printf( "do something, read / write ......\n" );

WaitDeviceOut:  // ȴUSB豸γ
		printf( "Wait Device Out\n" );
		while ( 1 ) {
			if ( Query374Interrupt( ) ) HostDetectInterrupt( );  // USBж
			if ( Query374DeviceIn( ) == FALSE ) break;  // ûUSB豸
		}
		mDelaymS( 100 );  // ȴ豸ȫϿζ
		if ( Query374DeviceIn( ) ) goto WaitDeviceOut;  // ûȫϿ
//		HostSetBusFree( );  // 趨USBУҪĿǹرSOF
	}
}
