/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Module      @CH375  **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* Uļдģ, ӷʽ: 3ƴ+ѯ */
/* MCS-51ƬCʾ */
/* ΪʹUļдģʹUļӳ,ռýٵĵƬԴ,ʹ89C51Ƭ */
/* ʾļĿ¼,:޸ļ,ļĴںʱ */

#include <reg51.h>
#include <absacc.h>
#include <string.h>
#include <stdio.h>

#define MAX_PATH_LEN			40		/* ·,бָܷСԼ·00H,CH375ģֵֵ֧62,Сֵ13 */
/* Ϊ˴ļĿ¼,MAX_PATH_LENΪ36,sizeof( mCmdParam.FileDirInfo ) */
#include "..\CH375HM.H"

/* ·ӷʽ,ֻҪ3,ʹôͬ
   Ƭ    ģ
    TXD   =  SIN
    RXD   =  SOUT
             STA# ջӸߵƽ
             INT# ӵػӵ͵ƽ
    GND   =  GND
*/
sbit	P15					=	P1^5;

CMD_PARAM	idata	mCmdParam;			/* Ĭ¸ýṹռ60ֽڵRAM,޸MAX_PATH_LEN,޸Ϊ32ʱ,ֻռ32ֽڵRAM */

sbit	LED_OUT		=	P1^4;			/* P1.4 ͵ƽLEDʾ,ڼʾĽ */

/* ԺΪλʱ,24MHzʱ */
void	mDelaymS( unsigned char delay )
{
	unsigned char	i, j, c;
	for ( i = delay; i != 0; i -- ) {
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
	}
}

/* һֽݸCH375ģ */
void	mSendByte( unsigned char c )
{
	TI = 0;
	SBUF = c;
	while ( TI == 0 );
}

/* CH375ģһֽ */
unsigned char	mRecvByte( )
{
	unsigned char	c;
	while ( RI == 0 );
	c = SBUF;
	RI = 0;
	return( c );
}

/* ִ */
unsigned char	ExecCommand( unsigned char cmd, unsigned char len )
/* ,ز״̬,ͷزCMD_PARAMṹ */
{
	unsigned char		i, j, status;
	mSendByte( SER_SYNC_CODE1 );  /* ʹ֪ͬͨģ,˵뿪ʼ,ʼִ */
	mSendByte( SER_SYNC_CODE2 );  /* ͬSTA#½ */
/* ͬӦ,,ôʱ䲻ܳ20mS,Ч */
	RI = 0;
	mSendByte( cmd );  /* д */
	mSendByte( len );  /* дĳ */
	if ( len ) {  /* в */
		for ( i = 0; i != len; i ++ ) mSendByte( mCmdParam.Other.mBuffer[ i ] );  /* д */
	}
	while ( 1 ) {  /* ݴ,ֱɲ˳ */
		status = mRecvByte( );  /* ȴģɲز״̬ */
		if ( status == ERR_SUCCESS ) {  /* ɹ */
			i = mRecvByte( );  /* ؽݵĳ */
			if ( i ) {  /* н */
				j = 0;
				do {  /* ʹdo+whileṹΪЧʸfor */
					mCmdParam.Other.mBuffer[ j ] = mRecvByte( );  /* սݲ浽ṹ */
					j ++;
				} while ( -- i );
			}
			break;  /* ɹ */
		}
		else if ( status == USB_INT_DISK_READ || status == USB_INT_DISK_WRITE || status == USB_INT_DISK_RETRY ) {  /* ڴU̶ݿ,ݶ,Uдݿ,д,дݿʧ */
			break;  /* ֻʹֽΪλļдӳ,²յ״̬,ʧܷ */
		}
		else {  /* ʧ */
			if ( status == ERR_DISK_DISCON || status == ERR_USB_CONNECT ) mDelaymS( 100 );  /* U̸ոӻ߶Ͽ,Ӧʱʮٲ */
			break;  /* ʧܷ */
		}
	}
	return( status );
}

/* ״̬,ʾ벢ͣ,Ӧ滻ΪʵʵĴʩ */
void	mStopIfError( unsigned char iError )
{
	unsigned char	led;
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
/*	printf( "Error: %02X\n", (unsigned short)iError );*/  /* ʾ */
	led=0;
	while ( 1 ) {
		LED_OUT = led&1;  /* LED˸ */
		mDelaymS( 100 );
		led^=1;
	}
}

/* С˸ʽݴ */
unsigned short	SwapUINT16( unsigned short d )
{
	return( ( d << 8 ) & 0xFF00 | ( d >> 8 ) & 0xFF );
}

main( ) {
	unsigned char	i;
	unsigned short	FileCreateDate, FileCreateTime;
	unsigned char	*name;
	LED_OUT = 0;  /* LEDһʾ */
	mDelaymS( 100 );  /* ʱ100,CH375ģϵҪ100ҵĸλʱ */
	mDelaymS( 100 );
	LED_OUT = 1;
/* CH375ģͨѶĴ */
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xE6;  /* 24MHz, 4800bps */
	TR1 = 1;

/*	printf( "Start\n" );*/
	while ( 1 ) {  /* ѭ */
/*		printf( "Wait\n" );*/
		while ( 1 ) {  /* ʹòѯʽUǷ */
			i = ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬ */
			mStopIfError( i );
			if ( mCmdParam.Status.mDiskStatus >= DISK_CONNECT ) break;  /* UѾ */
			mDelaymS( 100 );  /* ڴдUʱٲѯ,ûбҪһֱͣزѯ,õƬ,û¿ʱȴһٲѯ */
		}
		mDelaymS( 200 );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */
		LED_OUT = 0;  /* LED */
/* UǷ׼,ĳЩU̱Ҫִһܹ */
		for ( i = 0; i < 3; i ++ ) {
			mDelaymS( 100 );
//			printf( "Ready ?\n" );
			if ( ExecCommand( CMD_DiskReady, 0 ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
		}
/* MY_ADC.TXTļ޸ΪWY_ADC.C,ôļںʱ,ȴԭļ */
		name = "/MY_ADC.TXT";  /* ļ,б˵ǴӸĿ¼ʼ */
/*		printf( "Open\n" );*/
		strcpy( mCmdParam.Open.mPathName, name );  /* ԭļ */
		i = ExecCommand( CMD_FileOpen, MAX_PATH_LEN );  /* ļ,Ϊֵ,ʡټ */
		if ( i == ERR_MISS_FILE ) mStopIfError( i );  /* ļ,Ȼ޷޸ļĿ¼Ϣ */
		mStopIfError( i );
		/* ļд... */

/*		printf( "Get file directory information\n" );*/
		mCmdParam.FileDirInfo.mAccessMode = 0;  /* ȡļĿ¼Ϣ */
		mCmdParam.FileDirInfo.mReserved[0] = mCmdParam.FileDirInfo.mReserved[1] = mCmdParam.FileDirInfo.mReserved[2] = 0;  /* Ԫ */
		i = ExecCommand( CMD_FileDirInfo, 4 );  /* ȡǰѴļĿ¼Ϣ */
		mStopIfError( i );

/* ޸ļĿ¼Ϣеļ */
		mCmdParam.FileDirInfo.mDir.DIR_Name[0] = 'W';  /* ޸ļֽΪW */
		mCmdParam.FileDirInfo.mDir.DIR_Name[8] = 'C';  /* ޸ļչΪC */
		mCmdParam.FileDirInfo.mDir.DIR_Name[9] = ' ';
		mCmdParam.FileDirInfo.mDir.DIR_Name[10] = ' ';

/* ޸ļĿ¼Ϣеļʱ,DIR_CrtTimeǴʱ,DIR_WrtTime޸ʱ */
		FileCreateTime = MAKE_FILE_TIME( 16, 49, 28 );  /* ļʱ16ʱ4928 */
//		mCmdParam.FileDirInfo.mDir.DIR_CrtTime = FileCreateTime;  /* ļʱ,С˸ʽ */
		mCmdParam.FileDirInfo.mDir.DIR_CrtTime = SwapUINT16( FileCreateTime );  /* MCS51ƬCǴ˸ʽ,Աת */
		FileCreateDate = MAKE_FILE_DATE( 2004, 12, 8 );  /* ļ2004128 */
//		mCmdParam.FileDirInfo.mDir.DIR_CrtDate = FileCreateDate;  /* ļ,С˸ʽ */
		mCmdParam.FileDirInfo.mDir.DIR_CrtDate = SwapUINT16( FileCreateDate );  /* MCS51ƬCǴ˸ʽ,Աת */

//		mCmdParam.FileDirInfo.mDir.DIR_WrtTime = SwapUINT16( MAKE_FILE_TIME( ʱ, ,  ) );  /* ļ޸ʱ */
//		mCmdParam.FileDirInfo.mDir.DIR_LstAccDate = SwapUINT16( MAKE_FILE_DATE( , ,  ) );  /* һδȡ */

/* ½޸ĹˢµU */
/*		printf( "Save new file directory information\n" );*/
		mCmdParam.FileDirInfo.mAccessMode = 0xF0;  /* д/ļĿ¼Ϣ */
		i = ExecCommand( CMD_FileDirInfo, sizeof( mCmdParam.FileDirInfo ) );  /* ȡǰѴļĿ¼Ϣ */
		mStopIfError( i );

		/* ļд... */
/*		printf( "Close\n" );*/
		mCmdParam.Close.mUpdateLen = 0;
		i = ExecCommand( CMD_FileClose, 1 );  /* رļ */
		mStopIfError( i );

/* ȴU̶Ͽ */
/*		printf( "Take_out\n" );*/
		while ( 1 ) {  /* ʹòѯʽUǷϿ */
			i = ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬ */
			mStopIfError( i );
			if ( mCmdParam.Status.mDiskStatus <= DISK_DISCONNECT ) break;  /* UѾϿ */
			mDelaymS( 100 );  /* ûбҪһֱͣزѯ,õƬ,û¿ʱȴһٲѯ */
		}
		LED_OUT = 1;  /* LED */
	}
}
