;---------------------------------------------------------------
;iostruc.inc - structures for I/O monitor                      |
;--------------------------------------------------------------|

idt             struc
i_offset        dw      ?
i_selector      dw      ?
i_unused        db      0
i_dpl_id        db      PRESENT + (DPL0 shl 5) + INT_GATE
i_offset2       dw      0
idt             ends


seg_descrip     struc
seg_limit_low   dw      ?
seg_base_low    dw      ?
seg_base_mid    db      ?
seg_type_dpl    db      ?
seg_limit_gran  db      ?
seg_base_top    db      ?
seg_descrip     ends

err_stack_area  struc                   ;stack with error code
e_pushed_int    dw      ?               ;int pushed by I/O monitor
e_pushed_bp     dw      ?               ;bp pushed by I/O monitor
e_errcode       dd      ?               ;error code
e_eip           dd      ?
e_cs            dw      ?
                dw      ?
e_eflags        dd      ?
e_esp           dd      ?
e_ss            dw      ?
                dw      ?
e_es            dw      ?
                dw      ?
e_ds            dw      ?
                dw      ?
e_fs            dw      ?
                dw      ?
e_gs            dw      ?
                dw      ?
err_stack_area  ends

stack_area      struc                   ;stack without error code
s_pushed_int    dw      ?               ;int pushed by I/O monitor
s_pushed_bp     dw      ?               ;bp pushed by I/O monitor
s_eip           dd      ?
s_cs            dw      ?
                dw      ?
s_eflags        dd      ?
s_esp           dd      ?
s_ss            dw      ?
                dw      ?
s_es            dw      ?
                dw      ?
s_ds            dw      ?
                dw      ?
s_fs            dw      ?
                dw      ?
s_gs            dw      ?
                dw      ?
stack_area      ends


user_stack      struc
user_ip         dw      ?
user_cs         dw      ?
user_flags      dw      ?
user_stack      ends


psp             struc
                db      80h dup(?)
arg_len         db      ?
arg_off         db      ?
psp             ends

doub_word       struc
d_offset        dw      ?
d_segment       dw      ?
doub_word       ends

io_struc        struc
io_opcode       db      ?
io_info         db      ?
io_struc        ends

buf_record      struc                   ;format of logged data
buf_info        db      ?
buf_port        dw      ?
buf_data        dw      ?
buf_record      ends

tss_dat         struc
t_backlink      dw      ?
                dw      ?
t_esp0          dd      ?
t_ess0          dw      ?
                dw      ?
t_esp1          dd      ?
t_ess1          dw      ?
                dw      ?
t_esp2          dd      ?
t_ess2          dw      ?
                dw      ?
t_cr3           dd      ?
t_eip           dd      ?
t_eflags        dd      ?
t_eax           dd      ?
t_ecx           dd      ?
t_edx           dd      ?
t_ebx           dd      ?
t_esp           dd      ?
t_ebp           dd      ?
t_esi           dd      ?
t_edi           dd      ?
t_es            dw      ?
                dw      ?
t_cs            dw      ?
                dw      ?
t_ss            dw      ?
                dw      ?
t_ds            dw      ?
                dw      ?
t_fs            dw      ?
                dw      ?
t_gs            dw      ?
                dw      ?
t_ldt           dw      ?
                dw      ?
t_tbit          dw      ?
t_iobase        dw      ?
t_iomap         db      IO_MAP_SIZE     dup(?)
t_iopad         dw      0ffh            ;follow last map byte with 0ffh
tss_dat         ends



;------end of iostruc.inc
