#ifndef _UI_STRUCTS_H_
#define _UI_STRUCTS_H_


#include <stdint.h>


struct AlertHeader {
	uint16_t type, helpID, numButtons, dfltBtnIdx;
	char strs[];
} __attribute__((packed));

struct Point {
	int16_t x, y;
} __attribute__((packed));

struct Rectangle {
	struct Point topLeft, extent;
} __attribute__((packed));

struct WindowBE {
	uint8_t rfu0[9];
	uint8_t freeBmp				:1;
	uint8_t dialog				:1;
	uint8_t visible				:1;
	uint8_t enabled				:1;
	uint8_t focusable			:1;
	uint8_t modal				:1;
	uint8_t offscreen			:1;
	uint8_t format				:1;
	struct Rectangle bounds;
	uint8_t rfu1[12];
	uint8_t frameCornerDiam;
	uint8_t frameWidth			:2;
	uint8_t frameShadowWidth	:2;
	uint8_t frame3d				:1;
	uint8_t frameRfu			:3;
	uint8_t rfu2[8];
} __attribute__((packed));

struct WindowLE {
	uint8_t rfu0[8];
	struct Rectangle bounds;
	uint8_t rfu1[12];
	uint8_t format				:1;
	uint8_t offscreen			:1;
	uint8_t modal				:1;
	uint8_t focusable			:1;
	uint8_t enabled				:1;
	uint8_t visible				:1;
	uint8_t dialog				:1;
	uint8_t freeBmp				:1;
	uint8_t rfu2;
	uint8_t frameCornerDiam;
	uint8_t frameRfu			:3;
	uint8_t frame3d				:1;
	uint8_t frameShadowWidth	:2;
	uint8_t frameWidth			:2;
	uint8_t rfu3[8];
} __attribute__((packed));

struct FormBE {
	struct WindowBE win;
	uint16_t id;
	uint8_t doingDialog			:1;
	uint8_t globalsAvailable	:1;
	uint8_t graffitiShift		:1;
	uint8_t saveBehind			:1;
	uint8_t dirty				:1;
	uint8_t visible				:1;
	uint8_t enabled				:1;
	uint8_t usable				:1;
	uint8_t rfu0				:6;
	uint8_t attnIndicator		:1;
	uint8_t exitDialog			:1;
	uint8_t rfu1[12];
	uint16_t dfltBtnId;
	uint16_t helpId;
	uint16_t menuId;
	uint16_t nObjects;
	uint8_t rfu2[4];
} __attribute__((packed));

struct FormLE {
	struct WindowLE win;
	uint8_t usable				:1;
	uint8_t enabled				:1;
	uint8_t visible				:1;
	uint8_t dirty				:1;
	uint8_t saveBehind			:1;
	uint8_t graffitiShift		:1;
	uint8_t globalsAvailable	:1;
	uint8_t doingDialog			:1;
	uint8_t exitDialog			:1;
	uint8_t attnIndicator		:1;
	uint8_t rfu0				:6;
	uint8_t rfu1[10];
	uint16_t id;
	uint8_t rfu2[2];
	uint16_t dfltBtnId;
	uint16_t helpId;
	uint16_t menuId;
	uint16_t nObjects;
	uint8_t rfu3[4];
} __attribute__((packed));

enum FormObjKind {
	FormObjField,
	FormObjControl,
	FormObjList,
	FormObjTable,
	FormObjBitmap,
	FormObjLine,	//not uspported
	FormObjFrame,	//not uspported
	FormObjRect,	//not uspported
	FormObjLabel,
	FormObjTitle,
	FormObjPopup,
	FormObjGSI,
	FormObjGadget,
	FormObjScrollbar,
};

struct FormObjListItemBE {
	uint8_t objKind;
	uint8_t rfu;
	uint32_t objOfst;
} __attribute__((packed));

struct FormObjListItemLE {
	uint32_t objOfst;
	uint8_t objKind;
	uint8_t rfu[3];
} __attribute__((packed));

struct PopupObj {
	uint16_t triggerId;
	uint16_t listId;
} __attribute__((packed));

struct GSIObj {
	struct Point pos;
} __attribute__((packed));

struct GadgetObjBE {
	uint16_t id;
	uint8_t rfu0		:5;
	uint8_t visible		:1;
	uint8_t extended	:1;
	uint8_t usable		:1;
	uint8_t rfu1;
	struct Rectangle bounds;
	uint8_t rfu2[8];
} __attribute__((packed));

struct GadgetObjLE {
	uint16_t id;
	uint8_t usable		:1;
	uint8_t extended	:1;
	uint8_t visible		:1;
	uint8_t rfu0		:5;
	uint8_t rfu1;
	struct Rectangle bounds;
	uint8_t rfu2[8];
} __attribute__((packed));

struct ScrollbarBE {
	struct Rectangle bounds;
	uint16_t id;
	uint8_t activeRegion		:4;
	uint8_t shown				:1;
	uint8_t hilighted			:1;
	uint8_t visible				:1;
	uint8_t usable				:1;
	uint8_t rfu0;
	int16_t val;
	int16_t min;
	int16_t max;
	uint16_t pageSize;
	uint8_t rfu1[4];
} __attribute__((packed));

struct ScrollbarLE {
	struct Rectangle bounds;
	uint16_t id;
	uint8_t usable				:1;
	uint8_t visible				:1;
	uint8_t hilighted			:1;
	uint8_t shown				:1;
	uint8_t activeRegion		:4;
	uint8_t rfu0;
	int16_t val;
	int16_t min;
	int16_t max;
	uint16_t pageSize;
	uint8_t rfu1[4];
} __attribute__((packed));

struct SliderBE {
	uint16_t id;
	struct Rectangle bounds;
	uint16_t thumbBmpId;
	uint16_t backgroundBmpId;
	uint8_t frame			:3;
	uint8_t leftAnchor		:1;
	uint8_t on				:1;
	uint8_t visible			:1;
	uint8_t enabled			:1;
	uint8_t usable			:1;
	uint8_t rfu0			:5;
	uint8_t vertical		:1;
	uint8_t graphical		:1;
	uint8_t drawnAsSelected	:1;
	uint8_t controlKind;
	uint8_t rfu1;
	int16_t minValue;
	int16_t maxValue;
	int16_t pageSize;
	int16_t value;
	uint8_t rfu2[4];
} __attribute__((packed));

struct SliderLE {
	uint16_t id;
	uint8_t usable			:1;
	uint8_t enabled			:1;
	uint8_t visible			:1;
	uint8_t on				:1;
	uint8_t leftAnchor		:1;
	uint8_t frame			:3;
	uint8_t drawnAsSelected	:1;
	uint8_t graphical		:1;
	uint8_t vertical		:1;
	uint8_t rfu0			:5;
	struct Rectangle bounds;
	uint16_t thumbBmpId;
	uint16_t backgroundBmpId;
	uint8_t controlKind;
	uint8_t rfu1;
	int16_t minValue;
	int16_t maxValue;
	int16_t pageSize;
	int16_t value;
	uint8_t rfu2[6];
} __attribute__((packed));

struct ControlBE {
	uint16_t id;
	struct Rectangle bounds;
	union {
		uint32_t textPtr;
		struct {
			uint16_t normalBmpId;
			uint16_t selectedBmpId;
		} gfx;
	};
	uint8_t frame			:3;
	uint8_t leftAnchor		:1;
	uint8_t on				:1;
	uint8_t visible			:1;
	uint8_t enabled			:1;
	uint8_t usable			:1;
	uint8_t rfu0			:5;
	uint8_t vertical		:1;
	uint8_t graphical		:1;
	uint8_t drawnAsSelected	:1;
	uint8_t controlKind;
	uint8_t font;
	uint8_t group;
	uint8_t rfu1;
} __attribute__((packed));

struct ControlLE {
	uint16_t id;
	uint8_t usable			:1;
	uint8_t enabled			:1;
	uint8_t visible			:1;
	uint8_t on				:1;
	uint8_t leftAnchor		:1;
	uint8_t frame			:3;
	uint8_t drawnAsSelected	:1;
	uint8_t graphical		:1;
	uint8_t vertical		:1;
	uint8_t rfu0			:5;
	struct Rectangle bounds;
	union {
		uint32_t textPtr;
		struct {
			uint16_t normalBmpId;
			uint16_t selectedBmpId;
		} gfx;
	};
	uint8_t controlKind;
	uint8_t font;
	uint8_t group;
	uint8_t rfu1;
} __attribute__((packed));

enum ButtonFrame {
	ButtonFrameNone,
	ButtonFrameNormal,
	ButtonFrameBold,
	ButtonFrameRect,	
};

enum ControlKind {
	ControlKindButton,
	ControlKindPushbutton,
	ControlKindCheckbox,
	ControlKindPopupTrigger,
	ContorlTypeSelectorTrigger,
	ControlTypeRepeatingButton,
	ControlTypeSlider,
	ControlTypeFeedbackSlider,
};

struct LabelBE {
	uint16_t id;
	struct Point pos;
	uint8_t rfu0	:7;
	uint8_t usable	:1;
	uint8_t rfu1;
	uint8_t font;
	uint8_t rfu2;
	uint32_t textPtr;
} __attribute__((packed));

struct LabelLE {
	struct Point pos;
	uint32_t textPtr;
	uint16_t id;
	uint8_t usable	:1;
	uint8_t rfu0	:7;
	uint8_t rfu1;
	uint8_t font;
	uint8_t rfu2[3];
} __attribute__((packed));

struct FormTitle {
	struct Rectangle rect;
	uint32_t textPtr;
} __attribute__((packed));

struct ListObjBE {
	uint16_t id;
	struct Rectangle bounds;
	uint8_t rfu0			:2;
	uint8_t search			:1;
	uint8_t hasScrollBar	:1;
	uint8_t poppedUp		:1;
	uint8_t visible			:1;
	uint8_t enabled			:1;
	uint8_t usable			:1;
	uint8_t rfu1;
	uint32_t itemsTextsPtr;
	uint16_t nItems;
	uint16_t curItem;
	uint16_t topItem;
	uint8_t font;
	uint8_t rfu2[9];
} __attribute__((packed));

struct ListObjLE {
	uint16_t id;
	uint8_t usable			:1;
	uint8_t enabled			:1;
	uint8_t visible			:1;
	uint8_t poppedUp		:1;
	uint8_t hasScrollBar	:1;
	uint8_t search			:1;
	uint8_t rfu0			:2;
	uint8_t rfu1;
	struct Rectangle bounds;
	uint32_t itemsTextsPtr;
	uint16_t nItems;
	uint16_t curItem;
	uint16_t topItem;
	uint8_t font;
	uint8_t rfu2[9];
} __attribute__((packed));

struct FieldBE {
	uint16_t id;
	struct Rectangle bounds;
	uint8_t dirty			:1;
	uint8_t insPtVisible	:1;
	uint8_t dynamicSize		:1;
	uint8_t hasFocus		:1;
	uint8_t singleLine		:1;
	uint8_t editable		:1;
	uint8_t visible			:1;
	uint8_t usable			:1;
	uint8_t rfu0			:1;
	uint8_t numeric			:1;
	uint8_t hasScrollBar	:1;
	uint8_t autoShift		:1;
	uint8_t justification	:2;
	uint8_t underlined		:1;
	uint8_t rfu1[12];
	uint16_t textLen;
	uint16_t textBlockSize;
	uint16_t maxChars;
	uint8_t rfu2[8];
	uint8_t font;
	uint8_t maxVisibleLines;
} __attribute__((packed));

struct FieldLE {
	struct Rectangle bounds;
	uint16_t id;
	uint8_t usable			:1;
	uint8_t visible			:1;
	uint8_t editable		:1;
	uint8_t singleLine		:1;
	uint8_t hasFocus		:1;
	uint8_t dynamicSize		:1;
	uint8_t insPtVisible	:1;
	uint8_t dirty			:1;
	uint8_t underlined		:1;
	uint8_t justification	:2;
	uint8_t autoShift		:1;
	uint8_t hasScrollBar	:1;
	uint8_t numeric			:1;
	uint8_t rfu0			:1;
	uint8_t rfu1[12];
	uint16_t textLen;
	uint16_t textBlockSize;
	uint16_t maxChars;
	uint8_t rfu2[8];
	uint8_t font;
	uint8_t maxVisibleLines;
} __attribute__((packed));

struct TableObjBE {
	uint16_t id;
	struct Rectangle bounds;
	uint8_t rfu0			:2;
	uint8_t usable			:1;
	uint8_t hasScrollBar	:1;
	uint8_t selected		:1;
	uint8_t editing			:1;
	uint8_t editable		:1;
	uint8_t visible			:1;
	uint8_t rfu1;
	uint16_t numCols;
	uint16_t numRows;
	uint16_t curRow;
	uint16_t curCol;
	uint16_t topRow;
	uint8_t rfu2[16];
} __attribute__((packed));

struct TableObjLE {
	uint16_t id;
	uint8_t visible			:1;
	uint8_t editable		:1;
	uint8_t editing			:1;
	uint8_t selected		:1;
	uint8_t hasScrollBar	:1;
	uint8_t usable			:1;
	uint8_t rfu0			:2;
	uint8_t rfu1;
	struct Rectangle bounds;
	uint16_t numCols;
	uint16_t numRows;
	uint16_t curRow;
	uint16_t curCol;
	uint16_t topRow;
	uint8_t rfu2[16];
} __attribute__((packed));

struct TblColAttrBE {
	int16_t width;
	uint8_t usable			:1;
	uint8_t editIndicator	:1;
	uint8_t masked			:1;
	uint8_t rfu0			:5;
	int16_t spacing;
	uint8_t rfu1[13];
} __attribute__((packed));

struct TblColAttrLE {
	int16_t width;
	int16_t spacing;
	uint8_t rfu0			:5;
	uint8_t masked			:1;
	uint8_t editIndicator	:1;
	uint8_t usable			:1;
	uint8_t rfu1[13];
} __attribute__((packed));

struct BitmapObjBE {
	uint8_t rfu0	:7;
	uint8_t usable	:1;
	struct Point pos;
	uint16_t id;
} __attribute__((packed));

struct BitmapObjLE {
	uint8_t usable	:1;
	uint8_t rfu0	:7;
	uint16_t id;
	struct Point pos;
} __attribute__((packed));

struct MenuHeaderBE {
	uint8_t rfu0[16];
	uint8_t rfu1					:3;
	uint8_t attnIndicatorIsAllowed	:1;
	uint8_t needsRecalc				:1;
	uint8_t insPtEnabled			:1;
	uint8_t commandPending			:1;
	uint8_t visible					:1;
	uint8_t rfu2[9];
	uint16_t numItems;
	uint8_t rfu3[4];
	//struct MenuBE[]
} __attribute__((packed));

struct MenuHeaderLE {
	uint8_t rfu0[16];
	uint8_t visible					:1;
	uint8_t commandPending			:1;
	uint8_t insPtEnabled			:1;
	uint8_t needsRecalc				:1;
	uint8_t attnIndicatorIsAllowed	:1;
	uint8_t rfu1					:3;
	uint8_t rfu2[5];
	uint16_t numItems;
	uint8_t rfu3[8];
	//struct MenuLE[]
} __attribute__((packed));

struct MenuBE {
	uint8_t rfu[24];
	uint32_t titleOfst;
	uint8_t numItemsHi	:7;
	uint8_t hidden		:1;
	uint8_t numItemsLo;
	uint32_t submenusOfst;
} __attribute__((packed));

struct MenuLE {
	uint8_t rfu[24];
	uint32_t titleOfst;
	uint16_t hidden		:1;
	uint16_t rfu2		:15;
	uint8_t numItemsLo;
	uint8_t numItemsHi;
	uint32_t submenusOfst;
} __attribute__((packed));

struct SubmenuBE {
	uint16_t id;
	char cmd;
	uint8_t rfu0	:7;
	uint8_t hidden	:1;
	uint32_t textOfst;
} __attribute__((packed));

struct SubmenuLE {
	uint16_t id;
	char cmd;
	uint8_t hidden	:1;
	uint8_t rfu0	:7;
	uint32_t textOfst;
} __attribute__((packed));




#endif
