#include <stdint.h>
#include <MemoryMgr.h>
#include <LibTraps.h>
#include <SerialMgr.h>
#include <string.h>
#include "common.h"
#include "printf.h"
#include "vdrvV5.h"
#include "port.h"

//these must be ARM since they are referenced from CRT


#ifdef BUILDING_FOR_BIG_ARM
	#pragma GCC target ("arm")
#endif

Err __attribute__((used)) impl_DrvEntry(uint32_t opCode, void *data)
{
	Err err = 0xFFFF;
	
	if (data) switch (opCode) {
		case VDRV_ENTRY_NUM_GET_NUM_PORTS:
			*(uint16_t*)data = NUM_PORTS;
			err = errNone;
			break;
		
		case VDRV_ENTRY_NUM_GET_PORT_FUNCS:
			((struct VdrvPortFuncs*)data)->VdrvOpenF = portOpen;
			((struct VdrvPortFuncs*)data)->VdrvCloseF = portClose;
			((struct VdrvPortFuncs*)data)->VdrvControlF = portControl;
			((struct VdrvPortFuncs*)data)->VdrvGetStatusF = portGetStatus;
			((struct VdrvPortFuncs*)data)->VdrvWriteF = portWrite;
			((struct VdrvPortFuncs*)data)->VdrvCustomControlF = portCustomControl;
			err = errNone;
			break;
		
		case VDRV_ENTRY_NUM_GET_PORT_INFO:
			err = portGetInfo((struct VdrvPortInfo*)data);
			break;
	}
	
	return err;
}

uint32_t __attribute__((used)) PilotMain(uint16_t cmd, void* cmdPBP, uint16_t flags)
{
	return errNone;
}

