#ifndef _VSLOT_H_
#define _VSLOT_H_

#include <stdbool.h>
#include <stdint.h>
#include <Extensions/ExpansionMgr/ExpansionMgr.h>
#include <Extensions/ExpansionMgr/SlotDrvrLib.h>

#define expCapabilityNonRemovable			0x00000008

Err impl_SlotLibOpen(uint16_t slotLibRefNum);
Err impl_SlotLibClose(uint16_t slotLibRefNum);
Err impl_SlotLibSleep(uint16_t slotLibRefNum);
Err impl_SlotLibWake(uint16_t slotLibRefNum);
	
uint32_t impl_SlotLibLibAPIVersion(uint16_t slotLibRefNum);
Err impl_SlotLibCustomControl(uint16_t slotLibRefNum, uint32_t apiCreator, uint16_t apiSelector,  void *valueP, uint16_t *valueLenP);
Err impl_SlotLibCardPresent(uint16_t slotLibRefNum, uint16_t slotRefNum);
Err impl_SlotLibCardInfo(uint16_t slotLibRefNum, uint16_t slotRefNum, ExpCardInfoType *infoP);
Err impl_SlotLibCardMediaType(uint16_t slotLibRefNum, uint16_t slotRefNum, uint32_t *mediaTypeP);
Err impl_SlotLibMediaType(uint16_t slotLibRefNum, uint16_t slotRefNum, uint32_t *mediaTypeP);
Err impl_SlotLibCardReserve(uint16_t slotLibRefNum, uint16_t slotRefNum);
Err impl_SlotLibCardRelease(uint16_t slotLibRefNum, uint16_t slotRefNum);
Err impl_SlotLibCardGetSerialPort(uint16_t slotLibRefNum, uint16_t slotRefNum, uint32_t* portP);
Boolean impl_SlotLibCardIsFilesystemSupported(uint16_t slotLibRefNum, uint16_t slotRefNum, uint32_t filesystemType);
Err impl_SlotLibCardMetrics(uint16_t slotLibRefNum, uint16_t slotRefNum, CardMetricsPtr cardMetricsP);
Err impl_SlotLibCardLowLevelFormat(uint16_t slotLibRefNum, uint16_t slotRefNum);
Err impl_SlotLibCardSectorRead(uint16_t slotLibRefNum, uint16_t slotRefNum, uint32_t sectorNumber, uint8_t *bufferP, uint32_t *numSectorsP);
Err impl_SlotLibCardSectorWrite(uint16_t slotLibRefNum, uint16_t slotRefNum, uint32_t sectorNumber, const uint8_t *bufferP, uint32_t *numSectorsP);
Err impl_SlotLibPowerCheck(uint16_t slotLibRefNum, uint16_t slotRefNum, uint16_t operationFlags, uint16_t readBlocks, uint16_t writeBlocks);


#endif

