#define _ASSEMBLY
#include "common.h"
#define LIB_SLOT_IN_GLOBALS 0x10
.syntax unified
.globl SysLinkerStub  //required to exist
.type LinkerStubCall_v7m, %function
.globl LinkerStubCall_v7m
.weak LinkerStubCall_v7m
.section .text.LinkerStubCall_v7m
.balign 4 //life is easier when aligned to a 4-byte-boundary :)
.func
LinkerStubCall_v7m:
	//stack has [descr] [callfunc | 1]
	push  {r0-r3, lr}
	ldr   r0, [sp, #0x18]  //get stub func addr
	ldrh  r1, [r0, #0x05]  //load (self_module_id * 4)
	ldrh  r2, [r0, #0x09]  //load lib slot in globals
	bic   r1, #0xf000      //isolate (self_module_id * 4)
	bic   r2, #0xf000      //isolate lib slot in globals
	ldr   r3, [r9]         //get pointer to where table shall go into r3
	ldr   r3, [r3, r1]
	adds  r2, r3
	ldr   r0, [sp, #0x14]  //param #1: lib descriptor
	lsrs  r1, #2           //param #2: module ID
	adds  r2, #1           //param #3: table write loc (lower bit tells linker stub that we cna handle thumb addrs directly (rePalm special)
	bl    SysLinkerStub
	pop   {r0-r3, lr}
	add   sp, #4
	pop   {pc}
.endfunc
.type Llib_load_stub, %function
.section .text.Llib_load_stub
.balign 4 //life is easier when aligned to a 4-byte-boundary :)
.func
Llib_load_stub:
	adr r12, 1f
	push {r12}
	b.w LinkerStubCall_v7m
	.balign 4 // the data needs to be word-aligned
1:
	.word 0x6c696272 // type (libr)
	.word 0x6136386b // creator (a68k)
	.word 1
	.word 53
	.word 0x616d6464 // res type for data (amdd)
	.word 0x616d6469 // res type for info (amdi)
	.word 0x616d6463 // res type for code (amdc)
	.hword 0 // res id for data
	.hword 0 // res id for info
	.hword 0 // res id for code
	.hword 0 // reserved
.endfunc
.macro libentry name idx
	.type \name, %function
	.globl \name
	.section .text.\name
	.balign 4 //life is easier when aligned to a 4-byte-boundary :)
	.func
	\name:
	1:
		ldr   r12, [r9]
		ldr   r12, [r12, #0 + MY_LIB_ID]           // .W to force format T3
		ldr   r12, [r12, #0 + LIB_SLOT_IN_GLOBALS] // .W to force format T3
		cmp   r12, #0
		it    ne
		ldrne pc,  [r12, #4 * \idx]
		adr   r12, 1b + 1
		push  {r12}
		b     Llib_load_stub
	.endfunc
.endm
libentry PceInitializePACE 0
libentry PceReadInt8From68KStack 1
libentry PceReadInt16From68KStack 2
libentry PceReadInt32From68KStack 3
libentry PceReadVarArgsFrom68KStack 4
libentry PceReadStructureFrom68KStack 5
libentry PceWriteInt8To68KStack 6
libentry PceWriteInt16To68KStack 7
libentry PceWriteInt32To68KStack 8
libentry PceWriteStructureTo68KStack 9
libentry PceReadInt8From68KMemory 10
libentry PceReadInt16From68KMemory 11
libentry PceReadInt32From68KMemory 12
libentry PceReadVarArgsFrom68KMemory 13
libentry PceReadStructureFrom68KMemory 14
libentry PceWriteInt8To68KMemory 15
libentry PceWriteInt16To68KMemory 16
libentry PceWriteInt32To68KMemory 17
libentry PceWriteStructureTo68KMemory 18
libentry PceSet68KInt8ReturnResult 19
libentry PceSet68KInt16ReturnResult 20
libentry PceSet68KInt32ReturnResult 21
libentry PceSet68KPtrReturnResult 22
libentry PceGet68KInt8ReturnResult 23
libentry PceGet68KInt16ReturnResult 24
libentry PceGet68KInt32ReturnResult 25
libentry PceGet68KPtrReturnResult 26
libentry PceReverseBitFieldsInInt16 27
libentry PceGetCurrentAppEmulState 28
libentry PceGetSystemEmulState 29
libentry PceCall68KRoutine 30
libentry PceCall68KLibRoutine 31
libentry PceSysLibFind68KLibrary 32
libentry PceSysLibLoad68KLibrary 33
libentry PceSysLibLoadARMLibrary 34
libentry PceSysLibRemoveLibrary 35
libentry PceSysLibGetNativeRefNum 36
libentry PceReadExgSocketFrom68KMemory 37
libentry PceWriteExgSocketTo68KMemory 38
libentry PceReadEventFrom68KMemory 39
libentry PceWriteEventTo68KMemory 40
libentry PceAllocPseudo68KCallAddr 41
libentry PceFreePseudo68KCallAddr 42
libentry PceGetPseudo68KCallAddrInfo 43
libentry PceDbgBreak 44
libentry PceLaunchConsole 45
libentry PceGet68KTrapHandler 46
libentry PceSet68KTrapHandler 47
libentry PceNativeFormDeleted 48
libentry Pce68KAppIsDebuggable 49
libentry PceDbgBreakOnNextInstr 50
libentry PceConvert68KBitmap 51
libentry PrvPceSleepWakeNotification 52
