#ifndef _DMA_DRIVER_H_
#define _DMA_DRIVER_H_

#include <ErrorBase.h>
#include <stdbool.h>
#include <stdint.h>

#define DMA_STRM_IRQ_FIFO_ERR		0x01
#define DMA_STRM_IRQ_DIRECT_ERR		0x04
#define DMA_STRM_IRQ_XFER_ERR		0x08
#define DMA_STRM_IRQ_HALF			0x10
#define DMA_STRM_IRQ_DONE			0x20

typedef void (*DmaLibIrqHandlerF)(void* userData, uint32_t strmSta /* DMA_STRM_IRQ_* */);

#define CFG_STRUCT_MAGIX			0xFAF00BAC
struct DmaStreamUserCfg {
	
	uint32_t magic;
	
	uint8_t chan;
	uint8_t	memBurstSz;
	uint8_t	perBurstSz;
	uint8_t prio;
	uint8_t fifoThresh;
	
	uint16_t dblBuf				: 1;
	uint16_t circBuf			: 1;
	uint16_t perIncr			: 1;	//autoincrement periph addr?
	uint16_t memIncr			: 1;	//autoincrement periph addr?
	uint16_t perSz				: 2;	//0 = byte, 1 = halfword, 2 = word, etc...
	uint16_t memSz				: 2;
	uint16_t toMem				: 1;	//else from mem
	uint16_t perControlsFlow	: 1;
	uint16_t useFifo			: 1;
	
	uint32_t numItems;			//PER-buffer in case of double-buffering
};

typedef void* DmaStream;
#define DMA_STREAM_INVALID	((void*)0)

void DmaLibGetInfo(uint32_t *numControllersP, uint32_t *numStreamsPerControllerP);
DmaStream DmaLibStreamReserve(uint32_t controller, uint32_t stream);
bool DmaLibStreamRelease(DmaStream strm);
bool DmaLibStreamSetIrqHandler(DmaStream strm, DmaLibIrqHandlerF irqFunc, void* irqHandlerData);
bool DmaLibStreamSetIrqState(DmaStream strm, uint32_t irqsEnabled /* mask of DMA_STRM_IRQ_* */);
bool DmaLibStreamConfigure(DmaStream strm, const struct DmaStreamUserCfg* cfg);
bool DmaLibStreamSetEnabled(DmaStream strm, bool on);
bool DmaLibStreamSetPeriphAddr(DmaStream strm, uint32_t addr);
bool DmaLibStreamSetMemAddr(DmaStream strm, uint32_t bufferIdx, uint32_t addr);
bool DmaLibStreamGetItemsLeftToTransfer(DmaStream strm, uint32_t *numItemsToTransferP);
bool DmaLibStreamGetCurrentTargetBuffer(DmaStream strm, uint32_t *targetBufferIdxP);	//for double buffer mode. always 0 or 1
bool DmaLibStreamGetEnabled(DmaStream strm, bool *enabledP);



#endif
