#include "palmosInternal.h"
#include "patching.h"
#include "private.h"


static uintptr_t __attribute__((noinline,naked)) getBase(void)		//get base of this module in a sane way. there is no way to do this in c (gcc insists on a got). luckily GAS has our back
{
	asm volatile(
		"	ldr r0, 1f			\n\t"
		"	add r0, pc			\n\t"
		"	bx lr				\n\t"
		"2:						\n\t"
		"	.balign 4			\n\t"
		"1:						\n\t"
		"	.word vecs - 2b		\n\t"
	);
	
	return 0;	//shut gcc up
}

static void __attribute__((naked, used, section(".patches.a"))) patchesStart(void) {}	//must be in same compilation unit as the below, or else we get a ".got"
static void __attribute__((naked, used, section(".patches.z"))) patchesEnd(void) {}
static void sbarPrvInstallPatchesForModule(struct Globals *g, uint32_t moduleId, uint32_t moduleRefNo, uintptr_t base)
{
	const struct PalmOsFuncPatch *__patches_start = (struct PalmOsFuncPatch*)(((uintptr_t)&patchesStart) &~ 1);
	const struct PalmOsFuncPatch *__patches_end = (struct PalmOsFuncPatch*)(((uintptr_t)&patchesEnd) &~ 1);
	const struct PalmOsFuncPatch *p;
	
	for (p = __patches_start; p != __patches_end; p++) {
		
		void *func = (void*)((((uintptr_t)p->func) & 0x00ffffff) + base);
		
		if (p->moduleId != moduleId)
			continue;
		
		if (errNone != SysPatchEntry(moduleRefNo, p->entryPt, func, (p->oldTrapOfst == -1) ? NULL : (((void**)g) + p->oldTrapOfst)))
			SysFatalAlert("Patch install failure");
	}
}

void sbarPrvInstallPatches(void)
{
	struct Globals *g = globalsGet();
	uintptr_t base = getBase();
	uint32_t refNo;

	if (errNone != SysFindModule('rsrc', 'pdal', 0, 0, &refNo))
		SysFatalAlert("Failed to find DAL");
	sbarPrvInstallPatchesForModule(g, 0, refNo, base);

	if (errNone != SysFindModule('rsrc', 'psys', 0, 0, &refNo))
		SysFatalAlert("Failed to find Boot");
	sbarPrvInstallPatchesForModule(g, 1, refNo, base);

	if (errNone != SysFindModule('rsrc', 'puil', 0, 0, &refNo))
		SysFatalAlert("Failed to find UI");
	sbarPrvInstallPatchesForModule(g, 2, refNo, base);
}