#ifndef _PALMOS_INTERNAL_H_
#define _PALMOS_INTERNAL_H_

#include <stdint.h>
#define _DIRECT_CALL_WITH_UNPOPPED_16BIT_SELECTOR(...)
#include "../dal/boot.h"
#include <stdint.h>
#include <MemoryMgr.h>
#include <LibTraps.h>
#include <SerialMgr.h>
#include <FatalAlert.h>
#include <StringMgr.h>
#include <FeatureMgr.h>
#include <SystemMgr.h>
#include <TimeMgr.h>
#include <Window.h>
#include <Bitmap.h>
#include <string.h>
#include <stddef.h>
#include <PenInputMgr.h>
#include <SysEvtMgr.h>
#include <UIResources.h>
#include <Form.h>
#include <TextMgr.h>
#include <UIColor.h>



#define PALMOS_ALERT_FORM_ID			12000
#define PALMOS_ALERT_INPUT_FIELD_ID		12001

union PalmFrameFlags {

	struct {
		uint16_t cornerDiam		: 8;		//lsl 24
		uint16_t rfu			: 3;		//lsl 21
		uint16_t threeD			: 1;		//lsl 20
		uint16_t shadowWidth	: 2;		//lsl 18
		uint16_t width			: 2;		//lsl 16
	};
	uint16_t frameType;
};

struct PalmWindowFlags {

	uint16_t format			: 1;
	uint16_t offscreen		: 1;
	uint16_t modal			: 1;
	uint16_t focusable		: 1;
	uint16_t enabled		: 1;
	uint16_t visible		: 1;
	uint16_t dialog			: 1;
	uint16_t freeBitmap		: 1;
	uint16_t reserved		: 8;
};

struct PalmWindow {
	uint16_t				oldStuff1[2];	//00
	uint32_t				oldStuff2;		//04
	struct RectangleType	bounds;			//08
	struct AbsRectType		clipBounds;		//10
	struct BitmapType		*bmp;			//18
	struct PalmWindowFlags	flags;			//1C
	union PalmFrameFlags  	frm;			//1E
	struct PalmDrawState 	*drawState;		//20
	struct PalmWindow 		*next;			//24
};

struct PalmSilkscreenArea {
	struct RectangleType bounds;
	uint32_t type;	//4CC
	uint16_t index;
	uint16_t rfu;
};

struct PalmSilkButton {
	struct RectangleType bounds;
	uint16_t asciiCode;		//palm "WChar"
	uint16_t keyCode;		//palm "keyCode"
	uint16_t modifiers;		//palm "modifiers"
	uint16_t rfu;
};

struct PalmSilkButtonList {
	uint16_t numItems;
	uint16_t rfu;
	struct PalmSilkButton btns[];		//[numItems]
};

struct PalmSilkscreenInfo {
	uint16_t ver;
	uint16_t numAreas;
	uint32_t crid;
	uint16_t locLang;
	uint16_t locCountry;
	//struct PalmSilkscreenArea[numAreas]
	//struct PalmSilkButtonList
};

struct EvtMgrGlobals50 {
	
	uint8_t rfu0[0x10];							//0x00
	struct RectangleType writingArea;			//0x10
	uint16_t appAreaBottom;						//0x18
	uint8_t rfu1[0x10];							//0x1A
	
	//these last two members are only present in v5.1 and later!!!
	uint16_t dgtToScreenScale;					//0x2A	10.6 format
	uint16_t dgtToStandardScale;				//0x2C	10.6 format
};

struct EvtMgrGlobals54 {
	
	uint8_t rfu0[0x0C];							//0x00
	struct RectangleType writingArea;			//0x0C
	uint16_t appAreaBottom;						//0x14
	uint8_t rfu1[0x12];							//0x16
	uint32_t dgtToScreenScale;					//0x28	16.16 format
	uint32_t dgtToStandardScale;				//0x2c	16.16 format
};

struct EvtMgrGlobals {
	union {
		struct EvtMgrGlobals50 v51;
		struct EvtMgrGlobals54 v54;
	};
};

struct UiGlobals {
	uint32_t rfu1[7];
	struct PalmDrawState *curDrawState;	//0x1C
	uint32_t rfu2[11];
	struct PalmFont *curFont;			//0x4C
	struct PalmFont **systemFonts;		//0x50
	struct PalmFont **appFonts;			//0x54
	uint16_t numSystemFonts;			//0x58
	uint16_t numAppFonts;				//0x5A
	struct PalmFont **uiFonts;			//0x5C	(if ui has a font with a font map (and subfonts), this is where the fonts for it are)
	uint32_t rfu3[1];					//0x60
	uint8_t curFontId;					//0x64
	uint8_t padding1[3];				//0x65
	uint32_t rfu4[18];					//0x68
	struct {							//0xB0
		uint8_t alwaysRectaBorders : 1;	//changes how contorl borders are drawn
	} uiConfigs;
};

struct PalmForm {
	struct PalmWindow		win;				//00
	struct {									//28
		uint16_t usable				: 1;
		uint16_t enabled			: 1;
		uint16_t visible			: 1;
		uint16_t dirty				: 1;
		uint16_t saveBehind			: 1;
		uint16_t graffitiShift		: 1;
		uint16_t globalsAvailable	: 1;
		uint16_t doingDialog		: 1;
		uint16_t exitDialog			: 1;
		uint16_t attnIndSupported	: 1;
		uint16_t reserved			: 6;
	} attr;
	struct PalmDiaPolicyAttr {									//2A
		uint16_t frmDIAPolicy		: 1;	//set if form HAS a custom policy (as opposed to a default one)
		uint16_t inputAreaState		: 3;
		uint16_t statusState		: 1;
		uint16_t inputTrigger		: 1;
		uint16_t orientation		: 3;
		uint16_t orientationTrigger	: 1;
		uint16_t reserved2			: 6;
	} diaPolicyAttr;
	void*					bitsBehindForm;		//2C
	void*					formEventHandler;	//30
	uint16_t				formID;				//34
	uint16_t				focus;				//36
	uint16_t				defaultButton;		//38
	uint16_t				helpRscId;			//3A
	uint16_t				menuRscId;			//3C
	uint16_t				numObjects;			//3E
	struct PalmFormObj		*objs;				//40
};


struct UiGlobals* UIGetGlobalsPtr(void);


#endif
