#ifndef _ZODIAC_H_
#define _ZODIAC_H_

#include "dal.h"


//things to call on app exit
void zodPrvAppExitNotifTwInput(void);

//things to call for init
void zodTwInputInit(void);
void zodTwGfxInit(void);
void zodDevicesInit(void);
void zodVibratorInit(void);


//internal: exported interfaces
void* zodPrvGetSoundIface(void);
void* zodPrvGetGfxResetIface(void);



//internal: device framework

struct TwDeviceEntry;
struct TwDevice;
typedef Err (*TwDeviceCloseF)(struct TwDevice *handle);
typedef Err (*TwDeviceReadF)(struct TwDevice *handle, void* buf, int32_t lenP);
typedef Err (*TwDeviceWriteF)(struct TwDevice *handle, const void* buf, int32_t lenP);
typedef Err (*TwDeviceInitF)(struct TwDevice *handle, const char *name, const char *mode);
typedef Err (*TwDeviceControlF)(struct TwDevice *handle, int32_t cmd, void* buf, int32_t lenP);
typedef Err (*TwDeviceGetPropertyF)(struct TwDevice *handle, int32_t prop, void* buf, int32_t *lenP);
typedef Err (*TwDeviceSetPropertyF)(struct TwDevice *handle, int32_t prop, const void* buf, int32_t lenP);
struct TwDevice {
	
	//this part as per docs and not to be changed
	TwDeviceInitF initF;
	TwDeviceCloseF closeF;
	TwDeviceReadF readF;
	TwDeviceWriteF writeF;
	TwDeviceGetPropertyF getPropF;
	TwDeviceSetPropertyF setPropF;
	TwDeviceControlF controlF;
	
	void *data[4];	//[0] inited to data passed to TwDeviceRegister()
	
	struct TwDeviceEntry *entry;
	struct TwDevice *next, *prev;
	
	//anything after this is ours to use
};
Err impl_TwDeviceRegister(const char *name, TwDeviceInitF initF, void* data);





#ifdef SUPPORT_ZODIAC

	void zodSetInitStage(uint32_t stage);
	bool zodFilterHalEvents(uint32_t type, const void* data);
	void zodScreenLockNotif(bool locked);	//only once - when first locked and when last unlocked

#else

	static inline void zodSetInitStage(uint32_t stage) {}
	static inline bool zodFilterHalEvents(uint32_t type, const void* data) { return true; }
	static inline void zodScreenLockNotif(bool locked) {}

#endif


#endif
