#ifndef _SONY_H_
#define _SONY_H_

#include <stdbool.h>
#include <stdint.h>
#include "ral.h"

#ifdef SONY_SUPPORT_ENABLED
	bool isSony(void);
	bool isSony_safe(bool whatToAssume);	//do not crash but assume a given value if not known yet
	
	void sonyHalSetInitStage(uint32_t stage);	//caled by HALSetInitStage
	void sonyPatchLibEntrypts(uint32_t dbType, uint32_t dbCrid, uint32_t *entryptAddrs, uint32_t nEntries);
	void sonyPatchLibMainEntry(uint32_t dbType, uint32_t dbCrid, ModuleEntryPoint* entryPtP);
	bool sonyDenyLibLoad(uint32_t dbType, uint32_t dbCrid);	//return true to deny loading
#else
	static inline bool isSony(void) { return false; }
	static inline bool isSony_safe(bool whatToAssume) { return false; }
	
	static inline void sonyHalSetInitStage(uint32_t stage) {return; }
	static inline void sonyPatchLibEntrypts(uint32_t dbType, uint32_t dbCrid, uint32_t *entryptAddrs, uint32_t nEntries) {return; }
	static inline void sonyPatchLibMainEntry(uint32_t dbType, uint32_t dbCrid, ModuleEntryPoint* entryPtP) {return; }
	static inline bool sonyDenyLibLoad(uint32_t dbType, uint32_t dbCrid) { return false; }
#endif



#endif
