#ifndef _K_MPU_H_
#define _K_MPU_H_

#include <stdbool.h>
#include <stdint.h>

//however many mpu regions there are, the highest numbered one is reserved for stack guard use


#define MPU_PERM_U_XX_S_XX				(0b000 << 24)
#define MPU_PERM_U_XX_S_RO				(0b101 << 24)
#define MPU_PERM_U_RO_S_RO				(0b110 << 24)
#define MPU_PERM_U_XX_S_RW				(0b001 << 24)
#define MPU_PERM_U_RO_S_RW				(0b010 << 24)
#define MPU_PERM_U_RW_S_RW				(0b011 << 24)
#define MPU_PERM_MASK					(0b111 << 24)

#define MPU_PERM_NX						(1 << 28)
#define MPU_FLAG_ENABLED				(1)

#define MPU_MAKE_MEM_TYPE(_tex, _c, _b, _s)		(((_tex) << 19) | ((_c) << 17) | ((_b) << 16) | ((_s) << 18))

//stm32 treat "s" to mean non-cacheable. careful...
#ifdef BUILD_FOR_THUMB_1

	//this is for ARMv6M

	#define MPU_MEM_TYPE_DEVICE				MPU_MAKE_MEM_TYPE(0, 0, 1, 0)
	#define MPU_MEM_TYPE_ROM				MPU_MAKE_MEM_TYPE(0, 1, 0, 0)
	#define MPU_MEM_TYPE_RAM				MPU_MAKE_MEM_TYPE(0, 1, 1, 0)
	#define MPU_MEM_TYPE_UNCACHED_RAM		MPU_MAKE_MEM_TYPE(0, 0, 0, 0)

#else

	//this is for ARMv7M
	
	#define MPU_MEM_TYPE_DEVICE				MPU_MAKE_MEM_TYPE(2, 0, 0, 0)
	#define MPU_MEM_TYPE_ROM				MPU_MAKE_MEM_TYPE(0, 1, 0, 0)
	#define MPU_MEM_TYPE_RAM				MPU_MAKE_MEM_TYPE(1, 1, 1, 0)
	#define MPU_MEM_TYPE_UNCACHED_RAM		MPU_MAKE_MEM_TYPE(1, 0, 0, 0)

	#define MPU_STACK_GUARD_SIZE			32		//in bytes

#endif

#define MPU_REGION_SZ_4GB		(31 << 1)
#define MPU_REGION_SZ_2GB		(30 << 1)
#define MPU_REGION_SZ_1GB		(29 << 1)
#define MPU_REGION_SZ_512MB		(28 << 1)
#define MPU_REGION_SZ_256MB		(27 << 1)
#define MPU_REGION_SZ_128MB		(26 << 1)
#define MPU_REGION_SZ_64MB		(25 << 1)
#define MPU_REGION_SZ_32MB		(24 << 1)
#define MPU_REGION_SZ_16MB		(23 << 1)
#define MPU_REGION_SZ_8MB		(22 << 1)
#define MPU_REGION_SZ_4MB		(21 << 1)
#define MPU_REGION_SZ_2MB		(20 << 1)
#define MPU_REGION_SZ_1MB		(19 << 1)
#define MPU_REGION_SZ_512KB		(18 << 1)
#define MPU_REGION_SZ_256KB		(17 << 1)
#define MPU_REGION_SZ_128KB		(16 << 1)
#define MPU_REGION_SZ_64KB		(15 << 1)
#define MPU_REGION_SZ_32KB		(14 << 1)
#define MPU_REGION_SZ_16KB		(13 << 1)
#define MPU_REGION_SZ_8KB		(12 << 1)
#define MPU_REGION_SZ_4KB		(11 << 1)
#define MPU_REGION_SZ_2KB		(10 << 1)
#define MPU_REGION_SZ_1KB		(9 << 1)
#define MPU_REGION_SZ_512B		(8 << 1)
#define MPU_REGION_SZ_256B		(7 << 1)		//SRD allowed for this size and larger sizes
#define MPU_REGION_SZ_128B		(6 << 1)
#define MPU_REGION_SZ_64B		(5 << 1)
#define MPU_REGION_SZ_32B		(4 << 1)

#define MPU_SRD_7th				(0x8000)
#define MPU_SRD_6th				(0x4000)
#define MPU_SRD_5th				(0x2000)
#define MPU_SRD_4th				(0x1000)
#define MPU_SRD_3rd				(0x0800)
#define MPU_SRD_2nd				(0x0400)
#define MPU_SRD_1st				(0x0200)
#define MPU_SRD_0th				(0x0100)


void mpuEarlyInit(void);				//enable everything everywhere
bool mpuInit(void);
bool mpuSetStackGuard(uint32_t addr);	//addr == 0 to disable
void mpuSetStorageRamWriteable(bool allowWrites);

void mpuInstrCacheClearDataCacheClean(uintptr_t addr, int32_t sz);


#ifdef BUILDING_FOR_BIG_ARM
	void mpuSetDomainAccess(uint32_t domain, uint32_t bits);
	void mmuLockExcPage(void);
	void mmuPrvSleepMapping(bool create);
#endif

//mmu
void mmuMapIoSeg(void* va, uintptr_t pa);	//megabyte mapping, no cache no buffer

void mmuHandleCodeWritten(void* addr, uint32_t len);

#endif
