#ifndef _HYPER_H_
#define _HYPER_H_

#include "mach.h"

#ifdef MACH_TYPE_VIRTUAL

	#include "../hypercalls.h"

	void hyperInit(HyperFunc cbk);
	uint64_t hyperCall(uint32_t call, void *data);

#else
	
	typedef int HyperFunc;
	
	extern void LINK_ERROR_NO_HYPERCALS_ON_THIS_MACHINE(void);
	
	#define hyperInit(cbk)
	#define hyperCall(call, data)	LINK_ERROR_NO_HYPERCALS_ON_THIS_MACHINE();

#endif


#endif
