#ifndef _JIT_BACKEND_m0_PRIVATE_H_
#define _JIT_BACKEND_m0_PRIVATE_H_

#include "emuJitInternal.h"
#include "emit.h"

//this include is for private features of the m0 backend. it is rather weird so it needs these

struct SwitchBranchStateM0 {
	uint16_t* cases;
	uint8_t nCases, nHalfwordsPerCase;
};


enum EmitStatus jitPrvCalloutM0(struct EmitBuf *dest, const void *func, const int8_t *inRegsMap, const int8_t* outRegsMap);

//default case goes directly after this emits
enum EmitStatus jitPrvSwitchBranchM0(struct EmitBuf *dest, struct SwitchBranchStateM0 *state, uint32_t rmNo, uint32_t numCases, uint32_t halfwordsPerCase);
enum EmitStatus jitPrvSwitchBranchWriteCaseM0(struct SwitchBranchStateM0 *state, uint32_t caseIdx, struct EmitBuf *caseSpace);	//fills caseSpace for you

//dynamic lib stub generation
enum EmitStatus jitPrvDynamicLibStubM0(struct EmitBuf *dest, uint32_t moduleId, uint32_t globalsOfst, uint32_t funcNo, uint32_t armFuncPtr, uint16_t *libStubCode);

#endif
