//need 2 init stages. one before threading is ready and one after

#ifndef _EMU_H_
#define _EMU_H_

#include <stdint.h>
#include "irqs.h"


struct EmuCpuState {
	uint32_t regs[16];		//PC of 0 indicates that this context is used
	uint32_t sr;
};



//emulator cores (take and return context)
struct EmuCpuState* emuCpuRun(struct EmuCpuState* ctx);

//emulator: enter from user mode
void emuEnterFromUserMode(void);

void emuCoreInit(void);	//called form the main thread for emu to init itself if it so wishes!


#endif
