#include "disp.h"
#include "printf.h"
#include "machSpecific.h"
#include <MemoryMgr.h>
#include <string.h>
#include "timers.h"
#include "memmap.h"
#include "boot.h"
#include "heap.h"
#include "cpu.h"
#include "dal.h"
#include "kal.h"


#define REV_C_DEV_BOARD

#define LCD_LANE_BYTE_CLOCK		62500		//in khz
#define LCD_CLOCK				27429		//in khz

#ifdef REV_C_DEV_BOARD

	#define DISP_HSYNC		2
	#define DISP_HBP		34
	#define DISP_HFP		34
	#define DISP_VSYNC		120
	#define DISP_VBP		150
	#define DISP_VFP		150

#else

	#define DISP_HSYNC		64
	#define DISP_HBP		64
	#define DISP_HFP		64
	#define DISP_VSYNC		8
	#define DISP_VBP		8
	#define DISP_VFP		8
	
#endif



#define DISP_WIDTH				480			//should be divisible by 8
#define DISP_HEIGHT				720
#define DISP_DENSITY			216

#if 1							//portrait (remember you need to rotate touch too)
	#define LCD_PORTRAIT		1
	#define LCD_WIDTH			480
	#define LCD_HEIGHT			800
#else							//landscape
	#define LCD_PORTRAIT		0
	#define LCD_WIDTH			800
	#define LCD_HEIGHT			480
#endif


static void* mFb;
static uint8_t mCurDepth;
static bool haveGrafArea = false;


#define USE_DMA2D			1

static const uint8_t mGrafitiAreaImage[] = {		//1bpp, bits are LtR, 60 rows 160 cols
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0xfc, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x3f, 0x00,
		0x00, 0xff, 0x03, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x08, 0xc0, 0xff, 0x00,
		0xc0, 0xff, 0x0f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0x03,
		0xe0, 0xc7, 0x1f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf8, 0xe1, 0x07,
		0xe0, 0xc7, 0x1f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x78, 0x80, 0x07,
		0xf0, 0xc7, 0x3f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0x9e, 0x0f,
		0xf0, 0x83, 0x3f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3c, 0x3e, 0x0f,
		0xf8, 0x93, 0x7f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0xff, 0x1f,
		0xf8, 0x93, 0x7f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0xff, 0x1f,
		0xf8, 0x99, 0x7f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0xff, 0x1f,
		0xf8, 0x39, 0x7f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0xff, 0x1f,
		0xf8, 0x39, 0x7f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0xff, 0x1f,
		0xf8, 0x00, 0x7f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0x3e, 0x1f,
		0xf0, 0x00, 0x3e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0x9e, 0x0f,
		0xf0, 0x7c, 0x3e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0xc0, 0x0f,
		0x60, 0x7c, 0x1c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf8, 0xe1, 0x07,
		0xe0, 0xff, 0x1f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf8, 0xff, 0x07,
		0xc0, 0xff, 0x0f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0x03,
		0x00, 0xff, 0x03, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xc0, 0xff, 0x00,
		0x00, 0xfc, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x3f, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x7e, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x3f, 0x00,
		0x80, 0xff, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xc0, 0xff, 0x00,
		0xe0, 0xff, 0x07, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0x03,
		0x30, 0x7f, 0x0e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf8, 0xff, 0x07,
		0x30, 0x7e, 0x0e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf8, 0x01, 0x07,
		0x38, 0x3e, 0x1e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfc, 0x01, 0x0f,
		0x38, 0x3e, 0x1e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfc, 0xf9, 0x0f,
		0xbc, 0x9c, 0x3e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfe, 0xf9, 0x1f,
		0xbc, 0x9c, 0x3c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfe, 0xf9, 0x1f,
		0x9c, 0x9c, 0x3c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfe, 0x81, 0x1f,
		0x9c, 0xc9, 0x3c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfe, 0x81, 0x1f,
		0x9c, 0xc9, 0x3c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfe, 0xf9, 0x1f,
		0x9c, 0xc1, 0x3c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfe, 0xf9, 0x1f,
		0x98, 0xe3, 0x1c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfc, 0xf9, 0x0f,
		0x98, 0xe3, 0x1c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfc, 0xf9, 0x0f,
		0x90, 0xff, 0x0c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf8, 0xf9, 0x07,
		0xf0, 0xff, 0x0f, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf8, 0xf9, 0x07,
		0xe0, 0xff, 0x07, 0x20, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x09, 0xf0, 0xff, 0x03,
		0x80, 0xff, 0x01, 0x20, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0b, 0xc0, 0xff, 0x00,
		0x00, 0x7e, 0x00, 0xa0, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x09, 0x00, 0x3f, 0x00,
		0x00, 0x00, 0x00, 0xa0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0b, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0xa0, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x09, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0xa0, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	};

#define OTM8009A_MADCTR_MODE_LANDSCAPE		0x60
#define OTM8009A_CMD_NOP					0x00
#define OTM8009A_CMD_WRCABC					0x55
#define OTM8009A_CMD_WRCABCMB				0x5E
#define OTM8009A_CMD_RAMWRC					0x3C
#define OTM8009A_CMD_CASET					0x2A
#define OTM8009A_CMD_PASET					0x2B
#define OTM8009A_CMD_SLPOUT					0x11
#define OTM8009A_COLMOD_RGB565				0x55
#define OTM8009A_COLMOD_RGB888				0x77
#define OTM8009A_CMD_COLMOD					0x3A
#define OTM8009A_CMD_MADCTR					0x36
#define OTM8009A_CMD_WRDISBV				0x51
#define OTM8009A_CMD_WRCTRLD				0x53
#define OTM8009A_CMD_DISPON					0x29
#define OTM8009A_CMD_RAMWR					0x2C


#define  NT35510_CMD_NOP                   0x00  /* NOP */
#define  NT35510_CMD_SWRESET               0x01  /* SW reset */
#define  NT35510_CMD_RDDID                 0x04  /* Read display ID */
#define  NT35510_CMD_RDNUMED               0x05  /* Read number of errors on DSI */
#define  NT35510_CMD_RDDPM                 0x0A  /* Read display power mode */
#define  NT35510_CMD_RDDMADCTL             0x0B  /* Read display MADCTL */
#define  NT35510_CMD_RDDCOLMOD             0x0C  /* Read display pixel format */
#define  NT35510_CMD_RDDIM                 0x0D  /* Read display image mode */
#define  NT35510_CMD_RDDSM                 0x0E  /* Read display signal mode */
#define  NT35510_CMD_RDDSDR                0x0F  /* Read display self-diagnostics result */
#define  NT35510_CMD_SLPIN                 0x10  /* Sleep in */
#define  NT35510_CMD_SLPOUT                0x11  /* Sleep out */
#define  NT35510_CMD_PTLON                 0x12  /* Partial mode on  */
#define  NT35510_CMD_NORON                 0x13  /* Normal display mode on */
#define  NT35510_CMD_INVOFF                0x20  /* Display inversion off */
#define  NT35510_CMD_INVON                 0x21  /* Display inversion on */
#define  NT35510_CMD_ALLPOFF               0x22  /* All pixel off */
#define  NT35510_CMD_ALLPON                0x23  /* All pixel on */
#define  NT35510_CMD_GAMSET                0x26  /* Gamma set */
#define  NT35510_CMD_DISPOFF               0x28  /* Display off */
#define  NT35510_CMD_DISPON                0x29  /* Display on */
#define  NT35510_CMD_CASET                 0x2A  /* Column address set */
#define  NT35510_CMD_RASET                 0x2B  /* Row address set */
#define  NT35510_CMD_RAMWR                 0x2C  /* Memory write */
#define  NT35510_CMD_RAMRD                 0x2E  /* Memory read  */
#define  NT35510_CMD_PLTAR                 0x30  /* Partial area */
#define  NT35510_CMD_TOPC                  0x32  /* Turn On Peripheral Command */
#define  NT35510_CMD_TEOFF                 0x34  /* Tearing effect line off */
#define  NT35510_CMD_TEEON                 0x35  /* Tearing effect line on */
#define  NT35510_CMD_MADCTL                0x36  /* Memory data access control */
#define  NT35510_CMD_IDMOFF                0x38  /* Idle mode off */
#define  NT35510_CMD_IDMON                 0x39  /* Idle mode on */
#define  NT35510_CMD_COLMOD                0x3A  /* Interface pixel format */
#define  NT35510_CMD_RAMWRC                0x3C  /* Memory write continue */
#define  NT35510_CMD_RAMRDC                0x3E  /* Memory read continue */
#define  NT35510_CMD_STESL                 0x44  /* Set tearing effect scan line */
#define  NT35510_CMD_GSL                   0x45  /* Get scan line */

#define  NT35510_CMD_DSTBON                0x4F  /* Deep standby mode on */
#define  NT35510_CMD_WRPFD                 0x50  /* Write profile value for display */
#define  NT35510_CMD_WRDISBV               0x51  /* Write display brightness */
#define  NT35510_CMD_RDDISBV               0x52  /* Read display brightness */
#define  NT35510_CMD_WRCTRLD               0x53  /* Write CTRL display */
#define  NT35510_CMD_RDCTRLD               0x54  /* Read CTRL display value */
#define  NT35510_CMD_WRCABC                0x55  /* Write content adaptative brightness control */
#define  NT35510_CMD_RDCABC                0x56  /* Read content adaptive brightness control */
#define  NT35510_CMD_WRHYSTE               0x57  /* Write hysteresis */
#define  NT35510_CMD_WRGAMMSET             0x58  /* Write gamme setting */
#define  NT35510_CMD_RDFSVM                0x5A  /* Read FS value MSBs */
#define  NT35510_CMD_RDFSVL                0x5B  /* Read FS value LSBs */
#define  NT35510_CMD_RDMFFSVM              0x5C  /* Read median filter FS value MSBs */
#define  NT35510_CMD_RDMFFSVL              0x5D  /* Read median filter FS value LSBs */
#define  NT35510_CMD_WRCABCMB              0x5E  /* Write CABC minimum brightness */
#define  NT35510_CMD_RDCABCMB              0x5F  /* Read CABC minimum brightness */
#define  NT35510_CMD_WRLSCC                0x65  /* Write light sensor compensation coefficient value */
#define  NT35510_CMD_RDLSCCM               0x66  /* Read light sensor compensation coefficient value MSBs */
#define  NT35510_CMD_RDLSCCL               0x67  /* Read light sensor compensation coefficient value LSBs */
#define  NT35510_CMD_RDBWLB                0x70  /* Read black/white low bits */
#define  NT35510_CMD_RDBKX                 0x71  /* Read Bkx */
#define  NT35510_CMD_RDBKY                 0x72  /* Read Bky */
#define  NT35510_CMD_RDWX                  0x73  /* Read Wx */
#define  NT35510_CMD_RDWY                  0x74  /* Read Wy */
#define  NT35510_CMD_RDRGLB                0x75  /* Read red/green low bits */
#define  NT35510_CMD_RDRX                  0x76  /* Read Rx */
#define  NT35510_CMD_RDRY                  0x77  /* Read Ry */
#define  NT35510_CMD_RDGX                  0x78  /* Read Gx */
#define  NT35510_CMD_RDGY                  0x79  /* Read Gy */
#define  NT35510_CMD_RDBALB                0x7A  /* Read blue/acolor low bits */
#define  NT35510_CMD_RDBX                  0x7B  /* Read Bx */
#define  NT35510_CMD_RDBY                  0x7C  /* Read By */
#define  NT35510_CMD_RDAX                  0x7D  /* Read Ax */
#define  NT35510_CMD_RDAY                  0x7E  /* Read Ay */
#define  NT35510_CMD_RDDDBS                0xA1  /* Read DDB start */
#define  NT35510_CMD_RDDDBC                0xA8  /* Read DDB continue */
#define  NT35510_CMD_RDDCS                 0xAA  /* Read first checksum */
#define  NT35510_CMD_RDCCS                 0xAF  /* Read continue checksum */
#define  NT35510_CMD_RDID1                 0xDA  /* Read ID1 value */
#define  NT35510_CMD_RDID2                 0xDB  /* Read ID2 value */
#define  NT35510_CMD_RDID3                 0xDC  /* Read ID3 value */

#define  NT35510_COLMOD_RGB565             0x55
#define  NT35510_COLMOD_RGB888             0x77



	
static void dsiCfgPacketHdr(uint32_t dataTyp, uint32_t data0, uint32_t data1)
{
	DSI->GHCR = (dataTyp | (data0 << 8) | (data1 << 16));
}

static void dsiCmdExecLong(uint32_t mode, uint32_t nParams, uint32_t param1, const uint8_t* paramsTab)
{
	uint32_t i;
	
	//Set the DCS code hexadecimal on payload byte 1, and the other parameters on the write FIFO command
	for (i = 0; i < nParams; i += 3) {
		
		if (!i)		//first
			DSI->GPDR = (uint32_t)param1 | (((uint32_t)paramsTab[i + 0]) << 8) | (((uint32_t)paramsTab[i + 1]) << 16) | (((uint32_t)paramsTab[i + 2]) << 24);
		else {
			DSI->GPDR = (((uint32_t)paramsTab[i + 0]) << 0) | (((uint32_t)paramsTab[i + 1]) << 8) | (((uint32_t)paramsTab[i + 2]) << 16) | (((uint32_t)paramsTab[i + 3]) << 24);
			i++;
		}
	}
	
	nParams++;
	dsiCfgPacketHdr(mode, nParams & 0xff, nParams >> 8);
}

static void dsiCmdExecShort(uint32_t mode, uint32_t param1, uint32_t param2)
{
	dsiCfgPacketHdr(mode, param1, param2);
}

static void dsiCmdExec(uint32_t nParams, const uint8_t *params)
{
	#define DSI_DCS_LONG_PKT_WRITE				((uint32_t)0x00000039U)
	#define DSI_DCS_SHORT_PKT_WRITE_P1			((uint32_t)0x00000015U)
	
	
	//in either case we need to wait for the buffer to be ready
	while (!(DSI->GPSR & DSI_GPSR_CMDFE));
	
	if (nParams > 1)
		dsiCmdExecLong(DSI_DCS_LONG_PKT_WRITE, nParams, params[nParams], params);
	else
		dsiCmdExecShort(DSI_DCS_SHORT_PKT_WRITE_P1, params[0], params[1]); 
}

static void dispInitTheScreen_NT35510(void)
{
	const uint8_t nt35510_reg[]   = {0x55, 0xAA, 0x52, 0x08, 0x01, 0xF0};
	const uint8_t nt35510_reg1[]  = {0x03, 0x03, 0x03, 0xB0};
	const uint8_t nt35510_reg2[]  = {0x46, 0x46, 0x46, 0xB6};
	const uint8_t nt35510_reg3[]  = {0x03, 0x03, 0x03, 0xB1};
	const uint8_t nt35510_reg4[]  = {0x36, 0x36, 0x36, 0xB7};
	const uint8_t nt35510_reg5[]  = {0x00, 0x00, 0x02, 0xB2};
	const uint8_t nt35510_reg6[]  = {0x26, 0x26, 0x26, 0xB8};
	const uint8_t nt35510_reg7[]  = {0xBF, 0x01};
	const uint8_t nt35510_reg8[]  = {0x09, 0x09, 0x09, 0xB3};
	const uint8_t nt35510_reg9[]  = {0x36, 0x36, 0x36, 0xB9};
	const uint8_t nt35510_reg10[] = {0x08, 0x08, 0x08, 0xB5};
	const uint8_t nt35510_reg12[] = {0x26, 0x26, 0x26, 0xBA};
	const uint8_t nt35510_reg13[] = {0x00, 0x80, 0x00, 0xBC};
	const uint8_t nt35510_reg14[] = {0x00, 0x80, 0x00, 0xBD};
	const uint8_t nt35510_reg15[] = {0x00, 0x50, 0xBE};
	const uint8_t nt35510_reg16[] = {0x55, 0xAA, 0x52, 0x08, 0x00, 0xF0};
	const uint8_t nt35510_reg17[] = {0xFC, 0x00, 0xB1};
	const uint8_t nt35510_reg18[] = {0xB6, 0x03};
	const uint8_t nt35510_reg19[] = {0xB5, 0x51};
	const uint8_t nt35510_reg20[] = {0x00, 0x00, 0xB7};
	const uint8_t nt35510_reg21[] = {0x01, 0x02, 0x02, 0x02, 0xB8};
	const uint8_t nt35510_reg22[] = {0x00, 0x00, 0x00, 0xBC};
	const uint8_t nt35510_reg23[] = {0x03, 0x00, 0x00, 0xCC};
	const uint8_t nt35510_reg24[] = {0xBA, 0x01};
	const uint8_t nt35510_madctl_portrait[] = {NT35510_CMD_MADCTL ,0x00};
	const uint8_t nt35510_caset_portrait[] = {0x00, 0x00, 0x01, 0xDF ,NT35510_CMD_CASET};
	const uint8_t nt35510_raset_portrait[] = {0x00, 0x00, 0x03, 0x1F ,NT35510_CMD_RASET};
	const uint8_t nt35510_madctl_landscape[] = {NT35510_CMD_MADCTL, 0x60};
	const uint8_t nt35510_caset_landscape[] = {0x00, 0x00, 0x03, 0x1F ,NT35510_CMD_CASET};
	const uint8_t nt35510_raset_landscape[] = {0x00, 0x00, 0x01, 0xDF ,NT35510_CMD_RASET};
	const uint8_t nt35510_reg26[] = {NT35510_CMD_TEEON, 0x00};  /* Tear on */
	const uint8_t nt35510_reg27[] = {NT35510_CMD_SLPOUT, 0x00}; /* Sleep out */
	const uint8_t nt35510_reg30[] = {NT35510_CMD_DISPON, 0x00};
	
	const uint8_t nt35510_reg31[] = {NT35510_CMD_WRDISBV, 0x7F};
	const uint8_t nt35510_reg32[] = {NT35510_CMD_WRCTRLD, 0x2C};
	const uint8_t nt35510_reg33[] = {NT35510_CMD_WRCABC, 0x02};
	const uint8_t nt35510_reg34[] = {NT35510_CMD_WRCABCMB, 0xFF};
	const uint8_t nt35510_reg35[] = {NT35510_CMD_RAMWR, 0x00};
	const uint8_t nt35510_reg36[] = {NT35510_CMD_COLMOD, NT35510_COLMOD_RGB565};
	const uint8_t nt35510_reg37[] = {NT35510_CMD_COLMOD, NT35510_COLMOD_RGB888};
	
	machBusyWaitDelayMsec(120);
	
	dsiCmdExec(5, (uint8_t *)nt35510_reg); /* LV2:  Page 1 enable */
	dsiCmdExec(3, (uint8_t *)nt35510_reg1);/* AVDD: 5.2V */
	dsiCmdExec(3, (uint8_t *)nt35510_reg2);/* AVDD: Ratio */
	dsiCmdExec(3, (uint8_t *)nt35510_reg3);/* AVEE: -5.2V */
	dsiCmdExec(3, (uint8_t *)nt35510_reg4);/* AVEE: Ratio */
	dsiCmdExec(3, (uint8_t *)nt35510_reg5);/* VCL: -2.5V */
	dsiCmdExec(3, (uint8_t *)nt35510_reg6);/* VCL: Ratio */
	dsiCmdExec(1, (uint8_t *)nt35510_reg7);/* VGH: 15V (Free Pump) */
	dsiCmdExec(3, (uint8_t *)nt35510_reg8);
	dsiCmdExec(3, (uint8_t *)nt35510_reg9);/* VGH: Ratio */
	dsiCmdExec(3, (uint8_t *)nt35510_reg10);/* VGL_REG: -10V */
	dsiCmdExec(3, (uint8_t *)nt35510_reg12);/* VGLX: Ratio */
	dsiCmdExec(3, (uint8_t *)nt35510_reg13);/* VGMP/VGSP: 4.5V/0V */
	dsiCmdExec(3, (uint8_t *)nt35510_reg14);/* VGMN/VGSN:-4.5V/0V */
	dsiCmdExec(2, (uint8_t *)nt35510_reg15);/* VCOM: -1.325V */
	
	/* ************************************************************************** */
	/* Proprietary DCS Initialization                                             */
	/* ************************************************************************** */
	dsiCmdExec(5, (uint8_t *)nt35510_reg16);/* LV2: Page 0 enable */
	dsiCmdExec(2, (uint8_t *)nt35510_reg17);/* Display control */
	dsiCmdExec(1, (uint8_t *)nt35510_reg18);/* Src hold time */
	dsiCmdExec(1, (uint8_t *)nt35510_reg19);
	dsiCmdExec(2, (uint8_t *)nt35510_reg20);/* Gate EQ control */
	dsiCmdExec(4, (uint8_t *)nt35510_reg21);/* Src EQ control(Mode2) */
	dsiCmdExec(3, (uint8_t *)nt35510_reg22);/* Inv. mode(2-dot) */
	dsiCmdExec(3, (uint8_t *)nt35510_reg23);
	dsiCmdExec(1, (uint8_t *)nt35510_reg24);
	/* Tear on */
	dsiCmdExec(0, (uint8_t *)nt35510_reg26);
	/* Set Pixel color format to RGB888 */
	dsiCmdExec(0, (uint8_t *)nt35510_reg37);
	

	/* ************************************************************************** */
	/* Standard DCS Initialization                                                */
	/* ************************************************************************** */
	
	/* Add a delay, otherwise MADCTL not taken */
	machBusyWaitDelayMsec(200);
	
	/* Configure orientation */
	#if LCD_PORTRAIT
		dsiCmdExec(1, (uint8_t *)nt35510_madctl_portrait);
		dsiCmdExec(4, (uint8_t *)nt35510_caset_portrait);
		dsiCmdExec(4, (uint8_t *)nt35510_raset_portrait);
	#else
		dsiCmdExec(1, (uint8_t *)nt35510_madctl_landscape);
		dsiCmdExec(4, (uint8_t *)nt35510_caset_landscape);
		dsiCmdExec(4, (uint8_t *)nt35510_raset_landscape);
	#endif
	
	dsiCmdExec(0, (uint8_t *)nt35510_reg27);

	machBusyWaitDelayMsec(120);
	
	/* Set Pixel color format to RGB888 */
	dsiCmdExec(1, (uint8_t *)nt35510_reg37);
	
	/** CABC : Content Adaptive Backlight Control section start >> */
	/* Note : defaut is 0 (lowest Brightness), 0xFF is highest Brightness, try 0x7F : intermediate value */
	dsiCmdExec(1, (uint8_t *)nt35510_reg31);
	/* defaut is 0, try 0x2C - Brightness Control Block, Display Dimming & BackLight on */
	dsiCmdExec(1, (uint8_t *)nt35510_reg32);
	/* defaut is 0, try 0x02 - image Content based Adaptive Brightness [Still Picture] */
	dsiCmdExec(1, (uint8_t *)nt35510_reg33);
	/* defaut is 0 (lowest Brightness), 0xFF is highest Brightness */
	dsiCmdExec(1, (uint8_t *)nt35510_reg34);
	/** CABC : Content Adaptive Backlight Control section end << */
	
	/* Display on */
	dsiCmdExec(0, (uint8_t *)nt35510_reg30);
	
	/* Send Command GRAM memory write (no parameters) : this initiates frame write via other DSI commands sent by */
	/* DSI host from LTDC incoming pixels in video mode */
	dsiCmdExec(0, (uint8_t *)nt35510_reg35);
}

static void dispInitTheScreen_OTM8009A(void)
{
	static const uint8_t lcdShortRegData1[]  = {OTM8009A_CMD_NOP, 0x00};
	static const uint8_t lcdShortRegData2[]  = {OTM8009A_CMD_NOP, 0x80};
	static const uint8_t lcdShortRegData3[]  = {0xC4, 0x30};
	static const uint8_t lcdShortRegData4[]  = {OTM8009A_CMD_NOP, 0x8A};
	static const uint8_t lcdShortRegData5[]  = {0xC4, 0x40};
	static const uint8_t lcdShortRegData6[]  = {OTM8009A_CMD_NOP, 0xB1};
	static const uint8_t lcdShortRegData7[]  = {0xC5, 0xA9};
	static const uint8_t lcdShortRegData8[]  = {OTM8009A_CMD_NOP, 0x91};
	static const uint8_t lcdShortRegData9[]  = {0xC5, 0x34};
	static const uint8_t lcdShortRegData10[] = {OTM8009A_CMD_NOP, 0xB4};
	static const uint8_t lcdShortRegData11[] = {0xC0, 0x50};
	static const uint8_t lcdShortRegData12[] = {0xD9, 0x4E};
	static const uint8_t lcdShortRegData13[] = {OTM8009A_CMD_NOP, 0x81};
	static const uint8_t lcdShortRegData14[] = {0xC1, 0x66};
	static const uint8_t lcdShortRegData15[] = {OTM8009A_CMD_NOP, 0xA1};
	static const uint8_t lcdShortRegData16[] = {0xC1, 0x08};
	static const uint8_t lcdShortRegData17[] = {OTM8009A_CMD_NOP, 0x92};
	static const uint8_t lcdShortRegData18[] = {0xC5, 0x01};
	static const uint8_t lcdShortRegData19[] = {OTM8009A_CMD_NOP, 0x95};
	static const uint8_t lcdShortRegData20[] = {OTM8009A_CMD_NOP, 0x94};
	static const uint8_t lcdShortRegData21[] = {0xC5, 0x33};
	static const uint8_t lcdShortRegData22[] = {OTM8009A_CMD_NOP, 0xA3};
	static const uint8_t lcdShortRegData23[] = {0xC0, 0x1B};
	static const uint8_t lcdShortRegData24[] = {OTM8009A_CMD_NOP, 0x82};
	static const uint8_t lcdShortRegData25[] = {0xC5, 0x83};
	static const uint8_t lcdShortRegData26[] = {0xC4, 0x83};
	static const uint8_t lcdShortRegData27[] = {0xC1, 0x0E};
	static const uint8_t lcdShortRegData28[] = {OTM8009A_CMD_NOP, 0xA6};
	static const uint8_t lcdShortRegData29[] = {OTM8009A_CMD_NOP, 0xA0};
	static const uint8_t lcdShortRegData30[] = {OTM8009A_CMD_NOP, 0xB0};
	static const uint8_t lcdShortRegData31[] = {OTM8009A_CMD_NOP, 0xC0};
	static const uint8_t lcdShortRegData32[] = {OTM8009A_CMD_NOP, 0xD0};
	static const uint8_t lcdShortRegData33[] = {OTM8009A_CMD_NOP, 0x90};
	static const uint8_t lcdShortRegData34[] = {OTM8009A_CMD_NOP, 0xE0};
	static const uint8_t lcdShortRegData35[] = {OTM8009A_CMD_NOP, 0xF0};
	static const uint8_t lcdShortRegData36[] = {OTM8009A_CMD_SLPOUT, 0x00};
	static const uint8_t lcdShortRegData37[] = {OTM8009A_CMD_COLMOD, OTM8009A_COLMOD_RGB565};
	static const uint8_t lcdShortRegData38[] = {OTM8009A_CMD_COLMOD, OTM8009A_COLMOD_RGB888};
	static const uint8_t lcdShortRegData39[] = {OTM8009A_CMD_MADCTR, OTM8009A_MADCTR_MODE_LANDSCAPE};
	static const uint8_t lcdShortRegData40[] = {OTM8009A_CMD_WRDISBV, 0x7F};
	static const uint8_t lcdShortRegData41[] = {OTM8009A_CMD_WRCTRLD, 0x2C};
	static const uint8_t lcdShortRegData42[] = {OTM8009A_CMD_WRCABC, 0x02};
	static const uint8_t lcdShortRegData43[] = {OTM8009A_CMD_WRCABCMB, 0xFF};
	static const uint8_t lcdShortRegData44[] = {OTM8009A_CMD_DISPON, 0x00};
	static const uint8_t lcdShortRegData45[] = {OTM8009A_CMD_RAMWR, 0x00};
	static const uint8_t lcdShortRegData46[] = {0xCF, 0x00};
	static const uint8_t lcdShortRegData47[] = {0xC5, 0x66};
	static const uint8_t lcdShortRegData48[] = {OTM8009A_CMD_NOP, 0xB6};
	static const uint8_t lcdShortRegData49[] = {0xF5, 0x06};
	static const uint8_t lcdRegData1[]  = {0x80,0x09,0x01,0xFF};
	static const uint8_t lcdRegData2[]  = {0x80,0x09,0xFF};
	static const uint8_t lcdRegData3[]  = {0x00,0x09,0x0F,0x0E,0x07,0x10,0x0B,0x0A,0x04,0x07,0x0B,0x08,0x0F,0x10,0x0A,0x01,0xE1};
	static const uint8_t lcdRegData4[]  = {0x00,0x09,0x0F,0x0E,0x07,0x10,0x0B,0x0A,0x04,0x07,0x0B,0x08,0x0F,0x10,0x0A,0x01,0xE2};
	static const uint8_t lcdRegData5[]  = {0x79,0x79,0xD8};
	static const uint8_t lcdRegData6[]  = {0x00,0x01,0xB3};
	static const uint8_t lcdRegData7[]  = {0x85,0x01,0x00,0x84,0x01,0x00,0xCE};
	static const uint8_t lcdRegData8[]  = {0x18,0x04,0x03,0x39,0x00,0x00,0x00,0x18,0x03,0x03,0x3A,0x00,0x00,0x00,0xCE};
	static const uint8_t lcdRegData9[]  = {0x18,0x02,0x03,0x3B,0x00,0x00,0x00,0x18,0x01,0x03,0x3C,0x00,0x00,0x00,0xCE};
	static const uint8_t lcdRegData10[] = {0x01,0x01,0x20,0x20,0x00,0x00,0x01,0x02,0x00,0x00,0xCF};
	static const uint8_t lcdRegData11[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCB};
	static const uint8_t lcdRegData12[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCB};
	static const uint8_t lcdRegData13[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCB};
	static const uint8_t lcdRegData14[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCB};
	static const uint8_t lcdRegData15[] = {0x00,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCB};
	static const uint8_t lcdRegData16[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0xCB};
	static const uint8_t lcdRegData17[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCB};
	static const uint8_t lcdRegData18[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCB};
	static const uint8_t lcdRegData19[] = {0x00,0x26,0x09,0x0B,0x01,0x25,0x00,0x00,0x00,0x00,0xCC};
	static const uint8_t lcdRegData20[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x26,0x0A,0x0C,0x02,0xCC};
	static const uint8_t lcdRegData21[] = {0x25,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCC};
	static const uint8_t lcdRegData22[] = {0x00,0x25,0x0C,0x0A,0x02,0x26,0x00,0x00,0x00,0x00,0xCC};
	static const uint8_t lcdRegData23[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x25,0x0B,0x09,0x01,0xCC};
	static const uint8_t lcdRegData24[] = {0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCC};
	static const uint8_t lcdRegData25[] = {0xFF,0xFF,0xFF,0xFF};    
	static const uint8_t lcdRegData27[] = {0x00, 0x00, 0x03, 0x1F, OTM8009A_CMD_CASET};
	static const uint8_t lcdRegData28[] = {0x00, 0x00, 0x01, 0xDF, OTM8009A_CMD_PASET};

	/* Enable CMD2 to access vendor specific commands                               */
	/* Enter in command 2 mode and set EXTC to enable address shift function (0x00) */
	dsiCmdExec(0, lcdShortRegData1);
	dsiCmdExec(3, lcdRegData1);
	
	/* Enter ORISE Command 2 */
	dsiCmdExec(0, lcdShortRegData2); /* Shift address to 0x80 */
	dsiCmdExec(2, lcdRegData2);
	
	/////////////////////////////////////////////////////////////////////
	/* SD_PCH_CTRL - 0xC480h - 129th parameter - Default 0x00          */
	/* Set SD_PT                                                       */
	/* -> Source output level during porch and non-display area to GND */
	dsiCmdExec(0, lcdShortRegData2);
	dsiCmdExec(0, lcdShortRegData3);
	machBusyWaitDelayMsec(10);
	/* Not documented */
	dsiCmdExec(0, lcdShortRegData4);
	dsiCmdExec(0, lcdShortRegData5);
	machBusyWaitDelayMsec(10);
	/////////////////////////////////////////////////////////////////////
	
	/* PWR_CTRL4 - 0xC4B0h - 178th parameter - Default 0xA8 */
	/* Set gvdd_en_test                                     */
	/* -> enable GVDD test mode !!!                         */
	dsiCmdExec(0, lcdShortRegData6);
	dsiCmdExec(0, lcdShortRegData7);
	
	/* PWR_CTRL2 - 0xC590h - 146th parameter - Default 0x79      */
	/* Set pump 4 vgh voltage                                    */
	/* -> from 15.0v down to 13.0v                               */
	/* Set pump 5 vgh voltage                                    */
	/* -> from -12.0v downto -9.0v                               */
	dsiCmdExec(0, lcdShortRegData8);
	dsiCmdExec(0, lcdShortRegData9);
	
	/* P_DRV_M - 0xC0B4h - 181th parameter - Default 0x00 */
	/* -> Column inversion                                */
	dsiCmdExec(0, lcdShortRegData10);
	dsiCmdExec(0, lcdShortRegData11);
	
	/* VCOMDC - 0xD900h - 1st parameter - Default 0x39h */
	/* VCOM Voltage settings                            */
	/* -> from -1.0000v downto -1.2625v                 */
	dsiCmdExec(0, lcdShortRegData1);
	dsiCmdExec(0, lcdShortRegData12);
	
	/* Oscillator adjustment for Idle/Normal mode (LPDT only) set to 65Hz (default is 60Hz) */
	dsiCmdExec(0, lcdShortRegData13);
	dsiCmdExec(0, lcdShortRegData14);
	
	/* Video mode internal */
	dsiCmdExec(0, lcdShortRegData15);
	dsiCmdExec(0, lcdShortRegData16);
	
	/* PWR_CTRL2 - 0xC590h - 147h parameter - Default 0x00 */
	/* Set pump 4&5 x6                                     */
	/* -> ONLY VALID when PUMP4_EN_ASDM_HV = "0"           */
	dsiCmdExec(0, lcdShortRegData17);
	dsiCmdExec(0, lcdShortRegData18);
	
	/* PWR_CTRL2 - 0xC590h - 150th parameter - Default 0x33h */
	/* Change pump4 clock ratio                              */
	/* -> from 1 line to 1/2 line                            */
	dsiCmdExec(0, lcdShortRegData19);
	dsiCmdExec(0, lcdShortRegData9);
	
	/* GVDD/NGVDD settings */
	dsiCmdExec(0, lcdShortRegData1);
	dsiCmdExec(2, lcdRegData5);
	
	/* PWR_CTRL2 - 0xC590h - 149th parameter - Default 0x33h */
	/* Rewrite the default value !                           */
	dsiCmdExec(0, lcdShortRegData20);
	dsiCmdExec(0, lcdShortRegData21);
	
	/* Panel display timing Setting 3 */
	dsiCmdExec(0, lcdShortRegData22);
	dsiCmdExec(0, lcdShortRegData23);
	
	/* Power control 1 */
	dsiCmdExec(0, lcdShortRegData24);
	dsiCmdExec(0, lcdShortRegData25);
	
	/* Source driver precharge */
	dsiCmdExec(0, lcdShortRegData13);
	dsiCmdExec(0, lcdShortRegData26);
	
	dsiCmdExec(0, lcdShortRegData15);
	dsiCmdExec(0, lcdShortRegData27);
	
	dsiCmdExec(0, lcdShortRegData28);
	dsiCmdExec(2, lcdRegData6);
	
	/* GOAVST */
	dsiCmdExec(0, lcdShortRegData2);
	dsiCmdExec(6, lcdRegData7);
	
	dsiCmdExec(0, lcdShortRegData29);
	dsiCmdExec(14, lcdRegData8);
	
	dsiCmdExec(0, lcdShortRegData30);
	dsiCmdExec(14, lcdRegData9);
	
	dsiCmdExec(0, lcdShortRegData31);
	dsiCmdExec(10, lcdRegData10);
	
	dsiCmdExec(0, lcdShortRegData32);
	dsiCmdExec(0, lcdShortRegData46);
	
	dsiCmdExec(0, lcdShortRegData2);
	dsiCmdExec(10, lcdRegData11);
	
	dsiCmdExec(0, lcdShortRegData33);
	dsiCmdExec(15, lcdRegData12);
	
	dsiCmdExec(0, lcdShortRegData29);
	dsiCmdExec(15, lcdRegData13);
	
	dsiCmdExec(0, lcdShortRegData30);
	dsiCmdExec(10, lcdRegData14);
	
	dsiCmdExec(0, lcdShortRegData31);
	dsiCmdExec(15, lcdRegData15);
	
	dsiCmdExec(0, lcdShortRegData32);
	dsiCmdExec(15, lcdRegData16);
	
	dsiCmdExec(0, lcdShortRegData34);
	dsiCmdExec(10, lcdRegData17);
	
	dsiCmdExec(0, lcdShortRegData35);
	dsiCmdExec(10, lcdRegData18);
	
	dsiCmdExec(0, lcdShortRegData2);
	dsiCmdExec(10, lcdRegData19);
	
	dsiCmdExec(0, lcdShortRegData33);
	dsiCmdExec(15, lcdRegData20);
	
	dsiCmdExec(0, lcdShortRegData29);
	dsiCmdExec(15, lcdRegData21);
	
	dsiCmdExec(0, lcdShortRegData30);
	dsiCmdExec(10, lcdRegData22);
	
	dsiCmdExec(0, lcdShortRegData31);
	dsiCmdExec(15, lcdRegData23);
	
	dsiCmdExec(0, lcdShortRegData32);
	dsiCmdExec(15, lcdRegData24);
	
	/////////////////////////////////////////////////////////////////////////////
	/* PWR_CTRL1 - 0xc580h - 130th parameter - default 0x00 */
	/* Pump 1 min and max DM                                */
	dsiCmdExec(0, lcdShortRegData13);
	dsiCmdExec(0, lcdShortRegData47);
	dsiCmdExec(0, lcdShortRegData48);
	dsiCmdExec(0, lcdShortRegData49);
	/////////////////////////////////////////////////////////////////////////////
	
	/* Exit CMD2 mode */
	dsiCmdExec(0, lcdShortRegData1);
	dsiCmdExec(3, lcdRegData25);
	
	/*************************************************************************** */
	/* Standard DCS Initialization TO KEEP CAN BE DONE IN HSDT                   */
	/*************************************************************************** */
	
	/* NOP - goes back to DCS std command ? */
	dsiCmdExec(0, lcdShortRegData1);
	
	/* Gamma correction 2.2+ table (HSDT possible) */
	dsiCmdExec(0, lcdShortRegData1);
	dsiCmdExec(16, lcdRegData3);
	
	/* Gamma correction 2.2- table (HSDT possible) */
	dsiCmdExec(0, lcdShortRegData1);
	dsiCmdExec(16, lcdRegData4);
	
	/* Send Sleep Out command to display : no parameter */
	dsiCmdExec(0, lcdShortRegData36);
	
	/* Wait for sleep out exit */
	machBusyWaitDelayMsec(120);
	
	
	/* Set Pixel color format to RGB888 */
	dsiCmdExec(0, lcdShortRegData38);
	
	
	/* Send command to configure display in landscape orientation mode. By default
	the orientation mode is portrait  */
	if (!LCD_PORTRAIT) {
	
		dsiCmdExec(0, lcdShortRegData39);
		dsiCmdExec(4, lcdRegData27);
		dsiCmdExec(4, lcdRegData28);
	}
	
	/** CABC : Content Adaptive Backlight Control section start >> */
	/* Note : defaut is 0 (lowest Brightness), 0xFF is highest Brightness, try 0x7F : intermediate value */
	dsiCmdExec(0, lcdShortRegData40);
	
	/* defaut is 0, try 0x2C - Brightness Control Block, Display Dimming & BackLight on */
	dsiCmdExec(0, lcdShortRegData41);
	
	/* defaut is 0, try 0x02 - image Content based Adaptive Brightness [Still Picture] */
	dsiCmdExec(0, lcdShortRegData42);
	
	/* defaut is 0 (lowest Brightness), 0xFF is highest Brightness */
	dsiCmdExec(0, lcdShortRegData43);
	
	/** CABC : Content Adaptive Backlight Control section end << */
	
	/* Send Command Display On */
	dsiCmdExec(0, lcdShortRegData44);
	
	/* NOP command */
	dsiCmdExec(0, lcdShortRegData1);
	
	/* Send Command GRAM memory write (no parameters) : this initiates frame write via other DSI commands sent by */
	/* DSI host from LTDC incoming pixels in video mode */
	dsiCmdExec(0, lcdShortRegData45);	
}

static void dispInitHw(void)
{
	logt("resettng display\n");
	
	//reset display
	GPIOH->BSRR = 1 << (7 + 16);
	machBusyWaitDelayMsec(20);
	GPIOH->BSRR = 1 << (7);
	machBusyWaitDelayMsec(10);
	
	logt("turning dsi off\n");
	
	//turn DSI off properly first
	DSI->WCR &=~ DSI_WCR_DSIEN;
	DSI->CR &=~ DSI_CR_EN;
	DSI->PCTLR &=~ (DSI_PCTLR_CKE | DSI_PCTLR_DEN);
	DSI->WRPCR &=~ DSI_WRPCR_PLLEN;
	DSI->WRPCR &=~ DSI_WRPCR_REGEN;
	
//turn DSI on
	
	logt("waitnig for dsi regulator\n");
	DSI->WRPCR |= DSI_WRPCR_REGEN;			//regulator on
	while (!(DSI->WISR & DSI_WISR_RRS));	//wait till regulator is on
	
	logt("waiting for dsi pll\n");
	//setup PLL & turn it on
	
	DSI->WRPCR = (DSI->WRPCR &~ (DSI_WRPCR_PLL_NDIV | DSI_WRPCR_PLL_IDF | DSI_WRPCR_PLL_ODF)) | ((125 << DSI_WRPCR_PLL_NDIV_Pos) | (2 << DSI_WRPCR_PLL_IDF_Pos) | (0 << DSI_WRPCR_PLL_ODF_Pos));
	DSI->WRPCR |= DSI_WRPCR_PLLEN;
	while (!(DSI->WISR & DSI_WISR_PLLLS));	//wait till pll is on
	
	logt("setting up the dsi phy\n");
	
	//setup the d-phy
	DSI->PCTLR |= (DSI_PCTLR_CKE | DSI_PCTLR_DEN);
	DSI->CLCR = (DSI->CLCR &~ (DSI_CLCR_DPCC | DSI_CLCR_ACR)) | DSI_CLCR_DPCC;
	DSI->PCONFR = (DSI->PCONFR &~ DSI_PCONFR_NL) | DSI_PCONFR_NL0;
	
	//setup the clock
	DSI->CCR = (DSI->CCR &~ DSI_CCR_TXECKDIV) | 4;
	DSI->WPCR[0] = (DSI->WPCR[0] &~ DSI_WPCR0_UIX4) | 8;
	
	//disable all errors
	DSI->IER[0U] = 0;
	DSI->IER[1U] = 0;
	
	//config display
	DSI->MCR &= ~DSI_MCR_CMDM;
	DSI->WCFGR &= ~DSI_WCFGR_DSIM;

	DSI->VMCR &= ~DSI_VMCR_VMT;
	DSI->VMCR |= 2;
	
	DSI->VPCR &= ~DSI_VPCR_VPSIZE;
	DSI->VPCR |= LCD_WIDTH;
	
	DSI->VCCR &= ~DSI_VCCR_NUMC;
	
	DSI->VNPCR &= ~DSI_VNPCR_NPSIZE;
	DSI->VNPCR |= 0xFFF;
	
	DSI->LVCIDR &= ~DSI_LVCIDR_VCID;
	
	DSI->LPCR &= ~(DSI_LPCR_DEP | DSI_LPCR_VSP | DSI_LPCR_HSP);
	
	DSI->LCOLCR &= ~DSI_LCOLCR_COLC;
	DSI->LCOLCR |= 5;
	
	DSI->WCFGR &= ~DSI_WCFGR_COLMUX;
	DSI->WCFGR |= 5 << 1;
	
	DSI->VHSACR &= ~DSI_VHSACR_HSA;
	DSI->VHSACR |= (DISP_HSYNC * LCD_LANE_BYTE_CLOCK) / LCD_CLOCK;
	
	DSI->VHBPCR &= ~DSI_VHBPCR_HBP;
	DSI->VHBPCR |= (DISP_HBP * LCD_LANE_BYTE_CLOCK) / LCD_CLOCK;
	
	DSI->VLCR &= ~DSI_VLCR_HLINE;
	DSI->VLCR |= ((LCD_WIDTH + DISP_HSYNC + DISP_HBP + DISP_HFP) * LCD_LANE_BYTE_CLOCK) / LCD_CLOCK;
	
	DSI->VVSACR &= ~DSI_VVSACR_VSA;
	DSI->VVSACR |= DISP_VSYNC;
	
	DSI->VVBPCR &= ~DSI_VVBPCR_VBP;
	DSI->VVBPCR |= DISP_VBP;
	
	DSI->VVFPCR &= ~DSI_VVFPCR_VFP;
	DSI->VVFPCR |= DISP_VFP;
	
	DSI->VVACR &= ~DSI_VVACR_VA;
	DSI->VVACR |= LCD_HEIGHT;
	
	DSI->VMCR &= ~DSI_VMCR_LPCE;
	DSI->VMCR |= DSI_VMCR_LPCE;
	
	DSI->LPMCR &= ~DSI_LPMCR_LPSIZE;
	DSI->LPMCR |= (16 << 16);
	
	DSI->LPMCR &= ~DSI_LPMCR_VLPSIZE;
	
	DSI->VMCR &= ~DSI_VMCR_LPHFPE;
	DSI->VMCR |= DSI_VMCR_LPHFPE;
	
	DSI->VMCR &= ~DSI_VMCR_LPHBPE;
	DSI->VMCR |= DSI_VMCR_LPHBPE;
	
	DSI->VMCR &= ~DSI_VMCR_LPVAE;
	DSI->VMCR |= DSI_VMCR_LPVAE;
	
	DSI->VMCR &= ~DSI_VMCR_LPVFPE;
	DSI->VMCR |= DSI_VMCR_LPVFPE;
	
	DSI->VMCR &= ~DSI_VMCR_LPVBPE;
	DSI->VMCR |= DSI_VMCR_LPVBPE;
	
	DSI->VMCR &= ~DSI_VMCR_LPVSAE;
	DSI->VMCR |= DSI_VMCR_LPVSAE;
	
	DSI->VMCR &= ~DSI_VMCR_FBTAAE;

	DSI->CLTCR &= ~(DSI_CLTCR_LP2HS_TIME | DSI_CLTCR_HS2LP_TIME);
	DSI->CLTCR |= (35 | (35 << 16));
	
	DSI->DLTCR &= ~(DSI_DLTCR_MRD_TIME | DSI_DLTCR_LP2HS_TIME | DSI_DLTCR_HS2LP_TIME);
	DSI->DLTCR |= (35 << 16) | (35 << 24);
	
	DSI->PCONFR &= ~DSI_PCONFR_SW_TIME;
	DSI->PCONFR |= (10 << 8);

//setup LTDC now (feeds data to DSI)

	logt("dsi is up\n");

	// Configure the HS, VS, DE and PC polarity
	LTDC->GCR = LTDC_GCR_VSPOL | LTDC_GCR_HSPOL;
	
	// Set Synchronization size
	LTDC->SSCR = ((DISP_HSYNC - 1) << 16) | (DISP_VSYNC - 1);
	
	// Set Accumulated Back porch
	LTDC->BPCR = ((DISP_HSYNC + DISP_HBP - 1) << 16) | (DISP_VSYNC + DISP_VBP - 1);
	
	// Set Accumulated Active Width
	LTDC->AWCR = ((LCD_WIDTH + DISP_HSYNC + DISP_HBP - 1) << 16) | (LCD_HEIGHT + DISP_VSYNC + DISP_VBP - 1);
	
	// Set Total Width
	LTDC->TWCR = ((LCD_WIDTH + DISP_HSYNC + DISP_HBP + DISP_HFP - 1) << 16) | (LCD_HEIGHT + DISP_VSYNC + DISP_VBP + DISP_VFP - 1);
	
	// Set the background color to light blue
	LTDC->BCCR = 0x006666ff;
	
	// Enable LTDC
	LTDC->GCR |= LTDC_GCR_LTDCEN;

	logt("ldtc is up\n");

//start DSI now that LTDC is up
	DSI->CR |= DSI_CR_EN;
	DSI->WCR |= DSI_WCR_DSIEN;

	logt("dsi is on\n");

//init the actual display

	logt("initing display\n");
	
	//dispInitTheScreen_OTM8009A();
	dispInitTheScreen_NT35510();
	
	logt("dsi is on\n");
}

void dispSetBri(uint8_t bri)
{
	#ifdef REV_C_DEV_BOARD
		const uint8_t briCmd[] = {NT35510_CMD_WRDISBV, bri ? bri : 10};
	#else
		const uint8_t briCmd[] = {OTM8009A_CMD_WRDISBV, bri ? bri : 10};
	#endif
	
	dsiCmdExec(0, briCmd);	
}

void dispSetContrast(uint8_t bri)
{
	//not doable on this board	
}

bool dispSetBacklight(bool on)
{
	return false;	//not switchable
}

bool dispGetBacklight(void)
{
	return true;	//always on
}

static bool dispSetupLayer(bool second, void* data, uint32_t w, uint32_t h, uint32_t lineBytes, bool bpp16)	//second layer always below first (for graf area)
{
	uint32_t layerX, layerY, layerW, layerH, layerBpp = bpp16 ? 2 : 1;
	LTDC_Layer_TypeDef* layer = second ? LTDC_Layer2 : LTDC_Layer1;
	
	//calc where main layer is
	layerX = (LCD_WIDTH - DISP_WIDTH) / 2;			//centered
	layerW = DISP_WIDTH;
	layerY = (LCD_HEIGHT - DISP_HEIGHT) / 2;									//on top with some space
	layerH = DISP_HEIGHT;
	
	//now calc where requested layer is
	if (second) {
		layerW = w;
		layerY += layerH;
		layerH = h;
	}

	if (layer->CR & LTDC_LxCR_LEN) {		//if it is on, turn it off
		layer->CR = 0;
		LTDC->SRCR = 2;		//make it happen & wait
		while(LTDC->SRCR);
	}
	
	
	layer->WHPCR = ((((LTDC->BPCR & LTDC_BPCR_AHBP) >> LTDC_BPCR_AHBP_Pos) + layerX + layerW - 1) << LTDC_LxWHPCR_WHSPPOS_Pos) | 
							((((LTDC->BPCR & LTDC_BPCR_AHBP) >> LTDC_BPCR_AHBP_Pos) + layerX) << LTDC_LxWHPCR_WHSTPOS_Pos);
	
	layer->WVPCR = ((((LTDC->BPCR & LTDC_BPCR_AVBP) >> LTDC_BPCR_AVBP_Pos) + layerY + layerH - 1) << LTDC_LxWVPCR_WVSPPOS_Pos) | 
							((((LTDC->BPCR & LTDC_BPCR_AVBP) >> LTDC_BPCR_AVBP_Pos) + layerY) << LTDC_LxWVPCR_WVSTPOS_Pos);
	
	layer->CFBLR = (lineBytes << 16) | ((layerW * layerBpp) + 3);
	layer->CFBLNR = layerH;
	
	layer->PFCR = bpp16 ? 2 : 5;	//RGB565 or L8
	layer->CACR = 255;
	layer->DCCR = 0;
	layer->BFCR = 0x607;
	layer->CFBAR = (uintptr_t)data;
	
	if (second) {	//must be teansparent outside it boundaries..somehow that is NOT the default
		
		layer->CR = 0x01;			//layer on, clut off, color keying on
	}
	else{
	
		layer->CR = bpp16 ? 1 : 0x11;	//clut on for 8-bit main layer, not for second
	}
	
	//make it happen
	LTDC->SRCR = 2;
	
	return true;
}

static void dispDrawGrafAreaIfNeeded(void)
{
	uint32_t grafAreaH;
	uint8_t *graf;
	
	if (DISP_HEIGHT > DISP_WIDTH)	//not needed
		return;
	
	if (haveGrafArea)
		return;
	
	if (dalGetInitStage() < DAL_INIT_STAGE_MEM_AND_DM)
		return;
	
	grafAreaH = sizeof(mGrafitiAreaImage) * 8 / 160;
	
	graf = MemChunkNew(0, sizeof(mGrafitiAreaImage) * 8 * (DISP_WIDTH == 320 ? 4 : 1), 0x1200);
	if (!graf)
		return;
	
	if (DISP_WIDTH == 320) {
		
		const uint8_t* src = mGrafitiAreaImage;
		uint8_t* dst = graf;
		uint32_t r, c, t, i, v;
		
		for (r = 0; r < sizeof(mGrafitiAreaImage) / (160 / 8); r++) {
			for (c = 0; c < 160; c += 8) {
				
				t = *src++;
				
				for (i = 0; i < 8; i++, t >>= 1) {
					
					v = (t & 1) ? 0x00 : 0xff;
					
					dst[0] = v;
					dst[1] = v;
					dst[DISP_WIDTH + 0] = v;
					dst[DISP_WIDTH + 1] = v;
					dst += 2;
				}
			}
			dst += DISP_WIDTH;
		}
		
		grafAreaH *= 2;
	}
	else{
		uint32_t i, j, k = 0;
		
		for (i = 0; i < sizeof(mGrafitiAreaImage); i++) {
			
			uint32_t v = mGrafitiAreaImage[i];
			for (j = 0; j < 8; j++, v >>= 1)
				graf[k++] = (v & 1) ? 0x00 : 0xff;
		}
	}
	
	if (!dispSetupLayer(true, graf, DISP_WIDTH, grafAreaH, DISP_WIDTH, false))
		fatal("Cannot show graf area!\n");
	
	logw("graf area on\n");
	
	haveGrafArea = true;	
}

bool dispDrvInit(uint16_t *wP, uint16_t* hP, uint16_t* densityP, uint16_t *realDpiP, uint16_t *supportedDepthMapP, void** framebufferP, bool *indexedFmtIsLEP)
{
	#ifdef CPU_HARDWIRED_VRAM_ADDR
		mFb = (void*)CPU_HARDWIRED_VRAM_ADDR;
	#else
		mFb = kheapAlloc(DISP_WIDTH * DISP_HEIGHT * sizeof(uint16_t));
		if (!mFb) {
			loge("Cannot alloc fb\n");
			return false;
		}
	#endif
	
	*wP = DISP_WIDTH;
	*hP = DISP_HEIGHT;
	*densityP = DISP_DENSITY;
	*supportedDepthMapP = ((1 << 16) | (1 << 8) | (1 << 4) | (1 << 2) | (1 << 1)) >> 1;
	*framebufferP = mFb;
	*realDpiP = 240;
	*indexedFmtIsLEP = false;
	
	dispInitHw();
	mCurDepth = 16;
	return dispSetupLayer(false, mFb, DISP_WIDTH, DISP_HEIGHT, DISP_WIDTH * 2, true);
}


void dispSetClut(int32_t firstIdx, uint32_t numEntries, const struct PalmClutEntry *entries)
{
	uint32_t i;
	
	if (firstIdx == -1) {
		
		if (numEntries > 256)
			return;
	}
	else if (firstIdx < 0)
		return;
	else if (firstIdx >= 256 || numEntries + firstIdx > 256)
		return;

	for (i = 0; i < numEntries; i++) {
		
		uint32_t where = (firstIdx == -1) ? entries[i].idx : i + firstIdx;
		uint32_t r = entries[i].r;
		uint32_t g = entries[i].g;
		uint32_t b = entries[i].b;
		
		LTDC_Layer1->CLUTWR = (where << LTDC_LxCLUTWR_CLUTADD_Pos) | (r << LTDC_LxCLUTWR_RED_Pos) | (g << LTDC_LxCLUTWR_GREEN_Pos) | (b << LTDC_LxCLUTWR_BLUE_Pos);
	}

	dispDrawGrafAreaIfNeeded();
}

static void dispConfigResampler(uint32_t depth)
{
	static const uint32_t mOneBppFirstStageLut[] = {0xff000000, 0xff002000, 0xff008000, 0xff00a000, 0xff100000, 0xff102000, 0xff108000, 0xff10a000, 0xff400000, 0xff402000, 0xff408000, 0xff40a000, 0xff500000, 0xff502000, 0xff508000, 0xff50a000, 0xff000008, 0xff002008, 0xff008008, 0xff00a008, 0xff100008, 0xff102008, 0xff108008, 0xff10a008, 0xff400008, 0xff402008, 0xff408008, 0xff40a008, 0xff500008, 0xff502008, 0xff508008, 0xff50a008, 0xff000020, 0xff002020, 0xff008020, 0xff00a020, 0xff100020, 0xff102020, 0xff108020, 0xff10a020, 0xff400020, 0xff402020, 0xff408020, 0xff40a020, 0xff500020, 0xff502020, 0xff508020, 0xff50a020, 0xff000028, 0xff002028, 0xff008028, 0xff00a028, 0xff100028, 0xff102028, 0xff108028, 0xff10a028, 0xff400028, 0xff402028, 0xff408028, 0xff40a028, 0xff500028, 0xff502028, 0xff508028, 0xff50a028, 0xff000080, 0xff002080, 0xff008080, 0xff00a080, 0xff100080, 0xff102080, 0xff108080, 0xff10a080, 0xff400080, 0xff402080, 0xff408080, 0xff40a080, 0xff500080, 0xff502080, 0xff508080, 0xff50a080, 0xff000088, 0xff002088, 0xff008088, 0xff00a088, 0xff100088, 0xff102088, 0xff108088, 0xff10a088, 0xff400088, 0xff402088, 0xff408088, 0xff40a088, 0xff500088, 0xff502088, 0xff508088, 0xff50a088, 0xff0000a0, 0xff0020a0, 0xff0080a0, 0xff00a0a0, 0xff1000a0, 0xff1020a0, 0xff1080a0, 0xff10a0a0, 0xff4000a0, 0xff4020a0, 0xff4080a0, 0xff40a0a0, 0xff5000a0, 0xff5020a0, 0xff5080a0, 0xff50a0a0, 0xff0000a8, 0xff0020a8, 0xff0080a8, 0xff00a0a8, 0xff1000a8, 0xff1020a8, 0xff1080a8, 0xff10a0a8, 0xff4000a8, 0xff4020a8, 0xff4080a8, 0xff40a0a8, 0xff5000a8, 0xff5020a8, 0xff5080a8, 0xff50a0a8, 0xff000800, 0xff002800, 0xff008800, 0xff00a800, 0xff100800, 0xff102800, 0xff108800, 0xff10a800, 0xff400800, 0xff402800, 0xff408800, 0xff40a800, 0xff500800, 0xff502800, 0xff508800, 0xff50a800, 0xff000808, 0xff002808, 0xff008808, 0xff00a808, 0xff100808, 0xff102808, 0xff108808, 0xff10a808, 0xff400808, 0xff402808, 0xff408808, 0xff40a808, 0xff500808, 0xff502808, 0xff508808, 0xff50a808, 0xff000820, 0xff002820, 0xff008820, 0xff00a820, 0xff100820, 0xff102820, 0xff108820, 0xff10a820, 0xff400820, 0xff402820, 0xff408820, 0xff40a820, 0xff500820, 0xff502820, 0xff508820, 0xff50a820, 0xff000828, 0xff002828, 0xff008828, 0xff00a828, 0xff100828, 0xff102828, 0xff108828, 0xff10a828, 0xff400828, 0xff402828, 0xff408828, 0xff40a828, 0xff500828, 0xff502828, 0xff508828, 0xff50a828, 0xff000880, 0xff002880, 0xff008880, 0xff00a880, 0xff100880, 0xff102880, 0xff108880, 0xff10a880, 0xff400880, 0xff402880, 0xff408880, 0xff40a880, 0xff500880, 0xff502880, 0xff508880, 0xff50a880, 0xff000888, 0xff002888, 0xff008888, 0xff00a888, 0xff100888, 0xff102888, 0xff108888, 0xff10a888, 0xff400888, 0xff402888, 0xff408888, 0xff40a888, 0xff500888, 0xff502888, 0xff508888, 0xff50a888, 0xff0008a0, 0xff0028a0, 0xff0088a0, 0xff00a8a0, 0xff1008a0, 0xff1028a0, 0xff1088a0, 0xff10a8a0, 0xff4008a0, 0xff4028a0, 0xff4088a0, 0xff40a8a0, 0xff5008a0, 0xff5028a0, 0xff5088a0, 0xff50a8a0, 0xff0008a8, 0xff0028a8, 0xff0088a8, 0xff00a8a8, 0xff1008a8, 0xff1028a8, 0xff1088a8, 0xff10a8a8, 0xff4008a8, 0xff4028a8, 0xff4088a8, 0xff40a8a8, 0xff5008a8, 0xff5028a8, 0xff5088a8, 0xff50a8a8, };
	static const uint32_t mTwoBppLut[] = {0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x00010000, 0x01010000, 0x02010000, 0x03010000, 0x00020000, 0x01020000, 0x02020000, 0x03020000, 0x00030000, 0x01030000, 0x02030000, 0x03030000, 0x00000100, 0x01000100, 0x02000100, 0x03000100, 0x00010100, 0x01010100, 0x02010100, 0x03010100, 0x00020100, 0x01020100, 0x02020100, 0x03020100, 0x00030100, 0x01030100, 0x02030100, 0x03030100, 0x00000200, 0x01000200, 0x02000200, 0x03000200, 0x00010200, 0x01010200, 0x02010200, 0x03010200, 0x00020200, 0x01020200, 0x02020200, 0x03020200, 0x00030200, 0x01030200, 0x02030200, 0x03030200, 0x00000300, 0x01000300, 0x02000300, 0x03000300, 0x00010300, 0x01010300, 0x02010300, 0x03010300, 0x00020300, 0x01020300, 0x02020300, 0x03020300, 0x00030300, 0x01030300, 0x02030300, 0x03030300, 0x00000001, 0x01000001, 0x02000001, 0x03000001, 0x00010001, 0x01010001, 0x02010001, 0x03010001, 0x00020001, 0x01020001, 0x02020001, 0x03020001, 0x00030001, 0x01030001, 0x02030001, 0x03030001, 0x00000101, 0x01000101, 0x02000101, 0x03000101, 0x00010101, 0x01010101, 0x02010101, 0x03010101, 0x00020101, 0x01020101, 0x02020101, 0x03020101, 0x00030101, 0x01030101, 0x02030101, 0x03030101, 0x00000201, 0x01000201, 0x02000201, 0x03000201, 0x00010201, 0x01010201, 0x02010201, 0x03010201, 0x00020201, 0x01020201, 0x02020201, 0x03020201, 0x00030201, 0x01030201, 0x02030201, 0x03030201, 0x00000301, 0x01000301, 0x02000301, 0x03000301, 0x00010301, 0x01010301, 0x02010301, 0x03010301, 0x00020301, 0x01020301, 0x02020301, 0x03020301, 0x00030301, 0x01030301, 0x02030301, 0x03030301, 0x00000002, 0x01000002, 0x02000002, 0x03000002, 0x00010002, 0x01010002, 0x02010002, 0x03010002, 0x00020002, 0x01020002, 0x02020002, 0x03020002, 0x00030002, 0x01030002, 0x02030002, 0x03030002, 0x00000102, 0x01000102, 0x02000102, 0x03000102, 0x00010102, 0x01010102, 0x02010102, 0x03010102, 0x00020102, 0x01020102, 0x02020102, 0x03020102, 0x00030102, 0x01030102, 0x02030102, 0x03030102, 0x00000202, 0x01000202, 0x02000202, 0x03000202, 0x00010202, 0x01010202, 0x02010202, 0x03010202, 0x00020202, 0x01020202, 0x02020202, 0x03020202, 0x00030202, 0x01030202, 0x02030202, 0x03030202, 0x00000302, 0x01000302, 0x02000302, 0x03000302, 0x00010302, 0x01010302, 0x02010302, 0x03010302, 0x00020302, 0x01020302, 0x02020302, 0x03020302, 0x00030302, 0x01030302, 0x02030302, 0x03030302, 0x00000003, 0x01000003, 0x02000003, 0x03000003, 0x00010003, 0x01010003, 0x02010003, 0x03010003, 0x00020003, 0x01020003, 0x02020003, 0x03020003, 0x00030003, 0x01030003, 0x02030003, 0x03030003, 0x00000103, 0x01000103, 0x02000103, 0x03000103, 0x00010103, 0x01010103, 0x02010103, 0x03010103, 0x00020103, 0x01020103, 0x02020103, 0x03020103, 0x00030103, 0x01030103, 0x02030103, 0x03030103, 0x00000203, 0x01000203, 0x02000203, 0x03000203, 0x00010203, 0x01010203, 0x02010203, 0x03010203, 0x00020203, 0x01020203, 0x02020203, 0x03020203, 0x00030203, 0x01030203, 0x02030203, 0x03030203, 0x00000303, 0x01000303, 0x02000303, 0x03000303, 0x00010303, 0x01010303, 0x02010303, 0x03010303, 0x00020303, 0x01020303, 0x02020303, 0x03020303, 0x00030303, 0x01030303, 0x02030303, 0x03030303, };
	static const uint32_t mFourBppLut[] = {0xff000000, 0xff002000, 0xff004000, 0xff006000, 0xff008000, 0xff00a000, 0xff00c000, 0xff00e000, 0xff080000, 0xff082000, 0xff084000, 0xff086000, 0xff088000, 0xff08a000, 0xff08c000, 0xff08e000, 0xff000008, 0xff002008, 0xff004008, 0xff006008, 0xff008008, 0xff00a008, 0xff00c008, 0xff00e008, 0xff080008, 0xff082008, 0xff084008, 0xff086008, 0xff088008, 0xff08a008, 0xff08c008, 0xff08e008, 0xff000010, 0xff002010, 0xff004010, 0xff006010, 0xff008010, 0xff00a010, 0xff00c010, 0xff00e010, 0xff080010, 0xff082010, 0xff084010, 0xff086010, 0xff088010, 0xff08a010, 0xff08c010, 0xff08e010, 0xff000018, 0xff002018, 0xff004018, 0xff006018, 0xff008018, 0xff00a018, 0xff00c018, 0xff00e018, 0xff080018, 0xff082018, 0xff084018, 0xff086018, 0xff088018, 0xff08a018, 0xff08c018, 0xff08e018, 0xff000020, 0xff002020, 0xff004020, 0xff006020, 0xff008020, 0xff00a020, 0xff00c020, 0xff00e020, 0xff080020, 0xff082020, 0xff084020, 0xff086020, 0xff088020, 0xff08a020, 0xff08c020, 0xff08e020, 0xff000028, 0xff002028, 0xff004028, 0xff006028, 0xff008028, 0xff00a028, 0xff00c028, 0xff00e028, 0xff080028, 0xff082028, 0xff084028, 0xff086028, 0xff088028, 0xff08a028, 0xff08c028, 0xff08e028, 0xff000030, 0xff002030, 0xff004030, 0xff006030, 0xff008030, 0xff00a030, 0xff00c030, 0xff00e030, 0xff080030, 0xff082030, 0xff084030, 0xff086030, 0xff088030, 0xff08a030, 0xff08c030, 0xff08e030, 0xff000038, 0xff002038, 0xff004038, 0xff006038, 0xff008038, 0xff00a038, 0xff00c038, 0xff00e038, 0xff080038, 0xff082038, 0xff084038, 0xff086038, 0xff088038, 0xff08a038, 0xff08c038, 0xff08e038, 0xff000040, 0xff002040, 0xff004040, 0xff006040, 0xff008040, 0xff00a040, 0xff00c040, 0xff00e040, 0xff080040, 0xff082040, 0xff084040, 0xff086040, 0xff088040, 0xff08a040, 0xff08c040, 0xff08e040, 0xff000048, 0xff002048, 0xff004048, 0xff006048, 0xff008048, 0xff00a048, 0xff00c048, 0xff00e048, 0xff080048, 0xff082048, 0xff084048, 0xff086048, 0xff088048, 0xff08a048, 0xff08c048, 0xff08e048, 0xff000050, 0xff002050, 0xff004050, 0xff006050, 0xff008050, 0xff00a050, 0xff00c050, 0xff00e050, 0xff080050, 0xff082050, 0xff084050, 0xff086050, 0xff088050, 0xff08a050, 0xff08c050, 0xff08e050, 0xff000058, 0xff002058, 0xff004058, 0xff006058, 0xff008058, 0xff00a058, 0xff00c058, 0xff00e058, 0xff080058, 0xff082058, 0xff084058, 0xff086058, 0xff088058, 0xff08a058, 0xff08c058, 0xff08e058, 0xff000060, 0xff002060, 0xff004060, 0xff006060, 0xff008060, 0xff00a060, 0xff00c060, 0xff00e060, 0xff080060, 0xff082060, 0xff084060, 0xff086060, 0xff088060, 0xff08a060, 0xff08c060, 0xff08e060, 0xff000068, 0xff002068, 0xff004068, 0xff006068, 0xff008068, 0xff00a068, 0xff00c068, 0xff00e068, 0xff080068, 0xff082068, 0xff084068, 0xff086068, 0xff088068, 0xff08a068, 0xff08c068, 0xff08e068, 0xff000070, 0xff002070, 0xff004070, 0xff006070, 0xff008070, 0xff00a070, 0xff00c070, 0xff00e070, 0xff080070, 0xff082070, 0xff084070, 0xff086070, 0xff088070, 0xff08a070, 0xff08c070, 0xff08e070, 0xff000078, 0xff002078, 0xff004078, 0xff006078, 0xff008078, 0xff00a078, 0xff00c078, 0xff00e078, 0xff080078, 0xff082078, 0xff084078, 0xff086078, 0xff088078, 0xff08a078, 0xff08c078, 0xff08e078, };
	
	const uint32_t *lut;
	uint32_t i, amtcr;
	
	switch (depth) {
		case 1:		//1bbp stage 1
			//two stages, first a 2x expansion with field reversal, and then a 4x expansion
			//stage is picked based on value of "DMA2D->OMAR" 
			
			if (DMA2D->OMAR == ((uintptr_t)mFb) + DISP_WIDTH * DISP_HEIGHT) {	//need stage 1
			
				DMA2D->FGMAR = (uintptr_t)mFb;
				DMA2D->OMAR = (uintptr_t)mFb + DISP_WIDTH * DISP_HEIGHT / 8;
			
				DMA2D->FGPFCCR = 0xff05;	//256-entry argb8888 clut. input data is L8 format
				DMA2D->OPFCCR = 0x02;		//output RGB565
				lut = mOneBppFirstStageLut;
				DMA2D->NLR = ((DISP_WIDTH / 8) << 16) + DISP_HEIGHT;
				break;
			}
			
			//need stage 2
			DMA2D->OMAR = ((uintptr_t)mFb) + DISP_WIDTH * DISP_HEIGHT;
			DMA2D->FGMAR = (uintptr_t)mFb + DISP_WIDTH * DISP_HEIGHT / 8;
			//now same as 2bpp
			goto _2bpp_common;
			
		case 2:		//L8 -> argb8888
			DMA2D->FGMAR = (uintptr_t)mFb;
			DMA2D->OMAR = ((uintptr_t)mFb) + DISP_WIDTH * DISP_HEIGHT;
	_2bpp_common:
			DMA2D->FGPFCCR = 0xff05;	//16-entry argb8888 clut. input data is L8 format
			DMA2D->OPFCCR = 0x00;		//output ARGB8888
			lut = mTwoBppLut;
			DMA2D->NLR = ((DISP_WIDTH / 4) << 16) + DISP_HEIGHT;
			break;
		case 4:		//L8 -> rgb565
			DMA2D->FGMAR = (uintptr_t)mFb;
			DMA2D->OMAR = ((uintptr_t)mFb) + DISP_WIDTH * DISP_HEIGHT;
			DMA2D->FGPFCCR = 0xff05;	//256-entry argb8888 clut. input data is L8 format
			DMA2D->OPFCCR = 0x02;		//output RGB565
			lut = mFourBppLut;
			DMA2D->NLR = ((DISP_WIDTH / 2) << 16) + DISP_HEIGHT;
			break;
		default:
			return;
	}
	
	//load CLUT using DMA (tested faster than SW)
	DMA2D->FGCMAR = (uintptr_t)lut;
	amtcr = DMA2D->AMTCR;
	DMA2D->AMTCR = 0;				//disable DMA2D's AHB access dead time module for speed - let DMA2D use AHB all it wants for fast CLUT loading
	DMA2D->FGPFCCR |= 0x20;			//start loading
	while (DMA2D->FGPFCCR & 0x20);	//wait for it
	DMA2D->AMTCR = amtcr;			//restore dead time config
}

void __attribute__((used)) TIM5_IRQHandler(void)	//high bits come first
{
	TIM5->SR = 0;
	if (USE_DMA2D) {
		
		if (mCurDepth == 1)		///every other frame we need to reconfigure in the 1bpp case. halves the framerate, but no 1bpp ap needs a lot of ramerate anyways
			dispConfigResampler(1);
		
		DMA2D->CR |= 1;			//start
		return;
	}
	else {
		uint32_t t, pixels = DISP_WIDTH * DISP_HEIGHT;
		uint8_t *src = mFb, *dst = src + pixels;
		uint16_t *dst16 = (uint16_t*)dst;
		uint32_t *dst32 = (uint32_t*)dst;

		switch (mCurDepth) {
			case 4:
				pixels /= 2;
				do {
					t = *src++;
					*dst++ = (t >> 4) & 0x0F;
					*dst++ = (t >> 0) & 0x0F;
				} while (--pixels);
				break;
			case 2:
				pixels /= 4;
				do {
					static const uint16_t lut2b[] = {0x0000, 0x0100, 0x0200, 0x0300, 0x0001, 0x0101, 0x0201, 0x0301, 0x0002, 0x0102, 0x0202, 0x0302, 0x0003, 0x0103, 0x0203, 0x0303, };
					
					t = *src++;
					*dst16++ = lut2b[(t >> 4) & 0x0F];
					*dst16++ = lut2b[(t >> 0) & 0x0F];
				} while (--pixels);
				break;
			case 1:
				pixels /= 8;
				do {
					static const uint32_t lut1b[] = {0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100, 0x00010100, 0x01010100, 0x00000001, 0x01000001, 0x00010001, 0x01010001, 0x00000101, 0x01000101, 0x00010101, 0x01010101};
					
					t = *src++;
					*dst32++ = lut1b[(t >> 4) & 0x0F];
					*dst32++ = lut1b[(t >> 0) & 0x0F];
				} while (--pixels);
				break;
		}
	}
}

void dispSetDepth(uint32_t depth)
{
	uint32_t i;
	
	TIM5->CR1 = 0;
	NVIC_DisableIRQ(TIM5_IRQn);
	
	mCurDepth = depth;
	
	if (depth == 16 || depth == 8) {
		if (!dispSetupLayer(false, mFb, DISP_WIDTH, DISP_HEIGHT, DISP_WIDTH * depth / 8, depth == 16))
			fatal("Cannot set disp depth\n");
		return;
	}
	
	if (depth != 1 && depth != 2 && depth != 4) {
		fatal("depth %u is invalid\n", depth);
		return;
	}
	
	//set up display to be in second half of real FB
	dispSetupLayer(false, ((uint8_t*)mFb) + DISP_WIDTH * DISP_HEIGHT, DISP_WIDTH, DISP_HEIGHT, DISP_WIDTH, false);
	
	//start timer to update LCD constantly
	TIM5->PSC = 0;
	TIM5->DIER = TIM_DIER_UIE;
	TIM5->SR = -1;
	TIM5->CNT = TIMER_TICKS_PER_MSEC * 1000 / 60;
	TIM5->ARR = TIMER_TICKS_PER_MSEC * 1000 / 60;
	TIM5->CR1 = TIM_CR1_DIR | TIM_CR1_URS | TIM_CR1_CEN;
	NVIC_EnableIRQ(TIM5_IRQn);
	
	if (USE_DMA2D) {
		
		DMA2D->CR |= 4;			//abort
		while (DMA2D->CR & 1);	//wait
		
		DMA2D->CR = 0x10000 | DMA2D_CR_TCIE;	//mem-to-mem with pfc, int on complete
		DMA2D->FGOR = 0;	//input stride == width
		DMA2D->OOR = 0;		//output stride == width
		DMA2D->AMTCR = 0x1301;	//19 AHB cycles between each access by DMA2D (limits DMA2D's AHB use to 5%)

		dispConfigResampler(depth);
	}
	
	dispDrawGrafAreaIfNeeded();
}

void dispManualUpdate(void)
{
	//nothing
}

void dispRequestUpdate(void)
{
	//nothing
}


void dispSleep(void)
{
	TIM5->CR1 &=~ TIM_CR1_CEN;
	LTDC_Layer1->CR &=~ 1;
	LTDC->SRCR = 2;
	
	//we can do more to shut more things down, but why bother since this is a dev board
}

void dispWake(void)
{
	LTDC_Layer1->CR |= 1;
	LTDC->SRCR = 2;
	
	if (mCurDepth < 8)
		TIM5->CR1 |= TIM_CR1_CEN;
	
	//we can do more to shut more things down, but why bother since this is a dev board
}

